/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.Collection;
import java.util.logging.Level;
import org.compiere.model.MOrg;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.X_I_Product_BOM;

public class ImportProductBOM
extends SvrProcess {
    private boolean m_DeleteOldImported = false;
    private boolean m_IsImportOnlyNoErrors = true;
    private boolean isImported = false;
    private int imported = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter para : parameters = this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("IsImportOnlyNoErrors")) {
                this.m_IsImportOnlyNoErrors = "Y".equals(para.getParameter());
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_DeleteOldImported = "Y".equals(para.getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.m_DeleteOldImported) {
            int no = 0;
            for (X_I_Product_BOM bom : this.getRecords(true, false)) {
                bom.deleteEx(true);
                ++no;
            }
            this.log.fine("Delete Old Impored =" + no);
        }
        this.fillIDValues();
        this.importRecords();
        return "Imported: " + this.imported;
    }

    private void fillIDValues() {
        for (X_I_Product_BOM importBOM : this.getRecords(false, this.m_IsImportOnlyNoErrors)) {
            if (importBOM.getAD_Org_ID() >= 0) {
                MOrg org = new MOrg(Env.getCtx(), importBOM.getAD_Org_ID(), this.get_TrxName());
                importBOM.setOrgValue(org.getValue());
            }
            importBOM.setAD_Org_ID(this.getID("AD_Org", "Value = ?", new Object[]{importBOM.getOrgValue()}));
            if (importBOM.getM_Product_ID() == 0) {
                importBOM.setM_Product_ID(this.getID("M_Product", "Value=?", new Object[]{importBOM.getProductValue()}));
            }
            if (importBOM.getM_BOMProduct_ID() == 0) {
                importBOM.setM_BOMProduct_ID(this.getID("M_Product", "Value=?", new Object[]{importBOM.getProduct_BOM_Value()}));
            }
            if (importBOM.getC_UOM_ID() == 0) {
                importBOM.setC_UOM_ID(this.getID("C_UOM", "X12DE355=?", new Object[]{importBOM.getX12DE355()}));
            }
            StringBuffer err = new StringBuffer("");
            if (importBOM.getAD_Org_ID() <= 0) {
                err.append(" @AD_Org_ID@ @NotFound@,");
            }
            if (importBOM.getM_Product_ID() <= 0) {
                err.append(" @M_Product_ID@ @NotFound@,");
            }
            if (importBOM.getM_BOMProduct_ID() <= 0) {
                err.append(" @M_ProductBOM_ID@ @NotFound@");
            }
            if (err.toString() != null && err.toString().length() > 0) {
                importBOM.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), err.toString()));
            }
            importBOM.saveEx();
        }
    }

    private void importRecords() {
        for (X_I_Product_BOM importBOM : this.getRecords(false, this.m_IsImportOnlyNoErrors)) {
            this.isImported = false;
            MPPProductBOM bom = this.getMPPProductBOM(importBOM);
            MPPProductBOMLine bomLine = null;
            if (bom != null) {
                bomLine = this.importBOMLine(bom, importBOM);
                this.isImported = true;
            }
            if (bomLine == null) {
                this.isImported = false;
            }
            if (this.isImported) {
                importBOM.setPP_Product_BOMLine_ID(bomLine.getPP_Product_BOMLine_ID());
                importBOM.setPP_Product_BOM_ID(bom.get_ID());
                ++this.imported;
            }
            importBOM.setI_IsImported(this.isImported);
            importBOM.setProcessed(this.isImported);
            importBOM.saveEx();
        }
    }

    private MPPProductBOM getMPPProductBOM(X_I_Product_BOM importBOM) {
        String whereClause = "M_Product_ID=? AND Name=? AND Value=?";
        int id = new Query(Env.getCtx(), "PP_Product_BOM", whereClause, this.get_TrxName()).setParameters(importBOM.getM_Product_ID(), importBOM.getName(), importBOM.getValue()).firstId();
        if (id < 0) {
            id = 0;
        }
        MPPProductBOM bom = new MPPProductBOM(Env.getCtx(), id, this.get_TrxName());
        try {
            bom.setM_Product_ID(importBOM.getM_Product_ID());
            bom.setValue(importBOM.getM_Product().getValue());
            bom.setName(importBOM.getM_Product().getName());
            bom.setValidFrom(importBOM.getValidFrom());
            bom.setValidTo(importBOM.getValidTo());
            bom.setBOMType(importBOM.getBOMType());
            bom.setBOMUse(importBOM.getBOMUse());
            bom.setDescription(importBOM.getDescription());
            bom.setHelp(importBOM.getHelp());
            bom.setC_UOM_ID(importBOM.getM_Product().getC_UOM_ID());
            bom.saveEx();
            return bom;
        }
        catch (Exception e) {
            importBOM.setI_ErrorMsg(e.getMessage());
            this.isImported = false;
            return null;
        }
    }

    private MPPProductBOMLine importBOMLine(MPPProductBOM bom, X_I_Product_BOM importBOM) {
        MPPProductBOMLine bomLine = this.getProductBOMLine(bom, importBOM);
        MProduct component = new MProduct(Env.getCtx(), importBOM.getM_BOMProduct_ID(), this.get_TrxName());
        if (bomLine == null) {
            bomLine = new MPPProductBOMLine(Env.getCtx(), 0, this.get_TrxName());
        }
        try {
            bomLine.setM_Product_ID(importBOM.getM_BOMProduct_ID());
            bomLine.setComponentType(importBOM.getComponentType());
            bomLine.setQtyBOM(importBOM.getQtyBOM());
            bomLine.setQtyBatch(importBOM.getQtyBatch());
            bomLine.setIssueMethod(importBOM.getIssueMethod());
            bomLine.setIsQtyPercentage(importBOM.isQtyPercentage());
            bomLine.setPP_Product_BOM_ID(bom.get_ID());
            bomLine.setValidFrom(importBOM.getValidFrom());
            bomLine.setM_ChangeNotice_ID(importBOM.getM_ChangeNotice_ID());
            bomLine.setIsCritical(importBOM.isCritical());
            bomLine.setCostAllocationPerc(importBOM.getCostAllocationPerc());
            bomLine.setScrap(importBOM.getScrap());
            bomLine.setAssay(importBOM.getAssay());
            bomLine.setBackflushGroup(importBOM.getBackflushGroup());
            bomLine.setLeadTimeOffset(importBOM.getLeadTimeOffset());
            bomLine.setPP_Product_BOM_ID(bom.get_ID());
            if (importBOM.getC_UOM_ID() > 0) {
                bomLine.setC_UOM_ID(importBOM.getC_UOM_ID());
            } else {
                bomLine.setC_UOM_ID(component.getC_UOM_ID());
            }
            bomLine.saveEx();
            return bomLine;
        }
        catch (Exception e) {
            importBOM.setI_ErrorMsg(e.getLocalizedMessage());
            importBOM.saveEx();
            return null;
        }
    }

    private MPPProductBOMLine getProductBOMLine(MPPProductBOM bom, X_I_Product_BOM importBOM) {
        String whereClause = "M_Product_ID=? AND PP_Product_BOM_ID=?";
        return (MPPProductBOMLine)new Query(Env.getCtx(), "PP_Product_BOMLine", whereClause, this.get_TrxName()).setParameters(importBOM.getM_BOMProduct_ID(), bom.getPP_Product_BOM_ID()).first();
    }

    private int getID(String tableName, String whereClause, Object[] values) {
        return new Query(this.getCtx(), tableName, whereClause, this.get_TrxName()).setParameters(values).firstId();
    }

    private Collection<X_I_Product_BOM> getRecords(boolean imported, boolean isWithError) {
        StringBuffer whereClause = new StringBuffer("I_IsImported").append("=?");
        if (isWithError) {
            whereClause.append(" AND ").append("I_ErrorMsg").append(" IS NULL");
        }
        return new Query(this.getCtx(), "I_Product_BOM", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(imported).list();
    }
}

