/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_AD_WF_Node;
import org.compiere.model.I_AD_Workflow;
import org.compiere.model.I_C_UOM;
import org.compiere.model.I_S_Resource;
import org.compiere.model.MResource;
import org.compiere.model.MResourceType;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.I_PP_Cost_Collector;
import org.eevolution.model.I_PP_Order_Node;
import org.eevolution.model.MPPOrderNode;
import org.eevolution.model.RoutingService;

public class DefaultRoutingServiceImpl
implements RoutingService {
    @Override
    public BigDecimal estimateWorkingTime(I_AD_WF_Node node) {
        double duration = node.getUnitsCycles().signum() == 0 ? (double)node.getDuration() : (double)node.getDuration() / node.getUnitsCycles().doubleValue();
        return BigDecimal.valueOf(duration);
    }

    @Override
    public BigDecimal estimateWorkingTime(I_PP_Order_Node node, BigDecimal qty) {
        double unitDuration = node.getDuration();
        double cycles = this.calculateCycles(node.getUnitsCycles(), qty);
        BigDecimal duration = BigDecimal.valueOf(unitDuration * cycles);
        return duration;
    }

    @Override
    public BigDecimal estimateWorkingTime(I_PP_Cost_Collector cc) {
        String trxName = cc instanceof PO ? ((PO)((Object)cc)).get_TrxName() : null;
        BigDecimal qty = cc.getMovementQty();
        MPPOrderNode node = MPPOrderNode.get(Env.getCtx(), cc.getPP_Order_Node_ID(), trxName);
        return this.estimateWorkingTime(node, qty);
    }

    protected int calculateCycles(int unitsCycle, BigDecimal qty) {
        BigDecimal cycles = qty;
        BigDecimal unitsCycleBD = BigDecimal.valueOf(unitsCycle);
        if (unitsCycleBD.signum() > 0) {
            cycles = qty.divide(unitsCycleBD, 0, RoundingMode.UP);
        }
        return cycles.intValue();
    }

    protected BigDecimal calculateDuration(I_AD_WF_Node node, I_PP_Cost_Collector cc) {
        double duration;
        double setupTime;
        if (node == null) {
            node = cc.getPP_Order_Node().getAD_WF_Node();
        }
        I_AD_Workflow workflow = node.getAD_Workflow();
        double batchSize = workflow.getQtyBatchSize().doubleValue();
        if (cc != null) {
            setupTime = cc.getSetupTimeReal().doubleValue();
            duration = cc.getDurationReal().doubleValue();
        } else {
            setupTime = node.getSetupTime();
            duration = this.estimateWorkingTime(node).doubleValue();
        }
        double totalDuration = batchSize > 0.0 ? setupTime / batchSize + duration : setupTime + duration;
        return BigDecimal.valueOf(totalDuration);
    }

    @Override
    public BigDecimal calculateDuration(I_AD_WF_Node node) {
        return this.calculateDuration(node, null);
    }

    @Override
    public BigDecimal calculateDuration(I_PP_Cost_Collector cc) {
        return this.calculateDuration(this.getAD_WF_Node(cc), cc);
    }

    @Override
    public BigDecimal calculateDuration(I_AD_Workflow wf, I_S_Resource plant, BigDecimal qty) {
        MWFNode[] nodes;
        if (plant == null) {
            return Env.ZERO;
        }
        Properties ctx = ((PO)((Object)wf)).getCtx();
        MResourceType S_ResourceType = MResourceType.get(ctx, plant.getS_ResourceType_ID());
        BigDecimal AvailableDayTime = BigDecimal.valueOf(S_ResourceType.getTimeSlotHours());
        int AvailableDays = S_ResourceType.getAvailableDaysWeek();
        double durationBaseSec = this.getDurationBaseSec(wf.getDurationUnit());
        double durationTotal = 0.0;
        for (MWFNode node : nodes = ((MWorkflow)wf).getNodes(false, Env.getAD_Client_ID(ctx))) {
            durationTotal += (double)node.getQueuingTime();
            durationTotal += (double)node.getSetupTime();
            durationTotal += (double)node.getWaitingTime();
            durationTotal += (double)node.getMovingTime();
            double overlapUnits = qty.doubleValue();
            if (node.getOverlapUnits() > 0 && (double)node.getOverlapUnits() < overlapUnits) {
                overlapUnits = node.getOverlapUnits();
            }
            double durationBeforeOverlap = (double)node.getDuration() * overlapUnits;
            durationTotal += durationBeforeOverlap;
        }
        BigDecimal requiredTime = BigDecimal.valueOf(durationTotal * durationBaseSec / 60.0 / 60.0);
        BigDecimal WeeklyFactor = BigDecimal.valueOf(7L).divide(BigDecimal.valueOf(AvailableDays), 8, RoundingMode.UP);
        return requiredTime.multiply(WeeklyFactor).divide(AvailableDayTime, 0, RoundingMode.UP);
    }

    protected BigDecimal convertDurationToResourceUOM(BigDecimal duration, int S_Resource_ID, I_AD_WF_Node node) {
        MResource resource = MResource.get(Env.getCtx(), S_Resource_ID);
        MWorkflow wf = MWorkflow.get(Env.getCtx(), node.getAD_Workflow_ID());
        MUOM resourceUOM = MUOM.get(Env.getCtx(), resource.getC_UOM_ID());
        return this.convertDuration(duration, wf.getDurationUnit(), resourceUOM);
    }

    @Override
    public BigDecimal getResourceBaseValue(int S_Resource_ID, I_PP_Cost_Collector cc) {
        return this.getResourceBaseValue(S_Resource_ID, null, cc);
    }

    @Override
    public BigDecimal getResourceBaseValue(int S_Resource_ID, I_AD_WF_Node node) {
        return this.getResourceBaseValue(S_Resource_ID, node, null);
    }

    protected BigDecimal getResourceBaseValue(int S_Resource_ID, I_AD_WF_Node node, I_PP_Cost_Collector cc) {
        MResource resource;
        Properties ctx;
        MUOM resourceUOM;
        if (node == null) {
            node = cc.getPP_Order_Node().getAD_WF_Node();
        }
        if (this.isTime(resourceUOM = MUOM.get(ctx = node instanceof PO ? ((PO)((Object)node)).getCtx() : Env.getCtx(), (resource = MResource.get(ctx, S_Resource_ID)).getC_UOM_ID()))) {
            BigDecimal duration = this.calculateDuration(node, cc);
            MWorkflow wf = MWorkflow.get(ctx, node.getAD_Workflow_ID());
            BigDecimal convertedDuration = this.convertDuration(duration, wf.getDurationUnit(), resourceUOM);
            return convertedDuration;
        }
        throw new AdempiereException("@NotSupported@ @C_UOM_ID@ - " + resourceUOM);
    }

    protected I_AD_WF_Node getAD_WF_Node(I_PP_Cost_Collector cc) {
        I_PP_Order_Node activity = cc.getPP_Order_Node();
        return activity.getAD_WF_Node();
    }

    public long getDurationBaseSec(String durationUnit) {
        if (durationUnit == null) {
            return 0L;
        }
        if ("s".equals(durationUnit)) {
            return 1L;
        }
        if ("m".equals(durationUnit)) {
            return 60L;
        }
        if ("h".equals(durationUnit)) {
            return 3600L;
        }
        if ("D".equals(durationUnit)) {
            return 86400L;
        }
        if ("M".equals(durationUnit)) {
            return 2592000L;
        }
        if ("Y".equals(durationUnit)) {
            return 31536000L;
        }
        return 0L;
    }

    public long getDurationBaseSec(I_C_UOM uom) {
        MUOM uomImpl = (MUOM)uom;
        if (uomImpl.isWeek()) {
            return 604800L;
        }
        if (uomImpl.isDay()) {
            return 86400L;
        }
        if (uomImpl.isHour()) {
            return 3600L;
        }
        if (uomImpl.isMinute()) {
            return 60L;
        }
        if (uomImpl.isSecond()) {
            return 1L;
        }
        throw new AdempiereException("@NotSupported@ @C_UOM_ID@=" + uom.getName());
    }

    public boolean isTime(I_C_UOM uom) {
        String x12de355 = uom.getX12DE355();
        return "03".equals(x12de355) || "MJ".equals(x12de355) || "HR".equals(x12de355) || "DA".equals(x12de355) || "WD".equals(x12de355) || "WK".equals(x12de355) || "MO".equals(x12de355) || "WM".equals(x12de355) || "YR".equals(x12de355);
    }

    public BigDecimal convertDuration(BigDecimal duration, String fromDurationUnit, I_C_UOM toUOM) {
        double fromMult = this.getDurationBaseSec(fromDurationUnit);
        double toDiv = this.getDurationBaseSec(toUOM);
        BigDecimal convertedDuration = BigDecimal.valueOf(duration.doubleValue() * fromMult / toDiv);
        int precision = toUOM.getStdPrecision();
        if (convertedDuration.scale() > precision) {
            convertedDuration = convertedDuration.setScale(precision, RoundingMode.HALF_UP);
        }
        return convertedDuration;
    }
}

