/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.io.FileWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MCurrency;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentBatch;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRPaySelection;
import org.eevolution.model.MHRPaySelectionLine;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.X_HR_PaySelectionCheck;

public final class MHRPaySelectionCheck
extends X_HR_PaySelectionCheck {
    private static final long serialVersionUID = -280580616570711570L;
    private static CLogger s_log = CLogger.getCLogger(MHRPaySelectionCheck.class);
    private static final int BP_VALUE = 0;
    private static final int BP_NAME = 1;
    private static final int BP_CONTACT = 2;
    private static final int BP_ADDR1 = 3;
    private static final int BP_ADDR2 = 4;
    private static final int BP_CITY = 5;
    private static final int BP_REGION = 6;
    private static final int BP_POSTAL = 7;
    private static final int BP_COUNTRY = 8;
    private static final int BP_REFNO = 9;
    private MHRPaySelection m_parent = null;
    private Collection<MHRPaySelectionLine> m_lines = null;

    public static MHRPaySelectionCheck getOfPayment(Properties properties, int n, String string) {
        List list = new Query(properties, "HR_PaySelectionCheck", "C_Payment_ID=?", string).setParameters(n).list();
        MHRPaySelectionCheck mHRPaySelectionCheck = null;
        int n2 = 0;
        for (MHRPaySelectionCheck mHRPaySelectionCheck2 : list) {
            if (mHRPaySelectionCheck == null) {
                mHRPaySelectionCheck = mHRPaySelectionCheck2;
            } else if (!mHRPaySelectionCheck.isProcessed() && mHRPaySelectionCheck2.isProcessed()) {
                mHRPaySelectionCheck = mHRPaySelectionCheck2;
            }
            ++n2;
        }
        if (n2 > 1) {
            s_log.warning("More then one for C_Payment_ID=" + n);
        }
        return mHRPaySelectionCheck;
    }

    public static Collection<MHRPaySelectionCheck> get(Properties properties, int n, String string, int n2, String string2) {
        s_log.fine("HR_PaySelection_ID=" + n + ", PaymentRule=" + string + ", startDocumentNo=" + n2);
        List<MHRPaySelectionCheck> list = new Query(properties, "HR_PaySelectionCheck", "HR_PaySelection_ID=? AND PaymentRule=?", string2).setClient_ID().setParameters(n, string).list();
        int n3 = n2;
        for (MHRPaySelectionCheck mHRPaySelectionCheck : list) {
            mHRPaySelectionCheck.setDocumentNo(String.valueOf(n3++));
        }
        return list;
    }

    public static int exportToFile(Collection<MHRPaySelectionCheck> collection, File file) {
        if (collection == null || collection.size() == 0) {
            return 0;
        }
        if (file.isDirectory()) {
            s_log.log(Level.WARNING, "File is directory - " + file.getAbsolutePath());
            return 0;
        }
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            s_log.log(Level.WARNING, "Could not delete - " + file.getAbsolutePath(), exception);
        }
        char c = '\"';
        int n = 0;
        StringBuffer stringBuffer = null;
        try {
            FileWriter fileWriter = new FileWriter(file);
            stringBuffer = new StringBuffer();
            stringBuffer.append(c).append("Value").append(c).append(",").append(c).append("Name").append(c).append(",").append(c).append("Contact").append(c).append(",").append(c).append("Addr1").append(c).append(",").append(c).append("Addr2").append(c).append(",").append(c).append("City").append(c).append(",").append(c).append("State").append(c).append(",").append(c).append("ZIP").append(c).append(",").append(c).append("Country").append(c).append(",").append(c).append("ReferenceNo").append(c).append(",").append(c).append("DocumentNo").append(c).append(",").append(c).append("PayDate").append(c).append(",").append(c).append("Currency").append(c).append(",").append(c).append("PayAmount").append(c).append(",").append(c).append("Comment").append(c).append(Env.NL);
            fileWriter.write(stringBuffer.toString());
            ++n;
            for (MHRPaySelectionCheck mHRPaySelectionCheck : collection) {
                if (mHRPaySelectionCheck == null) continue;
                String[] stringArray = MHRPaySelectionCheck.getBPartnerInfo(mHRPaySelectionCheck.getC_BPartner_ID());
                stringBuffer = new StringBuffer();
                stringBuffer.append(c).append(stringArray[0]).append(c).append(",").append(c).append(stringArray[1]).append(c).append(",").append(c).append(stringArray[2]).append(c).append(",").append(c).append(stringArray[3]).append(c).append(",").append(c).append(stringArray[4]).append(c).append(",").append(c).append(stringArray[5]).append(c).append(",").append(c).append(stringArray[6]).append(c).append(",").append(c).append(stringArray[7]).append(c).append(",").append(c).append(stringArray[8]).append(c).append(",").append(c).append(stringArray[9]).append(c).append(",").append(c).append(mHRPaySelectionCheck.getDocumentNo()).append(c).append(",").append(mHRPaySelectionCheck.getParent().getPayDate()).append(",").append(c).append(MCurrency.getISO_Code(Env.getCtx(), mHRPaySelectionCheck.getParent().getC_Currency_ID())).append(c).append(",").append(mHRPaySelectionCheck.getPayAmt()).append(",").append(Env.NL);
                fileWriter.write(stringBuffer.toString());
                ++n;
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            s_log.log(Level.SEVERE, "", exception);
        }
        return n;
    }

    private static String[] getBPartnerInfo(int n) {
        String[] stringArray = new String[10];
        String string = "SELECT bp.Value, bp.Name, c.Name AS Contact, a.Address1, a.Address2, a.City, r.Name AS Region, a.Postal, cc.Name AS Country, bp.ReferenceNo FROM C_BPartner bp, AD_User c, C_BPartner_Location l, C_Location a, C_Region r, C_Country cc WHERE bp.C_BPartner_ID=? AND bp.C_BPartner_ID=c.C_BPartner_ID(+) AND bp.C_BPartner_ID=l.C_BPartner_ID AND l.C_Location_ID=a.C_Location_ID AND a.C_Region_ID=r.C_Region_ID(+) AND a.C_Country_ID=cc.C_Country_ID ORDER BY l.IsBillTo DESC";
        try {
            CPreparedStatement cPreparedStatement = DB.prepareStatement(string, null);
            cPreparedStatement.setInt(1, n);
            ResultSet resultSet = cPreparedStatement.executeQuery();
            if (resultSet.next()) {
                stringArray[0] = resultSet.getString(1);
                if (stringArray[0] == null) {
                    stringArray[0] = "";
                }
                stringArray[1] = resultSet.getString(2);
                if (stringArray[1] == null) {
                    stringArray[1] = "";
                }
                stringArray[2] = resultSet.getString(3);
                if (stringArray[2] == null) {
                    stringArray[2] = "";
                }
                stringArray[3] = resultSet.getString(4);
                if (stringArray[3] == null) {
                    stringArray[3] = "";
                }
                stringArray[4] = resultSet.getString(5);
                if (stringArray[4] == null) {
                    stringArray[4] = "";
                }
                stringArray[5] = resultSet.getString(6);
                if (stringArray[5] == null) {
                    stringArray[5] = "";
                }
                stringArray[6] = resultSet.getString(7);
                if (stringArray[6] == null) {
                    stringArray[6] = "";
                }
                stringArray[7] = resultSet.getString(8);
                if (stringArray[7] == null) {
                    stringArray[7] = "";
                }
                stringArray[8] = resultSet.getString(9);
                if (stringArray[8] == null) {
                    stringArray[8] = "";
                }
                stringArray[9] = resultSet.getString(10);
                if (stringArray[9] == null) {
                    stringArray[9] = "";
                }
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            s_log.log(Level.SEVERE, string, sQLException);
        }
        return stringArray;
    }

    public static int confirmPrint(Collection<MHRPaySelectionCheck> collection, MPaymentBatch mPaymentBatch) {
        int n = 0;
        for (MHRPaySelectionCheck mHRPaySelectionCheck : collection) {
            int n2;
            String string = "SELECT HR_Concept_ID FROM HR_Movement  WHERE HR_Movement_ID IN(SELECT HR_Movement_ID FROM HR_PaySelectionLine  WHERE C_BPartner_ID=" + mHRPaySelectionCheck.getC_BPartner_ID() + " AND HR_PaySelection_ID=" + mHRPaySelectionCheck.getHR_PaySelection_ID() + ")";
            System.err.println("Concept: " + string);
            int n3 = DB.getSQLValue(mHRPaySelectionCheck.get_TrxName(), string);
            String string2 = "SELECT HR_Payroll_ID FROM HR_Process  WHERE HR_Process_ID IN(SELECT HR_Process_ID FROM HR_Movement  WHERE HR_Movement_ID IN(SELECT HR_Movement_ID FROM HR_PaySelectionLine  WHERE C_BPartner_ID=" + mHRPaySelectionCheck.getC_BPartner_ID() + " AND HR_PaySelection_ID=" + mHRPaySelectionCheck.getHR_PaySelection_ID() + ") )";
            System.err.println("Payroll: " + string2);
            int n4 = DB.getSQLValue(mHRPaySelectionCheck.get_TrxName(), string2);
            MHRConcept mHRConcept = new MHRConcept(mHRPaySelectionCheck.getCtx(), n3, mHRPaySelectionCheck.get_TrxName());
            MHRPayroll mHRPayroll = new MHRPayroll(mHRPaySelectionCheck.getCtx(), n4, mHRPaySelectionCheck.get_TrxName());
            MPayment mPayment = new MPayment(mHRPaySelectionCheck.getCtx(), mHRPaySelectionCheck.getC_Payment_ID(), mHRPaySelectionCheck.get_TrxName());
            if (mHRPaySelectionCheck.getC_Payment_ID() != 0) {
                if (mHRPaySelectionCheck.getPaymentRule().equals("S")) {
                    mPayment.setCheckNo(mHRPaySelectionCheck.getDocumentNo());
                    if (!mPayment.save()) {
                        s_log.log(Level.SEVERE, "Payment not saved: " + mPayment);
                    }
                }
            } else {
                int n5;
                mPayment = new MPayment(mHRPaySelectionCheck.getCtx(), 0, null);
                if (mHRPaySelectionCheck.getPaymentRule().equals("S")) {
                    mPayment.setBankCheck(mHRPaySelectionCheck.getParent().getC_BankAccount_ID(), false, mHRPaySelectionCheck.getDocumentNo());
                } else if (mHRPaySelectionCheck.getPaymentRule().equals("K")) {
                    mPayment.setTenderType("C");
                } else if (mHRPaySelectionCheck.getPaymentRule().equals("T") || mHRPaySelectionCheck.getPaymentRule().equals("D")) {
                    mPayment.setTenderType("D");
                } else {
                    s_log.log(Level.SEVERE, "Unsupported Payment Rule=" + mHRPaySelectionCheck.getPaymentRule());
                    continue;
                }
                mPayment.setTrxType("C");
                mPayment.setAmount(mHRPaySelectionCheck.getParent().getC_Currency_ID(), mHRPaySelectionCheck.getPayAmt());
                mPayment.setDiscountAmt(mHRPaySelectionCheck.getDiscountAmt());
                mPayment.setDateTrx(mHRPaySelectionCheck.getParent().getPayDate());
                mPayment.setDateAcct(mPayment.getDateTrx());
                mPayment.setC_BPartner_ID(mHRPaySelectionCheck.getC_BPartner_ID());
                n2 = DB.getSQLValue(mHRPaySelectionCheck.get_TrxName(), "SELECT MAX(C_Charge_ID) FROM HR_Attribute WHERE IsActive='Y' AND HR_Concept_ID=" + n3);
                if (n2 <= 0) {
                    mPayment.setC_Charge_ID(mHRPayroll.getC_Charge_ID());
                } else {
                    mPayment.setC_Charge_ID(n2);
                }
                mPayment.setC_BankAccount_ID(mHRPaySelectionCheck.getParent().getC_BankAccount_ID());
                mPayment.setWriteOffAmt(Env.ZERO);
                if (!mPayment.save()) {
                    s_log.log(Level.SEVERE, "Payment not saved: " + mPayment);
                }
                if ((n5 = mPayment.get_ID()) < 1) {
                    s_log.log(Level.SEVERE, "Payment not created=" + mHRPaySelectionCheck);
                } else {
                    mHRPaySelectionCheck.setC_Payment_ID(n5);
                    mHRPaySelectionCheck.save();
                    mPayment.processIt("CO");
                    if (!mPayment.save()) {
                        s_log.log(Level.SEVERE, "Payment not saved: " + mPayment);
                    }
                    mPayment.setAD_Org_ID(mHRPaySelectionCheck.getAD_Org_ID());
                    mPayment.setAD_OrgTrx_ID(mHRPaySelectionCheck.getAD_Org_ID());
                    mPayment.saveEx();
                }
            }
            try {
                n2 = Integer.parseInt(mHRPaySelectionCheck.getDocumentNo());
                if (n < n2) {
                    n = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                s_log.log(Level.SEVERE, "DocumentNo=" + mHRPaySelectionCheck.getDocumentNo(), numberFormatException);
            }
            mHRPaySelectionCheck.setIsPrinted(true);
            mHRPaySelectionCheck.setProcessed(true);
            if (mHRPaySelectionCheck.save()) continue;
            s_log.log(Level.SEVERE, "Check not saved: " + mHRPaySelectionCheck);
        }
        s_log.fine("Last Document No = " + n);
        return n;
    }

    public MHRPaySelectionCheck(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setPayAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setIsPrinted(false);
            this.setIsReceipt(false);
            this.setQty(0);
        }
    }

    public MHRPaySelectionCheck(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MHRPaySelectionCheck(MHRPaySelectionLine mHRPaySelectionLine, String string) {
        this(mHRPaySelectionLine.getCtx(), 0, mHRPaySelectionLine.get_TrxName());
        this.setClientOrg(mHRPaySelectionLine);
        this.setHR_PaySelection_ID(mHRPaySelectionLine.getHR_PaySelection_ID());
        this.setAD_Org_ID(mHRPaySelectionLine.getHR_Movement().getAD_Org_ID());
        int n = mHRPaySelectionLine.getHR_Movement().getC_BPartner_ID();
        this.setC_BPartner_ID(n);
        if ("D".equals(string)) {
            MBPBankAccount[] mBPBankAccountArray = MBPBankAccount.getOfBPartner(mHRPaySelectionLine.getCtx(), n);
            for (int i = 0; i < mBPBankAccountArray.length; ++i) {
                MBPBankAccount mBPBankAccount = mBPBankAccountArray[i];
                if (!mBPBankAccount.isDirectDebit()) continue;
                this.setC_BP_BankAccount_ID(mBPBankAccount.getC_BP_BankAccount_ID());
                break;
            }
        } else if ("T".equals(string)) {
            MBPBankAccount[] mBPBankAccountArray = MBPBankAccount.getOfBPartner(mHRPaySelectionLine.getCtx(), n);
            for (int i = 0; i < mBPBankAccountArray.length; ++i) {
                MBPBankAccount mBPBankAccount = mBPBankAccountArray[i];
                if (!mBPBankAccount.isDirectDeposit()) continue;
                this.setC_BP_BankAccount_ID(mBPBankAccount.getC_BP_BankAccount_ID());
                break;
            }
        }
        this.setPaymentRule(string);
        this.setIsReceipt(mHRPaySelectionLine.isSOTrx());
        this.setPayAmt(mHRPaySelectionLine.getPayAmt());
        this.setDiscountAmt(mHRPaySelectionLine.getDiscountAmt());
        this.setQty(1);
    }

    public MHRPaySelectionCheck(MHRPaySelection mHRPaySelection, String string) {
        this(mHRPaySelection.getCtx(), 0, mHRPaySelection.get_TrxName());
        this.setClientOrg(mHRPaySelection);
        this.setHR_PaySelection_ID(mHRPaySelection.getHR_PaySelection_ID());
        this.setPaymentRule(string);
    }

    public void addLine(MHRPaySelectionLine mHRPaySelectionLine) {
        if (this.getC_BPartner_ID() != mHRPaySelectionLine.getHR_Movement().getC_BPartner_ID()) {
            throw new IllegalArgumentException("Line for fifferent BPartner");
        }
        if (this.isReceipt() == mHRPaySelectionLine.isSOTrx()) {
            this.setPayAmt(this.getPayAmt().add(mHRPaySelectionLine.getPayAmt()));
            this.setDiscountAmt(this.getDiscountAmt().add(mHRPaySelectionLine.getDiscountAmt()));
        } else {
            this.setPayAmt(this.getPayAmt().subtract(mHRPaySelectionLine.getPayAmt()));
            this.setDiscountAmt(this.getDiscountAmt().subtract(mHRPaySelectionLine.getDiscountAmt()));
        }
        this.setQty(this.getQty() + 1);
    }

    public MHRPaySelection getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MHRPaySelection(this.getCtx(), this.getHR_PaySelection_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public boolean isValid() {
        if (this.getC_BP_BankAccount_ID() != 0) {
            return true;
        }
        return !this.isDirect();
    }

    public boolean isDirect() {
        return "T".equals(this.getPaymentRule()) || "D".equals(this.getPaymentRule());
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MHRPaymentCheck[");
        stringBuffer.append(this.get_ID()).append("-").append(this.getDocumentNo()).append("-").append(this.getPayAmt()).append(",PaymetRule=").append(this.getPaymentRule()).append(",Qty=").append(this.getQty()).append("]");
        return stringBuffer.toString();
    }

    public Collection<MHRPaySelectionLine> getPaySelectionLines(boolean bl) {
        if (this.m_lines != null && !bl) {
            return this.m_lines;
        }
        List list = new Query(this.getCtx(), "HR_PaySelectionLine", "HR_PaySelectionCheck_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.getHR_PaySelectionCheck_ID()).setOrderBy("Line").list();
        this.m_lines = list;
        return this.m_lines;
    }

    public static boolean deleteGeneratedDraft(Properties properties, int n, String string) {
        MHRPaySelectionCheck mHRPaySelectionCheck = MHRPaySelectionCheck.getOfPayment(properties, n, string);
        if (mHRPaySelectionCheck != null && mHRPaySelectionCheck.isGeneratedDraft()) {
            MHRPaySelection mHRPaySelection = new MHRPaySelection(properties, mHRPaySelectionCheck.getHR_PaySelection_ID(), string);
            MHRPaySelectionLine[] mHRPaySelectionLineArray = mHRPaySelection.getLines(true);
            for (int i = 0; i < mHRPaySelectionLineArray.length; ++i) {
                if (mHRPaySelectionLineArray[i].delete(true, string)) continue;
                return false;
            }
            if (!mHRPaySelectionCheck.delete(true, string)) {
                return false;
            }
            if (!mHRPaySelection.delete(true, string)) {
                return false;
            }
        }
        return true;
    }
}

