/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util.sogexis.ecommerce.magento;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.sogexis.ecommerce.magento.ZECommerceParameterBean;
import org.compiere.util.sogexis.ecommerce.magento.ZECommerceTypeBean;

public class MagentoUtils {
    private static String updateZECommerceAssoSql = "UPDATE --table-- SET lastsynchronized = ?, updated = ?, updatedby = ? WHERE --key-- = ? AND z_ecommerce_parameter_id = ?";
    private static String updateZECommerceAssoStockSql = "UPDATE --table-- SET lastsynchronizedstock = ?, updated = ?, updatedby = ? WHERE --key-- = ? AND z_ecommerce_parameter_id = ?";
    private static String insertZECommerceAssoSql = "INSERT INTO --table-- (ad_client_id, ad_org_id, created, createdby, isactive, lastsynchronized, --key--, z_ecommerce_parameter_id, updated, updatedby, --keyID--) VALUES (?,?,?,?,?,?,?,?,?,?,?)";

    public static void updateZECommerceAsso(String table2, String key, int id, ZECommerceParameterBean zECommerceParamtereBean, PreparedStatement pstmt, Trx trx, int idUser) throws SQLException {
        Timestamp time = new Timestamp(new Date().getTime());
        pstmt = DB.prepareStatement(updateZECommerceAssoSql.replaceAll("--table--", table2).replaceAll("--key--", key), trx.getTrxName());
        pstmt.setTimestamp(1, time);
        pstmt.setTimestamp(2, time);
        pstmt.setInt(3, idUser);
        pstmt.setInt(4, id);
        pstmt.setInt(5, zECommerceParamtereBean.getId());
        pstmt.executeUpdate();
    }

    public static void updateZECommerceAssoStock(String table2, String key, int id, ZECommerceParameterBean zECommerceParamtereBean, PreparedStatement pstmt, Trx trx, int idUser) throws SQLException {
        Timestamp time = new Timestamp(new Date().getTime());
        pstmt = DB.prepareStatement(updateZECommerceAssoStockSql.replaceAll("--table--", table2).replaceAll("--key--", key), trx.getTrxName());
        pstmt.setTimestamp(1, time);
        pstmt.setTimestamp(2, time);
        pstmt.setInt(3, idUser);
        pstmt.setInt(4, id);
        pstmt.setInt(5, zECommerceParamtereBean.getId());
        pstmt.executeUpdate();
    }

    public static void insertZECommerceAsso(String table2, String key, String keyID, int id, ZECommerceParameterBean zECommerceParamtereBean, PreparedStatement pstmt, Trx trx, int idUser) throws SQLException {
        Timestamp time = new Timestamp(new Date().getTime());
        int no = DB.getNextID(zECommerceParamtereBean.getAD_Client_ID(), table2, trx.getTrxName());
        pstmt = DB.prepareStatement(insertZECommerceAssoSql.replaceAll("--table--", table2).replaceAll("--keyID--", keyID).replaceAll("--key--", key), trx.getTrxName());
        pstmt.setInt(1, zECommerceParamtereBean.getAD_Client_ID());
        pstmt.setInt(2, zECommerceParamtereBean.getAD_Org_ID());
        pstmt.setTimestamp(3, time);
        pstmt.setInt(4, idUser);
        pstmt.setString(5, "Y");
        pstmt.setTimestamp(6, time);
        pstmt.setInt(7, id);
        pstmt.setInt(8, zECommerceParamtereBean.getId());
        pstmt.setTimestamp(9, time);
        pstmt.setInt(10, idUser);
        pstmt.setInt(11, no);
        pstmt.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ZECommerceParameterBean> getZECommerceParameterBeanList() {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT * FROM Z_ECommerce_Parameter  WHERE isactive = 'Y'";
        ArrayList<ZECommerceParameterBean> zECommerceParameterList = new ArrayList<ZECommerceParameterBean>();
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ZECommerceParameterBean bean = new ZECommerceParameterBean();
                MagentoUtils.mapZECommerceParameterList(rs, bean);
                zECommerceParameterList.add(bean);
            }
        }
        catch (SQLException ex) {
            try {
                System.out.println(ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return zECommerceParameterList;
    }

    private static void mapZECommerceParameterList(ResultSet rs, ZECommerceParameterBean bean) throws SQLException {
        bean.setAD_Client_ID(rs.getInt("ad_client_id"));
        bean.setAD_Org_ID(rs.getInt("ad_org_id"));
        bean.setC_Currency_ID(rs.getInt("c_currency_id"));
        bean.setC_DocType_ID(rs.getInt("c_doctype_id"));
        bean.setDocAction(rs.getString("docaction"));
        bean.setM_PriceList_ID(rs.getInt("m_pricelist_id"));
        bean.setM_Warehouse_ID(rs.getInt("m_warehouse_id"));
        bean.setSalesrep_ID(rs.getInt("salesrep_id"));
        bean.setId(rs.getInt("z_ecommerce_parameter_id"));
        bean.setUrl(rs.getString("url"));
        bean.setTitle(rs.getString("title"));
        bean.setC_BP_Group_ID(rs.getInt("c_bp_group_id"));
        bean.setZ_Login(rs.getString("z_login"));
        bean.setZ_Magento_Origin(rs.getString("z_magento_origin"));
        bean.setZ_Password(rs.getString("z_password"));
        String stock = rs.getString("z_ecommerce_is_stock_all_ware");
        bean.setZ_ECommerce_Is_Stock_All(stock != null && stock.equalsIgnoreCase("y"));
        bean.setZ_ECommerce_Categorie_ID(rs.getString("z_ecommerce_categorie_id"));
        bean.setZ_ECommerce_Type(ZECommerceTypeBean.valueOf(rs.getString("z_ecommerce_type")));
        bean.setC_Country_ID(rs.getInt("C_Country_ID"));
        bean.setDeliveryRule(rs.getString("DeliveryRule"));
        bean.setPriorityRule(rs.getString("PriorityRule"));
        bean.setFreightCostRule(rs.getString("FreightCostRule"));
        bean.setInvoiceRule(rs.getString("InvoiceRule"));
        bean.setC_PaymentTerm_ID(rs.getInt("C_PaymentTerm_ID"));
        bean.setM_Product_ID(rs.getInt("M_Product_ID"));
        bean.setC_BankAccount_ID(rs.getInt("C_BankAccount_ID"));
        bean.setZ_ECommerce_Website_ID(rs.getString("Z_ECommerce_Website_ID"));
        String taxCategory = rs.getString("z_tax_category_mapping");
        String[] taxCategoryTab = taxCategory.split(";");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String taxCat : taxCategoryTab) {
            map.put(taxCat.split(":")[0], taxCat.split(":")[1]);
        }
        bean.setMTaxCategoryMap(map);
    }

    public static MUser getMUserForEmail(Properties ctx, Trx trx, String email) {
        MUser mUser = (MUser)new Query(ctx, "AD_User", "email = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters(email).first();
        return mUser;
    }

    public static MBPartnerLocation getMBPartnerLocationForID(Properties ctx, Trx trx, int idAddress) {
        MBPartnerLocation mbPartnerLocation = (MBPartnerLocation)new Query(ctx, "C_BPartner_Location", "C_BPartner_Location_ID = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters(idAddress).first();
        return mbPartnerLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getMProductIDForRefAndZEcommerce(Properties ctx, Trx trx, ZECommerceParameterBean zECommerceParamtereBean, String reference) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT _pro.M_Product_ID FROM M_Product _pro INNER JOIN z_ecommerce_m_product _asso ON _pro.M_Product_ID = _asso.M_Product_ID WHERE _asso.z_ecommerce_parameter_id = " + zECommerceParamtereBean.getId() + " AND _pro.isactive = 'Y'" + " AND _pro.ad_client_id = " + zECommerceParamtereBean.getAD_Client_ID() + " AND (_pro.ad_org_id = 0 OR _pro.ad_org_id = " + zECommerceParamtereBean.getAD_Org_ID() + ")" + " AND _pro.value = ?";
        Integer id = null;
        try {
            pstmt = DB.prepareStatement(sql, trx.getTrxName());
            pstmt.setString(1, reference);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                id = rs.getInt(1);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return id;
    }

    public static MOrder getMOrderForIDECommerce(Properties ctx, Trx trx, int idZECommerceParameter, int idZMagentoOrder) {
        MOrder mOrderExisting = (MOrder)new Query(Env.getCtx(), "C_Order", "z_ecommerce_parameter_id = ? AND Z_Magento_Order_ID = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters(idZECommerceParameter, idZMagentoOrder).first();
        return mOrderExisting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean[] isCategorySynchronized(int idParameter, int idCategory, Trx trx) {
        ResultSet rs;
        CPreparedStatement pstmt;
        boolean isActive;
        boolean created;
        boolean isAlready;
        block4: {
            isAlready = false;
            created = false;
            isActive = false;
            pstmt = null;
            rs = null;
            String sql = "SELECT _asso.z_ecommerce_parameter_id, _asso.lastsynchronized, _asso.isactive FROM Z_ECommerce_M_Product_Cat _asso WHERE _asso.z_ecommerce_parameter_id = " + idParameter + " AND _asso.M_Product_Category_ID = " + idCategory;
            try {
                pstmt = DB.prepareStatement(sql, trx.getTrxName());
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                created = rs.getObject(1) != null;
                isAlready = created && rs.getObject(2) != null;
                isActive = rs.getObject(3) != null && "Y".equalsIgnoreCase(rs.getString(3));
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    pstmt = null;
                    rs = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                pstmt = null;
                rs = null;
            }
        }
        DB.close(rs, pstmt);
        pstmt = null;
        rs = null;
        boolean[] tab = new boolean[]{isAlready, created, isActive};
        return tab;
    }
}

