/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util.sogexis.ecommerce.magento;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.model.Tax;
import org.compiere.util.CLogger;
import org.compiere.util.Trx;
import org.compiere.util.sogexis.ecommerce.magento.MagentoAPI;
import org.compiere.util.sogexis.ecommerce.magento.MagentoUtils;
import org.compiere.util.sogexis.ecommerce.magento.ZECommerceParameterBean;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncSalesOrderEntity;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncSalesOrderInvoicePaymentEntity;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncSalesOrderItemEntity;

public class MagentoSyncOrderMagentoToAdempiere {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private ZECommerceParameterBean zECommerceParamtereBean;
    private MagentoAPI api;
    private Properties context;

    public MagentoSyncOrderMagentoToAdempiere(ZECommerceParameterBean zECommerceParamtereBean, MagentoAPI api, Properties context) {
        this.zECommerceParamtereBean = zECommerceParamtereBean;
        this.api = api;
        this.context = context;
    }

    private Properties getCtx() {
        return this.context;
    }

    public void processSync() {
        this.syncOrder();
        this.syncOrderPayment();
    }

    private void syncOrderPayment() {
        List<SyncSalesOrderInvoicePaymentEntity> magentoPaymentList = this.api.getPaymentValidatedToSyncList();
        if (magentoPaymentList != null && magentoPaymentList.size() > 0) {
            for (SyncSalesOrderInvoicePaymentEntity magentoEntity : magentoPaymentList) {
                Trx trx = Trx.get(Trx.createTrxName(), false);
                MOrder mOrderExisting = MagentoUtils.getMOrderForIDECommerce(this.getCtx(), trx, this.zECommerceParamtereBean.getId(), Integer.parseInt(magentoEntity.getOrderIncrementId()));
                if (mOrderExisting == null || !StringUtils.isEmpty((String)magentoEntity.getDateSync()) || !magentoEntity.getMethod().toLowerCase().contains("paypal") || !magentoEntity.getState().toLowerCase().equals("2")) continue;
                this.createPayment(mOrderExisting, magentoEntity, trx);
            }
        }
    }

    private void createPayment(MOrder mOrder, SyncSalesOrderInvoicePaymentEntity magentoEntity, Trx trx) {
        String errorMsg = "";
        boolean isOK = true;
        try {
            MInvoice[] mInvoiceArray;
            MPayment mPayment = new MPayment(this.getCtx(), 0, trx.getTrxName());
            mPayment.setAD_Org_ID(this.zECommerceParamtereBean.getAD_Org_ID());
            mPayment.setC_BankAccount_ID(this.zECommerceParamtereBean.getC_BankAccount_ID());
            mPayment.setDateTrx(Timestamp.valueOf(magentoEntity.getCreatedAt()));
            mPayment.setDateAcct(Timestamp.valueOf(magentoEntity.getCreatedAt()));
            MUser mUser = MagentoUtils.getMUserForEmail(this.getCtx(), trx, magentoEntity.getEmail());
            if (mUser == null) {
                errorMsg = errorMsg + "\n Tiers correspondant au client Magento introuvable";
                isOK = false;
            }
            mPayment.setC_BPartner_ID(mUser.getC_BPartner_ID());
            if (mOrder == null) {
                errorMsg = errorMsg + "\n commande Magento correspondante introuvable";
                isOK = false;
            }
            if ((mInvoiceArray = mOrder.getInvoices()).length > 0) {
                MInvoice mInvoice = mInvoiceArray[0];
                mPayment.setC_Invoice_ID(mInvoice.get_ID());
            } else {
                mPayment.setC_Order_ID(mOrder.get_ID());
            }
            MCurrency mCurrency = (MCurrency)new Query(this.getCtx(), "C_Currency", "ISO_Code = ?", trx.getTrxName()).setOnlyActiveRecords(true).setParameters(magentoEntity.getCurrencyCode()).first();
            if (mCurrency != null) {
                mPayment.setC_Currency_ID(mCurrency.get_ID());
            } else {
                mPayment.setC_Currency_ID(this.zECommerceParamtereBean.getC_Currency_ID());
            }
            mPayment.setPayAmt(new BigDecimal(magentoEntity.getAmount()));
            if (magentoEntity.getMethod().toLowerCase().contains("paypal")) {
                mPayment.setTenderType("C");
                mOrder.setDescription("Paiement Paypal - Confirm\u00e9");
            }
            int GL_Category_ID = new Query(this.getCtx(), "GL_Category", "C_BankAccount_ID=?", trx.getTrxName()).setParameters(this.zECommerceParamtereBean.getC_BankAccount_ID()).firstIdOnly();
            int C_DocType_ID = new Query(this.getCtx(), "C_DocType", "GL_Category_ID=? AND docbasetype=?", trx.getTrxName()).setParameters(GL_Category_ID, "ARR").firstIdOnly();
            mPayment.setC_DocType_ID(C_DocType_ID);
            if (isOK) {
                isOK = mPayment.save();
            }
            if (isOK) {
                mPayment.setDocAction("CO");
                mPayment.processIt("CO");
                isOK = mPayment.save();
                isOK &= mOrder.save();
            }
            if (!isOK) {
                this.log.log(Level.SEVERE, "Erreur creation de paiement : " + errorMsg);
                trx.rollback();
            } else {
                trx.commit(true);
                this.api.updatePaymentValidatedDateSync(Integer.parseInt(magentoEntity.getInvoiceIncrementId()));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            trx.rollback();
            this.log.log(Level.SEVERE, "Erreur creation paiement Commit: " + e.getMessage());
            this.log.log(Level.SEVERE, "Erreur creation de paiement : " + errorMsg);
        }
    }

    private void syncOrder() {
        List<SyncSalesOrderEntity> magentoOrderList = this.api.getOrderToSyncList();
        if (magentoOrderList != null && magentoOrderList.size() > 0) {
            for (SyncSalesOrderEntity magentoEntity : magentoOrderList) {
                Trx trx = Trx.get(Trx.createTrxName(), false);
                MOrder mOrderExisting = MagentoUtils.getMOrderForIDECommerce(this.getCtx(), trx, this.zECommerceParamtereBean.getId(), Integer.parseInt(magentoEntity.getIncrementId()));
                if (mOrderExisting != null) {
                    this.updateOrder(mOrderExisting, magentoEntity, trx);
                } else {
                    this.createOrder(magentoEntity, trx);
                }
                trx.close();
            }
        }
    }

    private void createOrder(SyncSalesOrderEntity magentoEntity, Trx trx) {
        String errorMsg = "";
        boolean isOK = true;
        try {
            MOrder mOrder = new MOrder(this.getCtx(), 0, trx.getTrxName());
            mOrder.setClientOrg(this.zECommerceParamtereBean.getAD_Client_ID(), this.zECommerceParamtereBean.getAD_Org_ID());
            mOrder.setC_DocType_ID(this.zECommerceParamtereBean.getC_DocType_ID());
            mOrder.setC_DocTypeTarget_ID(this.zECommerceParamtereBean.getC_DocType_ID());
            mOrder.setIsSOTrx(true);
            mOrder.setDateOrdered(Timestamp.valueOf(magentoEntity.getCreatedAt()));
            mOrder.setDatePromised(new Timestamp(new Date().getTime()));
            mOrder.set_ValueOfColumn("z_ecommerce_parameter_id", (Object)this.zECommerceParamtereBean.getId());
            MUser mUser = MagentoUtils.getMUserForEmail(this.getCtx(), trx, magentoEntity.getEmail());
            if (mUser == null) {
                this.log.log(Level.SEVERE, magentoEntity.toString());
                this.log.log(Level.SEVERE, "Erreur creation de commande MOrder car le MBPartner n'existe pas: " + errorMsg);
                isOK = false;
            } else {
                mOrder.setC_BPartner_ID(mUser.getC_BPartner_ID());
                mOrder.setBill_BPartner_ID(mUser.getC_BPartner_ID());
                MBPartnerLocation mBpartnerLocationShipping = MagentoUtils.getMBPartnerLocationForID(this.getCtx(), trx, Integer.parseInt(magentoEntity.getShippingAddress().getAdempiereId()));
                if (mBpartnerLocationShipping != null) {
                    mOrder.setC_BPartner_Location_ID(mBpartnerLocationShipping.get_ID());
                    mOrder.setAD_User_ID(mUser.get_ID());
                } else {
                    errorMsg = errorMsg + "\n Adresse de livraison introuvable";
                    this.log.log(Level.SEVERE, magentoEntity.toString());
                    this.log.log(Level.SEVERE, "Erreur creation de commande MOrder car le adresse de livraison n'existe pas: " + errorMsg);
                    isOK = false;
                }
                MBPartnerLocation mBpartnerLocationBilling = MagentoUtils.getMBPartnerLocationForID(this.getCtx(), trx, Integer.parseInt(magentoEntity.getBillingAddress().getAdempiereId()));
                if (mBpartnerLocationBilling != null) {
                    mOrder.setBill_Location_ID(mBpartnerLocationBilling.get_ID());
                    mOrder.setBill_User_ID(mUser.get_ID());
                } else {
                    errorMsg = errorMsg + "\n Adresse de facturation introuvable";
                    this.log.log(Level.SEVERE, magentoEntity.toString());
                    this.log.log(Level.SEVERE, "Erreur creation de commande MOrder car le adresse de facturation n'existe pas: " + errorMsg);
                    isOK = false;
                }
                mOrder.setDeliveryRule(this.zECommerceParamtereBean.getDeliveryRule());
                mOrder.setPriorityRule(this.zECommerceParamtereBean.getPriorityRule());
                mOrder.setFreightCostRule(this.zECommerceParamtereBean.getFreightCostRule());
                mOrder.setInvoiceRule(this.zECommerceParamtereBean.getInvoiceRule());
                mOrder.setM_Warehouse_ID(this.zECommerceParamtereBean.getM_Warehouse_ID());
                mOrder.setM_PriceList_ID(this.zECommerceParamtereBean.getM_PriceList_ID());
                mOrder.setC_Currency_ID(this.zECommerceParamtereBean.getC_Currency_ID());
                mOrder.setSalesRep_ID(this.zECommerceParamtereBean.getSalesrep_ID());
                mOrder.setC_PaymentTerm_ID(this.zECommerceParamtereBean.getC_PaymentTerm_ID());
                mOrder.set_ValueOfColumn("Z_Magento_Order_ID", (Object)Integer.parseInt(magentoEntity.getIncrementId()));
                mOrder.set_ValueOfColumn("POReference", (Object)Integer.parseInt(magentoEntity.getIncrementId()));
                this.copyPropertiesSalesOrderFromMagentoToAdempiere(mOrder, magentoEntity, trx);
                if (magentoEntity.getPayment().getMethod().toLowerCase().contains("paypal")) {
                    mOrder.setPaymentRule("P");
                } else {
                    mOrder.setPaymentRule("S");
                }
                if (isOK) {
                    if (!mOrder.save()) {
                        isOK = false;
                        this.log.log(Level.SEVERE, magentoEntity.toString());
                        this.log.log(Level.SEVERE, "La commande n'a pas pu \u00eatre cr\u00e9ee: " + errorMsg);
                    } else {
                        List<SyncSalesOrderItemEntity> items = magentoEntity.getItems().getComplexObjectArray();
                        for (int i2 = 0; i2 < items.size(); ++i2) {
                            MOrderLine mOrderLine = new MOrderLine(this.getCtx(), 0, trx.getTrxName());
                            mOrderLine.setLine(i2 * 10);
                            mOrderLine.setC_Order_ID(mOrder.get_ID());
                            mOrderLine.setAD_Org_ID(mOrder.getAD_Org_ID());
                            Integer mProductID = MagentoUtils.getMProductIDForRefAndZEcommerce(this.context, trx, this.zECommerceParamtereBean, items.get(i2).getSku());
                            if (mProductID == null || mProductID <= 0) {
                                this.log.log(Level.SEVERE, magentoEntity.toString());
                                errorMsg = errorMsg + "\n Produit Magento correspondant introuvable";
                                isOK = false;
                                break;
                            }
                            mOrderLine.setM_Product_ID(mProductID);
                            mOrderLine.setQty(new BigDecimal(items.get(i2).getQtyOrdered()));
                            mOrderLine.setPrice(new BigDecimal(items.get(i2).getPrice()));
                            mOrderLine.setDiscount(new BigDecimal(items.get(i2).getDiscountPercent()));
                            int C_Tax_ID = Tax.get(this.getCtx(), mProductID, 0, mOrder.getDateOrdered(), mOrder.getDatePromised(), mOrder.getAD_Org_ID(), mOrder.getM_Warehouse_ID(), mOrder.getBill_Location_ID(), mOrder.getC_BPartner_Location_ID(), true);
                            MTax mTax = (MTax)new Query(this.getCtx(), "C_Tax", "C_Tax_ID = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters(new BigDecimal(C_Tax_ID)).first();
                            if (mTax != null) {
                                BigDecimal percent = new BigDecimal(items.get(i2).getTaxPercent());
                                if (percent == null || percent.compareTo(mTax.getRate()) != 0) {
                                    this.log.log(Level.SEVERE, magentoEntity.toString());
                                    errorMsg = errorMsg + "\n Taxe Magento Et Adempiere ne correspondent pas : " + items.get(i2).getTaxPercent() + " / " + mTax.getRate().doubleValue();
                                    isOK = false;
                                    break;
                                }
                            } else {
                                this.log.log(Level.SEVERE, magentoEntity.toString());
                                this.log.log(Level.SEVERE, "Taxe Magento correspondante introuvable: " + errorMsg);
                                errorMsg = errorMsg + "\n Taxe Magento correspondante introuvable";
                                isOK = false;
                                break;
                            }
                            mOrderLine.setC_Tax_ID(C_Tax_ID);
                            mOrderLine.setPriceActual(new BigDecimal(items.get(i2).getBasePrice()));
                            mOrderLine.setPriceList(new BigDecimal(items.get(i2).getPrice()));
                            mOrderLine.set_ValueOfColumn("Z_Magento_OrderLine_ID", (Object)items.get(i2).getItemId());
                            if (mOrderLine.save()) continue;
                            isOK = false;
                            this.log.log(Level.SEVERE, magentoEntity.toString());
                            this.log.log(Level.SEVERE, "Erreur lors de la cr\u00e9ation de la ligne de commande: " + errorMsg);
                            break;
                        }
                        if (magentoEntity.getShippingAmount() != null) {
                            BigDecimal bigDecimal = new BigDecimal(magentoEntity.getShippingAmount());
                            if (bigDecimal.doubleValue() > 0.0) {
                                MOrderLine mOrderLine = new MOrderLine(this.getCtx(), 0, trx.getTrxName());
                                mOrderLine.setC_Order_ID(mOrder.get_ID());
                                mOrderLine.setAD_Org_ID(mOrder.getAD_Org_ID());
                                mOrderLine.setM_Product_ID(this.zECommerceParamtereBean.getM_Product_ID());
                                mOrderLine.setQty(new BigDecimal(1));
                                mOrderLine.setPrice(new BigDecimal(magentoEntity.getShippingAmount()));
                                MTax mTax = (MTax)new Query(this.getCtx(), "C_Tax", "rate = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters(new BigDecimal("0")).first();
                                if (mTax != null) {
                                    mOrderLine.setC_Tax_ID(mTax.get_ID());
                                } else {
                                    isOK = false;
                                    errorMsg = errorMsg + "\n Taxe Magento correspondante introuvable";
                                }
                                mOrderLine.setPriceActual(new BigDecimal(magentoEntity.getShippingAmount()));
                                mOrderLine.setPriceList(new BigDecimal(magentoEntity.getShippingAmount()));
                                if (!mOrderLine.save()) {
                                    isOK = false;
                                    this.log.log(Level.SEVERE, magentoEntity.toString());
                                    this.log.log(Level.SEVERE, "Erreur lors de la cr\u00e9ation de la ligne de commande frais de port: " + errorMsg);
                                }
                            }
                        }
                    }
                }
            }
            if (isOK) {
                if (magentoEntity.getStatus().equalsIgnoreCase("canceled")) {
                    if (mOrder.getDocStatus().compareTo("VO") != 0) {
                        mOrder.setDescription("Commande annul\u00e9e");
                        mOrder.setDocAction("VO");
                        mOrder.processIt("VO");
                    }
                } else {
                    mOrder.setDocAction(this.zECommerceParamtereBean.getDocAction());
                    mOrder.processIt(this.zECommerceParamtereBean.getDocAction());
                }
                isOK = mOrder.save();
            }
            if (!isOK) {
                trx.rollback();
            } else {
                trx.commit(true);
                this.api.updateOrderDateSync(Integer.parseInt(magentoEntity.getIncrementId()));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            trx.rollback();
            this.log.log(Level.SEVERE, magentoEntity.toString());
            this.log.log(Level.SEVERE, "Erreur creation Commande Commit: " + e.getMessage());
        }
    }

    private void updateOrder(MOrder mOrder, SyncSalesOrderEntity magentoEntity, Trx trx) {
        String errorMsg = "";
        boolean isOK = true;
        try {
            this.copyPropertiesSalesOrderFromMagentoToAdempiere(mOrder, magentoEntity, trx);
            if (magentoEntity.getStatus().equalsIgnoreCase("canceled") && mOrder.getDocStatus().compareTo("VO") != 0) {
                mOrder.setDescription("Commande annul\u00e9e");
                mOrder.setDocAction("VO");
                mOrder.processIt("VO");
            }
            if (!mOrder.save()) {
                this.log.log(Level.SEVERE, magentoEntity.toString());
                this.log.log(Level.SEVERE, "Erreur Mise \u00e0 Jour Commande : " + errorMsg);
                isOK = false;
            }
            if (!isOK) {
                trx.rollback();
            } else {
                trx.commit(true);
                this.api.updateOrderDateSync(Integer.parseInt(magentoEntity.getIncrementId()));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            trx.rollback();
            this.log.log(Level.SEVERE, magentoEntity.toString());
            this.log.log(Level.SEVERE, "Erreur Mise \u00e0 Jour Commande Commit: " + e.getMessage());
        }
    }

    private void copyPropertiesSalesOrderFromMagentoToAdempiere(MOrder mOrder, SyncSalesOrderEntity magentoEntity, Trx trx) {
        if (magentoEntity.getStatus().equalsIgnoreCase("pending_payment") || magentoEntity.getStatus().equalsIgnoreCase("payment_review")) {
            mOrder.setDescription("Paiement Paypal - En attente de confirmation");
        } else if (magentoEntity.getStatus().equalsIgnoreCase("fraud")) {
            mOrder.setDescription("Paiement Paypal - Fraude Suspect\u00e9e");
        } else if (magentoEntity.getStatus().equalsIgnoreCase("pending")) {
            mOrder.setDescription("En attente de r\u00e9ception du paiement par ch\u00e8que / esp\u00e8ces");
        } else if (magentoEntity.getStatus().equalsIgnoreCase("processing")) {
            mOrder.setDescription("");
        }
    }
}

