/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util.sogexis.ecommerce.magento;

import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCountry;
import org.compiere.model.MLocation;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Trx;
import org.compiere.util.sogexis.ecommerce.magento.MagentoAPI;
import org.compiere.util.sogexis.ecommerce.magento.MagentoUtils;
import org.compiere.util.sogexis.ecommerce.magento.ZECommerceParameterBean;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCustomerAddressEntity;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCustomerCustomerEntity;

public class MagentoSyncCustomerMagentoToAdempiere {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private ZECommerceParameterBean zECommerceParamtereBean;
    private MagentoAPI api;
    private Properties context;

    public MagentoSyncCustomerMagentoToAdempiere(ZECommerceParameterBean zECommerceParamtereBean, MagentoAPI api, Properties context) {
        this.zECommerceParamtereBean = zECommerceParamtereBean;
        this.api = api;
        this.context = context;
    }

    private Properties getCtx() {
        return this.context;
    }

    public void processSync() {
        this.syncCustomer();
        this.syncCustomerAddress();
    }

    private void syncCustomer() {
        List<SyncCustomerCustomerEntity> magentoCustomerList = this.api.getCustomerToSyncList();
        if (magentoCustomerList != null && magentoCustomerList.size() > 0) {
            for (SyncCustomerCustomerEntity magentoEntity : magentoCustomerList) {
                Trx trx = Trx.get(Trx.createTrxName(), false);
                MUser mUser = MagentoUtils.getMUserForEmail(this.getCtx(), trx, magentoEntity.getEmail());
                if (mUser != null) {
                    this.updateCustomer(mUser, magentoEntity, trx);
                } else {
                    this.createCustomer(magentoEntity, trx);
                }
                trx.close();
            }
        }
    }

    private void syncCustomerAddress() {
        List<SyncCustomerAddressEntity> magentoCustomerAddressList = this.api.getCustomerAddressToSyncList();
        if (magentoCustomerAddressList != null && magentoCustomerAddressList.size() > 0) {
            for (SyncCustomerAddressEntity magentoEntity : magentoCustomerAddressList) {
                Trx trx = Trx.get(Trx.createTrxName(), false);
                MUser mUser = MagentoUtils.getMUserForEmail(this.getCtx(), trx, magentoEntity.getEmail());
                if (mUser != null) {
                    MBPartnerLocation mbPartnerLocation = null;
                    if (magentoEntity.getAdempiereId() != null) {
                        mbPartnerLocation = (MBPartnerLocation)new Query(this.getCtx(), "C_BPartner_Location", "C_BPartner_Location_ID = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters((int)magentoEntity.getAdempiereId()).first();
                    }
                    if (mbPartnerLocation != null) {
                        this.updateCustomerAddress(mUser, mbPartnerLocation, magentoEntity, trx);
                    } else {
                        this.createCustomerAddress(mUser, magentoEntity, trx);
                    }
                } else {
                    this.log.log(Level.SEVERE, magentoEntity.toString());
                    this.log.log(Level.SEVERE, "Erreur creation Adresse - Le Tiers n'existe pas");
                }
                trx.close();
            }
        }
    }

    private void createCustomerAddress(MUser mUser, SyncCustomerAddressEntity magentoEntity, Trx trx) {
        String errorMsg = "";
        boolean isOK = true;
        try {
            MBPartnerLocation mbPartnerLocation = new MBPartnerLocation(this.getCtx(), 0, trx.getTrxName());
            MLocation mLocation = new MLocation(this.getCtx(), 0, trx.getTrxName());
            this.copyPropertiesCustomerAddressFromMagentoToAdempiere(mbPartnerLocation, mLocation, magentoEntity, trx);
            if (!mLocation.save()) {
                this.log.log(Level.SEVERE, magentoEntity.toString());
                this.log.log(Level.SEVERE, "Erreur creation Location pour adresse : " + errorMsg);
                isOK = false;
            }
            mbPartnerLocation.setC_Location_ID(mLocation.get_ID());
            mbPartnerLocation.setC_BPartner_ID(mUser.getC_BPartner_ID());
            if (!mbPartnerLocation.save()) {
                this.log.log(Level.SEVERE, magentoEntity.toString());
                this.log.log(Level.SEVERE, "Erreur creation MBPartner Location pour adresse : " + errorMsg);
                isOK = false;
            }
            if (!isOK) {
                trx.rollback();
            } else {
                trx.commit(true);
                this.api.updateCustomerAddressDateSync(magentoEntity.getCustomerAddressId(), mbPartnerLocation.getC_BPartner_Location_ID());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            trx.rollback();
            this.log.log(Level.SEVERE, magentoEntity.toString());
            this.log.log(Level.SEVERE, "Erreur creation Adresse Commit: " + e.getMessage());
        }
    }

    private void updateCustomerAddress(MUser mUser, MBPartnerLocation mbPartnerLocation, SyncCustomerAddressEntity magentoEntity, Trx trx) {
        String errorMsg = "";
        boolean isOK = true;
        try {
            MLocation mLocation = mbPartnerLocation.getLocation(true);
            this.copyPropertiesCustomerAddressFromMagentoToAdempiere(mbPartnerLocation, mLocation, magentoEntity, trx);
            if (!mLocation.save()) {
                this.log.log(Level.SEVERE, magentoEntity.toString());
                this.log.log(Level.SEVERE, "Erreur Mise \u00e0 Jour Location pour adresse : " + errorMsg);
                isOK = false;
            }
            if (!mbPartnerLocation.save()) {
                this.log.log(Level.SEVERE, magentoEntity.toString());
                this.log.log(Level.SEVERE, "Erreur Mise \u00e0 Jour MBPartner Location pour adresse : " + errorMsg);
                isOK = false;
            }
            if (!isOK) {
                trx.rollback();
            } else {
                trx.commit(true);
                this.api.updateCustomerAddressDateSync(magentoEntity.getCustomerAddressId(), mbPartnerLocation.getC_BPartner_Location_ID());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            trx.rollback();
            this.log.log(Level.SEVERE, magentoEntity.toString());
            this.log.log(Level.SEVERE, "Erreur Mise \u00e0 Jour Adresse Commit: " + e.getMessage());
        }
    }

    private void createCustomer(SyncCustomerCustomerEntity magentoEntity, Trx trx) {
        String errorMsg = "";
        boolean isOK = true;
        try {
            MBPartner mBPartner = new MBPartner(this.getCtx(), 0, trx.getTrxName());
            mBPartner.setClientOrg(this.zECommerceParamtereBean.getAD_Client_ID(), this.zECommerceParamtereBean.getAD_Org_ID());
            MUser mUser = new MUser(this.getCtx(), 0, trx.getTrxName());
            if (this.zECommerceParamtereBean.getC_BP_Group_ID() > 0) {
                mBPartner.setC_BP_Group_ID(this.zECommerceParamtereBean.getC_BP_Group_ID());
            } else {
                errorMsg = "Groupe de Tiers Magento manquant";
            }
            mBPartner.setIsProspect(false);
            mBPartner.setIsCustomer(true);
            this.copyPropertiesCustomerFromMagentoToAdempiere(mBPartner, mUser, magentoEntity);
            if (!mBPartner.save()) {
                this.log.log(Level.SEVERE, magentoEntity.toString());
                this.log.log(Level.SEVERE, "Erreur creation Tiers BPartner: " + errorMsg);
                isOK = false;
            }
            mUser.setC_BPartner_ID(mBPartner.get_ID());
            if (!mUser.save()) {
                this.log.log(Level.SEVERE, magentoEntity.toString());
                this.log.log(Level.SEVERE, "Erreur creation Tiers User: " + errorMsg);
                isOK = false;
            }
            if (!isOK) {
                trx.rollback();
            } else {
                trx.commit(true);
                this.api.updateCustomerDateSync(magentoEntity.getCustomerId());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            trx.rollback();
            this.log.log(Level.SEVERE, magentoEntity.toString());
            this.log.log(Level.SEVERE, "Erreur creation Tiers Commit: " + e.getMessage());
        }
    }

    private void updateCustomer(MUser mUser, SyncCustomerCustomerEntity magentoEntity, Trx trx) {
        String errorMsg = "";
        boolean isOK = true;
        try {
            MBPartner mBPartner = (MBPartner)mUser.getC_BPartner();
            this.copyPropertiesCustomerFromMagentoToAdempiere(mBPartner, mUser, magentoEntity);
            if (!mBPartner.save()) {
                this.log.log(Level.SEVERE, magentoEntity.toString());
                this.log.log(Level.SEVERE, "Erreur Mise \u00e0 Jour Tiers BPartner: " + errorMsg);
                isOK = false;
            }
            mUser.setC_BPartner_ID(mBPartner.get_ID());
            if (!mUser.save()) {
                this.log.log(Level.SEVERE, magentoEntity.toString());
                this.log.log(Level.SEVERE, "Erreur Mise \u00e0 Jour Tiers User: " + errorMsg);
                isOK = false;
            }
            if (!isOK) {
                trx.rollback();
            } else {
                trx.commit(true);
                this.api.updateCustomerDateSync(magentoEntity.getCustomerId());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            trx.rollback();
            this.log.log(Level.SEVERE, magentoEntity.toString());
            this.log.log(Level.SEVERE, "Erreur Mise \u00e0 Jour Tiers Commit: " + e.getMessage());
        }
    }

    private void copyPropertiesCustomerFromMagentoToAdempiere(MBPartner mBPartner, MUser mUser, SyncCustomerCustomerEntity magentoEntity) {
        if (StringUtils.isNotEmpty((String)magentoEntity.getCompanyaccount())) {
            mBPartner.setName(magentoEntity.getCompanyaccount());
        } else {
            mBPartner.setName(magentoEntity.getName());
        }
        mUser.setName(magentoEntity.getName());
        mUser.setEMail(magentoEntity.getEmail());
    }

    private void copyPropertiesCustomerAddressFromMagentoToAdempiere(MBPartnerLocation mbPartnerLocation, MLocation mLocation, SyncCustomerAddressEntity magentoEntity, Trx trx) {
        String mbPartnerName;
        mLocation.setAddress1(magentoEntity.getName());
        mLocation.setAddress2(magentoEntity.getStreet1());
        mLocation.setAddress3(magentoEntity.getStreet2());
        mLocation.setCity(magentoEntity.getCity());
        mLocation.setPostal(magentoEntity.getPostcode());
        mLocation.setRegionName(magentoEntity.getRegion());
        MCountry mCountry = (MCountry)new Query(this.getCtx(), "C_Country", "CountryCode = ?", trx.getTrxName()).setOnlyActiveRecords(true).setParameters(magentoEntity.getCountryId()).first();
        if (mCountry != null) {
            mLocation.setC_Country_ID(mCountry.get_ID());
        } else {
            mLocation.setC_Country_ID(this.zECommerceParamtereBean.getC_Country_ID());
        }
        String string = mbPartnerName = magentoEntity.getCity() != null ? magentoEntity.getCity() : "";
        if (StringUtils.isNotEmpty((String)magentoEntity.getName())) {
            if (StringUtils.isNotEmpty((String)mbPartnerName)) {
                mbPartnerName = mbPartnerName + " - ";
            }
            mbPartnerName = mbPartnerName + magentoEntity.getName();
        }
        mbPartnerLocation.setName(mbPartnerName);
        mbPartnerLocation.setPhone(magentoEntity.getTelephone());
        mbPartnerLocation.setFax(magentoEntity.getFax());
    }
}

