/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util.sogexis.ecommerce.magento;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Trx;
import org.compiere.util.sogexis.ecommerce.magento.MagentoAPI;
import org.compiere.util.sogexis.ecommerce.magento.ZECommerceParameterBean;

public class MagentoSyncBLAdempiereToMagento {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private ZECommerceParameterBean zECommerceParamtereBean;
    private MagentoAPI api;
    private Properties context;

    public MagentoSyncBLAdempiereToMagento(ZECommerceParameterBean zECommerceParamtereBean, MagentoAPI api, Properties context) {
        this.zECommerceParamtereBean = zECommerceParamtereBean;
        this.api = api;
        this.context = context;
    }

    private Properties getCtx() {
        return this.context;
    }

    public void processSync() {
        this.syncBL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncBL() {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT io.M_InOut_ID, co.C_Order_ID, co.Z_Magento_Order_ID FROM M_InOut io INNER JOIN C_Order co ON co.C_Order_ID = io.C_Order_ID  WHERE co.z_ecommerce_parameter_id = " + this.zECommerceParamtereBean.getId() + " AND io.docstatus = '" + "CO" + "'" + " AND  (io.lastsynchronized IS NULL OR io.updated > io.lastsynchronized)";
        ArrayList mInOutList = new ArrayList();
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("M_InOut_ID", rs.getInt(1));
                map.put("C_Order_ID", rs.getInt(2));
                map.put("Z_Magento_Order_ID", rs.getInt(3));
                mInOutList.add(map);
            }
        }
        catch (SQLException ex) {
            try {
                this.log.log(Level.SEVERE, sql, ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        System.out.println("BL \u00e0 envoyer vers Magento : " + mInOutList.size());
        for (HashMap hashMap : mInOutList) {
            Trx trx = Trx.get(Trx.createTrxName(), false);
            try {
                MInOut mInOut = (MInOut)new Query(this.getCtx(), "M_InOut", "m_inout_id = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters((int)((Integer)hashMap.get("M_InOut_ID"))).first();
                Integer magentoOrderID = (int)((Integer)hashMap.get("Z_Magento_Order_ID"));
                if (magentoOrderID == null || magentoOrderID == 0) continue;
                MInOutLine[] mInOutLineArray = mInOut.getLines();
                ArrayList<HashMap<String, Double>> itemsToShip = new ArrayList<HashMap<String, Double>>();
                for (int i2 = 0; i2 < mInOutLineArray.length; ++i2) {
                    HashMap<String, Double> itemQty = new HashMap<String, Double>();
                    MOrderLine mOrderLine = (MOrderLine)new Query(this.getCtx(), "C_OrderLine", "C_OrderLine_ID = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters(mInOutLineArray[i2].getC_OrderLine_ID()).first();
                    if (mOrderLine.get_Value("Z_Magento_OrderLine_ID") == null) continue;
                    itemQty.put("id", ((Integer)mOrderLine.get_Value("Z_Magento_OrderLine_ID")).doubleValue());
                    itemQty.put("qty", mInOutLineArray[i2].getQtyEntered().doubleValue());
                    itemsToShip.add(itemQty);
                }
                try {
                    this.api.createShipment(magentoOrderID.toString(), itemsToShip);
                    mInOut.set_ValueOfColumn("lastsynchronized", (Object)new Timestamp(new Date().getTime()));
                    mInOut.save();
                    trx.commit(true);
                }
                catch (Throwable e) {
                    this.log.log(Level.SEVERE, "Erreur lors de l'export du BL " + mInOut.getDocumentNo() + " " + e.getLocalizedMessage());
                    e.printStackTrace();
                    trx.rollback();
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Le BL " + (Integer)hashMap.get("M_InOut_ID") + " n'a pas \u00e9t\u00e9 export\u00e9");
                e.printStackTrace();
                trx.rollback();
            }
            finally {
                trx.close();
            }
        }
    }
}

