/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util.sogexis.ecommerce.magento;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.MImage;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.sogexis.ecommerce.magento.MagentoUtils;
import org.compiere.util.sogexis.ecommerce.magento.ZECommerceParameterBean;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.ArrayOfString;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.CatalogInventoryStockItemUpdateEntity;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.CatalogInventoryStockItemUpdateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.CatalogProductAttributeMediaCreateEntity;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.CatalogProductAttributeMediaCreateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.CatalogProductAttributeMediaListRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.CatalogProductAttributeMediaRemoveRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.CatalogProductAttributeMediaUpdateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.CatalogProductCreateEntity;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.CatalogProductCreateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.CatalogProductCreateResponseParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.CatalogProductImageEntityArray;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.CatalogProductImageFileEntity;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.CatalogProductUpdateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.Filters;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.LoginParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.LoginResponseParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.MageApiModelServerWsiHandlerPortType;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.OrderItemIdQty;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.OrderItemIdQtyArray;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SalesOrderCreditmemoCreateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SalesOrderCreditmemoData;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SalesOrderEntity;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SalesOrderInfoRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SalesOrderInfoResponseParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SalesOrderInvoiceCreateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SalesOrderInvoiceCreateResponseParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SalesOrderShipmentCreateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCatalogCategoryCreateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCatalogCategoryEntityCreate;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCatalogCategoryUpdateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCustomerAddressEntity;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCustomerAddressEntityArray;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCustomerAddressListRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCustomerAddressListResponseParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCustomerAddressUpdateDateSyncRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCustomerCustomerEntity;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCustomerCustomerEntityArray;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCustomerCustomerListRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCustomerCustomerListResponseParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncCustomerCustomerUpdateDateSyncRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncSalesOrderCancelRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncSalesOrderEntity;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncSalesOrderInvoicePaymentEntity;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncSalesOrderInvoicePaymentListEntityArray;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncSalesOrderInvoicePaymentListRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncSalesOrderInvoicePaymentListResponseParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncSalesOrderInvoicePaymentUpdateDateSyncRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncSalesOrderListEntityArray;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncSalesOrderListRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncSalesOrderListResponseParam;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.SyncSalesOrderUpdateDateSyncRequestParam;

public class MagentoAPI {
    private MageApiModelServerWsiHandlerPortType webservice;
    private String sessionID;

    public MagentoAPI(ZECommerceParameterBean parameterBean) {
        try {
            this.webservice = this.initWebService(parameterBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((String)parameterBean.getZ_Login())) {
            throw new AdempiereException("Il n'y a pas de login pour le webservice Magento (SOGEXIS_WEBSERVICE_MAGENTO_LOGIN)");
        }
        if (StringUtils.isEmpty((String)parameterBean.getZ_Password())) {
            throw new AdempiereException("Il n'y a pas de mot de passe pour le webservice Magento (SOGEXIS_WEBSERVICE_MAGENTO_PASSWORD)");
        }
        this.sessionID = this.loginWebService(parameterBean.getZ_Login(), parameterBean.getZ_Password());
    }

    private MageApiModelServerWsiHandlerPortType initWebService(ZECommerceParameterBean parameterBean) throws Exception {
        if (StringUtils.isEmpty((String)parameterBean.getUrl())) {
            throw new AdempiereException("Il n'y a pas d'adresse pour la queue de message Magento");
        }
        URL url = new URL(parameterBean.getUrl());
        QName qname = new QName("urn:Magento", "MagentoService");
        Service service = Service.create((URL)url, (QName)qname);
        return (MageApiModelServerWsiHandlerPortType)service.getPort(MageApiModelServerWsiHandlerPortType.class);
    }

    public String loginWebService(String username, String apikey) {
        LoginParam param = new LoginParam();
        param.setUsername(username);
        param.setApiKey(apikey);
        LoginResponseParam loginResponse = this.webservice.login(param);
        return loginResponse.getResult();
    }

    public void createShipment(String magentoOrderId, List<HashMap<String, Double>> itemsToShip) {
        SalesOrderShipmentCreateRequestParam request = new SalesOrderShipmentCreateRequestParam();
        request.setSessionId(this.sessionID);
        request.setOrderIncrementId(magentoOrderId);
        request.setEmail(0);
        request.setIncludeComment(0);
        OrderItemIdQtyArray orderItems = new OrderItemIdQtyArray();
        for (HashMap<String, Double> item : itemsToShip) {
            OrderItemIdQty itemData = new OrderItemIdQty();
            itemData.setOrderItemId(item.get("id").intValue());
            itemData.setQty(item.get("qty"));
            orderItems.getComplexObjectArray().add(itemData);
        }
        request.setItemsQty(orderItems);
        this.webservice.salesOrderShipmentCreate(request);
    }

    public Integer createInvoice(String magentoOrderId, List<HashMap<String, Double>> itemsToInvoice) {
        SalesOrderInvoiceCreateRequestParam request = new SalesOrderInvoiceCreateRequestParam();
        request.setSessionId(this.sessionID);
        request.setInvoiceIncrementId(magentoOrderId);
        request.setEmail("0");
        request.setIncludeComment("0");
        OrderItemIdQtyArray orderItems = new OrderItemIdQtyArray();
        for (HashMap<String, Double> item : itemsToInvoice) {
            OrderItemIdQty itemData = new OrderItemIdQty();
            itemData.setOrderItemId(item.get("id").intValue());
            itemData.setQty(item.get("qty"));
            orderItems.getComplexObjectArray().add(itemData);
        }
        request.setItemsQty(orderItems);
        SalesOrderInvoiceCreateResponseParam response = this.webservice.salesOrderInvoiceCreate(request);
        return Integer.parseInt(response.getResult());
    }

    public void cancelInvoice(MInvoice invoiceToCancel) {
        MInvoiceLine[] mInvoiceLines;
        SalesOrderCreditmemoCreateRequestParam request = new SalesOrderCreditmemoCreateRequestParam();
        request.setSessionId(this.sessionID);
        MOrder mOrder = (MOrder)new Query(Env.getCtx(), "C_Order", "C_Order_ID = ?", null).setOnlyActiveRecords(true).setClient_ID().setParameters(invoiceToCancel.getC_Order_ID()).first();
        Integer magentoOrderID = (Integer)mOrder.get_Value("Z_Magento_Order_ID");
        request.setCreditmemoIncrementId(magentoOrderID.toString());
        SalesOrderCreditmemoData data = new SalesOrderCreditmemoData();
        OrderItemIdQtyArray itemsArray = new OrderItemIdQtyArray();
        for (MInvoiceLine mInvoiceLine : mInvoiceLines = invoiceToCancel.getLines()) {
            MOrderLine mOrderLine = (MOrderLine)new Query(Env.getCtx(), "C_OrderLine", "C_OrderLine_ID = ?", null).setOnlyActiveRecords(true).setClient_ID().setParameters(mInvoiceLine.getC_OrderLine_ID()).first();
            Integer magentoItemID = (Integer)mOrderLine.get_Value("Z_Magento_OrderLine_ID");
            if (magentoItemID != null && magentoItemID != 0) {
                OrderItemIdQty item = new OrderItemIdQty();
                item.setOrderItemId(magentoItemID);
                item.setQty(mInvoiceLine.getQtyEntered().doubleValue());
                itemsArray.getComplexObjectArray().add(item);
                continue;
            }
            data.setShippingAmount(mInvoiceLine.getLineNetAmt().doubleValue());
        }
        data.setQtys(itemsArray);
        request.setCreditmemoData(data);
        this.webservice.salesOrderCreditmemoCreate(request);
    }

    public void cancelOrder(String magentoOrderID) {
        SyncSalesOrderCancelRequestParam request = new SyncSalesOrderCancelRequestParam();
        request.setSessionId(this.sessionID);
        request.setOrderIncrementId(magentoOrderID.toString());
        this.webservice.syncSalesOrderCancel(request);
    }

    public String getOrderInvoicedAmt(String magentoOrderID) {
        SalesOrderInfoRequestParam request = new SalesOrderInfoRequestParam();
        request.setSessionId(this.sessionID);
        request.setOrderIncrementId(magentoOrderID);
        SalesOrderInfoResponseParam response = this.webservice.salesOrderInfo(request);
        SalesOrderEntity orderEntity = response.getResult();
        if (orderEntity.getTotalInvoiced() != null) {
            return orderEntity.getTotalInvoiced();
        }
        return "0";
    }

    public List<SyncCustomerCustomerEntity> getCustomerToSyncList() {
        SyncCustomerCustomerListRequestParam request = new SyncCustomerCustomerListRequestParam();
        request.setSessionId(this.sessionID);
        Filters filters = new Filters();
        request.setFilters(filters);
        SyncCustomerCustomerListResponseParam response = this.webservice.syncCustomerCustomerList(request);
        SyncCustomerCustomerEntityArray orderListEntity = response.getResult();
        System.out.println("Size list customer magento to sync : " + orderListEntity.getComplexObjectArray().size());
        return orderListEntity.getComplexObjectArray();
    }

    public void updateCustomerDateSync(int magentoCustomerID) {
        SyncCustomerCustomerUpdateDateSyncRequestParam request = new SyncCustomerCustomerUpdateDateSyncRequestParam();
        request.setSessionId(this.sessionID);
        request.setCustomerId(magentoCustomerID);
        this.webservice.syncCustomerCustomerUpdateDateSync(request);
    }

    public List<SyncCustomerAddressEntity> getCustomerAddressToSyncList() {
        SyncCustomerAddressListRequestParam request = new SyncCustomerAddressListRequestParam();
        request.setSessionId(this.sessionID);
        SyncCustomerAddressListResponseParam response = this.webservice.syncCustomerAddressList(request);
        SyncCustomerAddressEntityArray orderListEntity = response.getResult();
        System.out.println("Size list customer address magento to sync : " + orderListEntity.getComplexObjectArray().size());
        return orderListEntity.getComplexObjectArray();
    }

    public void updateCustomerAddressDateSync(int magentoCustomerAddressID, int adempiereID) {
        SyncCustomerAddressUpdateDateSyncRequestParam request = new SyncCustomerAddressUpdateDateSyncRequestParam();
        request.setSessionId(this.sessionID);
        request.setAddressId(magentoCustomerAddressID);
        request.setAdempiereId(adempiereID);
        this.webservice.syncCustomerAddressUpdateDateSync(request);
    }

    public List<SyncSalesOrderEntity> getOrderToSyncList() {
        SyncSalesOrderListRequestParam request = new SyncSalesOrderListRequestParam();
        request.setSessionId(this.sessionID);
        Filters filters = new Filters();
        request.setFilters(filters);
        SyncSalesOrderListResponseParam response = this.webservice.syncSalesOrderList(request);
        SyncSalesOrderListEntityArray orderListEntity = response.getResult();
        System.out.println("Size list order magento to sync : " + orderListEntity.getComplexObjectArray().size());
        return orderListEntity.getComplexObjectArray();
    }

    public void updateOrderDateSync(int magentoOrderId) {
        SyncSalesOrderUpdateDateSyncRequestParam request = new SyncSalesOrderUpdateDateSyncRequestParam();
        request.setSessionId(this.sessionID);
        request.setOrderIncrementId(magentoOrderId);
        this.webservice.syncSalesOrderUpdateDateSync(request);
    }

    public List<SyncSalesOrderInvoicePaymentEntity> getPaymentValidatedToSyncList() {
        SyncSalesOrderInvoicePaymentListRequestParam request = new SyncSalesOrderInvoicePaymentListRequestParam();
        request.setSessionId(this.sessionID);
        SyncSalesOrderInvoicePaymentListResponseParam response = this.webservice.syncSalesOrderInvoicePaymentList(request);
        SyncSalesOrderInvoicePaymentListEntityArray orderListEntity = response.getResult();
        System.out.println("Size list payment magento to sync : " + orderListEntity.getComplexObjectArray().size());
        return orderListEntity.getComplexObjectArray();
    }

    public void updatePaymentValidatedDateSync(int magentoInvoiceId) {
        SyncSalesOrderInvoicePaymentUpdateDateSyncRequestParam request = new SyncSalesOrderInvoicePaymentUpdateDateSyncRequestParam();
        request.setSessionId(this.sessionID);
        request.setInvoiceIncrementId(magentoInvoiceId);
        this.webservice.syncSalesOrderInvoicePaymentUpdateDateSync(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createProductCategory(MProductCategory mProductCategory, boolean isActive, ZECommerceParameterBean zECommerceParameterBean, Trx trx, int idUser) {
        SyncCatalogCategoryCreateRequestParam categoryCreateRequest = new SyncCatalogCategoryCreateRequestParam();
        categoryCreateRequest.setSessionId(this.sessionID);
        Integer parentCategoryID = mProductCategory.getM_Product_Category_Parent_ID();
        if (parentCategoryID != 0) {
            MProductCategory mProductParentCategory = (MProductCategory)new Query(Env.getCtx(), "M_Product_Category", "M_Product_Category_ID = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters(parentCategoryID).first();
            if (mProductParentCategory != null) {
                boolean[] tab = MagentoUtils.isCategorySynchronized(zECommerceParameterBean.getId(), parentCategoryID, trx);
                boolean isAlready = tab[0];
                boolean created = tab[1];
                categoryCreateRequest.setParentId(mProductParentCategory.get_ID());
                if (!isAlready) {
                    this.createProductCategory(mProductParentCategory, isActive, zECommerceParameterBean, trx, idUser);
                    String table2 = "Z_ECommerce_M_Product_Cat";
                    String key = "M_Product_Category_ID";
                    String keyID = "Z_ECommerce_M_Product_Cat_ID";
                    Object pstmt = null;
                    try {
                        if (!created) {
                            MagentoUtils.insertZECommerceAsso(table2, key, keyID, mProductParentCategory.get_ID(), zECommerceParameterBean, pstmt, trx, idUser);
                        }
                        MagentoUtils.updateZECommerceAsso(table2, key, mProductParentCategory.get_ID(), zECommerceParameterBean, pstmt, trx, idUser);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        DB.close(null, pstmt);
                        pstmt = null;
                    }
                }
            }
        } else {
            categoryCreateRequest.setParentId(Integer.parseInt(zECommerceParameterBean.getZ_ECommerce_Categorie_ID()));
        }
        SyncCatalogCategoryEntityCreate categoryData = new SyncCatalogCategoryEntityCreate();
        this.copyProductCategoryData(categoryData, mProductCategory, isActive);
        categoryCreateRequest.setCategoryData(categoryData);
        categoryCreateRequest.setAdempiereId(mProductCategory.get_ID());
        this.webservice.syncCatalogCategoryCreate(categoryCreateRequest);
    }

    public void updateProductCategory(MProductCategory mProductCategory, boolean isActive) {
        SyncCatalogCategoryUpdateRequestParam request = new SyncCatalogCategoryUpdateRequestParam();
        request.setSessionId(this.sessionID);
        SyncCatalogCategoryEntityCreate categoryData = new SyncCatalogCategoryEntityCreate();
        this.copyProductCategoryData(categoryData, mProductCategory, isActive);
        request.setCategoryData(categoryData);
        request.setAdempiereId(mProductCategory.get_ID());
        this.webservice.syncCatalogCategoryUpdate(request);
    }

    private void copyProductCategoryData(SyncCatalogCategoryEntityCreate categoryData, MProductCategory mProductCategory, boolean isActive) {
        categoryData.setName(mProductCategory.getName());
        categoryData.setIsActive(isActive && mProductCategory.isActive() ? 1 : 0);
        categoryData.setIncludeInMenu(1);
        categoryData.setDescription(mProductCategory.getDescription());
        ArrayOfString availableSorts = new ArrayOfString();
        availableSorts.getComplexObjectArray().add("position");
        availableSorts.getComplexObjectArray().add("name");
        availableSorts.getComplexObjectArray().add("price");
        categoryData.setAvailableSortBy(availableSorts);
        categoryData.setDefaultSortBy("position");
    }

    public String createProduct(MProduct mProduct, boolean isActive, BigDecimal prixCatalogue, BigDecimal prixActuel, ZECommerceParameterBean zECommerceParameterBean, Trx trx) throws Exception {
        CatalogProductCreateRequestParam request = new CatalogProductCreateRequestParam();
        CatalogProductCreateEntity productData = new CatalogProductCreateEntity();
        this.copyMProductAdempiereToMagento(productData, mProduct, isActive, prixCatalogue, prixActuel, zECommerceParameterBean, trx);
        request.setSessionId(this.sessionID);
        request.setProductData(productData);
        request.setSessionId(this.sessionID);
        request.setType("simple");
        request.setSet("4");
        request.setSku(mProduct.getValue());
        request.setProductData(productData);
        CatalogProductCreateResponseParam productCreateResponse = this.webservice.catalogProductCreate(request);
        Integer newProductID = productCreateResponse.getResult();
        return newProductID.toString();
    }

    private void copyMProductAdempiereToMagento(CatalogProductCreateEntity productData, MProduct mProduct, boolean isActive, BigDecimal prixCatalogue, BigDecimal prixActuel, ZECommerceParameterBean zECommerceParameterBean, Trx trx) throws Exception {
        productData.setName(mProduct.getName());
        ArrayOfString productCategories = new ArrayOfString();
        productCategories.getComplexObjectArray().add(mProduct.getM_Product_Category_ID() + "");
        productData.setCategories(productCategories);
        productData.setDescription(mProduct.getDescription());
        productData.setShortDescription(mProduct.getDescription());
        productData.setWeight(mProduct.getWeight().toString());
        productData.setStatus(mProduct.isActive() && isActive ? "1" : "2");
        productData.setVisibility("4");
        productData.setPrice(prixActuel.toString());
        if (prixActuel.compareTo(prixCatalogue) < 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Timestamp debutPromo = new Timestamp(cal.getTime().getTime());
            cal.add(2, 250);
            Timestamp finPromo = new Timestamp(cal.getTime().getTime());
            productData.setSpecialPrice(prixActuel.toString());
            productData.setSpecialFromDate(debutPromo.toString().substring(0, 19));
            productData.setSpecialToDate(finPromo.toString().substring(0, 19));
            productData.setPrice(prixCatalogue.toString());
        }
        if (zECommerceParameterBean.getMTaxCategoryMap().get(mProduct.getC_TaxCategory_ID() + "") == null) {
            throw new Exception("Erreur tax non configur\u00e9e entre Adempiere et Magento : " + mProduct.getC_TaxCategory_ID());
        }
        productData.setTaxClassId(zECommerceParameterBean.getMTaxCategoryMap().get(mProduct.getC_TaxCategory_ID() + ""));
        CatalogInventoryStockItemUpdateEntity stockData = new CatalogInventoryStockItemUpdateEntity();
        if (mProduct.getProductType().equals("S")) {
            stockData.setUseConfigManageStock(0);
            stockData.setManageStock(0);
        } else {
            BigDecimal qtyOnHand = this.getQtyAvailable(mProduct.get_ID(), zECommerceParameterBean, trx);
            if (qtyOnHand != null) {
                stockData.setQty(qtyOnHand.toString());
                stockData.setIsInStock(1);
            } else {
                stockData.setQty("0");
                stockData.setIsInStock(0);
            }
        }
        productData.setStockData(stockData);
    }

    public void updateProduct(MProduct mProduct, boolean isActive, BigDecimal prixCatalogue, BigDecimal prixActuel, ZECommerceParameterBean zECommerceParameterBean, Trx trx) throws Exception {
        CatalogProductUpdateRequestParam request = new CatalogProductUpdateRequestParam();
        CatalogProductCreateEntity productData = new CatalogProductCreateEntity();
        this.copyMProductAdempiereToMagento(productData, mProduct, isActive, prixCatalogue, prixActuel, zECommerceParameterBean, trx);
        request.setSessionId(this.sessionID);
        request.setProductData(productData);
        request.setProductId(mProduct.getValue());
        request.setIdentifierType("sku");
        this.webservice.catalogProductUpdate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private BigDecimal getQtyAvailable(int M_Product_ID, ZECommerceParameterBean zeCommerceParameterBean, Trx trx) {
        String SQL = "SELECT sum(qtyAvailable) FROM M_PRODUCT_STOCK_V WHERE m_product_id=" + M_Product_ID;
        if (!zeCommerceParameterBean.isZ_ECommerce_Is_Stock_All()) {
            SQL = SQL + " AND M_Warehouse_ID = " + zeCommerceParameterBean.getM_Warehouse_ID();
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        BigDecimal qtyOnHand = new BigDecimal(0);
        try {
            pstmt = DB.prepareStatement(SQL.toString(), trx.getTrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                qtyOnHand = rs.getBigDecimal(1);
            }
        }
        catch (Exception e) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return qtyOnHand;
    }

    public void updateStock(MProduct mProduct, ZECommerceParameterBean zECommerceParameterBean, Trx trx) {
        CatalogInventoryStockItemUpdateRequestParam req = new CatalogInventoryStockItemUpdateRequestParam();
        req.setProductId(mProduct.getValue());
        req.setSessionId(this.sessionID);
        CatalogInventoryStockItemUpdateEntity data = new CatalogInventoryStockItemUpdateEntity();
        BigDecimal qty = this.getQtyAvailable(mProduct.get_ID(), zECommerceParameterBean, trx);
        if (qty != null) {
            data.setQty(qty.toString());
            if (qty.signum() > 0) {
                data.setIsInStock(1);
            } else {
                data.setIsInStock(0);
            }
        } else {
            data.setQty("0");
            data.setIsInStock(0);
        }
        req.setData(data);
        this.webservice.catalogInventoryStockItemUpdate(req);
    }

    public void disableStock(String productReference) {
        CatalogInventoryStockItemUpdateRequestParam req = new CatalogInventoryStockItemUpdateRequestParam();
        req.setProductId(productReference);
        req.setSessionId(this.sessionID);
        CatalogInventoryStockItemUpdateEntity data = new CatalogInventoryStockItemUpdateEntity();
        data.setUseConfigManageStock(0);
        data.setManageStock(0);
        req.setData(data);
        this.webservice.catalogInventoryStockItemUpdate(req);
    }

    public CatalogProductImageEntityArray getProductImageInfo(String productID) {
        CatalogProductAttributeMediaListRequestParam imageListRequest = new CatalogProductAttributeMediaListRequestParam();
        imageListRequest.setProductId(productID);
        imageListRequest.setSessionId(this.sessionID);
        imageListRequest.setIdentifierType("sku");
        return this.webservice.catalogProductAttributeMediaList(imageListRequest).getResult();
    }

    private void copyProductImageAdempiereToMagento(int imageID, int position, CatalogProductAttributeMediaCreateEntity newImageData, Trx trx) {
        MImage mImage = new MImage(Env.getCtx(), imageID, trx.getTrxName());
        byte[] imageContent = mImage.getBinaryData();
        String imageUrl = mImage.getImageURL();
        CatalogProductImageFileEntity newImage = new CatalogProductImageFileEntity();
        byte[] encodedContent = Base64.encodeBase64((byte[])imageContent);
        String encodedContentString = new String(encodedContent);
        newImage.setContent(encodedContentString);
        String mimeType = "image/" + imageUrl.substring(imageUrl.lastIndexOf(".") + 1).toLowerCase();
        if (mimeType.equalsIgnoreCase("image/jpg")) {
            mimeType = "image/jpeg";
        }
        String imageName = imageUrl.substring(imageUrl.lastIndexOf("/") + 1);
        newImage.setName(imageName);
        newImage.setMime(mimeType);
        newImageData.setFile(newImage);
        newImageData.setLabel(imageName);
        ArrayOfString imageTypes = new ArrayOfString();
        if (position == 1) {
            imageTypes.getComplexObjectArray().add("image");
            imageTypes.getComplexObjectArray().add("small_image");
        }
        imageTypes.getComplexObjectArray().add("thumbnail");
        newImageData.setTypes(imageTypes);
        newImageData.setExclude("0");
    }

    public void addProductImage(String productID, int imageID, int position, Trx trx) throws Exception {
        CatalogProductAttributeMediaCreateEntity newImageData = new CatalogProductAttributeMediaCreateEntity();
        this.copyProductImageAdempiereToMagento(imageID, position, newImageData, trx);
        CatalogProductAttributeMediaCreateRequestParam addImageRequest = new CatalogProductAttributeMediaCreateRequestParam();
        addImageRequest.setSessionId(this.sessionID);
        addImageRequest.setProductId(productID);
        addImageRequest.setIdentifierType("sku");
        addImageRequest.setData(newImageData);
        this.webservice.catalogProductAttributeMediaCreate(addImageRequest);
    }

    public void updateProductImage(String productID, int imageID, String imagePath, int position, Trx trx) {
        CatalogProductAttributeMediaCreateEntity newImageData = new CatalogProductAttributeMediaCreateEntity();
        this.copyProductImageAdempiereToMagento(imageID, position, newImageData, trx);
        CatalogProductAttributeMediaUpdateRequestParam updateImageRequest = new CatalogProductAttributeMediaUpdateRequestParam();
        updateImageRequest.setSessionId(this.sessionID);
        updateImageRequest.setProductId(productID);
        updateImageRequest.setIdentifierType("sku");
        updateImageRequest.setData(newImageData);
        updateImageRequest.setFile(imagePath);
        this.webservice.catalogProductAttributeMediaUpdate(updateImageRequest);
    }

    public void deleteProductImage(String productID, String imagePath) {
        CatalogProductAttributeMediaRemoveRequestParam deleteImageRequest = new CatalogProductAttributeMediaRemoveRequestParam();
        deleteImageRequest.setSessionId(this.sessionID);
        deleteImageRequest.setFile(imagePath);
        deleteImageRequest.setProductId(productID);
        deleteImageRequest.setIdentifierType("sku");
        this.webservice.catalogProductAttributeMediaRemove(deleteImageRequest);
    }
}

