/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.swing.CPanel;

public final class IniDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -1469122685638342569L;
    static ResourceBundle s_res = ResourceBundle.getBundle("org.compiere.util.IniRes");
    private boolean m_accept = false;
    private static Logger log = Logger.getLogger(IniDialog.class.getName());
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private JScrollPane scrollPane = new JScrollPane();
    private CPanel southPanel = new CPanel();
    private JButton bReject = AdempierePLAF.getCancelButton();
    private JButton bAccept = AdempierePLAF.getOKButton();
    private FlowLayout southLayout = new FlowLayout();
    private JLabel southLabel = new JLabel();
    private JEditorPane licensePane = new JEditorPane();

    public IniDialog() {
        try {
            this.jbInit();
            String where = "org/compiere/license.html";
            URL url = null;
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl != null) {
                url = cl.getResource(where);
            }
            if (url == null) {
                log.warning("No license in resource ");
                url = new URL("http://www.adempiere.org/license.htm");
            }
            if (url == null) {
                this.cmd_reject();
            }
            this.licensePane.setPage(url);
            AdempierePLAF.showCenterScreen(this);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "init", ex);
            this.cmd_reject();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle("Adempiere - " + s_res.getString("Adempiere_License"));
        this.southLabel.setText(s_res.getString("Do_you_accept"));
        this.bReject.setText(s_res.getString("No"));
        this.bAccept.setText(s_res.getString("Yes_I_Understand"));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.mainPanel.setLayout(this.mainLayout);
        this.bReject.setForeground(Color.red);
        this.bReject.addActionListener(this);
        this.bAccept.addActionListener(this);
        this.southPanel.setLayout(this.southLayout);
        this.southLayout.setAlignment(2);
        this.licensePane.setEditable(false);
        this.licensePane.setContentType("text/html");
        this.scrollPane.setPreferredSize(new Dimension(700, 400));
        this.southPanel.add((Component)this.southLabel, null);
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.licensePane, null);
        this.mainPanel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.bReject, null);
        this.southPanel.add((Component)this.bAccept, null);
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bAccept) {
            this.m_accept = true;
        }
        this.dispose();
    }

    @Override
    public final void dispose() {
        super.dispose();
        if (!this.m_accept) {
            this.cmd_reject();
        }
    }

    public final boolean isAccepted() {
        return this.m_accept;
    }

    public final void cmd_reject() {
        String info = "License rejected or expired";
        try {
            info = s_res.getString("License_rejected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.severe(info);
        System.exit(10);
    }

    public static final boolean accept() {
        IniDialog id = new IniDialog();
        if (id.isAccepted()) {
            log.info("License Accepted");
            return true;
        }
        System.exit(10);
        return false;
    }
}

