/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import com.sun.mail.smtp.SMTPMessage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.util.ByteArrayDataSource;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.EMailAuthenticator;
import org.compiere.util.Env;
import org.compiere.util.Ini;

public final class EMail
implements Serializable {
    private static final long serialVersionUID = -1408649015285763245L;
    public static final String HTML_MAIL_MARKER = "ContentType=text/html;";
    private InternetAddress m_from;
    private ArrayList<InternetAddress> m_to;
    private ArrayList<InternetAddress> m_cc;
    private ArrayList<InternetAddress> m_bcc;
    private InternetAddress m_replyTo;
    private String m_subject;
    private String m_messageText;
    private String m_messageHTML;
    private String m_smtpHost;
    private ArrayList<Object> m_attachments;
    private EMailAuthenticator m_auth = null;
    private SMTPMessage m_msg = null;
    private Properties m_ctx;
    private boolean m_valid = false;
    private String m_sentMsg = null;
    public static final String SENT_OK = "OK";
    protected static CLogger log = CLogger.getCLogger(EMail.class);

    public EMail(MClient client, String from, String to, String subject, String message) {
        this(client.getCtx(), client.getSMTPHost(), from, to, subject, message);
    }

    public EMail(MClient client, String from, String to, String subject, String message, boolean html) {
        this(client.getCtx(), client.getSMTPHost(), from, to, subject, message, html);
    }

    public EMail(Properties ctx, String smtpHost, String from, String to, String subject, String message) {
        this(ctx, smtpHost, from, to, subject, message, false);
    }

    public EMail(Properties ctx, String smtpHost, String from, String to, String subject, String message, boolean html) {
        this.setSmtpHost(smtpHost);
        this.setFrom(from);
        String bccAddressForAllMails = MSysConfig.getValue("MAIL_SEND_BCC_TO_ADDRESS", Env.getAD_Client_ID(Env.getCtx()));
        if (bccAddressForAllMails != null && bccAddressForAllMails.length() > 0) {
            this.addBcc(bccAddressForAllMails);
        }
        this.addTo(to);
        this.m_ctx = ctx;
        if (subject == null || subject.length() == 0) {
            this.setSubject(".");
        } else {
            this.setSubject(subject);
        }
        if (message != null && message.length() > 0) {
            if (html) {
                this.setMessageHTML(subject, message);
            } else {
                this.setMessageText(message);
            }
        }
        this.m_valid = this.isValid(true);
    }

    public String send() {
        log.info("(" + this.m_smtpHost + ") " + this.m_from + " -> " + this.m_to);
        this.m_sentMsg = null;
        if (!this.isValid(true)) {
            this.m_sentMsg = "Invalid Data";
            return this.m_sentMsg;
        }
        Properties props = System.getProperties();
        props.put("mail.store.protocol", "smtp");
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.host", this.m_smtpHost);
        if (CLogMgt.isLevelFinest()) {
            props.put("mail.debug", "true");
        }
        Session session = null;
        try {
            if (this.m_auth != null) {
                props.put("mail.smtp.auth", "true");
            }
            if (this.m_smtpHost.equalsIgnoreCase("smtp.gmail.com") || this.m_smtpHost.equalsIgnoreCase("smtp.sogexis.fr")) {
                props.put("mail.smtp.port", "587");
                props.put("mail.smtp.starttls.enable", "true");
            }
            if (this.m_smtpHost.equalsIgnoreCase("smtp.linkeo.fr")) {
                props.put("mail.smtp.port", "587");
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.smtp.ssl.trust", "smtp.linkeo.fr");
            }
            session = Session.getInstance((Properties)props, (Authenticator)this.m_auth);
            session.setDebug(CLogMgt.isLevelFinest());
        }
        catch (SecurityException se) {
            log.log(Level.WARNING, "Auth=" + (Object)((Object)this.m_auth) + " - " + se.toString());
            this.m_sentMsg = se.toString();
            return se.toString();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Auth=" + (Object)((Object)this.m_auth), e);
            this.m_sentMsg = e.toString();
            return e.toString();
        }
        try {
            this.m_msg = new SMTPMessage(session);
            this.m_msg.setFrom((Address)this.m_from);
            InternetAddress[] rec = this.getTos();
            if (rec.length == 1) {
                this.m_msg.setRecipient(Message.RecipientType.TO, (Address)rec[0]);
            } else {
                this.m_msg.setRecipients(Message.RecipientType.TO, (Address[])rec);
            }
            rec = this.getCcs();
            if (rec != null && rec.length > 0) {
                this.m_msg.setRecipients(Message.RecipientType.CC, (Address[])rec);
            }
            if ((rec = this.getBccs()) != null && rec.length > 0) {
                this.m_msg.setRecipients(Message.RecipientType.BCC, (Address[])rec);
            }
            if (this.m_replyTo != null) {
                this.m_msg.setReplyTo(new Address[]{this.m_replyTo});
            }
            this.m_msg.setSentDate(new Date());
            this.m_msg.setHeader("Comments", "AdempiereMail");
            this.m_msg.setAllow8bitMIME(true);
            this.m_msg.setReturnOption(2);
            this.setContent();
            this.m_msg.saveChanges();
            Transport t = session.getTransport("smtp");
            t.connect();
            Transport.send((Message)this.m_msg);
            log.fine("Success - MessageID=" + this.m_msg.getMessageID());
        }
        catch (MessagingException me) {
            Throwable ex = me;
            StringBuffer sb = new StringBuffer("(ME)");
            boolean printed = false;
            do {
                String className;
                if (ex instanceof SendFailedException) {
                    SendFailedException sfex = (SendFailedException)ex;
                    Address[] invalid = sfex.getInvalidAddresses();
                    if (!printed) {
                        Address[] validSent;
                        Address[] validUnsent;
                        if (invalid != null && invalid.length > 0) {
                            sb.append(" - Invalid:");
                            for (int i2 = 0; i2 < invalid.length; ++i2) {
                                sb.append(" ").append(invalid[i2]);
                            }
                        }
                        if ((validUnsent = sfex.getValidUnsentAddresses()) != null && validUnsent.length > 0) {
                            sb.append(" - ValidUnsent:");
                            for (int i3 = 0; i3 < validUnsent.length; ++i3) {
                                sb.append(" ").append(validUnsent[i3]);
                            }
                        }
                        if ((validSent = sfex.getValidSentAddresses()) != null && validSent.length > 0) {
                            sb.append(" - ValidSent:");
                            for (int i4 = 0; i4 < validSent.length; ++i4) {
                                sb.append(" ").append(validSent[i4]);
                            }
                        }
                        printed = true;
                    }
                    if (sfex.getNextException() != null) continue;
                    sb.append(" ").append(sfex.getLocalizedMessage());
                    continue;
                }
                if (ex instanceof AuthenticationFailedException) {
                    sb.append(" - Invalid Username/Password - " + (Object)((Object)this.m_auth));
                    continue;
                }
                String msg = ex.getLocalizedMessage();
                if (msg == null) {
                    sb.append(": ").append(ex.toString());
                    continue;
                }
                if (msg.indexOf("Could not connect to SMTP host:") != -1) {
                    int index = msg.indexOf(10);
                    if (index != -1) {
                        msg = msg.substring(0, index);
                    }
                    String cc = "??";
                    if (this.m_ctx != null) {
                        cc = this.m_ctx.getProperty("#AD_Client_ID");
                    }
                    msg = msg + " - AD_Client_ID=" + cc;
                }
                if ((className = ex.getClass().getName()).indexOf("MessagingException") != -1) {
                    sb.append(": ").append(msg);
                    continue;
                }
                sb.append(" ").append(className).append(": ").append(msg);
            } while ((ex = ex instanceof MessagingException ? ex.getNextException() : null) != null);
            if (CLogMgt.isLevelFinest()) {
                log.log(Level.WARNING, sb.toString(), me);
            } else {
                log.log(Level.WARNING, sb.toString());
            }
            this.m_sentMsg = sb.toString();
            return sb.toString();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            this.m_sentMsg = e.getLocalizedMessage();
            return e.getLocalizedMessage();
        }
        if (CLogMgt.isLevelFinest()) {
            this.dumpMessage();
        }
        this.m_sentMsg = SENT_OK;
        return this.m_sentMsg;
    }

    public String getSentMsg() {
        return this.m_sentMsg;
    }

    public boolean isSentOK() {
        return this.m_sentMsg != null && SENT_OK.equals(this.m_sentMsg);
    }

    private void dumpMessage() {
        if (this.m_msg == null) {
            return;
        }
        try {
            Enumeration e = this.m_msg.getAllHeaderLines();
            while (e.hasMoreElements()) {
                log.fine("- " + e.nextElement());
            }
        }
        catch (MessagingException ex) {
            log.log(Level.WARNING, this.m_msg.toString(), ex);
        }
    }

    protected MimeMessage getMimeMessage() {
        return this.m_msg;
    }

    public String getMessageID() {
        try {
            if (this.m_msg != null) {
                return this.m_msg.getMessageID();
            }
        }
        catch (MessagingException ex) {
            log.log(Level.SEVERE, "", ex);
        }
        return null;
    }

    public EMailAuthenticator createAuthenticator(String username, String password) {
        if (username == null || password == null) {
            log.warning("Ignored - " + username + "/" + password);
            this.m_auth = null;
        } else {
            this.m_auth = new EMailAuthenticator(username, password);
        }
        return this.m_auth;
    }

    public InternetAddress getFrom() {
        return this.m_from;
    }

    public void setFrom(String newFrom) {
        if (newFrom == null) {
            this.m_valid = false;
            return;
        }
        try {
            this.m_from = new InternetAddress(newFrom, true);
            if (MSysConfig.getBooleanValue("MAIL_SEND_BCC_TO_FROM", false, Env.getAD_Client_ID(Env.getCtx()))) {
                // empty if block
            }
            this.addBcc(newFrom);
        }
        catch (Exception e) {
            log.log(Level.WARNING, newFrom + ": " + e.toString());
            this.m_valid = false;
        }
    }

    public boolean addTo(String newTo) {
        if (newTo == null || newTo.length() == 0) {
            this.m_valid = false;
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = new InternetAddress(newTo, true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, newTo + ": " + e.toString());
            this.m_valid = false;
            return false;
        }
        if (this.m_to == null) {
            this.m_to = new ArrayList();
        }
        this.m_to.add(ia);
        return true;
    }

    public InternetAddress getTo() {
        if (this.m_to == null || this.m_to.size() == 0) {
            return null;
        }
        InternetAddress ia = this.m_to.get(0);
        return ia;
    }

    public InternetAddress[] getTos() {
        if (this.m_to == null || this.m_to.size() == 0) {
            return null;
        }
        InternetAddress[] ias = new InternetAddress[this.m_to.size()];
        this.m_to.toArray(ias);
        return ias;
    }

    public boolean addCc(String newCc) {
        if (newCc == null || newCc.length() == 0) {
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = new InternetAddress(newCc, true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, newCc + ": " + e.toString());
            return false;
        }
        if (this.m_cc == null) {
            this.m_cc = new ArrayList();
        }
        this.m_cc.add(ia);
        return true;
    }

    public InternetAddress[] getCcs() {
        if (this.m_cc == null || this.m_cc.size() == 0) {
            return null;
        }
        InternetAddress[] ias = new InternetAddress[this.m_cc.size()];
        this.m_cc.toArray(ias);
        return ias;
    }

    public boolean addBcc(String newBcc) {
        if (newBcc == null || newBcc.length() == 0) {
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = new InternetAddress(newBcc, true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, newBcc + ": " + e.getMessage());
            return false;
        }
        if (this.m_bcc == null) {
            this.m_bcc = new ArrayList();
        }
        this.m_bcc.add(ia);
        return true;
    }

    public InternetAddress[] getBccs() {
        if (this.m_bcc == null || this.m_bcc.size() == 0) {
            return null;
        }
        InternetAddress[] ias = new InternetAddress[this.m_bcc.size()];
        this.m_bcc.toArray(ias);
        return ias;
    }

    public boolean setReplyTo(String newTo) {
        if (newTo == null || newTo.length() == 0) {
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = new InternetAddress(newTo, true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, newTo + ": " + e.toString());
            return false;
        }
        this.m_replyTo = ia;
        return true;
    }

    public InternetAddress getReplyTo() {
        return this.m_replyTo;
    }

    public void setSubject(String newSubject) {
        if (newSubject == null || newSubject.length() == 0) {
            this.m_valid = false;
        } else {
            this.m_subject = newSubject;
        }
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void setMessageText(String newMessage) {
        if (newMessage == null || newMessage.length() == 0) {
            this.m_valid = false;
        } else {
            this.m_messageText = newMessage;
            if (!this.m_messageText.endsWith("\n")) {
                this.m_messageText = this.m_messageText + "\n";
            }
        }
    }

    public String getMessageCRLF() {
        if (this.m_messageText == null) {
            return "";
        }
        char[] chars = this.m_messageText.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            char c = chars[i2];
            if (c == '\n') {
                int previous = i2 - 1;
                if (previous >= 0 && chars[previous] == '\r') {
                    sb.append(c);
                    continue;
                }
                sb.append("\r\n");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void setMessageHTML(String html) {
        if (html == null || html.length() == 0) {
            this.m_valid = false;
        } else {
            this.m_messageHTML = html;
            if (!this.m_messageHTML.endsWith("\n")) {
                this.m_messageHTML = this.m_messageHTML + "\n";
            }
        }
    }

    public void setMessageHTML(String subject, String message) {
        this.m_subject = subject;
        StringBuffer sb = new StringBuffer("<HTML>\n").append("<HEAD>\n").append("<TITLE>\n").append(subject + "\n").append("</TITLE>\n").append("</HEAD>\n");
        sb.append("<BODY>\n").append("<H2>" + subject + "</H2>" + "\n").append(message).append("\n").append("</BODY>\n");
        sb.append("</HTML>\n");
        this.m_messageHTML = sb.toString();
    }

    public String getMessageHTML() {
        return this.m_messageHTML;
    }

    public void addAttachment(File file) {
        if (file == null) {
            return;
        }
        if (this.m_attachments == null) {
            this.m_attachments = new ArrayList();
        }
        this.m_attachments.add(file);
    }

    public void addAttachments(Collection<File> files) {
        if (files == null || files.size() == 0) {
            return;
        }
        for (File f : files) {
            this.addAttachment(f);
        }
    }

    public void addAttachment(URI url) {
        if (url == null) {
            return;
        }
        if (this.m_attachments == null) {
            this.m_attachments = new ArrayList();
        }
        this.m_attachments.add(url);
    }

    public void addAttachment(byte[] data, String type, String name) {
        ByteArrayDataSource byteArray = new ByteArrayDataSource(data, type).setName(name);
        this.addAttachment(byteArray);
    }

    public void addAttachment(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        if (this.m_attachments == null) {
            this.m_attachments = new ArrayList();
        }
        this.m_attachments.add(dataSource);
    }

    /*
     * Unable to fully structure code
     */
    private void setContent() throws MessagingException, IOException {
        block13: {
            block12: {
                charSetName = Ini.getCharset().name();
                if (charSetName == null || charSetName.length() == 0) {
                    charSetName = "iso-8859-1";
                }
                this.m_msg.setSubject(this.getSubject(), charSetName);
                if (this.m_attachments != null && this.m_attachments.size() != 0) break block12;
                if (this.m_messageHTML == null || this.m_messageHTML.length() == 0) {
                    this.m_msg.setText(this.getMessageCRLF(), charSetName);
                } else {
                    this.m_msg.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.m_messageHTML, charSetName, "text/html")));
                }
                EMail.log.fine("(simple) " + this.getSubject());
                break block13;
            }
            mbp_1 = new MimeBodyPart();
            mbp_1.setText("");
            if (this.m_messageHTML == null || this.m_messageHTML.length() == 0) {
                mbp_1.setText(this.getMessageCRLF(), charSetName);
            } else {
                mbp_1.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.m_messageHTML, charSetName, "text/html")));
            }
            mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbp_1);
            EMail.log.fine("(multi) " + this.getSubject() + " - " + mbp_1);
            for (i = 0; i < this.m_attachments.size(); ++i) {
                attachment = this.m_attachments.get(i);
                ds = null;
                if (!(attachment instanceof File)) ** GOTO lbl32
                file = (File)attachment;
                if (file.exists()) {
                    ds = new FileDataSource(file);
                } else {
                    EMail.log.log(Level.WARNING, "File does not exist: " + file);
                    continue;
lbl32:
                    // 1 sources

                    if (attachment instanceof URI) {
                        url = (URI)attachment;
                        ds = new URLDataSource(url.toURL());
                    } else if (attachment instanceof DataSource) {
                        ds = (DataSource)attachment;
                    } else {
                        EMail.log.log(Level.WARNING, "Attachement type unknown: " + attachment);
                        continue;
                    }
                }
                mbp_2 = new MimeBodyPart();
                mbp_2.setDataHandler(new DataHandler(ds));
                mbp_2.setFileName(ds.getName());
                EMail.log.fine("Added Attachment " + ds.getName() + " - " + mbp_2);
                mp.addBodyPart((BodyPart)mbp_2);
            }
            this.m_msg.setContent((Multipart)mp);
        }
    }

    public void setSmtpHost(String newSmtpHost) {
        if (newSmtpHost == null || newSmtpHost.length() == 0) {
            this.m_valid = false;
        } else {
            this.m_smtpHost = newSmtpHost;
        }
    }

    public String getSmtpHost() {
        return this.m_smtpHost;
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public boolean isValid(boolean recheck) {
        if (!recheck) {
            return this.m_valid;
        }
        if (this.m_from == null || this.m_from.getAddress().length() == 0 || this.m_from.getAddress().indexOf(32) != -1) {
            log.warning("From is invalid=" + this.m_from);
            return false;
        }
        InternetAddress[] ias = this.getTos();
        if (ias == null) {
            log.warning("No To");
            return false;
        }
        for (int i2 = 0; i2 < ias.length; ++i2) {
            if (ias[i2] != null && ias[i2].getAddress().length() != 0 && ias[i2].getAddress().indexOf(32) == -1) continue;
            log.warning("To(" + i2 + ") is invalid=" + ias[i2]);
            return false;
        }
        if (this.m_smtpHost == null || this.m_smtpHost.length() == 0) {
            log.warning("SMTP Host is invalid" + this.m_smtpHost);
            return false;
        }
        if (this.m_subject == null || this.m_subject.length() == 0) {
            log.warning("Subject is invalid=" + this.m_subject);
            return false;
        }
        return true;
    }

    public Object[] getAttachments() {
        if (this.m_attachments == null) {
            return new Object[0];
        }
        return this.m_attachments.toArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("EMail[");
        sb.append("From:").append(this.m_from).append(",To:").append(this.getTo()).append(",Subject=").append(this.getSubject()).append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        if (args.length != 5) {
            System.out.println("Parameters: smtpHost from to subject message");
            System.out.println("Example: java org.compiere.util.EMail mail.acme.com joe@acme.com sue@acme.com HiThere CheersJoe");
            System.exit(1);
        }
        EMail email = new EMail(System.getProperties(), args[0], args[1], args[2], args[3], args[4]);
        email.send();
    }
}

