/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ContextListener
implements ServletContextListener {
    private static String realPath = null;
    private static String contextPath = null;
    private static Map<String, String> trxUnclosedLogMap = null;
    private static boolean isDeliveryRunning = false;

    public static String getRealPath() {
        return realPath;
    }

    public static String getContextPath() {
        return contextPath;
    }

    public static Map<String, String> getTrxUnclosedLogMap() {
        return trxUnclosedLogMap;
    }

    public static void printTrxUnclosedLog() {
        System.out.println("List des transactions non ferm\u00e9es : " + new Date() + "\n\n");
        if (trxUnclosedLogMap != null && trxUnclosedLogMap.size() > 0) {
            Collection<String> valuesList = trxUnclosedLogMap.values();
            for (String value : valuesList) {
                System.out.println(value);
            }
        }
    }

    public static void openTrxLog(String trxName, String line) {
        trxUnclosedLogMap.put(trxName, line);
    }

    public static void closeTrxLog(String trxName, String line) {
        if (trxUnclosedLogMap.get(trxName) != null) {
            trxUnclosedLogMap.remove(trxName);
        } else {
            trxUnclosedLogMap.put(trxName + new Date(), "Invalide close " + new Date() + " : " + line);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ContextListener.printTrxUnclosedLog();
        trxUnclosedLogMap = null;
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        realPath = context.getRealPath("");
        contextPath = context.getContextPath();
        trxUnclosedLogMap = new LinkedHashMap<String, String>();
    }

    public static void switchDeliveryRunning() {
        isDeliveryRunning = !isDeliveryRunning;
    }

    public static boolean isDeliveryRunning() {
        return isDeliveryRunning;
    }

    public static void setDeliveryRunning(boolean bool) {
        isDeliveryRunning = bool;
    }
}

