/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process.sae.planificator;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.SogexisUtils;

public class ZExportPrepareOrder
extends SvrProcess {
    String path_to_export_operator = "";
    String path_to_export_depot = "";
    String interval_configuration = "";

    @Override
    protected void prepare() {
        this.path_to_export_operator = MSysConfig.getValue("SOGEXIS_PATH_EXPORT_PREPARE_ORDER", "N", MClient.get(Env.getCtx()).get_ID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        String sql_order = "SELECT co.C_Order_ID,  co.documentNo,  cb.name,  to_char(datepromised, 'dd/MM/yy'),  co.description FROM C_Order co  INNER JOIN C_BPartner cb ON cb.C_BPartner_ID = co.C_BPartner_ID  WHERE co.IsSOTrx='Y' AND co.C_Order_ID IN (select c_order_id from Z_RV_Order_Not_Delivered) AND co.DocStatus='CO' AND co.z_a_preparer= 'Y'  ORDER BY DocumentNo ASC,DatePromised ";
        String sql_line = "";
        CPreparedStatement pstmt = null;
        CPreparedStatement pstmt_line = null;
        ResultSet rs = null;
        ResultSet rs_line = null;
        int nbr_export_order = 0;
        int nbr_export_order_line = 0;
        File file = new File(this.path_to_export_operator + "/Preparation");
        try {
            if (!file.exists()) {
                file.mkdir();
            } else {
                FileUtils.cleanDirectory((File)file);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Erreur - impossible de supprimer un fichier");
        }
        try {
            pstmt = DB.prepareStatement(sql_order, null);
            rs = pstmt.executeQuery();
            ArrayList<List<String>> lines = new ArrayList<List<String>>();
            while (rs.next()) {
                ArrayList<String> line = new ArrayList<String>();
                line.add(rs.getString(1));
                line.add(rs.getString(2));
                line.add(rs.getString(3));
                line.add(rs.getString(4));
                line.add(rs.getString(5).replace("\n", " ").replace("\r", " "));
                lines.add(line);
                sql_line = " SELECT  col.C_OrderLine_ID, mp.value, mp.name, ml.value, col.z_qtytoprepare, COALESCE((SELECT upc FROM M_Product WHERE M_Product_ID = mp.M_Product_ID) || ',' || (SELECT array_to_string(array_agg(upc), ',') FROM M_Product_PO WHERE M_Product_ID = mp.M_Product_ID), '')  FROM C_OrderLine col INNER JOIN M_Product mp ON mp.M_Product_ID = col.M_Product_ID  INNER JOIN M_Locator ml ON ml.M_Locator_ID = mp.M_Locator_ID  WHERE col.z_qtytoprepare <> 0 AND col.C_Order_ID = " + rs.getInt(1);
                pstmt_line = DB.prepareStatement(sql_line, null);
                rs_line = pstmt_line.executeQuery();
                while (rs_line.next()) {
                    line = new ArrayList();
                    line.add(rs_line.getString(1));
                    line.add(rs_line.getString(2));
                    line.add(rs_line.getString(3));
                    line.add(rs_line.getString(4));
                    line.add(rs_line.getString(5));
                    line.add(rs_line.getString(6).replace(";", ","));
                    lines.add(line);
                    ++nbr_export_order_line;
                }
                DB.close(rs_line, pstmt_line);
                rs_line = null;
                pstmt_line = null;
                SogexisUtils.exportToFileToPDA(this.path_to_export_operator + "/Preparation/", rs.getString(2), lines, "", new Long(0L));
                ++nbr_export_order;
                lines = new ArrayList();
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, "Erreur - " + sql_order, e);
                this.log.log(Level.SEVERE, "Erreur - " + sql_line, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                DB.close(rs_line, pstmt_line);
                rs = null;
                pstmt = null;
                rs_line = null;
                pstmt_line = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            DB.close(rs_line, pstmt_line);
            rs = null;
            pstmt = null;
            rs_line = null;
            pstmt_line = null;
        }
        DB.close(rs, pstmt);
        DB.close(rs_line, pstmt_line);
        rs = null;
        pstmt = null;
        rs_line = null;
        pstmt_line = null;
        this.addLog("Il y a eu " + nbr_export_order + " commandes exportees");
        this.addLog("Il y a eu " + nbr_export_order_line + " lignes commandes exportees");
        return "End";
    }
}

