/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process.cbl.planificator;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.SogexisUtils;

public class ZExportRequest
extends SvrProcess {
    String path_to_export = "";
    String interval_configuration = "";

    @Override
    protected void prepare() {
        this.path_to_export = MSysConfig.getValue("SOGEXIS_PATH_EXPORT_REQUEST", "N", MClient.get(Env.getCtx()).get_ID());
        this.interval_configuration = MSysConfig.getValue("SOGEXIS_INTERVAL_EXPORT_REQUEST", "N", MClient.get(Env.getCtx()).get_ID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        String sql = "SELECT req.documentno AS numero_request,  COALESCE(rc.name, '') AS categorie,  rs.name AS Statut,  CASE WHEN r.Priority = '1' THEN 'Urgent'  WHEN r.Priority = '3' THEN 'Haute'  WHEN r.Priority = '5' THEN 'Moyenne'  WHEN r.Priority = '7' THEN 'Basse' WHEN r.Priority = '9' THEN 'Mineur' END AS priority, req.summary,  cb.value AS BPartnerValue,  cb.name AS BPartnerName,  aa.name AS asset,  cl.city,  req.created,  cl.address1 || COALESCE( ',' || cl.address2, '') || COALESCE( ',' || cl.address3, '') || COALESCE( ',' || cl.address4, '') || COALESCE( ',' || cl.postal, '') || COALESCE( ',' || cl.city, '') AS address,  UPPER(adu.name) As tech,  adu.AD_User_ID,  adu.Z_IMEI,  to_char(req.created, 'DD/MM/YYYY') AS format_date,   CASE WHEN mp.M_PriceList_ID = 1000048 THEN 'N' ELSE 'Y' END AS facturable,  COALESCE(contact.phone2, COALESCE(contact.phone, '')) AS phone  FROM mes_requetes_technique req  INNER JOIN R_Request r ON req.R_Request_ID = r.R_Request_ID  INNER JOIN C_BPartner cb ON cb.C_BPartner_ID = req.C_BPartner_ID  INNER JOIN A_Asset aa ON aa.A_Asset_ID = req.A_Asset_ID  LEFT JOIN AD_User contact ON contact.AD_User_ID = aa.AD_User_ID  INNER JOIN R_Status rs ON rs.R_Status_ID = req.R_Status_ID  LEFT JOIN R_Category rc ON rc.R_Category_ID = req.R_Category_ID  INNER JOIN AD_User adu ON adu.AD_User_ID = req.AD_User_ID  INNER JOIN C_BPartner_Location cbl ON cbl.C_BPartner_Location_ID = aa.C_BPartner_Location_ID  INNER JOIN C_Location cl ON cl.C_Location_ID = cbl.C_Location_ID  INNER JOIN M_PriceList mp ON mp.M_PriceList_ID = aa.M_PriceList_ID WHERE adu.Z_IMEI IS NOT NULL AND req.created >= current_date - interval ' " + this.interval_configuration + " days '" + " ORDER BY adu.name ASC , cl.city ASC, req.created DESC ";
        System.out.println(sql);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int nbr_export = 0;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            int AD_User_ID = 0;
            String IMEI = null;
            String working_directory = "";
            while (rs.next()) {
                try {
                    if (AD_User_ID == 0 || AD_User_ID != rs.getInt("AD_User_ID")) {
                        AD_User_ID = rs.getInt("AD_User_ID");
                        IMEI = rs.getString("Z_IMEI");
                        File file = new File(this.path_to_export + "/Requete_" + IMEI);
                        if (!file.exists()) {
                            file.mkdir();
                        } else {
                            FileUtils.cleanDirectory((File)file);
                        }
                        working_directory = this.path_to_export + "/Requete_" + IMEI + "/";
                    }
                    ArrayList<List<String>> lines = new ArrayList<List<String>>();
                    ArrayList<String> line = new ArrayList<String>();
                    line.add("Requete");
                    line.add(rs.getString("format_date"));
                    line.add(rs.getString("Statut"));
                    line.add(rs.getString("priority"));
                    line.add(rs.getString("numero_request"));
                    line.add(rs.getString("BPartnerValue").replaceAll("[\n\r]", " "));
                    line.add(rs.getString("BPartnerName").replaceAll("[\n\r]", " "));
                    line.add(rs.getString("phone").replaceAll("[\n\r]", " "));
                    line.add(rs.getString("categorie").replaceAll("[\n\r]", " "));
                    line.add(rs.getString("city").replaceAll("[\n\r]", " "));
                    line.add(rs.getString("tech").replaceAll("[\n\r]", " "));
                    line.add(rs.getString("asset").replaceAll("[\n\r]", " "));
                    line.add(rs.getString("address").replaceAll(";", " ").replaceAll("[\n\r]", " "));
                    line.add(rs.getString("summary").replaceAll(";", " ").replaceAll("[\n\r]", " "));
                    line.add(rs.getString("facturable"));
                    line.add("Y");
                    lines.add(line);
                    SogexisUtils.exportToFileToPDA(working_directory, "Requete", lines, IMEI + "", rs.getTimestamp("created").getTime());
                    ++nbr_export;
                }
                catch (Exception e) {
                    this.addLog("Erreur - Requete non exporter");
                }
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, "Erreur - " + sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.addLog("Il y a eu " + nbr_export + " exportees");
        return "End";
    }
}

