/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process.cbl;

import java.io.File;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUserMail;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.SogexisUtils;

public class ZSendAskForReleveCompteurMailAndFaxCBL
extends SvrProcess {
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private int p_C_Invoice_ID = 0;
    private Timestamp p_Date;
    private boolean isSendByMail = false;
    private boolean isSendByFax = false;
    private boolean isSendByFaxIfMail = false;
    private int isCompteurAlready = 2;
    private int R_MailText_ID_Mail = 0;
    private int R_MailText_ID_Fax = 0;
    private int AD_PrintFormat_ID = 0;
    private MMailText mTextMail;
    private MMailText mTextFax;
    private MPrintFormat mPrintFormat;
    private static final String sqlUpdateContact = "UPDATE C_Invoice SET Z_DateSendAsk = ? WHERE C_Invoice_ID = ?";
    private MClient client = null;
    private int[] mailErrors = null;
    private List<String> mailErrorsList = null;
    private int[] mailSent = null;
    private Map<String, String> mailSentMap = null;
    private int[] faxErrors = null;
    private List<String> faxErrorsList = null;
    private int[] faxSent = null;
    private Map<String, String> faxSentMap = null;
    private int[] errors = null;
    private List<String> errorsList = null;
    private String mailFrom = null;
    private String mailToFax = null;
    private boolean IS_TEST = true;
    private String MAILTO_TEST = "technique@sogexis.fr";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("SendByMail")) {
                this.isSendByMail = para[i2].getParameterAsBoolean();
                continue;
            }
            if (name.equals("SendByFax")) {
                this.isSendByFax = para[i2].getParameterAsBoolean();
                continue;
            }
            if (name.equals("SendByFaxIfMail")) {
                this.isSendByFaxIfMail = para[i2].getParameterAsBoolean();
                continue;
            }
            if (name.equals("ZInvoiceContrat_ID")) {
                this.p_C_Invoice_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("DateInvoiced")) {
                this.p_Date = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("IsCompteurAlready")) {
                this.isCompteurAlready = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("R_MailText_ID_Mail")) {
                this.R_MailText_ID_Mail = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("R_MailText_ID_Fax")) {
                this.R_MailText_ID_Fax = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_PrintFormat_ID")) {
                this.AD_PrintFormat_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.client = MClient.get(this.getCtx());
        this.mailErrors = new int[1];
        this.mailErrorsList = new ArrayList<String>();
        this.mailSent = new int[1];
        this.mailSentMap = new HashMap<String, String>();
        this.faxErrors = new int[1];
        this.faxErrorsList = new ArrayList<String>();
        this.faxSent = new int[1];
        this.faxSentMap = new HashMap<String, String>();
        this.errors = new int[1];
        this.errorsList = new ArrayList<String>();
        this.mailFrom = MSysConfig.getValue("SOGEXIS_CBL_SEND_MAIL_FROM", "N", MClient.get(Env.getCtx()).get_ID());
        this.mailToFax = MSysConfig.getValue("SOGEXIS_CBL_SEND_MAIL_TO_FAX", "N", MClient.get(Env.getCtx()).get_ID());
        this.IS_TEST = "Y".equalsIgnoreCase(MSysConfig.getValue("SOGEXIS_CBL_SEND_MAIL_TEST", "Y", MClient.get(Env.getCtx()).get_ID()));
        this.MAILTO_TEST = MSysConfig.getValue("SOGEXIS_CBL_SEND_MAIL_TEST_TO", this.MAILTO_TEST, MClient.get(Env.getCtx()).get_ID());
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_Date == null) {
            return Msg.getElement(Env.getCtx(), "DateInvoiced");
        }
        if (!this.isSendByMail && !this.isSendByFax) {
            return Msg.getMsg(Env.getCtx(), "ChooseMailOrFax");
        }
        this.mTextMail = new MMailText(this.getCtx(), this.R_MailText_ID_Mail, this.get_TrxName());
        if (this.mTextMail.get_ID() != this.R_MailText_ID_Mail) {
            return Msg.getMsg(Env.getCtx(), "MailModelMail");
        }
        this.mTextFax = new MMailText(this.getCtx(), this.R_MailText_ID_Fax, this.get_TrxName());
        if (this.mTextFax.get_ID() != this.R_MailText_ID_Fax) {
            return Msg.getMsg(Env.getCtx(), "MailModelFax");
        }
        this.mPrintFormat = MPrintFormat.get(this.getCtx(), this.AD_PrintFormat_ID, false);
        if (this.mPrintFormat.get_ID() != this.AD_PrintFormat_ID) {
            return Msg.getMsg(Env.getCtx(), "MPrintFormatFax");
        }
        this.updatePassword();
        this.sendAskForReleveCompteur(this.client);
        return "Envoi des demandes de relev\u00e9 compteur termin\u00e9 !";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePassword() {
        String sqlUpdate = "UPDATE Ad_User SET password = ? WHERE AD_User_ID = ?";
        String sql = "SELECT DISTINCT Ad_User.AD_User_ID FROM Ad_User INNER JOIN A_Asset ON Ad_User.AD_User_ID = A_Asset.AD_User_ID WHERE (Ad_User.password IS NULL OR Ad_User.password = '') AND Ad_User.email IS NOT NULL AND Ad_User.email <> '' ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        CPreparedStatement pstmtUpdate = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            pstmtUpdate = DB.prepareStatement(sqlUpdate, this.get_TrxName());
            while (rs.next()) {
                pstmtUpdate.setString(1, SogexisUtils.randomPassword());
                pstmtUpdate.setInt(2, rs.getInt(1));
                pstmtUpdate.addBatch();
            }
            pstmtUpdate.executeBatch();
            pstmtUpdate.close();
            pstmt.close();
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                DB.close(null, pstmtUpdate);
                throw throwable;
            }
            DB.close(rs, pstmt);
            DB.close(null, pstmtUpdate);
        }
        DB.close(rs, pstmt);
        DB.close(null, pstmtUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAskForReleveCompteur(MClient client) {
        block23: {
            ResultSet rs = null;
            CPreparedStatement pstmt = null;
            String sql = "SELECT DISTINCT i.C_Invoice_ID, u.AD_User_ID, u.email, u.fax, asset.Z_FAX, u.password, asset.c_bpartner_id, bp.name, bp.value, i.documentNo FROM C_Recurring r INNER JOIN C_Invoice i ON (i.C_Invoice_ID = r.C_Invoice_ID) INNER JOIN C_InvoiceLine il ON (il.C_Invoice_ID = i.C_Invoice_ID) INNER JOIN A_Asset asset ON (il.A_Asset_ID = asset.A_Asset_ID) INNER JOIN C_BPartner bp ON (bp.c_bpartner_id = asset.c_bpartner_id) INNER JOIN C_DocType dt ON (dt.C_DocType_ID = i.C_DocTypeTarget_ID) LEFT JOIN AD_User u ON (u.AD_User_ID = asset.AD_User_ID) WHERE r.RecurringType = ? AND upper(dt.name) LIKE '%CONTRAT%'  AND r.IsActive = 'Y' AND ZIsCompteur = 'Y' AND asset.Type_Entretien = ?";
            if (this.p_C_Invoice_ID != 0) {
                sql = sql + " AND r.C_Invoice_ID = ?";
            }
            if (this.p_Date != null) {
                sql = sql + " AND trunc(r.DateNextRun) <= ?";
            }
            if (this.isCompteurAlready == 0) {
                sql = sql + " AND (QtyEntered IS NULL OR QtyEntered = 0)";
            } else if (this.isCompteurAlready == 1) {
                sql = sql + " AND QtyEntered > 0";
            }
            rs = null;
            pstmt = null;
            this.log.info(sql);
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                int k = 1;
                pstmt.setString(k++, "I");
                pstmt.setString(k++, "6");
                if (this.p_C_Invoice_ID != 0) {
                    pstmt.setInt(k++, this.p_C_Invoice_ID);
                }
                if (this.p_Date != null) {
                    pstmt.setTimestamp(k++, this.p_Date);
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int contractID = rs.getInt(1);
                    int adUserID = rs.getInt(2);
                    String mail = rs.getString(3);
                    mail = mail != null ? mail.replaceAll(" ", "") : mail;
                    String userFax = rs.getString(4);
                    userFax = userFax != null ? userFax.replaceAll(" ", "") : userFax;
                    userFax = userFax != null && userFax.equalsIgnoreCase("0262") ? null : userFax;
                    String assetFax = rs.getString(5);
                    assetFax = assetFax != null ? assetFax.replaceAll(" ", "") : assetFax;
                    assetFax = assetFax != null && assetFax.equalsIgnoreCase("0262") ? null : assetFax;
                    String fax = !StringUtils.isEmpty((String)assetFax) ? assetFax : userFax;
                    String password = rs.getString(6);
                    int bPartnerID = rs.getInt(7);
                    String bPartnerName = rs.getString(8);
                    String bPartnerNum = rs.getString(9);
                    String contractNum = rs.getString(10);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("customerNum", bPartnerNum);
                    params.put("customerName", bPartnerName);
                    params.put("password", password);
                    params.put("email", mail);
                    params.put("fax", fax);
                    params.put("dateEnd", this.sdf.format(this.p_Date));
                    if (this.isSendByMail) {
                        if (!StringUtils.isEmpty((String)mail)) {
                            if (this.mailSentMap.get(mail) == null || !this.mailSentMap.get(mail).equalsIgnoreCase(bPartnerNum)) {
                                this.sendAskForReleveCompteurMail(mail, adUserID, contractID, bPartnerNum, params);
                            } else {
                                this.updateZDateSendAskContract(contractID);
                            }
                        } else {
                            this.mailErrors[0] = this.mailErrors[0] + 1;
                            this.mailErrorsList.add(bPartnerNum + ":" + (mail != null ? mail : ""));
                        }
                    }
                    if (this.isSendByFax && (this.isSendByFaxIfMail || this.mailSentMap.get(mail) == null || !this.mailSentMap.get(mail).equalsIgnoreCase(bPartnerNum))) {
                        if (!StringUtils.isEmpty((String)fax)) {
                            if (this.faxSentMap.get(bPartnerNum) == null) {
                                this.sendAskForReleveCompteurFax(fax, adUserID, contractID, bPartnerNum, params, bPartnerID);
                            } else {
                                this.updateZDateSendAskContract(contractID);
                            }
                        } else {
                            this.faxErrors[0] = this.faxErrors[0] + 1;
                            this.faxErrorsList.add(bPartnerNum + ":" + (fax != null ? fax : ""));
                        }
                    }
                    if (this.mailSentMap.get(mail) != null && this.mailSentMap.get(mail).equalsIgnoreCase(bPartnerNum) || this.faxSentMap.get(bPartnerNum) != null) continue;
                    this.errors[0] = this.errors[0] + 1;
                    this.errorsList.add(contractNum);
                }
                rs.close();
                pstmt.close();
                DB.close(rs, pstmt);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
                break block23;
            }
            finally {
                DB.close(rs, pstmt);
                this.addLog("Nombre d'email envoy\u00e9 : " + this.mailSent[0]);
                this.addLog("Nombre de fax envoy\u00e9 : " + this.faxSent[0]);
                this.addLog("Nombre d'erreur d'envoi : " + this.errors[0]);
                this.addLog("Liste des contrats en erreur d'envoi : " + this.errorsList);
            }
            this.addLog("Nombre d'email envoy\u00e9 : " + this.mailSent[0]);
            this.addLog("Nombre de fax envoy\u00e9 : " + this.faxSent[0]);
            this.addLog("Nombre d'erreur d'envoi : " + this.errors[0]);
            this.addLog("Liste des contrats en erreur d'envoi : " + this.errorsList);
        }
    }

    private void sendAskForReleveCompteurMail(String mailTo, int adUserID, int contractID, String bPartnerNum, Map<String, String> params) {
        String subject;
        EMail email;
        if (this.IS_TEST) {
            mailTo = this.MAILTO_TEST;
        }
        if (!(email = this.client.createEMail(mailTo, subject = SogexisUtils.getMailContent(this.mTextMail.getMailHeader(), params), null)).isValid()) {
            this.mailErrors[0] = this.mailErrors[0] + 1;
            this.mailErrorsList.add(bPartnerNum + ":" + (mailTo != null ? mailTo : ""));
        } else {
            if (!StringUtils.isEmpty((String)this.mailFrom)) {
                email.setFrom(this.mailFrom);
            }
            String message = SogexisUtils.getMailContent(this.mTextMail.getMailText(true), params);
            if (this.mTextMail.isHtml()) {
                email.setSubject(subject);
                email.setMessageHTML(message);
            } else {
                email.setSubject(subject);
                email.setMessageText(message);
            }
            String msg = email.send();
            if (adUserID > 0) {
                MUserMail um = new MUserMail(this.mTextMail, adUserID, email);
                um.setSubject(email.getSubject());
                um.save();
            }
            if (msg.equals("OK")) {
                this.mailSent[0] = this.mailSent[0] + 1;
                this.mailSentMap.put(mailTo, bPartnerNum);
                this.updateZDateSendAskContract(contractID);
            } else {
                this.mailErrors[0] = this.mailErrors[0] + 1;
                this.mailErrorsList.add(bPartnerNum + ":" + (mailTo != null ? mailTo : ""));
            }
        }
    }

    private void sendAskForReleveCompteurFax(String fax, int adUserID, int contractID, String bPartnerNum, Map<String, String> params, int bPartnerID) {
        String subject;
        EMail email;
        String mailTo = this.mailToFax;
        if (this.IS_TEST) {
            mailTo = this.MAILTO_TEST;
        }
        if (!(email = this.client.createEMail(mailTo, subject = SogexisUtils.getMailContent(this.mTextFax.getMailHeader(), params), null)).isValid()) {
            this.faxErrors[0] = this.faxErrors[0] + 1;
            this.faxErrorsList.add(bPartnerNum + ":" + (fax != null ? fax : ""));
        } else {
            if (!StringUtils.isEmpty((String)this.mailFrom)) {
                email.setFrom(this.mailFrom);
            }
            String message = SogexisUtils.getMailContent(this.mTextFax.getMailText(true), params);
            if (this.mTextFax.isHtml()) {
                email.setSubject(subject);
                email.setMessageHTML(message);
            } else {
                email.setSubject(subject);
                email.setMessageText(message);
            }
            HashMap<String, Object> paramsReport = new HashMap<String, Object>();
            paramsReport.putAll(params);
            paramsReport.put("RecurringType", "I");
            paramsReport.put("DateRecurring", this.p_Date);
            paramsReport.put("BPARTNER_ID", bPartnerID);
            File askForCompteurFaxPDF = SogexisUtils.getPDFFromPrintFormatFromAdempiereOrJasperReportForInvoice(this.mPrintFormat, contractID, bPartnerID, this.getCtx(), this.get_TrxName(), paramsReport);
            if (askForCompteurFaxPDF != null) {
                email.addAttachment(askForCompteurFaxPDF);
            }
            if (email.getAttachments().length <= 0) {
                this.faxErrors[0] = this.faxErrors[0] + 1;
                this.faxErrorsList.add(bPartnerNum + ":" + (fax != null ? fax : ""));
            } else {
                String msg = email.send();
                if (adUserID > 0) {
                    MUserMail um = new MUserMail(this.mTextFax, adUserID, email);
                    um.setSubject(email.getSubject());
                    um.save();
                }
                if (msg.equals("OK")) {
                    this.faxSent[0] = this.faxSent[0] + 1;
                    this.faxSentMap.put(bPartnerNum, fax);
                    this.updateZDateSendAskContract(contractID);
                } else {
                    this.faxErrors[0] = this.faxErrors[0] + 1;
                    this.faxErrorsList.add(bPartnerNum + ":" + (fax != null ? fax : ""));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateZDateSendAskContract(int contractID) {
        CPreparedStatement stUpdate = null;
        try {
            stUpdate = DB.prepareStatement(sqlUpdateContact, this.get_TrxName());
            stUpdate.setTimestamp(1, new Timestamp(new Date().getTime()));
            stUpdate.setInt(2, contractID);
            stUpdate.executeUpdate();
            stUpdate.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sqlUpdateContact, e);
        }
        finally {
            DB.close(null, stUpdate);
        }
    }
}

