/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class RoleAccessUpdate
extends SvrProcess {
    private static CLogger s_log = CLogger.getCLogger(RoleAccessUpdate.class);
    private int p_AD_Role_ID = -1;
    private int p_AD_Client_ID = -1;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Role_ID")) {
                this.p_AD_Role_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Client_ID")) {
                this.p_AD_Client_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("AD_Client_ID=" + this.p_AD_Client_ID + ", AD_Role_ID=" + this.p_AD_Role_ID);
        if (this.p_AD_Role_ID > 0) {
            this.updateRole(new MRole(this.getCtx(), this.p_AD_Role_ID, this.get_TrxName()));
        } else {
            ArrayList<Object> params = new ArrayList<Object>();
            String whereClause = "1=1";
            if (this.p_AD_Client_ID > 0) {
                whereClause = whereClause + " AND AD_Client_ID=? ";
                params.add(this.p_AD_Client_ID);
            }
            if (this.p_AD_Role_ID == 0) {
                whereClause = whereClause + " AND AD_Role_ID=?";
                params.add(this.p_AD_Role_ID);
            }
            List roles = new Query(this.getCtx(), "AD_Role", whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(params).setOrderBy("AD_Client_ID, Name").list();
            for (MRole role : roles) {
                this.updateRole(role);
            }
        }
        return "";
    }

    private void updateRole(MRole role) {
        this.addLog(0, null, null, role.getName() + ": " + role.updateAccessRecords());
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(false);
        CLogMgt.setLevel(Level.FINE);
        s_log.info("Role Access Update");
        s_log.info("------------------");
        ProcessInfo pi = new ProcessInfo("Role Access Update", 295);
        pi.setAD_Client_ID(0);
        pi.setAD_User_ID(100);
        RoleAccessUpdate rau = new RoleAccessUpdate();
        rau.startProcess(Env.getCtx(), pi, null);
        System.out.println("Process=" + pi.getTitle() + " Error=" + pi.isError() + " Summary=" + pi.getSummary());
    }
}

