/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MMailText;
import org.compiere.model.MOrder;
import org.compiere.model.MQuery;
import org.compiere.model.MRecurring;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.model.PrintInfo;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_C_Order;
import org.compiere.model.X_M_InOut;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Ini;
import org.compiere.util.Language;

public class RecurringSogexis
extends SvrProcess {
    private List<Integer> listOrder = new ArrayList<Integer>();
    private List<String> listEnvoiMail = new ArrayList<String>();
    private List<Integer> listMailText = new ArrayList<Integer>();
    private List<Integer> listDestinataire = new ArrayList<Integer>();
    private List<Integer> listInvoice = new ArrayList<Integer>();
    private List<String> listEnvoiMailInvoice = new ArrayList<String>();
    private List<Integer> listMailTextInvoice = new ArrayList<Integer>();
    private List<Integer> listDestinataireInvoice = new ArrayList<Integer>();

    @Override
    protected void prepare() {
    }

    @Override
    protected String doIt() throws Exception {
        String sql = "SELECT c_recurring_id, runsremaining, datenextrun, z_envoimail, R_MailText_ID, AD_User_ID FROM c_recurring WHERE datenextrun < (CURRENT_DATE + 1) AND isActive = 'Y' AND (recurringtype = 'O' OR recurringType = 'I') AND z_facturationauto = 'Y'";
        CPreparedStatement pstmtRecurring = DB.prepareStatement(sql, null);
        ResultSet rs = pstmtRecurring.executeQuery();
        MRecurring rec = null;
        Integer id_mOrder = null;
        Integer id_Invoice = null;
        Integer destinataireRecurring = null;
        while (rs.next()) {
            String sendMail = rs.getString(4);
            int mailText = rs.getInt(5);
            rec = new MRecurring(this.getCtx(), rs.getInt(1), null);
            this.log.info(rec.toString());
            destinataireRecurring = rs.getInt(6);
            if (destinataireRecurring == null) {
                destinataireRecurring = 0;
            }
            if (rec.getRecurringType().equals("O")) {
                id_mOrder = rec.executeRunOrder();
                this.listOrder.add(id_mOrder);
                this.listEnvoiMail.add(sendMail);
                this.listMailText.add(mailText);
                this.listDestinataire.add(destinataireRecurring);
                continue;
            }
            if (!rec.getRecurringType().equals("I")) continue;
            id_Invoice = rec.executeRunOrder();
            this.listInvoice.add(id_Invoice);
            this.listEnvoiMailInvoice.add(sendMail);
            this.listMailTextInvoice.add(mailText);
            this.listDestinataireInvoice.add(destinataireRecurring);
        }
        return "process terminer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postProcess(boolean success) {
        int destrinataireRecurringID;
        int mailText;
        boolean sendMail;
        String sendMailTmp;
        int i2;
        MOrder maCommande = null;
        MInvoice maFacture = null;
        for (i2 = 0; i2 < this.listInvoice.size(); ++i2) {
            int id_Invoice = this.listInvoice.get(i2);
            sendMailTmp = this.listEnvoiMailInvoice.get(i2);
            sendMail = sendMailTmp.equals("Y");
            mailText = this.listMailTextInvoice.get(i2);
            maFacture = new MInvoice(this.getCtx(), id_Invoice, null);
            maFacture.processIt("CO");
            maFacture.save();
            if (!sendMail && this.listDestinataireInvoice.get(i2) == 0 && (sendMail || this.listDestinataireInvoice.get(i2) != 0)) continue;
            MMailText mText = null;
            mText = new MMailText(this.getCtx(), mailText, null);
            MClient client = MClient.get(this.getCtx());
            destrinataireRecurringID = this.listDestinataireInvoice.get(i2);
            StringBuffer sqlMail = new StringBuffer("SELECT i.C_Invoice_ID,bp.AD_Language, COALESCE(bp.Invoice_PrintFormat_ID, dt.AD_PrintFormat_ID, pf.Invoice_PrintFormat_ID), bp.C_BPartner_ID ,bpc.AD_User_ID, i.DocumentNo,c.IsMultiLingualDocument FROM C_Invoice i INNER JOIN C_BPartner bp ON (i.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN AD_User bpc ON (i.AD_User_ID=bpc.AD_User_ID) INNER JOIN AD_Client c ON (i.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (i.AD_Client_ID=pf.AD_Client_ID) INNER JOIN C_DocType dt ON (i.C_DocType_ID=dt.C_DocType_ID) WHERE i.AD_Client_ID=" + maFacture.getAD_Client_ID() + " AND i.AD_Org_ID=" + maFacture.getAD_Org_ID() + " AND i.C_Invoice_ID=" + maFacture.getC_Invoice_ID() + "");
            MPrintFormat format = null;
            CPreparedStatement pstmt = null;
            ResultSet rsMail = null;
            try {
                pstmt = DB.prepareStatement(sqlMail.toString(), null);
                rsMail = pstmt.executeQuery();
                while (rsMail.next()) {
                    MClient destinataireRecurringClient;
                    MClient societeClient;
                    Language language = Language.getLoginLanguage();
                    String AD_Language = rsMail.getString(2);
                    if (AD_Language != null && "Y".equals(rsMail.getString(7))) {
                        language = Language.getLanguage(AD_Language);
                    }
                    int AD_PrintFormat_ID = rsMail.getInt(3);
                    int C_BPartner_ID = rsMail.getInt(4);
                    String documentNo = rsMail.getString(6);
                    String documentDir = client.getDocumentDir();
                    if (documentDir == null || documentDir.length() == 0) {
                        documentDir = ".";
                    }
                    format = MPrintFormat.get(this.getCtx(), AD_PrintFormat_ID, false);
                    format.setLanguage(language);
                    format.setTranslationLanguage(language);
                    MQuery query = new MQuery("C_Invoice_Header_v");
                    query.addRestriction("C_Invoice_ID", "=", new Integer(id_Invoice));
                    PrintInfo info = new PrintInfo(documentNo, X_C_Invoice.Table_ID, id_Invoice, C_BPartner_ID);
                    ReportEngine re = new ReportEngine(this.getCtx(), format, query, info);
                    if (!sendMail && destrinataireRecurringID == 0 && (sendMail || this.listDestinataireInvoice.get(i2) != 0)) continue;
                    boolean printed = false;
                    String subject = mText.getMailHeader();
                    MUser destinataireInvoice = null;
                    if (sendMail) {
                        destinataireInvoice = new MUser(this.getCtx(), maFacture.getAD_User_ID(), null);
                    }
                    MUser destinataireRecurring = new MUser(this.getCtx(), destrinataireRecurringID, null);
                    EMail email = null;
                    String message = "";
                    if (maFacture.isSOTrx()) {
                        MClient destinataireClient;
                        if ((destinataireInvoice == null || destinataireInvoice.getEMail() == null) && destinataireRecurring.getEMail() == null) {
                            System.out.println("7");
                            societeClient = new MClient(this.getCtx(), maFacture.getAD_Client_ID(), null);
                            email = societeClient.createEMail(societeClient.getRequestEMail(), "Erreur - " + subject, null);
                            mText.setBPartner(C_BPartner_ID);
                            mText.setBPartner(C_BPartner_ID);
                            mText.setPO(new MInvoice(this.getCtx(), maFacture.get_ID(), null));
                            message = "Erreur - La facture (" + maFacture.getDocumentNo() + ") n'a pu \u00eatre transmis au client. V\u00e9rifier l'adresse email.";
                        } else if (destinataireInvoice != null && destinataireInvoice.getEMail() != null && destinataireRecurring.getEMail() == null) {
                            System.out.println("8");
                            destinataireClient = new MClient(this.getCtx(), destinataireInvoice.getAD_Client_ID(), null);
                            email = destinataireClient.createEMail(destinataireInvoice.getEMail(), "Votre facture " + subject, null);
                            mText.setUser(destinataireInvoice);
                            mText.setBPartner(C_BPartner_ID);
                            mText.setPO(new MInvoice(this.getCtx(), maFacture.get_ID(), null));
                            message = mText.getMailText(true);
                        } else if ((destinataireInvoice == null || destinataireInvoice.getEMail() == null) && destinataireRecurring.getEMail() != null) {
                            System.out.println("9");
                            destinataireRecurringClient = new MClient(this.getCtx(), destinataireRecurring.getAD_Client_ID(), null);
                            email = destinataireRecurringClient.createEMail(destinataireRecurring.getEMail(), "Votre facture " + subject, null);
                            mText.setUser(destinataireRecurring);
                            mText.setBPartner(C_BPartner_ID);
                            mText.setPO(new MInvoice(this.getCtx(), maFacture.get_ID(), null));
                            message = mText.getMailText(true);
                        } else {
                            System.out.println("10");
                            destinataireClient = new MClient(this.getCtx(), destinataireInvoice.getAD_Client_ID(), null);
                            email = destinataireClient.createEMail(destinataireInvoice.getEMail(), "Votre facture " + subject, null);
                            mText.setUser(destinataireInvoice);
                            mText.setBPartner(C_BPartner_ID);
                            mText.setPO(new MInvoice(this.getCtx(), maFacture.get_ID(), null));
                            message = mText.getMailText(true);
                            email.addBcc(destinataireRecurring.getEMail());
                        }
                    } else if (destinataireRecurring.getEMail() == null) {
                        System.out.println("11");
                        societeClient = new MClient(this.getCtx(), maFacture.getAD_Client_ID(), null);
                        email = societeClient.createEMail(societeClient.getRequestEMail(), "Erreur - " + subject, null);
                        mText.setBPartner(C_BPartner_ID);
                        mText.setBPartner(C_BPartner_ID);
                        mText.setPO(new MInvoice(this.getCtx(), maFacture.get_ID(), null));
                        message = "Erreur - La facutre (" + maFacture.getDocumentNo() + ") n'a pu \u00eatre tramis au client. V\u00e9rifier l'adresse email.";
                    } else {
                        System.out.println("12");
                        destinataireRecurringClient = new MClient(this.getCtx(), destinataireRecurring.getAD_Client_ID(), null);
                        email = destinataireRecurringClient.createEMail(destinataireRecurring.getEMail(), "Votre facture " + subject, null);
                        mText.setUser(destinataireRecurring);
                        mText.setBPartner(C_BPartner_ID);
                        mText.setPO(new MInvoice(this.getCtx(), maFacture.get_ID(), null));
                        message = mText.getMailText(true);
                    }
                    File invoice = null;
                    if (!Ini.isClient()) {
                        invoice = new File(MInvoice.getPDFFileName(documentDir, id_Invoice));
                        invoice = maFacture.createPDF(new File("Facture " + maFacture.getDocumentNo() + ".pdf"));
                    }
                    File attachement = re.getPDF(invoice);
                    if (mText.isHtml()) {
                        email.setMessageHTML(subject, message);
                    } else {
                        email.setSubject(subject);
                        email.setMessageText(message);
                    }
                    email.addAttachment(attachement);
                    String msg = email.send();
                    MUserMail um = new MUserMail(mText, this.getAD_User_ID(), email);
                    um.save();
                    if (msg.equals("OK")) {
                        printed = true;
                    }
                    invoice.delete();
                    if (!printed) continue;
                    StringBuffer sb = new StringBuffer("UPDATE C_Invoice SET DatePrinted=SysDate, IsPrinted='Y' WHERE C_Invoice_ID=").append(id_Invoice);
                    DB.executeUpdateEx(sb.toString(), null);
                }
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, "doIt - " + sqlMail, e);
                }
                catch (Throwable throwable) {
                    DB.close(rsMail, pstmt);
                    throw throwable;
                }
                DB.close(rsMail, pstmt);
                continue;
            }
            DB.close(rsMail, pstmt);
            continue;
        }
        for (i2 = 0; i2 < this.listOrder.size(); ++i2) {
            int id_mOrder = this.listOrder.get(i2);
            sendMailTmp = this.listEnvoiMail.get(i2);
            sendMail = sendMailTmp.equals("Y");
            mailText = this.listMailText.get(i2);
            maCommande = new MOrder(this.getCtx(), id_mOrder, null);
            maCommande.processIt("CO");
            maCommande.save();
            if (!sendMail && this.listDestinataire.get(i2) == 0 && (sendMail || this.listDestinataire.get(i2) != 0)) continue;
            MDocType currentDoct = new MDocType(this.getCtx(), maCommande.getC_DocType_ID(), null);
            MMailText mText = null;
            mText = new MMailText(this.getCtx(), mailText, null);
            MClient client = MClient.get(this.getCtx());
            destrinataireRecurringID = this.listDestinataire.get(i2);
            StringBuffer sqlMail = maCommande.isSOTrx() && currentDoct.getDocSubTypeSO().contains("WI") ? new StringBuffer("SELECT i.C_Invoice_ID,bp.AD_Language, COALESCE(bp.Invoice_PrintFormat_ID, dt.AD_PrintFormat_ID, pf.Invoice_PrintFormat_ID), bp.C_BPartner_ID ,bpc.AD_User_ID, i.DocumentNo,c.IsMultiLingualDocument FROM C_Invoice i INNER JOIN C_BPartner bp ON (i.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN AD_User bpc ON (i.AD_User_ID=bpc.AD_User_ID) INNER JOIN AD_Client c ON (i.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (i.AD_Client_ID=pf.AD_Client_ID) INNER JOIN C_DocType dt ON (i.C_DocType_ID=dt.C_DocType_ID) WHERE i.AD_Client_ID=" + maCommande.getAD_Client_ID() + " AND i.AD_Org_ID=" + maCommande.getAD_Org_ID() + " AND i.isSOTrx='Y' AND i.C_Invoice_ID=" + maCommande.getC_Invoice_ID()) : (maCommande.isSOTrx() && currentDoct.getDocSubTypeSO().contains("WP") ? new StringBuffer("SELECT i.m_inout_ID,bp.AD_Language, COALESCE(bp.Invoice_PrintFormat_ID, dt.AD_PrintFormat_ID, pf.shipment_printformat_id), bp.C_BPartner_ID ,bpc.AD_User_ID, i.DocumentNo,c.IsMultiLingualDocument FROM m_inout i INNER JOIN C_BPartner bp ON (i.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN AD_User bpc ON (i.AD_User_ID=bpc.AD_User_ID) INNER JOIN AD_Client c ON (i.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (i.AD_Client_ID=pf.AD_Client_ID) INNER JOIN C_DocType dt ON (i.C_DocType_ID=dt.C_DocType_ID) WHERE i.AD_Client_ID=" + maCommande.getAD_Client_ID() + " AND i.AD_Org_ID=" + maCommande.getAD_Org_ID() + " AND i.isSOTrx='Y' AND i.C_Order_ID=" + maCommande.get_ID()) : new StringBuffer("SELECT o.c_order_id, bp.AD_language, COALESCE(bp.Invoice_PrintFormat_ID, dt.AD_PrintFormat_id, pf.Order_PrintFormat_id), bp.C_BPartner_ID, bpc.AD_User_ID, o.DocumentNo, c.IsMultiLingualDocument FROM c_order o INNER JOIN C_BPartner bp ON (o.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN AD_User bpc ON (o.AD_User_ID=bpc.AD_User_ID) INNER JOIN AD_Client c ON (o.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (o.AD_Client_ID=pf.AD_Client_ID) INNER JOIN C_Doctype dt ON (o.C_DocType_ID=dt.C_DocType_ID) WHERE o.AD_Client_ID=" + maCommande.getAD_Client_ID() + " AND o.AD_Org_ID=" + maCommande.getAD_Org_ID() + " AND o.isSOTrx='" + (maCommande.isSOTrx() ? "Y" : "N") + "' AND o.c_order_id=" + maCommande.get_ID() + ""));
            MPrintFormat format = null;
            CPreparedStatement pstmt = null;
            ResultSet rsMail = null;
            try {
                pstmt = DB.prepareStatement(sqlMail.toString(), null);
                rsMail = pstmt.executeQuery();
                while (rsMail.next()) {
                    MClient destinataireRecurringClient;
                    String message;
                    MClient societeClient;
                    MQuery queryMail;
                    Language language = Language.getLoginLanguage();
                    String AD_Language = rsMail.getString(2);
                    if (AD_Language != null && "Y".equals(rsMail.getString(7))) {
                        language = Language.getLanguage(AD_Language);
                    }
                    int AD_PrintFormat_ID = rsMail.getInt(3);
                    int C_BPartner_ID = rsMail.getInt(4);
                    String documentNo = rsMail.getString(6);
                    String documentDir = client.getDocumentDir();
                    if (documentDir == null || documentDir.length() == 0) {
                        documentDir = ".";
                    }
                    format = MPrintFormat.get(this.getCtx(), AD_PrintFormat_ID, false);
                    format.setLanguage(language);
                    format.setTranslationLanguage(language);
                    if (maCommande.isSOTrx() && currentDoct.getDocSubTypeSO().contains("WI")) {
                        queryMail = new MQuery("C_Invoice_Header_v");
                        queryMail.addRestriction("C_Invoice_ID", "=", new Integer(maCommande.getC_Invoice_ID()));
                    } else if (maCommande.isSOTrx() && currentDoct.getDocSubTypeSO().contains("WP")) {
                        queryMail = new MQuery("M_Inout_Header_v");
                        queryMail.addRestriction("m_inout_id", "=", new Integer(rsMail.getInt(1)));
                    } else {
                        queryMail = new MQuery("C_Order_Header_v");
                        queryMail.addRestriction("C_Order_ID", "=", new Integer(maCommande.get_ID()));
                    }
                    PrintInfo info = currentDoct.getName().contains("BL et Facture") ? new PrintInfo(documentNo, X_C_Invoice.Table_ID, maCommande.getC_Invoice_ID(), C_BPartner_ID) : (currentDoct.getName().contains("BL") ? new PrintInfo(documentNo, X_M_InOut.Table_ID, rsMail.getInt(1), C_BPartner_ID) : new PrintInfo(documentNo, X_C_Order.Table_ID, maCommande.get_ID(), C_BPartner_ID));
                    ReportEngine re = new ReportEngine(this.getCtx(), format, queryMail, info);
                    if (!sendMail && this.listDestinataire.get(i2) == 0 && (sendMail || this.listDestinataire.get(i2) != 0)) continue;
                    MUser destinataireOrder = null;
                    if (sendMail) {
                        destinataireOrder = new MUser(this.getCtx(), maCommande.getBill_User_ID(), null);
                    }
                    MUser destinataireRecurring = new MUser(this.getCtx(), destrinataireRecurringID, null);
                    boolean printed = false;
                    String subject = mText.getMailHeader() + " - " + documentNo;
                    EMail email = null;
                    if (maCommande.isSOTrx()) {
                        MClient destinataireClient;
                        if ((destinataireOrder == null || destinataireOrder.getEMail() == null) && destinataireRecurring.getEMail() == null) {
                            System.out.println("1");
                            societeClient = new MClient(this.getCtx(), maCommande.getAD_Client_ID(), null);
                            email = societeClient.createEMail(societeClient.getRequestEMail(), "Erreur - " + subject, null);
                            mText.setBPartner(C_BPartner_ID);
                            mText.setBPartner(C_BPartner_ID);
                            mText.setPO(new MOrder(this.getCtx(), maCommande.get_ID(), null));
                            message = "Erreur - La commande de vente (" + maCommande.getDocumentNo() + ") n'a pu \u00eatre transmis au client. V\u00e9rifier l'adresse email.";
                        } else if (destinataireOrder != null && destinataireOrder.getEMail() != null && destinataireRecurring.getEMail() == null) {
                            System.out.println("2");
                            destinataireClient = new MClient(this.getCtx(), destinataireOrder.getAD_Client_ID(), null);
                            email = destinataireClient.createEMail(destinataireOrder.getEMail(), subject, null);
                            mText.setUser(destinataireOrder);
                            mText.setBPartner(C_BPartner_ID);
                            mText.setPO(new MOrder(this.getCtx(), maCommande.get_ID(), null));
                            message = mText.getMailText(true);
                        } else if ((destinataireOrder == null || destinataireOrder.getEMail() == null) && destinataireRecurring.getEMail() != null) {
                            System.out.println("3");
                            destinataireRecurringClient = new MClient(this.getCtx(), destinataireRecurring.getAD_Client_ID(), null);
                            email = destinataireRecurringClient.createEMail(destinataireRecurring.getEMail(), subject, null);
                            mText.setUser(destinataireRecurring);
                            mText.setBPartner(C_BPartner_ID);
                            mText.setPO(new MOrder(this.getCtx(), maCommande.get_ID(), null));
                            message = mText.getMailText(true);
                        } else {
                            System.out.println("4");
                            destinataireClient = new MClient(this.getCtx(), destinataireOrder.getAD_Client_ID(), null);
                            email = destinataireClient.createEMail(destinataireOrder.getEMail(), subject, null);
                            mText.setUser(destinataireOrder);
                            mText.setBPartner(C_BPartner_ID);
                            mText.setPO(new MOrder(this.getCtx(), maCommande.get_ID(), null));
                            message = mText.getMailText(true);
                            email.addBcc(destinataireRecurring.getEMail());
                        }
                    } else if (destinataireRecurring.getEMail() == null) {
                        System.out.println("5");
                        societeClient = new MClient(this.getCtx(), maCommande.getAD_Client_ID(), null);
                        email = societeClient.createEMail(societeClient.getRequestEMail(), "Erreur - " + subject, null);
                        mText.setBPartner(C_BPartner_ID);
                        mText.setBPartner(C_BPartner_ID);
                        mText.setPO(new MOrder(this.getCtx(), maCommande.get_ID(), null));
                        message = "Erreur - La commande de vente (" + maCommande.getDocumentNo() + ") n'a pu \u00eatre tramis au client. V\u00e9rifier l'adresse email.";
                    } else {
                        System.out.println("6");
                        destinataireRecurringClient = new MClient(this.getCtx(), destinataireRecurring.getAD_Client_ID(), null);
                        email = destinataireRecurringClient.createEMail(destinataireRecurring.getEMail(), subject, null);
                        mText.setUser(destinataireRecurring);
                        mText.setBPartner(C_BPartner_ID);
                        mText.setPO(new MOrder(this.getCtx(), maCommande.get_ID(), null));
                        message = mText.getMailText(true);
                    }
                    File order = null;
                    if (!Ini.isClient()) {
                        if (maCommande.isSOTrx() && currentDoct.getDocSubTypeSO().contains("WI")) {
                            MInvoice invoice = new MInvoice(this.getCtx(), maCommande.getC_Invoice_ID(), null);
                            order = invoice.createPDF(new File("Facture " + invoice.getDocumentNo() + ".pdf"));
                        } else if (maCommande.isSOTrx() && currentDoct.getDocSubTypeSO().contains("WP")) {
                            MInOut inout = new MInOut(this.getCtx(), rsMail.getInt(1), null);
                            order = inout.createPDF(new File("Bon de livraison " + inout.getDocumentNo() + ".pdf"));
                        } else {
                            order = maCommande.createPDF(new File("Ordre " + (maCommande.isSOTrx() ? "de vente" : " d'achat") + " " + maCommande.getDocumentNo() + ".pdf"));
                        }
                    }
                    File attachement = re.getPDF(order);
                    if (mText.isHtml()) {
                        email.setMessageHTML(subject, message);
                    } else {
                        email.setSubject(subject);
                        email.setMessageText(message);
                    }
                    email.addAttachment(attachement);
                    String msg = email.send();
                    MUserMail um = new MUserMail(mText, this.getAD_User_ID(), email);
                    um.save();
                    if (msg.equals("OK")) {
                        printed = true;
                    }
                    order.delete();
                    if (!printed) continue;
                    StringBuffer sb = new StringBuffer("UPDATE C_Order SET DatePrinted=SysDate, isPrinted='Y' WHERE C_Order_ID=" + maCommande.get_ID());
                    DB.executeUpdateEx(sb.toString(), null);
                }
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, "doIt - " + sqlMail, e);
                }
                catch (Throwable throwable) {
                    DB.close(rsMail, pstmt);
                    throw throwable;
                }
                DB.close(rsMail, pstmt);
                continue;
            }
            DB.close(rsMail, pstmt);
            continue;
        }
    }
}

