/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceSchedule;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class InvoiceGenerateSogexis
extends SvrProcess {
    private boolean p_Selection = false;
    private Timestamp p_DateInvoiced = null;
    private int p_AD_Org_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_C_Order_ID = 0;
    private boolean p_ConsolidateDocument = true;
    private String p_docAction = "CO";
    private MInvoice m_invoice = null;
    private MInOut m_ship = null;
    private int m_created = 0;
    private int m_line = 0;
    private MBPartner m_bp = null;
    private Timestamp p_MovementDate_From = null;
    private Timestamp p_MovementDate_To = null;
    private boolean p_z_retenue_garantie = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("Selection")) {
                this.p_Selection = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("DateInvoiced")) {
                this.p_DateInvoiced = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_Order_ID")) {
                this.p_C_Order_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("ConsolidateDocument")) {
                this.p_ConsolidateDocument = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("DocAction")) {
                this.p_docAction = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("MovementDate_From")) {
                this.p_MovementDate_From = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("MovementDate_To")) {
                this.p_MovementDate_To = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("z_retenue_garantie")) {
                this.p_z_retenue_garantie = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = new Timestamp(System.currentTimeMillis());
        }
        if (!"CO".equals(this.p_docAction)) {
            this.p_docAction = "PR";
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("Selection=" + this.p_Selection + ", DateInvoiced=" + this.p_DateInvoiced + ", AD_Org_ID=" + this.p_AD_Org_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", C_Order_ID=" + this.p_C_Order_ID + ", DocAction=" + this.p_docAction + ", Consolidate=" + this.p_ConsolidateDocument);
        String sql = null;
        if (this.p_Selection) {
            sql = "SELECT C_Order.* FROM C_Order, T_Selection WHERE C_Order.DocStatus='CO' AND C_Order.IsSOTrx='Y' AND C_Order.C_Order_ID = T_Selection.T_Selection_ID AND T_Selection.AD_PInstance_ID=? ORDER BY C_Order.M_Warehouse_ID, C_Order.PriorityRule, C_Order.C_BPartner_ID, C_Order.C_Order_ID";
        } else {
            sql = "SELECT * FROM C_Order o  Left JOIN M_INOUT mi ON (o.C_Order_ID = mi.C_Order_ID) WHERE o.DocStatus IN('CO','CL') AND mi.DocStatus IN('CO','CL') AND o.IsSOTrx='Y'";
            if (this.p_AD_Org_ID != 0) {
                sql = sql + " AND o.AD_Org_ID=?";
            }
            if (this.p_C_BPartner_ID != 0) {
                sql = sql + " AND o.C_BPartner_ID=?";
            }
            if (this.p_C_Order_ID != 0) {
                sql = sql + " AND o.C_Order_ID=?";
            }
            if (this.p_MovementDate_From != null) {
                sql = sql + " AND TRUNC(mi.MovementDate,'DD') >= ?";
            }
            if (this.p_MovementDate_To != null) {
                sql = sql + " AND TRUNC(mi.MovementDate,'DD') <= ?";
            }
            sql = sql + " AND EXISTS (SELECT * FROM C_OrderLine ol WHERE o.C_Order_ID=ol.C_Order_ID AND ol.QtyOrdered<>ol.QtyInvoiced) AND o.C_DocType_ID IN (SELECT C_DocType_ID FROM C_DocType WHERE DocBaseType='SOO' AND DocSubTypeSO NOT IN ('ON','OB','WR')) ORDER BY o.M_Warehouse_ID, o.PriorityRule, o.C_BPartner_ID, o.C_Order_ID";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            int index = 1;
            if (this.p_Selection) {
                pstmt.setInt(index, this.getAD_PInstance_ID());
            } else {
                if (this.p_AD_Org_ID != 0) {
                    pstmt.setInt(index++, this.p_AD_Org_ID);
                }
                if (this.p_C_BPartner_ID != 0) {
                    pstmt.setInt(index++, this.p_C_BPartner_ID);
                }
                if (this.p_C_Order_ID != 0) {
                    pstmt.setInt(index++, this.p_C_Order_ID);
                }
                if (this.p_MovementDate_From != null) {
                    pstmt.setTimestamp(index++, this.p_MovementDate_From);
                }
                if (this.p_MovementDate_To != null) {
                    pstmt.setTimestamp(index++, this.p_MovementDate_To);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return this.generate(pstmt);
    }

    private String generate(PreparedStatement pstmt) {
        try {
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MInOutLine[] shipLines;
                MInOut ship;
                int i2;
                MInOut[] shipments;
                MOrder order = new MOrder(this.getCtx(), rs, this.get_TrxName());
                if (!this.p_ConsolidateDocument || this.m_invoice != null && this.m_invoice.getC_BPartner_Location_ID() != order.getBill_Location_ID()) {
                    this.completeInvoice();
                }
                boolean completeOrder = "O".equals(order.getInvoiceRule());
                boolean doInvoice = false;
                if ("S".equals(order.getInvoiceRule())) {
                    this.m_bp = new MBPartner(this.getCtx(), order.getBill_BPartner_ID(), null);
                    if (this.m_bp.getC_InvoiceSchedule_ID() == 0) {
                        this.log.warning("BPartner has no Schedule - set to After Delivery");
                        order.setInvoiceRule("D");
                        order.save();
                    } else {
                        MInvoiceSchedule is = MInvoiceSchedule.get(this.getCtx(), this.m_bp.getC_InvoiceSchedule_ID(), this.get_TrxName());
                        if (!is.canInvoice(order.getDateOrdered(), order.getGrandTotal())) continue;
                        doInvoice = true;
                    }
                }
                if (doInvoice || "D".equals(order.getInvoiceRule())) {
                    shipments = order.getShipments();
                    for (i2 = 0; i2 < shipments.length; ++i2) {
                        ship = shipments[i2];
                        if (ship.getMovementDate().compareTo(this.p_MovementDate_From) < 0 || ship.getMovementDate().compareTo(this.p_MovementDate_To) > 0 || !ship.isComplete() || ship.getDocStatus().equals("RE")) continue;
                        shipLines = ship.getLines(false);
                        for (int j = 0; j < shipLines.length; ++j) {
                            MInOutLine shipLine = shipLines[j];
                            if (!order.isOrderLine(shipLine.getC_OrderLine_ID()) || shipLine.isInvoiced()) continue;
                            this.createLine(order, ship, shipLine);
                        }
                        this.m_line += 1000;
                    }
                } else {
                    MOrderLine[] oLines = order.getLines(true, null);
                    for (i2 = 0; i2 < oLines.length; ++i2) {
                        boolean fullyDelivered;
                        MOrderLine oLine = oLines[i2];
                        BigDecimal toInvoice = oLine.getQtyOrdered().subtract(oLine.getQtyInvoiced());
                        if (toInvoice.compareTo(Env.ZERO) == 0 && oLine.getM_Product_ID() != 0) continue;
                        BigDecimal notInvoicedShipment = oLine.getQtyDelivered().subtract(oLine.getQtyInvoiced());
                        boolean bl = fullyDelivered = oLine.getQtyOrdered().compareTo(oLine.getQtyDelivered()) == 0;
                        if (completeOrder && !fullyDelivered) {
                            this.log.fine("Failed CompleteOrder - " + oLine);
                            this.addLog("Failed CompleteOrder - " + oLine);
                            completeOrder = false;
                            break;
                        }
                        if ("I".equals(order.getInvoiceRule())) {
                            this.log.fine("Immediate - ToInvoice=" + toInvoice + " - " + oLine);
                            BigDecimal qtyEntered = toInvoice;
                            if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                                qtyEntered = toInvoice.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 12, 4);
                            }
                            this.createLine(order, oLine, toInvoice, qtyEntered);
                            continue;
                        }
                        this.log.fine("Failed: " + order.getInvoiceRule() + " - ToInvoice=" + toInvoice + " - " + oLine);
                        this.addLog("Failed: " + order.getInvoiceRule() + " - ToInvoice=" + toInvoice + " - " + oLine);
                    }
                    if ("I".equals(order.getInvoiceRule())) {
                        this.m_line += 1000;
                    }
                }
                if (!completeOrder || !"O".equals(order.getInvoiceRule())) continue;
                shipments = order.getShipments();
                for (i2 = 0; i2 < shipments.length; ++i2) {
                    ship = shipments[i2];
                    if (!ship.isComplete() || ship.getDocStatus().equals("RE")) continue;
                    shipLines = ship.getLines(false);
                    for (int j = 0; j < shipLines.length; ++j) {
                        MInOutLine shipLine = shipLines[j];
                        if (!order.isOrderLine(shipLine.getC_OrderLine_ID()) || shipLine.isInvoiced()) continue;
                        this.createLine(order, ship, shipLine);
                    }
                    this.m_line += 1000;
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.completeInvoice();
        return "@Created@ = " + this.m_created;
    }

    private void createLine(MOrder order, MOrderLine orderLine, BigDecimal qtyInvoiced, BigDecimal qtyEntered) {
        if (this.m_invoice == null) {
            this.m_invoice = new MInvoice(order, 0, this.p_DateInvoiced);
            if (!this.m_invoice.save()) {
                throw new IllegalStateException("Could not create Invoice (o)");
            }
        }
        MInvoiceLine line = new MInvoiceLine(this.m_invoice);
        line.setOrderLine(orderLine);
        line.setQtyInvoiced(qtyInvoiced);
        line.setQtyEntered(qtyEntered);
        line.setLine(this.m_line + orderLine.getLine());
        if (!line.save()) {
            throw new IllegalStateException("Could not create Invoice Line (o)");
        }
        this.log.fine(line.toString());
    }

    private void createLine(MOrder order, MInOut ship, MInOutLine sLine) {
        if (this.m_invoice == null) {
            this.m_invoice = new MInvoice(order, 0, this.p_DateInvoiced);
            if (this.p_z_retenue_garantie) {
                this.m_invoice.setC_DocTypeTarget_ID(1000045);
            }
            if (!this.m_invoice.save()) {
                throw new IllegalStateException("Could not create Invoice (s)");
            }
        }
        if (this.m_ship == null || this.m_ship.getM_InOut_ID() != ship.getM_InOut_ID()) {
            MDocType dt = MDocType.get(this.getCtx(), ship.getC_DocType_ID());
            if (this.m_bp == null || this.m_bp.getC_BPartner_ID() != ship.getC_BPartner_ID()) {
                this.m_bp = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), this.get_TrxName());
            }
            MClient client = MClient.get(this.getCtx(), order.getAD_Client_ID());
            String AD_Language = client.getAD_Language();
            if (client.isMultiLingualDocument() && this.m_bp.getAD_Language() != null) {
                AD_Language = this.m_bp.getAD_Language();
            }
            if (AD_Language == null) {
                AD_Language = Language.getBaseAD_Language();
            }
            SimpleDateFormat format = DisplayType.getDateFormat(15, Language.getLanguage(AD_Language));
            String reference = dt.getPrintName(this.m_bp.getAD_Language()) + ": " + ship.getDocumentNo() + " - " + format.format(ship.getMovementDate());
            this.m_ship = ship;
            MInvoiceLine line = new MInvoiceLine(this.m_invoice);
            line.setIsDescription(true);
            line.setDescription(reference);
            line.setLine(this.m_line + sLine.getLine() - 2);
            if (!line.save()) {
                throw new IllegalStateException("Could not create Invoice Comment Line (sh)");
            }
            if (order.getBill_Location_ID() != ship.getC_BPartner_Location_ID()) {
                MLocation addr = MLocation.getBPLocation(this.getCtx(), ship.getC_BPartner_Location_ID(), null);
                line = new MInvoiceLine(this.m_invoice);
                line.setIsDescription(true);
                line.setDescription(addr.toString());
                line.setLine(this.m_line + sLine.getLine() - 1);
                if (!line.save()) {
                    throw new IllegalStateException("Could not create Invoice Comment Line 2 (sh)");
                }
            }
        }
        MInvoiceLine line = new MInvoiceLine(this.m_invoice);
        line.setShipLine(sLine);
        if (sLine.sameOrderLineUOM()) {
            line.setQtyEntered(sLine.getQtyEntered());
        } else {
            line.setQtyEntered(sLine.getMovementQty());
        }
        line.setQtyInvoiced(sLine.getMovementQty());
        line.setLine(this.m_line + sLine.getLine());
        if (!line.save()) {
            throw new IllegalStateException("Could not create Invoice Line (s)");
        }
        sLine.setIsInvoiced(true);
        if (!sLine.save()) {
            throw new IllegalStateException("Could not update Shipment Line");
        }
        this.log.fine(line.toString());
    }

    private void completeInvoice() {
        if (this.m_invoice != null) {
            if (!this.m_invoice.processIt(this.p_docAction)) {
                this.log.warning("completeInvoice - failed: " + this.m_invoice);
                this.addLog("completeInvoice - failed: " + this.m_invoice);
            }
            this.m_invoice.save();
            this.addLog(this.m_invoice.getC_Invoice_ID(), this.m_invoice.getDateInvoiced(), null, this.m_invoice.getDocumentNo());
            ++this.m_created;
        }
        this.m_invoice = null;
        this.m_ship = null;
        this.m_line = 0;
    }
}

