/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MClient;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInventoryLineMA;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;

public class InventoryCountCreate
extends SvrProcess {
    private int p_M_Inventory_ID = 0;
    private MInventory m_inventory = null;
    private int p_M_Locator_ID = 0;
    private String p_LocatorValue = null;
    private String p_ProductValue = null;
    private int p_M_Product_Category_ID = 0;
    private String p_QtyRange = null;
    private boolean p_InventoryCountSetZero = false;
    private boolean p_DeleteOld = false;
    private int p_Z_Marque_ID = 0;
    private String isMarqueEnable = "";
    private MInventoryLine m_line = null;

    @Override
    protected void prepare() {
        this.isMarqueEnable = MSysConfig.getValue("SOGEXIS_MARQUE_FILTRE", "N", MClient.get(Env.getCtx()).get_ID());
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("M_Locator_ID")) {
                this.p_M_Locator_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("LocatorValue")) {
                this.p_LocatorValue = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("ProductValue")) {
                this.p_ProductValue = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("M_Product_Category_ID")) {
                this.p_M_Product_Category_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("QtyRange")) {
                this.p_QtyRange = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("InventoryCountSet")) {
                this.p_InventoryCountSetZero = "Z".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("DeleteOld")) {
                this.p_DeleteOld = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("z_marque_ID") && this.isMarqueEnable.equals("Y")) {
                this.p_Z_Marque_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_M_Inventory_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        CharSequence sql;
        this.log.info("M_Inventory_ID=" + this.p_M_Inventory_ID + ", M_Locator_ID=" + this.p_M_Locator_ID + ", LocatorValue=" + this.p_LocatorValue + ", ProductValue=" + this.p_ProductValue + ", M_Product_Category_ID=" + this.p_M_Product_Category_ID + ", QtyRange=" + this.p_QtyRange + ", DeleteOld=" + this.p_DeleteOld);
        this.m_inventory = new MInventory(this.getCtx(), this.p_M_Inventory_ID, this.get_TrxName());
        if (this.m_inventory.get_ID() == 0) {
            throw new AdempiereSystemError("Not found: M_Inventory_ID=" + this.p_M_Inventory_ID);
        }
        if (this.m_inventory.isProcessed()) {
            throw new AdempiereSystemError("@M_Inventory_ID@ @Processed@");
        }
        if (this.p_DeleteOld) {
            String sql1 = "DELETE FROM M_InventoryLineMA ma WHERE EXISTS (SELECT * FROM M_InventoryLine l WHERE l.M_InventoryLine_ID=ma.M_InventoryLine_ID AND Processed='N' AND M_Inventory_ID=" + this.p_M_Inventory_ID + ")";
            int no1 = DB.executeUpdate(sql1, this.get_TrxName());
            this.log.fine("doIt - Deleted MA #" + no1);
            String sql2 = "DELETE M_InventoryLine WHERE Processed='N' AND M_Inventory_ID=" + this.p_M_Inventory_ID;
            int no = DB.executeUpdate(sql2, this.get_TrxName());
            this.log.fine("doIt - Deleted #" + no);
        }
        if (this.p_QtyRange != null && this.p_QtyRange.equals("=")) {
            sql = "INSERT INTO M_Storage (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, QtyOnHand, QtyReserved, QtyOrdered, DateLastInventory) SELECT l.AD_CLIENT_ID, l.AD_ORG_ID, 'Y', SysDate, 0,SysDate, 0, l.M_Locator_ID, p.M_Product_ID, 0, 0,0,0,null FROM M_Locator l INNER JOIN M_Product p ON (l.AD_Client_ID=p.AD_Client_ID) WHERE l.M_Warehouse_ID=" + this.m_inventory.getM_Warehouse_ID();
            if (this.p_M_Locator_ID != 0) {
                sql = (String)sql + " AND l.M_Locator_ID=" + this.p_M_Locator_ID;
            }
            sql = (String)sql + " AND l.IsDefault='Y' AND p.IsActive='Y' AND p.IsStocked='Y' and p.ProductType='I' AND NOT EXISTS (SELECT * FROM M_Storage s INNER JOIN M_Locator sl ON (s.M_Locator_ID=sl.M_Locator_ID) WHERE sl.M_Warehouse_ID=l.M_Warehouse_ID AND s.M_Product_ID=p.M_Product_ID)";
            int no = DB.executeUpdate((String)sql, this.get_TrxName());
            this.log.fine("'0' Inserted #" + no);
        }
        sql = new StringBuffer("SELECT s.M_Product_ID, s.M_Locator_ID, s.M_AttributeSetInstance_ID, s.QtyOnHand, p.M_AttributeSet_ID FROM M_Product p INNER JOIN M_Storage s ON (s.M_Product_ID=p.M_Product_ID) INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) WHERE l.M_Warehouse_ID=? AND p.IsActive='Y' AND p.IsStocked='Y' and p.ProductType='I'");
        MClient mClient = new MClient(Env.getCtx(), Env.getAD_Client_ID(Env.getCtx()), null);
        String accesOrg = "";
        KeyNamePair clientKNPair = new KeyNamePair(mClient.get_ID(), mClient.getName());
        for (KeyNamePair orgKNPairs : this.getOrgs(clientKNPair, true)) {
            accesOrg = accesOrg + orgKNPairs.getKey() + ",";
        }
        accesOrg = accesOrg.substring(0, accesOrg.length() - 1);
        ((StringBuffer)sql).append(" AND p.AD_Org_ID IN (").append(accesOrg).append(")");
        if (this.p_M_Locator_ID != 0) {
            ((StringBuffer)sql).append(" AND s.M_Locator_ID=?");
        }
        if (this.p_LocatorValue != null && (this.p_LocatorValue.trim().length() == 0 || this.p_LocatorValue.equals("%"))) {
            this.p_LocatorValue = null;
        }
        if (this.p_LocatorValue != null) {
            ((StringBuffer)sql).append(" AND UPPER(l.Value) LIKE ?");
        }
        if (this.p_ProductValue != null && (this.p_ProductValue.trim().length() == 0 || this.p_ProductValue.equals("%"))) {
            this.p_ProductValue = null;
        }
        if (this.p_ProductValue != null) {
            ((StringBuffer)sql).append(" AND UPPER(p.Value) LIKE ?");
        }
        if (this.p_M_Product_Category_ID != 0) {
            ((StringBuffer)sql).append(" AND p.M_Product_Category_ID IN (" + this.getSubCategoryWhereClause(this.p_M_Product_Category_ID) + ")");
        }
        if (!this.p_DeleteOld) {
            ((StringBuffer)sql).append(" AND NOT EXISTS (SELECT * FROM M_InventoryLine il WHERE il.M_Inventory_ID=? AND il.M_Product_ID=s.M_Product_ID AND il.M_Locator_ID=s.M_Locator_ID AND COALESCE(il.M_AttributeSetInstance_ID,0)=COALESCE(s.M_AttributeSetInstance_ID,0))");
        }
        if (this.isMarqueEnable.equals("Y")) {
            ((StringBuffer)sql).append(" AND p.z_marque_id = ").append(this.p_Z_Marque_ID);
        }
        ((StringBuffer)sql).append(" ORDER BY l.Value, p.Value, s.QtyOnHand DESC");
        int count = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(((StringBuffer)sql).toString(), this.get_TrxName());
            int index = 1;
            pstmt.setInt(index++, this.m_inventory.getM_Warehouse_ID());
            if (this.p_M_Locator_ID != 0) {
                pstmt.setInt(index++, this.p_M_Locator_ID);
            }
            if (this.p_LocatorValue != null) {
                pstmt.setString(index++, this.p_LocatorValue.toUpperCase());
            }
            if (this.p_ProductValue != null) {
                pstmt.setString(index++, this.p_ProductValue.toUpperCase());
            }
            if (!this.p_DeleteOld) {
                pstmt.setInt(index++, this.p_M_Inventory_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int M_Product_ID = rs.getInt(1);
                int M_Locator_ID = rs.getInt(2);
                int M_AttributeSetInstance_ID = rs.getInt(3);
                BigDecimal QtyOnHand = rs.getBigDecimal(4);
                if (QtyOnHand == null) {
                    QtyOnHand = Env.ZERO;
                }
                int M_AttributeSet_ID = rs.getInt(5);
                int compare = QtyOnHand.compareTo(Env.ZERO);
                if (!(this.p_QtyRange == null || this.p_QtyRange.equals(">") && compare > 0 || this.p_QtyRange.equals("<") && compare < 0 || this.p_QtyRange.equals("=") && compare == 0 || this.p_QtyRange.equals("N") && compare != 0) && !this.p_QtyRange.equals("*")) continue;
                count += this.createInventoryLine(M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, QtyOnHand, M_AttributeSet_ID);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, ((StringBuffer)sql).toString(), e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (this.p_InventoryCountSetZero) {
            String sql1 = "UPDATE M_InventoryLine l SET QtyCount=0 WHERE M_Inventory_ID=" + this.p_M_Inventory_ID;
            int no = DB.executeUpdate(sql1, this.get_TrxName());
            this.log.info("Set Cont to Zero=" + no);
        }
        return "@M_InventoryLine_ID@ - #" + count;
    }

    private int createInventoryLine(int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal QtyOnHand, int M_AttributeSet_ID) {
        boolean oneLinePerASI = false;
        if (M_AttributeSet_ID != 0) {
            MAttributeSet mas = MAttributeSet.get(this.getCtx(), M_AttributeSet_ID);
            oneLinePerASI = mas.isInstanceAttribute();
        }
        if (oneLinePerASI) {
            MInventoryLine line = new MInventoryLine(this.m_inventory, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, QtyOnHand, QtyOnHand);
            if (line.save()) {
                return 1;
            }
            return 0;
        }
        if (QtyOnHand.signum() == 0) {
            M_AttributeSetInstance_ID = 0;
        }
        if (this.m_line != null && this.m_line.getM_Locator_ID() == M_Locator_ID && this.m_line.getM_Product_ID() == M_Product_ID) {
            MInventoryLineMA ma;
            if (QtyOnHand.signum() == 0) {
                return 0;
            }
            if (this.m_line.getM_AttributeSetInstance_ID() == M_AttributeSetInstance_ID) {
                this.m_line.setQtyBook(this.m_line.getQtyBook().add(QtyOnHand));
                this.m_line.setQtyCount(this.m_line.getQtyCount().add(QtyOnHand));
                this.m_line.save();
                return 0;
            }
            if (this.m_line.getM_AttributeSetInstance_ID() == 0 || !(ma = new MInventoryLineMA(this.m_line, this.m_line.getM_AttributeSetInstance_ID(), this.m_line.getQtyBook())).save()) {
                // empty if block
            }
            this.m_line.setM_AttributeSetInstance_ID(0);
            this.m_line.setQtyBook(this.m_line.getQtyBook().add(QtyOnHand));
            this.m_line.setQtyCount(this.m_line.getQtyCount().add(QtyOnHand));
            this.m_line.save();
            ma = new MInventoryLineMA(this.m_line, M_AttributeSetInstance_ID, QtyOnHand);
            if (!ma.save()) {
                // empty if block
            }
            return 0;
        }
        this.m_line = new MInventoryLine(this.m_inventory, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, QtyOnHand, QtyOnHand);
        if (this.m_line.save()) {
            return 1;
        }
        return 0;
    }

    private String getSubCategoryWhereClause(int productCategoryId) throws SQLException, AdempiereSystemError {
        int subTreeRootParentId = 0;
        String retString = " ";
        String sql = " SELECT M_Product_Category_ID, M_Product_Category_Parent_ID FROM M_Product_Category";
        Vector<SimpleTreeNode> categories = new Vector<SimpleTreeNode>(100);
        Statement stmt = DB.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            if (rs.getInt(1) == productCategoryId) {
                subTreeRootParentId = rs.getInt(2);
            }
            categories.add(new SimpleTreeNode(rs.getInt(1), rs.getInt(2)));
        }
        retString = retString + this.getSubCategoriesString(productCategoryId, categories, subTreeRootParentId);
        rs.close();
        stmt.close();
        return retString;
    }

    private String getSubCategoriesString(int productCategoryId, Vector<SimpleTreeNode> categories, int loopIndicatorId) throws AdempiereSystemError {
        String ret = "";
        for (SimpleTreeNode node : categories) {
            if (node.getParentId() != productCategoryId) continue;
            if (node.getNodeId() == loopIndicatorId) {
                throw new AdempiereSystemError("The product category tree contains a loop on categoryId: " + loopIndicatorId);
            }
            ret = ret + this.getSubCategoriesString(node.getNodeId(), categories, loopIndicatorId) + ",";
        }
        this.log.fine(ret);
        return ret + productCategoryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyNamePair[] getOrgs(KeyNamePair client, boolean withStar) {
        int AD_Role_ID = Env.getContextAsInt(Env.getCtx(), "#AD_Role_ID");
        int AD_User_ID = Env.getContextAsInt(Env.getCtx(), "#AD_User_ID");
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        KeyNamePair[] retValue = null;
        String sql = "SELECT o.AD_Org_ID,o.Name,o.IsSummary FROM AD_Role r, AD_Client c INNER JOIN AD_Org o ON (c.AD_Client_ID=o.AD_Client_ID OR o.AD_Org_ID=0) WHERE r.AD_Role_ID=? AND c.AD_Client_ID=? AND o.IsActive='Y' AND o.IsSummary='N' " + (withStar ? "" : " AND o.AD_Org_ID != 0 ") + " AND (r.IsAccessAllOrgs='Y' " + "OR (r.IsUseUserOrgAccess='N' AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_Role_OrgAccess ra " + "WHERE ra.AD_Role_ID=r.AD_Role_ID AND ra.IsActive='Y')) " + "OR (r.IsUseUserOrgAccess='Y' AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_User_OrgAccess ua " + "WHERE ua.AD_User_ID=? AND ua.IsActive='Y'))" + ") " + "ORDER BY o.Name";
        CPreparedStatement pstmt = null;
        MRole role = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Role_ID);
            pstmt.setInt(2, client.getKey());
            pstmt.setInt(3, AD_User_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int AD_Org_ID = rs.getInt(1);
                String Name2 = rs.getString(2);
                boolean summary = "Y".equals(rs.getString(3));
                if (summary) {
                    if (role != null) continue;
                    role = MRole.get(Env.getCtx(), AD_Role_ID);
                    continue;
                }
                KeyNamePair p2 = new KeyNamePair(AD_Org_ID, Name2);
                if (list.contains(p2)) continue;
                list.add(p2);
            }
            retValue = new KeyNamePair[list.size()];
            list.toArray(retValue);
            this.log.fine("Client: " + client.toStringX() + ", AD_Role_ID=" + AD_Role_ID + ", AD_User_ID=" + AD_User_ID + " - orgs #" + retValue.length);
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, ex);
            retValue = null;
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    private class SimpleTreeNode {
        private int nodeId;
        private int parentId;

        public SimpleTreeNode(int nodeId, int parentId) {
            this.nodeId = nodeId;
            this.parentId = parentId;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public int getParentId() {
            return this.parentId;
        }
    }
}

