/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MCost;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MProduct;
import org.compiere.model.X_I_Inventory;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class ImportInventory
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_M_Locator_ID = 0;
    private Timestamp p_MovementDate = null;
    private boolean p_DeleteOldImported = false;
    private boolean p_UpdateCosting = false;
    private int p_C_AcctSchema_ID = 0;
    MAcctSchema acctSchema = null;
    private int p_M_CostType_ID = 0;
    private int p_M_CostElement_ID = 0;
    private int p_AD_OrgTrx_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Client_ID")) {
                this.p_AD_Client_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_Locator_ID")) {
                this.p_M_Locator_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("MovementDate")) {
                this.p_MovementDate = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.p_DeleteOldImported = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("IsUpdateCosting")) {
                this.p_UpdateCosting = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_CostType_ID")) {
                this.p_M_CostType_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_CostElement_ID")) {
                this.p_M_CostElement_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_OrgTrx_ID")) {
                this.p_AD_OrgTrx_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("M_Locator_ID=" + this.p_M_Locator_ID + ",MovementDate=" + this.p_MovementDate);
        if (this.p_UpdateCosting) {
            if (this.p_C_AcctSchema_ID <= 0) {
                throw new IllegalArgumentException("Accounting Schema required!");
            }
            if (this.p_M_CostType_ID <= 0) {
                throw new IllegalArgumentException("Cost Type required!");
            }
            if (this.p_M_CostElement_ID <= 0) {
                throw new IllegalArgumentException("Cost Element required!");
            }
            if (this.p_AD_OrgTrx_ID < 0) {
                throw new IllegalArgumentException("AD_OrgTrx required!");
            }
            this.acctSchema = MAcctSchema.get(this.getCtx(), this.p_C_AcctSchema_ID, this.get_TrxName());
        }
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.p_AD_Client_ID;
        if (this.p_DeleteOldImported) {
            sql = new StringBuffer("DELETE I_Inventory WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Delete Old Imported=" + no);
        }
        sql = new StringBuffer("UPDATE I_Inventory SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.p_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID,").append(this.p_AD_Org_ID).append("),");
        if (this.p_MovementDate != null) {
            sql.append(" MovementDate = COALESCE (MovementDate,").append(DB.TO_DATE(this.p_MovementDate)).append("),");
        }
        sql.append(" IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', M_Warehouse_ID = NULL, I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.info("Reset=" + no);
        sql = new StringBuffer("UPDATE I_Inventory o SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, 'WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0 OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N'))) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Org=" + no);
        }
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Locator_ID=(SELECT MAX(M_Locator_ID) FROM M_Locator l WHERE i.LocatorValue=l.Value AND i.AD_Client_ID=l.AD_Client_ID) WHERE M_Locator_ID IS NULL AND LocatorValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Locator from Value =" + no);
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Locator_ID=(SELECT MAX(M_Locator_ID) FROM M_Locator l WHERE i.X=l.X AND i.Y=l.Y AND i.Z=l.Z AND i.AD_Client_ID=l.AD_Client_ID) WHERE M_Locator_ID IS NULL AND X IS NOT NULL AND Y IS NOT NULL AND Z IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Locator from X,Y,Z =" + no);
        if (this.p_M_Locator_ID != 0) {
            sql = new StringBuffer("UPDATE I_Inventory SET M_Locator_ID = ").append(this.p_M_Locator_ID).append(" WHERE M_Locator_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Set Locator from Parameter=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Location, ' WHERE M_Locator_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("No Location=" + no);
        }
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Warehouse_ID=(SELECT M_Warehouse_ID FROM M_Locator l WHERE i.M_Locator_ID=l.M_Locator_ID) WHERE M_Locator_ID IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Warehouse from Locator =" + no);
        sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Warehouse, ' WHERE M_Warehouse_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("No Warehouse=" + no);
        }
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE i.Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND Value IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Product from Value=" + no);
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Product_ID=COALESCE((SELECT MAX(M_Product_ID) FROM M_Product p WHERE i.UPC=p.UPC AND i.AD_Client_ID=p.AD_Client_ID), (SELECT MAX(M_Product_ID) FROM M_Product p WHERE  p.M_Product_ID IN (SELECT mpo.M_Product_ID FROM M_Product_PO mpo WHERE mpo.UPC LIKE '%' || i.UPC || '%') AND i.AD_Client_ID=p.AD_Client_ID)) WHERE M_Product_ID IS NULL AND UPC IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Product from UPC=" + no);
        sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Product, ' WHERE M_Product_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("No Product=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Qty Count, ' WHERE QtyCount IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("No QtyCount=" + no);
        }
        this.commitEx();
        MInventory inventory = null;
        int noInsert = 0;
        int noInsertLine = 0;
        sql = new StringBuffer("SELECT * FROM I_Inventory WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY M_Warehouse_ID, TRUNC(MovementDate, 'DD'), M_Product_ID, M_Locator_ID, I_Inventory_ID");
        BigDecimal qtyCounted = Env.ZERO;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            int x_M_Warehouse_ID = -1;
            Timestamp x_MovementDate = null;
            boolean tmp_M_Product_ID = false;
            boolean tmp_M_Locator_ID = false;
            ArrayList<X_I_Inventory> iInventories = new ArrayList<X_I_Inventory>();
            X_I_Inventory imp = null;
            X_I_Inventory imp2 = null;
            while (rs.next()) {
                iInventories.add(new X_I_Inventory(this.getCtx(), rs, this.get_TrxName()));
            }
            for (int i2 = 0; i2 < iInventories.size(); ++i2) {
                MInventoryLine line;
                MProduct product;
                if (imp == null) {
                    imp = (X_I_Inventory)iInventories.get(i2);
                }
                imp2 = null;
                if (i2 + 1 < iInventories.size()) {
                    imp2 = (X_I_Inventory)iInventories.get(i2 + 1);
                }
                if (imp2 != null && imp.getM_Product_ID() == imp2.getM_Product_ID() && imp.getM_Locator_ID() == imp2.getM_Locator_ID()) {
                    imp.setQtyCount(imp.getQtyCount().add(imp2.getQtyCount()));
                    imp.saveEx();
                    qtyCounted = qtyCounted.add(Env.ONE);
                    imp2.setProcessed(true);
                    imp2.setDescription(imp2.getDescription() != null ? imp2.getDescription() + "// Fusionn\u00e9e \u00e0 " + imp.get_ID() : "// Fusionn\u00e9e \u00e0 " + imp.get_ID());
                    imp2.save();
                    continue;
                }
                Timestamp MovementDate = TimeUtil.getDay(imp.getMovementDate());
                if (inventory == null || imp.getM_Warehouse_ID() != x_M_Warehouse_ID || !MovementDate.equals(x_MovementDate)) {
                    inventory = new MInventory(this.getCtx(), 0, this.get_TrxName());
                    inventory.setClientOrg(imp.getAD_Client_ID(), imp.getAD_Org_ID());
                    inventory.setDescription("I " + imp.getM_Warehouse_ID() + " " + MovementDate);
                    inventory.setM_Warehouse_ID(imp.getM_Warehouse_ID());
                    inventory.setMovementDate(MovementDate);
                    if (!inventory.save()) {
                        this.log.log(Level.SEVERE, "Inventory not saved");
                        break;
                    }
                    inventory.load(this.get_TrxName());
                    x_M_Warehouse_ID = imp.getM_Warehouse_ID();
                    x_MovementDate = MovementDate;
                    ++noInsert;
                }
                int M_AttributeSetInstance_ID = 0;
                if ((imp.getLot() != null && imp.getLot().length() > 0 || imp.getSerNo() != null && imp.getSerNo().length() > 0) && (product = MProduct.get(this.getCtx(), imp.getM_Product_ID())).isInstanceAttribute()) {
                    MAttributeSet mas = product.getAttributeSet();
                    MAttributeSetInstance masi = new MAttributeSetInstance(this.getCtx(), 0, mas.getM_AttributeSet_ID(), this.get_TrxName());
                    if (mas.isLot() && imp.getLot() != null) {
                        masi.setLot(imp.getLot(), imp.getM_Product_ID());
                    }
                    if (mas.isSerNo() && imp.getSerNo() != null) {
                        masi.setSerNo(imp.getSerNo());
                    }
                    masi.setDescription();
                    masi.save();
                    M_AttributeSetInstance_ID = masi.getM_AttributeSetInstance_ID();
                }
                if ((line = new MInventoryLine(inventory, imp.getM_Locator_ID(), imp.getM_Product_ID(), M_AttributeSetInstance_ID, imp.getQtyBook(), imp.getQtyCount())).save()) {
                    imp.setI_IsImported(true);
                    imp.setM_Inventory_ID(line.getM_Inventory_ID());
                    imp.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                    imp.setProcessed(true);
                    if (imp.save()) {
                        ++noInsertLine;
                        if (this.p_UpdateCosting) {
                            MCost cost = MCost.get(MProduct.get(this.getCtx(), imp.getM_Product_ID()), 0, this.acctSchema, this.p_AD_OrgTrx_ID, this.p_M_CostElement_ID, this.get_TrxName());
                            cost.setCurrentCostPrice(imp.getCurrentCostPrice());
                            if (!cost.save()) {
                                this.log.log(Level.SEVERE, "Cost not saved!");
                                break;
                            }
                        }
                    }
                }
                imp = null;
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@M_Inventory_ID@: @Inserted@(Avec " + qtyCounted + " doublon(s))");
        this.addLog(0, null, new BigDecimal(noInsertLine), "@M_InventoryLine_ID@: @Inserted@");
        this.addLog(0, null, qtyCounted, " nombre de ligne(s) fusionn\u00e9e(s) ( " + new BigDecimal(no).subtract(qtyCounted) + " vrai erreurs)");
        return "";
    }
}

