/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.adempiere.process.ImportProcess;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MLocation;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.X_I_BPartner;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ImportBPartnerSogexis
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean m_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private Timestamp m_DateValue = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i2].getParameterAsBoolean();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.m_deleteOldImported) {
            sql = new StringBuffer("DELETE I_BPartner WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_BPartner SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID, 0), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Reset=" + no);
        ModelValidationEngine.get().fireImportValidate(this, null, null, 10);
        sql = new StringBuffer("UPDATE I_BPartner i SET GroupValue=(SELECT MAX(Value) FROM C_BP_Group g WHERE g.IsDefault='Y' AND g.AD_Client_ID=i.AD_Client_ID) ");
        sql.append("WHERE GroupValue IS NULL AND C_BP_Group_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Group Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_BP_Group_ID=(SELECT C_BP_Group_ID FROM C_BP_Group g WHERE i.GroupValue=g.Value AND g.AD_Client_ID=i.AD_Client_ID) WHERE C_BP_Group_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Group=" + no);
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Group, ' WHERE C_BP_Group_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.config("Invalid Group=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_Country_ID=(SELECT C_Country_ID FROM C_Country c WHERE i.CountryCode=c.CountryCode AND c.AD_Client_ID IN (0, i.AD_Client_ID)) WHERE C_Country_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Country=" + no);
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Country, ' WHERE C_Country_ID IS NULL AND (City IS NOT NULL OR Address1 IS NOT NULL) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.config("Invalid Country=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i Set RegionName=(SELECT MAX(Name) FROM C_Region r WHERE r.IsDefault='Y' AND r.C_Country_ID=i.C_Country_ID AND r.AD_Client_ID IN (0, i.AD_Client_ID)) ");
        sql.append("WHERE RegionName IS NULL AND C_Region_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Region Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i Set C_Region_ID=(SELECT C_Region_ID FROM C_Region r WHERE r.Name=i.RegionName AND r.C_Country_ID=i.C_Country_ID AND r.AD_Client_ID IN (0, i.AD_Client_ID)) WHERE C_Region_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Region=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Region, ' WHERE C_Region_ID IS NULL  AND EXISTS (SELECT * FROM C_Country c WHERE c.C_Country_ID=i.C_Country_ID AND c.HasRegion='Y') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.config("Invalid Region=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_Greeting_ID=(SELECT C_Greeting_ID FROM C_Greeting g WHERE i.BPContactGreeting=g.Name AND g.AD_Client_ID IN (0, i.AD_Client_ID)) WHERE C_Greeting_ID IS NULL AND BPContactGreeting IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Greeting=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Greeting, ' WHERE C_Greeting_ID IS NULL AND BPContactGreeting IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.config("Invalid Greeting=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_BPartner_ID=(SELECT C_BPartner_ID FROM AD_User u WHERE i.EMail=u.EMail AND u.AD_Client_ID=i.AD_Client_ID) WHERE i.EMail IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Found EMail User=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET AD_User_ID=(SELECT AD_User_ID FROM AD_User u WHERE i.EMail=u.EMail AND u.AD_Client_ID=i.AD_Client_ID) WHERE i.EMail IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Found EMail User=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p WHERE i.Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND Value IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Found BPartner=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET AD_User_ID=(SELECT AD_User_ID FROM AD_User c WHERE i.ContactName=c.Name AND i.C_BPartner_ID=c.C_BPartner_ID AND c.AD_Client_ID=i.AD_Client_ID) WHERE C_BPartner_ID IS NOT NULL AND AD_User_ID IS NULL AND ContactName IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Found Contact=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_BPartner_Location_ID=(SELECT C_BPartner_Location_ID FROM C_BPartner_Location bpl INNER JOIN C_Location l ON (bpl.C_Location_ID=l.C_Location_ID) WHERE i.C_BPartner_ID=bpl.C_BPartner_ID AND bpl.AD_Client_ID=i.AD_Client_ID AND (i.Address1=l.Address1 OR (i.Address1 IS NULL AND l.Address1 IS NULL)) AND (i.Address2=l.Address2 OR (i.Address2 IS NULL AND l.Address2 IS NULL)) AND (i.City=l.City OR (i.City IS NULL AND l.City IS NULL)) AND (i.Postal=l.Postal OR (i.Postal IS NULL AND l.Postal IS NULL)) AND (i.Postal_Add=l.Postal_Add OR (l.Postal_Add IS NULL AND l.Postal_Add IS NULL)) AND i.C_Region_ID=l.C_Region_ID AND i.C_Country_ID=l.C_Country_ID) WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL AND I_IsImported='N'").append(clientCheck);
        this.log.fine("Found Location=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET R_InterestArea_ID=(SELECT R_InterestArea_ID FROM R_InterestArea ia WHERE i.InterestAreaName=ia.Name AND ia.AD_Client_ID=i.AD_Client_ID) WHERE R_InterestArea_ID IS NULL AND InterestAreaName IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Interest Area=" + no);
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Value is mandatory, ' WHERE Value IS NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.config("Value is mandatory=" + no);
        ModelValidationEngine.get().fireImportValidate(this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        int noInsert = 0;
        int noUpdate = 0;
        sql = new StringBuffer("SELECT * FROM I_BPartner WHERE I_IsImported='N'").append(clientCheck);
        sql.append(" ORDER BY Value, I_BPartner_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            rs = pstmt.executeQuery();
            String Old_BPValue = "";
            MBPartner bp = null;
            MBPartnerLocation bpl = null;
            while (rs.next()) {
                X_I_BPartner impBP;
                block40: {
                    block42: {
                        block43: {
                            block41: {
                                block39: {
                                    String customImport;
                                    String New_BPValue = rs.getString("Value");
                                    impBP = new X_I_BPartner(this.getCtx(), rs, this.get_TrxName());
                                    this.log.fine("I_BPartner_ID=" + impBP.getI_BPartner_ID() + ", C_BPartner_ID=" + impBP.getC_BPartner_ID() + ", C_BPartner_Location_ID=" + impBP.getC_BPartner_Location_ID() + ", AD_User_ID=" + impBP.getAD_User_ID());
                                    if (New_BPValue.equals(Old_BPValue)) break block40;
                                    bp = null;
                                    if (impBP.getC_BPartner_ID() == 0) {
                                        bp = new MBPartner(impBP);
                                        ModelValidationEngine.get().fireImportValidate(this, impBP, bp, 40);
                                        this.setTypeOfBPartner(impBP, bp);
                                        customImport = MSysConfig.getValue("SOGEXIS_IMPORT_CUSTOM", "N", MClient.get(Env.getCtx()).get_ID());
                                        if (customImport.equals("CBL")) {
                                            System.out.println(impBP.getValue());
                                            if (impBP.get_ValueAsBoolean("IsSalesRep")) {
                                                bp.setIsSalesRep(true);
                                            }
                                            if ((BigDecimal)impBP.get_Value("SO_CreditLimit") != null) {
                                                bp.setSO_CreditLimit((BigDecimal)impBP.get_Value("SO_CreditLimit"));
                                            }
                                            if (impBP.get_ValueAsInt("C_PaymentTerm_ID") != 0) {
                                                bp.setC_PaymentTerm_ID((Integer)impBP.get_Value("C_PaymentTerm_ID"));
                                            }
                                            if (impBP.get_ValueAsInt("PO_PaymentTerm_ID") != 0) {
                                                bp.setPO_PaymentTerm_ID((Integer)impBP.get_Value("PO_PaymentTerm_ID"));
                                            }
                                            if (impBP.get_ValueAsInt("M_PriceList_ID") != 0) {
                                                bp.setM_PriceList_ID((Integer)impBP.get_Value("M_PriceList_ID"));
                                            }
                                            if (impBP.get_ValueAsInt("PO_PriceList_ID") != 0) {
                                                bp.setPO_PriceList_ID((Integer)impBP.get_Value("PO_PriceList_ID"));
                                            }
                                            if (impBP.get_ValueAsString("PaymentRule") != null && !impBP.get_ValueAsString("PaymentRule").isEmpty()) {
                                                bp.setPaymentRule(impBP.get_ValueAsString("PaymentRule"));
                                            }
                                            if (impBP.get_ValueAsString("SOCreditStatus") != null && !impBP.get_ValueAsString("SOCreditStatus").isEmpty()) {
                                                bp.setSOCreditStatus(impBP.get_ValueAsString("SOCreditStatus"));
                                            }
                                        }
                                        if (bp.save()) {
                                            impBP.setC_BPartner_ID(bp.getC_BPartner_ID());
                                            this.log.finest("Insert BPartner - " + bp.getC_BPartner_ID());
                                            ++noInsert;
                                            break block39;
                                        } else {
                                            sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert BPartner, ' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                                            DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                                            continue;
                                        }
                                    }
                                    bp = new MBPartner(this.getCtx(), impBP.getC_BPartner_ID(), this.get_TrxName());
                                    if (impBP.getName() != null) {
                                        bp.setName(impBP.getName());
                                        bp.setName2(impBP.getName2());
                                    }
                                    if (impBP.getDUNS() != null) {
                                        bp.setDUNS(impBP.getDUNS());
                                    }
                                    if (impBP.getTaxID() != null) {
                                        bp.setTaxID(impBP.getTaxID());
                                    }
                                    if (impBP.getNAICS() != null) {
                                        bp.setNAICS(impBP.getNAICS());
                                    }
                                    if (impBP.getDescription() != null) {
                                        bp.setDescription(impBP.getDescription());
                                    }
                                    if (impBP.getC_BP_Group_ID() != 0) {
                                        bp.setC_BP_Group_ID(impBP.getC_BP_Group_ID());
                                    }
                                    if ((customImport = MSysConfig.getValue("SOGEXIS_IMPORT_CUSTOM", "N", MClient.get(Env.getCtx()).get_ID())).equals("CBL")) {
                                        System.out.println(impBP.getValue());
                                        if (impBP.get_ValueAsBoolean("IsSalesRep")) {
                                            bp.setIsSalesRep(true);
                                        }
                                        if ((BigDecimal)impBP.get_Value("SO_CreditLimit") != null) {
                                            bp.setSO_CreditLimit((BigDecimal)impBP.get_Value("SO_CreditLimit"));
                                        }
                                        if (impBP.get_ValueAsInt("C_PaymentTerm_ID") != 0) {
                                            bp.setC_PaymentTerm_ID((Integer)impBP.get_Value("C_PaymentTerm_ID"));
                                        }
                                        if (impBP.get_ValueAsInt("PO_PaymentTerm_ID") != 0) {
                                            bp.setPO_PaymentTerm_ID((Integer)impBP.get_Value("PO_PaymentTerm_ID"));
                                        }
                                        if (impBP.get_ValueAsInt("M_PriceList_ID") != 0) {
                                            bp.setM_PriceList_ID((Integer)impBP.get_Value("M_PriceList_ID"));
                                        }
                                        if (impBP.get_ValueAsInt("PO_PriceList_ID") != 0) {
                                            bp.setPO_PriceList_ID((Integer)impBP.get_Value("PO_PriceList_ID"));
                                        }
                                        if (impBP.get_ValueAsString("PaymentRule") != null && !impBP.get_ValueAsString("PaymentRule").isEmpty()) {
                                            bp.setPaymentRule(impBP.get_ValueAsString("PaymentRule"));
                                        }
                                        if (impBP.get_ValueAsString("SOCreditStatus") != null && !impBP.get_ValueAsString("SOCreditStatus").isEmpty()) {
                                            bp.setSOCreditStatus(impBP.get_ValueAsString("SOCreditStatus"));
                                        }
                                    }
                                    ModelValidationEngine.get().fireImportValidate(this, impBP, bp, 40);
                                    this.setTypeOfBPartner(impBP, bp);
                                    if (bp.save()) {
                                        this.log.finest("Update BPartner - " + bp.getC_BPartner_ID());
                                        ++noUpdate;
                                    } else {
                                        sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Update BPartner, ' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                                        DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                                        continue;
                                    }
                                }
                                bpl = null;
                                if (impBP.getC_Country_ID() == 0 || impBP.getAddress1() == null || impBP.getCity() == null) break block40;
                                MLocation location = new MLocation(this.getCtx(), impBP.getC_Country_ID(), impBP.getC_Region_ID(), impBP.getCity(), this.get_TrxName());
                                location.setAddress1(impBP.getAddress1());
                                location.setAddress2(impBP.getAddress2());
                                location.setAddress3(impBP.get_ValueAsString("Address3"));
                                location.setAddress4(impBP.get_ValueAsString("Address4"));
                                location.setPostal(impBP.getPostal());
                                location.setPostal_Add(impBP.getPostal_Add());
                                if (!location.save()) break block41;
                                this.log.finest("Insert Location - " + location.getC_Location_ID());
                                bpl = new MBPartnerLocation(bp);
                                bpl.setC_Location_ID(location.getC_Location_ID());
                                bpl.setPhone(impBP.getPhone());
                                bpl.setPhone2(impBP.getPhone2());
                                String customImport = MSysConfig.getValue("SOGEXIS_IMPORT_CUSTOM", "N", MClient.get(Env.getCtx()).get_ID());
                                if (!customImport.equals("CBL")) break block42;
                                break block43;
                            }
                            this.rollback();
                            --noInsert;
                            sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert Location, ' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                            DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                            continue;
                        }
                        bpl.setIsBillTo(impBP.get_ValueAsBoolean("isBillto"));
                        bpl.setIsShipTo(impBP.get_ValueAsBoolean("isShipto"));
                        bpl.setIsRemitTo(impBP.get_ValueAsBoolean("isRemitto"));
                        bpl.setIsPayFrom(impBP.get_ValueAsBoolean("IsPayFrom"));
                        bpl.setName(impBP.get_ValueAsString("Z_Adresse"));
                    }
                    if (impBP.getEMail() != null) {
                        bpl.setISDN(impBP.getEMail());
                    }
                    bpl.setFax(impBP.getFax());
                    ModelValidationEngine.get().fireImportValidate(this, impBP, bpl, 40);
                    if (bpl.save()) {
                        this.log.finest("Insert BP Location - " + bpl.getC_BPartner_Location_ID());
                        impBP.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                    } else {
                        this.rollback();
                        --noInsert;
                        sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert BPLocation, ' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                        DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                        continue;
                    }
                }
                Object user = null;
                if (impBP.getAD_User_ID() == 0 && (impBP.getContactName() != null || impBP.getEMail() != null)) continue;
                impBP.setI_IsImported(true);
                impBP.setProcessed(true);
                impBP.setProcessing(false);
                impBP.saveEx();
                this.commitEx();
            }
            DB.close(rs, pstmt);
        }
        catch (SQLException e) {
            try {
                this.rollback();
                throw new DBException(e, sql.toString());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='N', Updated=current_date WHERE I_IsImported<>'Y'").append(clientCheck);
                no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                this.addLog(0, null, new BigDecimal(no), "@Errors@");
                this.addLog(0, null, new BigDecimal(noInsert), "@C_BPartner_ID@: @Inserted@");
                this.addLog(0, null, new BigDecimal(noUpdate), "@C_BPartner_ID@: @Updated@");
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='N', Updated=current_date WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_BPartner_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdate), "@C_BPartner_ID@: @Updated@");
        return "";
    }

    @Override
    public String getWhereClause() {
        return " AND AD_Client_ID=" + this.m_AD_Client_ID;
    }

    @Override
    public String getImportTableName() {
        return "I_BPartner";
    }

    private void setTypeOfBPartner(X_I_BPartner impBP, MBPartner bp) {
        if (impBP.isVendor()) {
            bp.setIsVendor(true);
            bp.setIsCustomer(false);
        }
        if (impBP.isEmployee()) {
            bp.setIsEmployee(true);
            bp.setIsCustomer(false);
        }
        if (impBP.isCustomer()) {
            bp.setIsCustomer(true);
        }
    }
}

