/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MQuery;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class CopyOrderSogexis
extends SvrProcess {
    private int p_C_Order_ID = 0;
    private int p_C_DocType_ID = 0;
    private Timestamp p_DateDoc = null;
    private Timestamp p_DatePromised = null;
    private boolean p_IsCloseDocument = false;
    private String p_DocStatus = "CO";
    private String p_DocAction = "RE";
    private MOrder newOrder;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_Order_ID")) {
                this.p_C_Order_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_DocType_ID")) {
                this.p_C_DocType_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("DateDoc")) {
                this.p_DateDoc = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("DatePromised")) {
                this.p_DatePromised = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("IsCloseDocument")) {
                this.p_IsCloseDocument = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.conversionCompleteAEnCours(this.p_C_Order_ID);
        this.log.info("C_Order_ID=" + this.p_C_Order_ID + ", C_DocType_ID=" + this.p_C_DocType_ID + ", CloseDocument=" + this.p_IsCloseDocument);
        if (this.p_C_Order_ID == 0) {
            throw new IllegalArgumentException("No Order");
        }
        MDocType dt = MDocType.get(this.getCtx(), this.p_C_DocType_ID);
        if (dt.get_ID() == 0) {
            throw new IllegalArgumentException("No DocType");
        }
        if (this.p_DateDoc == null) {
            this.p_DateDoc = new Timestamp(System.currentTimeMillis());
        }
        MOrder from = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
        this.newOrder = MOrder.copyFrom(from, this.p_DateDoc, dt.getC_DocType_ID(), dt.isSOTrx(), false, true, this.get_TrxName(), this.p_DatePromised);
        this.newOrder.setC_DocTypeTarget_ID(this.p_C_DocType_ID);
        this.newOrder.set_ValueOfColumn("Z_OrderRef", (Object)new BigDecimal(this.p_C_Order_ID));
        boolean OK = this.newOrder.save();
        if (!OK) {
            throw new IllegalStateException("Could not create new Order");
        }
        MBPartner mBPartner = (MBPartner)this.newOrder.getC_BPartner();
        mBPartner.setIsCustomer(true);
        mBPartner.setIsProspect(false);
        mBPartner.set_ValueOfColumn("Z_IsLead", (Object)false);
        mBPartner.save();
        MOrder original = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
        original.setDocAction("CO");
        String descTempo = original.getDescription();
        if (descTempo != null) {
            original.setDescription(descTempo + " / A g\u00e9n\u00e9r\u00e9 la commande: " + this.newOrder.getDocumentNo());
        } else {
            original.setDescription(" / A g\u00e9n\u00e9r\u00e9 la commande: " + this.newOrder.getDocumentNo());
        }
        original.set_ValueOfColumn("Z_OrderRef", (Object)new BigDecimal(this.newOrder.getC_Order_ID()));
        original.processIt("CO");
        original.save();
        original.setDocAction("CL");
        original.processIt("CL");
        original.save();
        if (this.p_IsCloseDocument) {
            this.newOrder.setDocAction("CO");
            this.newOrder.processIt("CO");
            this.newOrder.save();
        }
        return dt.getName() + ": " + this.newOrder.getDocumentNo();
    }

    @Override
    protected void postProcess(boolean success) {
        if (success) {
            MQuery query = new MQuery("c_order");
            query.addRestriction(" c_order_id =" + this.newOrder.get_ID());
        }
    }

    private void conversionCompleteAEnCours(int p_C_Order_ID2) {
        MOrder OrdreAConvertir = new MOrder(this.getCtx(), p_C_Order_ID2, null);
        String docstatus = OrdreAConvertir.getDocStatus();
        System.out.println(docstatus);
        if (docstatus.contains(this.p_DocStatus)) {
            this.process(OrdreAConvertir);
            System.out.println("change complete => reserved");
        }
    }

    private void process(MOrder ordreAConvertir) {
        ordreAConvertir.setDocAction(this.p_DocAction);
        if (ordreAConvertir.processIt(this.p_DocAction)) {
            ordreAConvertir.save();
        }
    }
}

