/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerInfo;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCurrency;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MUser;
import org.compiere.pos.PosBasePanel;
import org.compiere.pos.PosOrderModel;
import org.compiere.pos.PosPayment;
import org.compiere.pos.PosSubPanel;
import org.compiere.pos.QueryBPartner;
import org.compiere.pos.QueryTicket;
import org.compiere.print.ReportCtl;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class SubOrder
extends PosSubPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 5895558315889871887L;
    private CButton f_history;
    private CTextField f_name;
    private CButton f_bNew;
    private CButton f_bSearch;
    private CComboBox f_location;
    private CComboBox f_user;
    private CButton f_cashPayment;
    private CButton f_process;
    private CButton f_print;
    private CTextField f_DocumentNo;
    private CButton f_logout;
    private JFormattedTextField f_net;
    private JFormattedTextField f_tax;
    private JFormattedTextField f_total;
    private CTextField f_RepName;
    private MBPartner m_bpartner;
    private int m_M_PriceList_Version_ID = 0;
    private CTextField f_currency = new CTextField();
    private CButton f_bEdit;
    private CButton f_bSettings;
    private static CLogger log = CLogger.getCLogger(SubOrder.class);

    public SubOrder(PosBasePanel posPanel) {
        super(posPanel);
    }

    @Override
    public void init() {
        MigLayout layout = new MigLayout("ins 0 0", "[fill|fill|fill|fill]", "[nogrid]unrel[||]");
        this.setLayout((LayoutManager)layout);
        Font bigFont = AdempierePLAF.getFont_Field().deriveFont(16.0f);
        String buttonSize = "w 50!, h 50!,";
        this.f_bNew = this.createButtonAction("New", KeyStroke.getKeyStroke(113, 1009));
        this.add((Component)this.f_bNew, buttonSize);
        this.f_bEdit = this.createButtonAction("Edit", null);
        this.add((Component)this.f_bEdit, buttonSize);
        this.f_bEdit.setEnabled(false);
        this.f_history = this.createButtonAction("History", null);
        this.add((Component)this.f_history, buttonSize);
        this.f_process = this.createButtonAction("Cancel", null);
        this.add((Component)this.f_process, buttonSize);
        this.f_process.setEnabled(false);
        this.f_cashPayment = this.createButtonAction("Payment", null);
        this.f_cashPayment.setActionCommand("Cash");
        this.add((Component)this.f_cashPayment, buttonSize);
        this.f_cashPayment.setEnabled(false);
        this.f_print = this.createButtonAction("Print", null);
        this.add((Component)this.f_print, buttonSize);
        this.f_print.setEnabled(false);
        this.f_bSettings = this.createButtonAction("Preference", null);
        this.add((Component)this.f_bSettings, buttonSize);
        this.f_logout = this.createButtonAction("Logout", null);
        this.add((Component)this.f_logout, buttonSize + ", gapx 25, wrap");
        this.add((Component)new CLabel(Msg.getMsg(Env.getCtx(), "DocumentNo")), "");
        this.f_DocumentNo = new CTextField("");
        this.f_DocumentNo.setName("DocumentNo");
        this.f_DocumentNo.setEditable(false);
        this.add((Component)this.f_DocumentNo, "growx, pushx");
        CLabel lNet = new CLabel(Msg.translate(Env.getCtx(), "SubTotal"));
        this.add((Component)lNet, "");
        this.f_net = new JFormattedTextField(DisplayType.getNumberFormat(12));
        this.f_net.setHorizontalAlignment(11);
        this.f_net.setEditable(false);
        this.f_net.setFocusable(false);
        lNet.setLabelFor(this.f_net);
        this.add((Component)this.f_net, "wrap, growx, pushx");
        this.f_net.setValue(Env.ZERO);
        this.add((Component)new CLabel(Msg.translate(Env.getCtx(), "SalesRep_ID")), "");
        this.f_RepName = new CTextField("");
        this.f_RepName.setName("SalesRep");
        this.f_RepName.setEditable(false);
        this.add((Component)this.f_RepName, "growx, pushx");
        CLabel lTax = new CLabel(Msg.translate(Env.getCtx(), "TaxAmt"));
        this.add(lTax);
        this.f_tax = new JFormattedTextField(DisplayType.getNumberFormat(12));
        this.f_tax.setHorizontalAlignment(11);
        this.f_tax.setEditable(false);
        this.f_tax.setFocusable(false);
        lTax.setLabelFor(this.f_tax);
        this.add((Component)this.f_tax, "wrap, growx, pushx");
        this.f_tax.setValue(Env.ZERO);
        this.add((Component)new CLabel(Msg.translate(Env.getCtx(), "C_BPartner_ID")), "");
        this.f_name = new CTextField();
        this.f_name.setEditable(false);
        this.f_name.setName("Name");
        this.add((Component)this.f_name, "growx, pushx");
        CLabel lTotal = new CLabel(Msg.translate(Env.getCtx(), "GrandTotal"));
        lTotal.setFont(bigFont);
        this.add((Component)lTotal, "");
        this.f_total = new JFormattedTextField(DisplayType.getNumberFormat(12));
        this.f_total.setHorizontalAlignment(11);
        this.f_total.setFont(bigFont);
        this.f_total.setEditable(false);
        this.f_total.setFocusable(false);
        lTotal.setLabelFor(this.f_total);
        this.add((Component)this.f_total, "growx, pushx");
        this.f_total.setValue(Env.ZERO);
    }

    @Override
    public void dispose() {
        if (this.f_name != null) {
            this.f_name.removeFocusListener(this);
        }
        this.f_name = null;
        this.removeAll();
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("PosSubCustomer - actionPerformed: " + action);
        if (action.equals("New")) {
            this.p_posPanel.newOrder();
            return;
        }
        if (action.equals("History")) {
            QueryTicket qt = new QueryTicket(this.p_posPanel);
            qt.setVisible(true);
            return;
        }
        if (action.equals("Cancel")) {
            this.deleteOrder();
        } else if (action.equals("Cash")) {
            this.payOrder();
        } else if (action.equals("Print")) {
            this.printOrder();
        } else if (action.equals("BPartner")) {
            QueryBPartner qt = new QueryBPartner(this.p_posPanel);
            qt.setVisible(true);
        } else {
            if (action.equals("Logout")) {
                this.p_posPanel.dispose();
                return;
            }
            if (e.getSource() == this.f_name) {
                this.findBPartner();
            }
        }
        this.p_posPanel.updateInfo();
    }

    private void printOrder() {
        if (this.isOrderFullyPaid()) {
            this.updateOrder();
            this.printTicket();
            this.openCashDrawer();
        }
    }

    private void payOrder() {
        if (this.p_posPanel.m_order != null) {
            if (!this.p_posPanel.m_order.isProcessed() && !this.p_posPanel.m_order.processOrder()) {
                ADialog.warn(0, this.p_posPanel, "PosOrderProcessFailed");
                return;
            }
            if (PosPayment.pay(this.p_posPanel)) {
                this.printTicket();
                this.p_posPanel.setOrder(0);
            }
        }
    }

    private void deleteOrder() {
        if (this.p_posPanel != null && ADialog.ask(0, this, "Delete order?")) {
            this.p_posPanel.m_order.deleteOrder();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        log.info(e.toString());
        this.findBPartner();
    }

    private void findBPartner() {
        String query = this.f_name.getText();
        if (query == null || query.length() == 0) {
            return;
        }
        if (this.m_bpartner != null && this.m_bpartner.getName().equals(query)) {
            return;
        }
        query = query.toUpperCase();
        boolean allNumber = true;
        boolean noNumber = true;
        char[] qq = query.toCharArray();
        for (int i2 = 0; i2 < qq.length; ++i2) {
            if (!Character.isDigit(qq[i2])) continue;
            noNumber = false;
            break;
        }
        try {
            Integer.parseInt(query);
        }
        catch (Exception e) {
            allNumber = false;
        }
        String Value = query;
        String Name2 = allNumber ? null : query;
        String EMail2 = query.indexOf(64) != -1 ? query : null;
        String Phone = noNumber ? null : query;
        String City = null;
        MBPartnerInfo[] results = MBPartnerInfo.find(this.p_ctx, Value, Name2, null, EMail2, Phone, City);
        if (results.length == 0) {
            this.setC_BPartner_ID(0);
        } else if (results.length == 1) {
            this.setC_BPartner_ID(results[0].getC_BPartner_ID());
            this.f_name.setText(results[0].getName());
        } else {
            QueryBPartner qt = new QueryBPartner(this.p_posPanel);
            qt.setResults(results);
            qt.setVisible(true);
        }
    }

    public void setC_BPartner_ID(int C_BPartner_ID) {
        log.fine("PosSubCustomer.setC_BPartner_ID=" + C_BPartner_ID);
        if (C_BPartner_ID == 0) {
            this.m_bpartner = null;
        } else {
            this.m_bpartner = new MBPartner(this.p_ctx, C_BPartner_ID, null);
            if (this.m_bpartner.get_ID() == 0) {
                this.m_bpartner = null;
            }
        }
        if (this.m_bpartner != null) {
            this.f_name.setText(this.m_bpartner.getName());
        } else {
            this.f_name.setText(null);
        }
        this.m_M_PriceList_Version_ID = 0;
        this.getM_PriceList_Version_ID();
        if (this.p_posPanel.m_order != null && this.m_bpartner != null) {
            this.p_posPanel.m_order.setBPartner(this.m_bpartner);
        }
    }

    private void fillCombos() {
        Vector<KeyNamePair> locationVector = new Vector<KeyNamePair>();
        if (this.m_bpartner != null) {
            MBPartnerLocation[] locations = this.m_bpartner.getLocations(false);
            for (int i2 = 0; i2 < locations.length; ++i2) {
                locationVector.add(locations[i2].getKeyNamePair());
            }
        }
        DefaultComboBoxModel locationModel = new DefaultComboBoxModel(locationVector);
        this.f_location.setModel(locationModel);
        Vector<KeyNamePair> userVector = new Vector<KeyNamePair>();
        if (this.m_bpartner != null) {
            MUser[] users = this.m_bpartner.getContacts(false);
            for (int i3 = 0; i3 < users.length; ++i3) {
                userVector.add(users[i3].getKeyNamePair());
            }
        }
        DefaultComboBoxModel userModel = new DefaultComboBoxModel(userVector);
        this.f_user.setModel(userModel);
    }

    public int getC_BPartner_ID() {
        if (this.m_bpartner != null) {
            return this.m_bpartner.getC_BPartner_ID();
        }
        return 0;
    }

    public MBPartner getBPartner() {
        return this.m_bpartner;
    }

    public int getC_BPartner_Location_ID() {
        KeyNamePair pp;
        if (this.m_bpartner != null && (pp = (KeyNamePair)this.f_location.getSelectedItem()) != null) {
            return pp.getKey();
        }
        return 0;
    }

    public int getAD_User_ID() {
        KeyNamePair pp;
        if (this.m_bpartner != null && (pp = (KeyNamePair)this.f_user.getSelectedItem()) != null) {
            return pp.getKey();
        }
        return 0;
    }

    public int getM_PriceList_Version_ID() {
        if (this.m_M_PriceList_Version_ID == 0) {
            int M_PriceList_ID = this.p_pos.getM_PriceList_ID();
            if (this.m_bpartner != null && this.m_bpartner.getM_PriceList_ID() != 0) {
                M_PriceList_ID = this.m_bpartner.getM_PriceList_ID();
            }
            MPriceList pl = MPriceList.get(this.p_ctx, M_PriceList_ID, null);
            this.setCurrency(MCurrency.getISO_Code(this.p_ctx, pl.getC_Currency_ID()));
            this.f_name.setToolTipText(pl.getName());
            MPriceListVersion plv = pl.getPriceListVersion(this.p_posPanel.getToday());
            if (plv != null && plv.getM_PriceList_Version_ID() != 0) {
                this.m_M_PriceList_Version_ID = plv.getM_PriceList_Version_ID();
            }
        }
        return this.m_M_PriceList_Version_ID;
    }

    public void setCurrency(String currency) {
        if (currency == null) {
            this.f_currency.setText("---");
        } else {
            this.f_currency.setText(currency);
        }
    }

    public void printTicket() {
        if (this.p_posPanel.m_order == null) {
            return;
        }
        PosOrderModel order = this.p_posPanel.m_order;
        if (order != null) {
            try {
                ReportCtl.startDocumentPrint(0, order.getC_Order_ID(), null, Env.getWindowNo(this), true);
            }
            catch (Exception e) {
                log.severe("PrintTicket - Error Printing Ticket");
            }
        }
    }

    public boolean isOrderFullyPaid() {
        return true;
    }

    public void updateOrder() {
        if (this.p_posPanel != null) {
            PosOrderModel order = this.p_posPanel.m_order;
            if (order != null) {
                this.f_DocumentNo.setText(order.getDocumentNo());
                this.setC_BPartner_ID(order.getC_BPartner_ID());
                this.f_bNew.setEnabled(order.getLines().length != 0);
                this.f_bEdit.setEnabled(true);
                this.f_history.setEnabled(order.getLines().length != 0);
                this.f_process.setEnabled(true);
                this.f_print.setEnabled(order.isProcessed());
                this.f_cashPayment.setEnabled(order.getLines().length != 0);
            } else {
                this.f_DocumentNo.setText(null);
                this.setC_BPartner_ID(0);
                this.f_bNew.setEnabled(true);
                this.f_bEdit.setEnabled(false);
                this.f_history.setEnabled(true);
                this.f_process.setEnabled(false);
                this.f_print.setEnabled(false);
                this.f_cashPayment.setEnabled(false);
            }
        }
    }

    public void openCashDrawer() {
        String port = "/dev/lp";
        byte[] data = new byte[]{27, 64, 28};
        try {
            FileOutputStream m_out = null;
            if (m_out == null) {
                m_out = new FileOutputStream(port);
            }
            m_out.write(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void setSums(PosOrderModel order) {
        int noLines = this.p_posPanel.f_curLine.m_table.getRowCount();
        if (order == null || noLines == 0) {
            this.f_net.setValue(Env.ZERO);
            this.f_total.setValue(Env.ZERO);
            this.f_tax.setValue(Env.ZERO);
        } else {
            this.f_net.setValue(order.getSubtotal());
            this.f_total.setValue(order.getGrandTotal());
            this.f_tax.setValue(order.getTaxAmt());
        }
    }
}

