/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MWarehousePrice;
import org.compiere.pos.PosBasePanel;
import org.compiere.pos.PosQuery;
import org.compiere.pos.PosTable;
import org.compiere.pos.PosTextField;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class QueryProduct
extends PosQuery {
    private static final long serialVersionUID = 9172276999827406833L;
    private PosTextField f_value;
    private PosTextField f_name;
    private PosTextField f_upc;
    private PosTextField f_sku;
    private int m_M_Product_ID;
    private String m_ProductName;
    private BigDecimal m_Price;
    private int m_M_PriceList_Version_ID;
    private int m_M_Warehouse_ID;
    private CButton f_refresh;
    private CButton f_ok;
    private CButton f_cancel;
    private static CLogger log = CLogger.getCLogger(QueryProduct.class);
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "M_Product_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Value"), "Value", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "Name", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "UPC"), "UPC", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "SKU"), "SKU", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyAvailable"), "QtyAvailable", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyOnHand"), "QtyOnHand", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "PriceStd"), "PriceStd", BigDecimal.class)};
    private static String s_sqlFrom = "RV_WarehousePrice";
    private static String s_sqlWhere = "IsActive='Y'";

    public QueryProduct(PosBasePanel posPanel) {
        super(posPanel);
    }

    @Override
    protected void init() {
        CPanel panel = new CPanel();
        panel.setLayout((LayoutManager)new MigLayout("fill"));
        this.getContentPane().add(panel);
        this.northPanel = new CPanel((LayoutManager)new MigLayout("fill", "", "[50][50][]"));
        panel.add((Component)this.northPanel, "north");
        this.northPanel.setBorder(new TitledBorder(Msg.getMsg(this.p_ctx, "Query")));
        CLabel lvalue = new CLabel(Msg.translate(this.p_ctx, "Value"));
        this.northPanel.add((Component)lvalue, "growy");
        this.f_value = new PosTextField("", this.p_posPanel, this.p_pos.getOSK_KeyLayout_ID());
        lvalue.setLabelFor(this.f_value);
        this.northPanel.add((Component)this.f_value, "h 30, w 200");
        this.f_value.addActionListener(this);
        CLabel lupc = new CLabel(Msg.translate(this.p_ctx, "UPC"));
        this.northPanel.add((Component)lupc, "growy");
        this.f_upc = new PosTextField("", this.p_posPanel, this.p_pos.getOSK_KeyLayout_ID());
        lupc.setLabelFor(this.f_upc);
        this.northPanel.add((Component)this.f_upc, "h 30, w 200, wrap");
        this.f_upc.addActionListener(this);
        CLabel lname = new CLabel(Msg.translate(this.p_ctx, "Name"));
        this.northPanel.add((Component)lname, "growy");
        this.f_name = new PosTextField("", this.p_posPanel, this.p_pos.getOSK_KeyLayout_ID());
        lname.setLabelFor(this.f_name);
        this.northPanel.add((Component)this.f_name, "h 30, w 200");
        this.f_name.addActionListener(this);
        CLabel lsku = new CLabel(Msg.translate(this.p_ctx, "SKU"));
        this.northPanel.add((Component)lsku, "growy");
        this.f_sku = new PosTextField("", this.p_posPanel, this.p_pos.getOSK_KeyLayout_ID());
        lsku.setLabelFor(this.f_sku);
        this.northPanel.add((Component)this.f_sku, "h 30, w 200");
        this.f_sku.addActionListener(this);
        this.f_refresh = this.createButtonAction("Refresh", KeyStroke.getKeyStroke(116, 0));
        this.northPanel.add((Component)this.f_refresh, "w 50!, h 50!, wrap, alignx trailing");
        this.f_up = this.createButtonAction("Previous", KeyStroke.getKeyStroke(38, 0));
        this.northPanel.add((Component)this.f_up, "w 50!, h 50!, span, split 4");
        this.f_down = this.createButtonAction("Next", KeyStroke.getKeyStroke(40, 0));
        this.northPanel.add((Component)this.f_down, "w 50!, h 50!");
        this.f_ok = this.createButtonAction("Ok", KeyStroke.getKeyStroke(10, 0));
        this.northPanel.add((Component)this.f_ok, "w 50!, h 50!");
        this.f_cancel = this.createButtonAction("Cancel", KeyStroke.getKeyStroke(27, 0));
        this.northPanel.add((Component)this.f_cancel, "w 50!, h 50!");
        this.m_table = new PosTable();
        String sql = this.m_table.prepareTable(s_layout, s_sqlFrom, s_sqlWhere, false, "RV_WarehousePrice") + " ORDER BY Margin, QtyAvailable";
        this.m_table.addMouseListener(this);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.setColumnVisibility(this.m_table.getColumn(0), false);
        this.m_table.getColumn(1).setPreferredWidth(175);
        this.m_table.getColumn(2).setPreferredWidth(175);
        this.m_table.getColumn(3).setPreferredWidth(100);
        this.m_table.getColumn(4).setPreferredWidth(75);
        this.m_table.getColumn(5).setPreferredWidth(75);
        this.m_table.getColumn(6).setPreferredWidth(75);
        this.m_table.getColumn(7).setPreferredWidth(75);
        this.enableButtons();
        this.m_table.setFillsViewportHeight(true);
        this.m_table.growScrollbars();
        this.centerScroll = new CScrollPane(this.m_table);
        panel.add((Component)this.centerScroll, "growx, growy,south");
        panel.setPreferredSize(new Dimension(800, 600));
        this.f_value.requestFocus();
    }

    public void setQueryData(int M_PriceList_Version_ID, int M_Warehouse_ID) {
        this.m_M_PriceList_Version_ID = M_PriceList_Version_ID;
        this.m_M_Warehouse_ID = M_Warehouse_ID;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info(e.getActionCommand());
        if ("Refresh".equals(e.getActionCommand()) || e.getSource() == this.f_value || e.getSource() == this.f_upc || e.getSource() == this.f_name || e.getSource() == this.f_sku) {
            this.setResults(MWarehousePrice.find(this.p_ctx, this.m_M_PriceList_Version_ID, this.m_M_Warehouse_ID, this.f_value.getText(), this.f_name.getText(), this.f_upc.getText(), this.f_sku.getText(), null));
            return;
        }
        if ("Reset".equals(e.getActionCommand())) {
            this.reset();
            return;
        }
        if ("Previous".equalsIgnoreCase(e.getActionCommand())) {
            int rows = this.m_table.getRowCount();
            if (rows == 0) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (--row < 0) {
                row = 0;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(row, 1, true));
            return;
        }
        if ("Next".equalsIgnoreCase(e.getActionCommand())) {
            int rows = this.m_table.getRowCount();
            if (rows == 0) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (++row >= rows) {
                row = rows - 1;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(row, 1, true));
            return;
        }
        this.close();
    }

    public void setResults(MWarehousePrice[] results) {
        this.m_table.loadTable(results);
        if (this.m_table.getRowCount() > 0) {
            this.m_table.setRowSelectionInterval(0, 0);
        }
        this.enableButtons();
    }

    @Override
    protected void enableButtons() {
        Integer ID;
        boolean enabled;
        this.m_M_Product_ID = -1;
        this.m_ProductName = null;
        this.m_Price = null;
        int row = this.m_table.getSelectedRow();
        boolean bl = enabled = row != -1;
        if (enabled && (ID = this.m_table.getSelectedRowKey()) != null) {
            this.m_M_Product_ID = ID;
            this.m_ProductName = (String)this.m_table.getValueAt(row, 2);
            this.m_Price = (BigDecimal)this.m_table.getValueAt(row, 7);
        }
        this.f_ok.setEnabled(enabled);
        log.fine("M_Product_ID=" + this.m_M_Product_ID + " - " + this.m_ProductName + " - " + this.m_Price);
    }

    @Override
    protected void close() {
        log.fine("M_Product_ID=" + this.m_M_Product_ID);
        if (this.m_M_Product_ID > 0) {
            this.p_posPanel.f_curLine.setM_Product_ID(this.m_M_Product_ID);
            this.p_posPanel.f_curLine.setPrice(this.m_Price);
        } else {
            this.p_posPanel.f_curLine.setM_Product_ID(0);
            this.p_posPanel.f_curLine.setPrice(Env.ZERO);
        }
        this.dispose();
    }

    @Override
    public void reset() {
        this.f_value.setText(null);
        this.f_name.setText(null);
        this.f_sku.setText(null);
        this.f_upc.setText(null);
        this.setResults(new MWarehousePrice[0]);
    }
}

