/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model.cbl;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import org.compiere.model.MRecurring;
import org.compiere.util.DB;

public class YRecurring
extends MRecurring {
    private static final long serialVersionUID = 6425565848410647110L;
    public static final String FREQUENCYTYPE_SemiMonthly = "B";
    public static final String FREQUENCYTYPE_HalfYearly = "H";
    public static final String FREQUENCYTYPE_Yearly = "Y";
    public static final String ASSET_TYPE_ENTRETIEN_ID = "6";

    public YRecurring(Properties ctx, int C_Recurring_ID, String trxName) {
        super(ctx, C_Recurring_ID, trxName);
    }

    public YRecurring(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord) {
            super.setRunsRemaining(super.getRunsMax());
        }
        return super.beforeSave(newRecord);
    }

    public boolean calculateRuns() {
        String sql = "SELECT COUNT(*) FROM C_Recurring_Run WHERE C_Recurring_ID=?";
        int current = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Recurring_ID());
        int remaining = this.getRunsMax() - current;
        this.setRunsRemaining(remaining);
        this.save();
        return remaining > 0;
    }

    public Timestamp calculateDate(int indice) {
        if (this.getFrequency() < 1) {
            this.setFrequency(1);
        }
        int frequency = this.getFrequency();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getDateNextRun());
        if (this.getFrequencyType().equals("D")) {
            cal.add(6, frequency * indice);
        } else if (this.getFrequencyType().equals("W")) {
            cal.add(3, frequency * indice);
        } else if (this.getFrequencyType().equals("M")) {
            cal.add(2, frequency * indice);
        } else if (this.getFrequencyType().equals("Q")) {
            cal.add(2, 3 * frequency * indice);
        } else if (this.getFrequencyType().equals(FREQUENCYTYPE_SemiMonthly)) {
            cal.add(2, 2 * frequency * indice);
        } else if (this.getFrequencyType().equals(FREQUENCYTYPE_HalfYearly)) {
            cal.add(2, 6 * frequency * indice);
        } else if (this.getFrequencyType().equals(FREQUENCYTYPE_Yearly)) {
            cal.add(2, 12 * frequency * indice);
        }
        if (this.getFrequencyType().equals("M") || this.getFrequencyType().equals("Q") || this.getFrequencyType().equals(FREQUENCYTYPE_SemiMonthly) || this.getFrequencyType().equals(FREQUENCYTYPE_HalfYearly) || this.getFrequencyType().equals(FREQUENCYTYPE_Yearly)) {
            int maxDay = cal.getActualMaximum(5);
            int day = cal.get(5);
            if (day < maxDay) {
                cal.set(5, cal.getActualMaximum(5));
            }
            if (indice != 1) {
                cal.add(6, 1);
            }
        }
        Timestamp next = new Timestamp(cal.getTimeInMillis());
        return next;
    }

    public int getRunsNbr() {
        int nbr = 0;
        String sql = "SELECT COUNT(*) FROM C_Recurring_Run WHERE C_Recurring_ID=?";
        int current = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Recurring_ID());
        if (current != -1) {
            nbr = current;
        }
        return nbr;
    }
}

