/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model.cbl;

import java.math.BigDecimal;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.util.Env;

public class CalloutOrderCBL
extends CalloutEngine {
    private static int DOCTYPE_BL_NON_FACTURABLE = 1000032;
    private static int DOCTYPE_BT_NON_FACTURABLE = 1000081;
    private static int DOCTYPE_BL_FACTURABLE = 1000087;
    private static int DOCTYPE_BT_FACTURABLE = 1000086;
    private static int PRICELIST_ID_NON_FACTURABLE = 1000048;

    public String setDocTypeFromAsset(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer M_PriceList_ID = (Integer)mTab.getValue("M_PriceList_ID");
        if (M_PriceList_ID == null || M_PriceList_ID <= 0) {
            return "";
        }
        if (M_PriceList_ID == PRICELIST_ID_NON_FACTURABLE) {
            mTab.fireDataStatusEEvent("Attention au type de document.\nVeuillez indiquer si vous souhaitez r\u00e9aliser un BT (Non Facturable) ou un BL (Non Facturable).", "", false);
        } else {
            mTab.fireDataStatusEEvent("Attention au type de document.\nVeuillez indiquer si vous souhaitez r\u00e9aliser un BT (Facturable) ou un BL (Facturable).", "", false);
        }
        this.checkLineFromDocType(ctx, WindowNo, mTab, mField, value, oldValue);
        return "";
    }

    public String checkLineFromDocType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        if (this.isCalloutActive() || value == null) {
            mTab.setValue("Z_Conflic", (Object)false);
            return "";
        }
        Integer C_DocTypeTarget_ID = (Integer)mTab.getValue("C_DocTypeTarget_ID");
        Integer M_PriceList_ID = (Integer)mTab.getValue("M_PriceList_ID");
        Integer C_Order_ID = (Integer)mTab.getValue("C_Order_ID");
        if (C_DocTypeTarget_ID == null || C_DocTypeTarget_ID <= 0) {
            mTab.setValue("Z_Conflic", (Object)false);
            return "";
        }
        if (M_PriceList_ID == null || M_PriceList_ID <= 0) {
            mTab.setValue("Z_Conflic", (Object)false);
            return "";
        }
        String message = "";
        if (M_PriceList_ID == PRICELIST_ID_NON_FACTURABLE && (C_DocTypeTarget_ID == DOCTYPE_BL_FACTURABLE || C_DocTypeTarget_ID == DOCTYPE_BT_FACTURABLE)) {
            if (StringUtils.isEmpty((String)message)) {
                message = "Le type de document cible et la liste de prix ne sont pas comptabiles : <br/> - Type de document <span style=\"color:red;\">" + (C_DocTypeTarget_ID == DOCTYPE_BL_FACTURABLE ? "BL (Facturable)" : "BT (Facturable) ") + "</span> <br/> " + "- Liste de prix <span style=\"color:red;\">Non Facturable</span> <br/><br/>";
            }
            if (C_Order_ID == null || C_Order_ID <= 0) {
                mTab.setValue("Z_Conflic", (Object)true);
                mTab.fireDataStatusEEvent(message, "", false);
                return "";
            }
            MOrder mOrder = new MOrder(Env.getCtx(), C_Order_ID, null);
            for (MOrderLine mOrderLine : mOrder.getLines(true, "")) {
                if (mOrderLine.getPriceEntered() == null || mOrderLine.getPriceEntered().signum() == 0) continue;
                message = message + "Ligne " + mOrderLine.getLine() + " - " + (mOrderLine.getM_Product_ID() == 0 ? mOrderLine.getDescription() : mOrderLine.getM_Product().getValue() + " - " + mOrderLine.getM_Product().getName()) + " ( " + mOrderLine.getPriceEntered().setScale(2, 4) + " )<br/>";
            }
        } else {
            if (M_PriceList_ID != PRICELIST_ID_NON_FACTURABLE && (C_DocTypeTarget_ID == DOCTYPE_BL_FACTURABLE || C_DocTypeTarget_ID == DOCTYPE_BT_FACTURABLE)) {
                if (C_Order_ID == null || C_Order_ID <= 0) {
                    mTab.setValue("Z_Conflic", (Object)false);
                    return "";
                }
                MOrder mOrder = new MOrder(Env.getCtx(), C_Order_ID, null);
                for (MOrderLine mOrderLine : mOrder.getLines(true, "")) {
                    if (mOrderLine.getPriceEntered() == null || mOrderLine.getPriceEntered().signum() != 0) continue;
                    if (StringUtils.isEmpty((String)message)) {
                        message = "Des lignes de la commande n'ont pas de prix alors que vous \u00eates dans un context <span style=\"color:red;\">Facturable</span><br/><br/>";
                    }
                    message = message + "Ligne " + mOrderLine.getLine() + " : " + (mOrderLine.getM_Product_ID() == 0 ? mOrderLine.getDescription() : mOrderLine.getM_Product().getValue() + " - " + mOrderLine.getM_Product().getName()) + " ( " + mOrderLine.getPriceEntered().setScale(2, 4) + " )<br/>";
                }
                if (!StringUtils.isEmpty((String)message)) {
                    mTab.fireDataStatusEEvent(message, "", false);
                }
                mTab.setValue("Z_Conflic", (Object)false);
                return "";
            }
            if (M_PriceList_ID == PRICELIST_ID_NON_FACTURABLE && (C_DocTypeTarget_ID == DOCTYPE_BL_NON_FACTURABLE || C_DocTypeTarget_ID == DOCTYPE_BT_NON_FACTURABLE)) {
                if (C_Order_ID == null || C_Order_ID <= 0) {
                    mTab.setValue("Z_Conflic", (Object)false);
                    return "";
                }
                MOrder mOrder = new MOrder(Env.getCtx(), C_Order_ID, null);
                for (MOrderLine mOrderLine : mOrder.getLines(true, "")) {
                    if (mOrderLine.getPriceEntered() == null || mOrderLine.getPriceEntered().signum() == 0) continue;
                    if (StringUtils.isEmpty((String)message)) {
                        message = "Des lignes de la commande ont un prix alors que vous \u00eates dans un context <span style=\"color:red;\">Non Facturable</span><br/><br/>";
                    }
                    message = message + "Ligne " + mOrderLine.getLine() + " - " + (mOrderLine.getM_Product_ID() == 0 ? mOrderLine.getDescription() : mOrderLine.getM_Product().getValue() + " - " + mOrderLine.getM_Product().getName()) + " ( " + mOrderLine.getPriceEntered().setScale(2, 4) + " )<br/>";
                }
            } else if (M_PriceList_ID != PRICELIST_ID_NON_FACTURABLE && (C_DocTypeTarget_ID == DOCTYPE_BL_NON_FACTURABLE || C_DocTypeTarget_ID == DOCTYPE_BT_NON_FACTURABLE)) {
                if (StringUtils.isEmpty((String)message)) {
                    message = "Le type de document cible et la liste de prix ne sont pas comptabiles : <br/> - Type de document <span style=\"color:red;\">" + (C_DocTypeTarget_ID == DOCTYPE_BL_FACTURABLE ? "BL (Non Facturable)" : "BT (Non Facturable) ") + "</span> <br/> " + "- Liste de prix <span style=\"color:red;\">Facturable</span> <br/><br/>";
                }
                if (C_Order_ID == null || C_Order_ID <= 0) {
                    mTab.setValue("Z_Conflic", (Object)true);
                    mTab.fireDataStatusEEvent(message, "", false);
                    return "";
                }
                MOrder mOrder = new MOrder(Env.getCtx(), C_Order_ID, null);
                for (MOrderLine mOrderLine : mOrder.getLines(true, "")) {
                    if (mOrderLine.getPriceEntered() == null || mOrderLine.getPriceEntered().signum() != 0) continue;
                    message = message + "Ligne " + mOrderLine.getLine() + " : " + (mOrderLine.getM_Product_ID() == 0 ? mOrderLine.getDescription() : mOrderLine.getM_Product().getValue() + " - " + mOrderLine.getM_Product().getName()) + " ( " + mOrderLine.getPriceEntered().setScale(2, 4) + " )<br/>";
                }
            }
        }
        if (!StringUtils.isEmpty((String)message)) {
            mTab.setValue("Z_Conflic", (Object)true);
            mTab.fireDataStatusEEvent(message, "", false);
            return "";
        }
        mTab.setValue("Z_Conflic", (Object)false);
        return "";
    }

    public String checkPrice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer C_Order_ID = (Integer)mTab.getValue("C_Order_ID");
        MOrder mOrder = new MOrder(ctx, C_Order_ID, null);
        if (!mOrder.isSOTrx()) {
            return "";
        }
        Integer M_PriceList_ID = mOrder.getM_PriceList_ID();
        BigDecimal priceEntered = (BigDecimal)mTab.getValue("PriceEntered");
        if (M_PriceList_ID == PRICELIST_ID_NON_FACTURABLE && priceEntered != null && priceEntered.signum() != 0) {
            mTab.fireDataStatusEEvent("Vous \u00eates sur la liste de prix <span style=\"color:red;\">Non Facturable</span>.<br/>Le prix de l'article doit \u00eatre 0 \u20ac", "", false);
            mTab.setValue("PriceEntered", (Object)Env.ZERO);
        }
        return "";
    }
}

