/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MField;
import org.compiere.model.MWindow;
import org.compiere.model.X_AD_Tab;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MTab
extends X_AD_Tab {
    private static final long serialVersionUID = 4946144044358216142L;
    private MField[] m_fields = null;
    private static CLogger s_log = CLogger.getCLogger(MTab.class);

    public MTab(Properties ctx, int AD_Tab_ID, String trxName) {
        super(ctx, AD_Tab_ID, trxName);
        if (AD_Tab_ID == 0) {
            this.setEntityType("U");
            this.setHasTree(false);
            this.setIsReadOnly(false);
            this.setIsSingleRow(false);
            this.setIsSortTab(false);
            this.setIsTranslationTab(false);
            this.setSeqNo(0);
            this.setTabLevel(0);
            this.setIsInsertRecord(true);
            this.setIsAdvancedTab(false);
        }
    }

    public MTab(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTab(MWindow parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Window_ID(parent.getAD_Window_ID());
        this.setEntityType(parent.getEntityType());
    }

    public MTab(MWindow parent, MTab from) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        MTab.copyValues(from, this);
        this.setClientOrg(parent);
        this.setAD_Window_ID(parent.getAD_Window_ID());
        this.setEntityType(parent.getEntityType());
    }

    public MField[] getFields(boolean reload, String trxName) {
        if (this.m_fields != null && !reload) {
            return this.m_fields;
        }
        String sql = "SELECT * FROM AD_Field WHERE AD_Tab_ID=? ORDER BY SeqNo";
        ArrayList<MField> list = new ArrayList<MField>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, this.getAD_Tab_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MField(this.getCtx(), rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_fields = new MField[list.size()];
        list.toArray(this.m_fields);
        return this.m_fields;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isReadOnly() && this.isInsertRecord()) {
            this.setIsInsertRecord(false);
        }
        if (this.isSortTab() && this.getAD_ColumnSortOrder_ID() == 0) {
            throw new FillMandatoryException(new String[]{"AD_ColumnSortOrder_ID"});
        }
        return true;
    }

    public static int getTab_ID(int AD_Window_ID, String TabName) {
        int retValue = 0;
        String SQL = "SELECT AD_Tab_ID FROM AD_Tab WHERE AD_Window_ID= ?  AND Name = ?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, AD_Window_ID);
            pstmt.setString(2, TabName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, SQL, e);
            retValue = -1;
        }
        return retValue;
    }
}

