/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.Query;
import org.compiere.model.X_Z_OrderTransport;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MOrderTransport
extends X_Z_OrderTransport {
    private static final long serialVersionUID = 5113229835193479301L;

    public MOrderTransport(Properties ctx, int Z_OrderTransport_ID, String trxName) {
        super(ctx, Z_OrderTransport_ID, trxName);
        if (Z_OrderTransport_ID == 0) {
            this.setDocStatus("IP");
            this.setDocAction("CO");
        }
    }

    public MOrderTransport(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeDelete() {
        if (this.getDocStatus().equals("CO")) {
            throw new AdempiereException("Impossible de supprimer un document valid\u00e9.");
        }
        DB.executeUpdate("UPDATE C_Order SET Z_OrderTransport_ID = null WHERE Z_OrderTransport_ID = " + this.get_ID(), null);
        DB.executeUpdate("UPDATE C_Invoice SET Z_OrderTransport_ID = null WHERE Z_OrderTransport_ID = " + this.get_ID(), null);
        return super.beforeDelete();
    }

    public String completeIt() {
        List mInvoices = new Query(this.getCtx(), "C_Invoice", " Z_OrderTransport_ID = ? AND C_Order_ID IS NOT NULL AND DocStatus = 'CO' AND isActive = 'Y'", null).setClient_ID().setOnlyActiveRecords(true).setParameters(this.getZ_OrderTransport_ID()).list();
        for (MInvoice mInvoice : mInvoices) {
            System.out.println(mInvoice.get_ID());
            for (MInvoiceLine mInvoiceLine : mInvoice.getLines()) {
                if (mInvoiceLine.getM_Product_ID() == 0 || !mInvoiceLine.getM_Product().getProductType().equals("I")) continue;
                mInvoiceLine.set_Value("z_fraisapproche", this.get_Value("Z_FraisApprocheUsed"));
                mInvoiceLine.saveEx();
                if (mInvoiceLine.getM_InOutLine_ID() == 0) continue;
                BigDecimal qtyOnHand = this.getQtyOnHand(mInvoiceLine.getM_Product_ID(), DB.getSQLValueTS(null, "SELECT MAX(movementDate) FROM M_InOut WHERE DocStatus = 'CO' AND isSoTrx = 'N' AND M_InOut_ID IN (SELECT M_InOut_ID FROM M_InOutline WHERE C_OrderLine_ID = " + mInvoiceLine.getC_OrderLine_ID() + ")", new Object[0]));
                BigDecimal actualPrice = this.getActualPrice(mInvoiceLine.getM_Product_ID());
                if (actualPrice == null) {
                    actualPrice = Env.ZERO;
                }
                BigDecimal tmp1 = qtyOnHand.multiply(actualPrice);
                BigDecimal tmp2 = mInvoiceLine.getQtyInvoiced().multiply(mInvoiceLine.getPriceEntered().multiply((BigDecimal)this.get_Value("Z_FraisApprocheUsed")));
                BigDecimal tmp3 = tmp1.add(tmp2);
                BigDecimal tmp4 = qtyOnHand.add(mInvoiceLine.getQtyInvoiced());
                BigDecimal finalPrice = tmp3.divide(tmp4, 2, RoundingMode.HALF_UP);
                System.out.println(mInvoiceLine.getM_Product_ID() + " " + mInvoiceLine.getM_Product().getName() + " " + mInvoiceLine.getQtyInvoiced() + " : " + actualPrice + " - " + finalPrice + " \u20ac : " + mInvoiceLine.getQtyInvoiced() + " - " + qtyOnHand);
                DB.executeUpdate("UPDATE M_ProductPrice SET priceLimit = " + finalPrice + " WHERE M_Product_ID = " + mInvoiceLine.getM_Product_ID() + " AND isActive = 'Y'", null);
            }
        }
        return "CO";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getQtyOnHand(Integer M_Product_ID, Timestamp dateReceived) {
        BigDecimal qtyOnHand = Env.ZERO;
        String sql = "SELECT COALESCE(sum(MovementQty),0)  FROM M_Transaction  WHERE M_Product_ID = ?  AND MovementDate < ?  AND isActive = ? ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setTimestamp(2, dateReceived);
            pstmt.setString(3, "Y");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                qtyOnHand = qtyOnHand.add(rs.getBigDecimal(1));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "Erreur : " + sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (qtyOnHand.compareTo(Env.ZERO) <= 0) {
            qtyOnHand = Env.ZERO;
        }
        return qtyOnHand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getActualPrice(Integer M_Product_ID) {
        ResultSet rs;
        CPreparedStatement pstmt;
        BigDecimal priceActual;
        block4: {
            BigDecimal bigDecimal;
            priceActual = Env.ZERO;
            String sql = " SELECT MAX(priceLimit) as one  FROM M_ProductPrice mpp LEFT JOIN M_PriceList_Version mplv ON mplv.M_PriceList_Version_ID = mpp.M_PriceList_Version_ID LEFT JOIN M_PriceList mpl ON mpl.M_PriceList_ID = mplv.M_PriceList_ID  WHERE mpl.issopricelist = 'N'  AND mpl.isActive = 'Y'  AND mplv.isActive = 'Y'  AND mpp.isActive = 'Y'  AND mpp.M_Product_ID = ? ";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, M_Product_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                bigDecimal = rs.getBigDecimal(1);
            }
            catch (SQLException e) {
                try {
                    this.log.log(Level.SEVERE, "Erreur : " + sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return bigDecimal;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return priceActual;
    }
}

