/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.BPartnerNoBillToAddressException;
import org.adempiere.exceptions.BPartnerNoShipToAddressException;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocator;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MRefList;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MStorage;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_DocType;
import org.compiere.model.X_C_Order;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class MOrder
extends X_C_Order
implements DocAction {
    private static final long serialVersionUID = -1575104995897726572L;
    private MOrderLine[] m_lines = null;
    private MOrderTax[] m_taxes = null;
    private boolean m_forceCreation = false;
    public static final String DocSubTypeSO_Standard = "SO";
    public static final String DocSubTypeSO_Quotation = "OB";
    public static final String DocSubTypeSO_Proposal = "ON";
    public static final String DocSubTypeSO_Prepay = "PR";
    public static final String DocSubTypeSO_POS = "WR";
    public static final String DocSubTypeSO_Warehouse = "WP";
    public static final String DocSubTypeSO_OnCredit = "WI";
    public static final String DocSubTypeSO_RMA = "RM";
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MOrder copyFrom(MOrder from, Timestamp dateDoc, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, boolean copyASI, String trxName, Timestamp datePromised) {
        MOrder to = new MOrder(from.getCtx(), 0, trxName);
        to.set_TrxName(trxName);
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("C_Order_ID", I_ZERO);
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(0);
        to.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        to.setIsSOTrx(isSOTrx);
        to.setIsSelected(false);
        to.setDateOrdered(dateDoc);
        to.setDateAcct(dateDoc);
        if (datePromised != null && dateDoc.compareTo(datePromised) <= 0) {
            to.setDatePromised(datePromised);
        } else if (from.getDatePromised() != null && dateDoc.compareTo(from.getDatePromised()) <= 0) {
            to.setDatePromised(from.getDatePromised());
        } else {
            to.setDatePromised(dateDoc);
        }
        to.setDatePrinted(null);
        to.setIsPrinted(false);
        to.setIsApproved(false);
        to.setIsCreditApproved(false);
        to.setC_Payment_ID(0);
        to.setC_CashLine_ID(0);
        to.setGrandTotal(Env.ZERO);
        to.setTotalLines(Env.ZERO);
        to.setIsDelivered(false);
        to.setIsInvoiced(false);
        to.setIsSelfService(false);
        to.setIsTransferred(false);
        to.setPosted(false);
        to.setProcessed(false);
        if (counter) {
            to.setRef_Order_ID(from.getC_Order_ID());
        } else {
            to.setRef_Order_ID(0);
        }
        if (!to.save(trxName)) {
            throw new IllegalStateException("Could not create Order");
        }
        if (counter) {
            from.setRef_Order_ID(to.getC_Order_ID());
        }
        if (to.copyLinesFrom(from, counter, copyASI) == 0) {
            throw new IllegalStateException("Could not create Order Lines");
        }
        to.setLink_Order_ID(0);
        return to;
    }

    public MOrder(Properties ctx, int C_Order_ID, String trxName) {
        super(ctx, C_Order_ID, trxName);
        if (C_Order_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction(DocSubTypeSO_Prepay);
            this.setDeliveryRule("A");
            this.setFreightCostRule("I");
            this.setInvoiceRule("I");
            this.setPaymentRule("P");
            this.setPriorityRule("5");
            this.setDeliveryViaRule("P");
            this.setIsDiscountPrinted(false);
            this.setIsSelected(false);
            this.setIsTaxIncluded(false);
            this.setIsSOTrx(true);
            this.setIsDropShip(false);
            this.setSendEMail(false);
            this.setIsApproved(false);
            this.setIsPrinted(false);
            this.setIsCreditApproved(false);
            this.setIsDelivered(false);
            this.setIsInvoiced(false);
            this.setIsTransferred(false);
            this.setIsSelfService(false);
            super.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setDatePromised(new Timestamp(System.currentTimeMillis()));
            this.setDateOrdered(new Timestamp(System.currentTimeMillis()));
            this.setFreightAmt(Env.ZERO);
            this.setChargeAmt(Env.ZERO);
            this.setTotalLines(Env.ZERO);
            this.setGrandTotal(Env.ZERO);
        }
    }

    public MOrder(MProject project, boolean IsSOTrx, String DocSubTypeSO) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setAD_Client_ID(project.getAD_Client_ID());
        this.setAD_Org_ID(project.getAD_Org_ID());
        this.setC_Campaign_ID(project.getC_Campaign_ID());
        this.setSalesRep_ID(project.getSalesRep_ID());
        this.setC_Project_ID(project.getC_Project_ID());
        this.setDescription(project.getName());
        Timestamp ts = project.getDateContract();
        if (ts != null) {
            this.setDateOrdered(ts);
        }
        if ((ts = project.getDateFinish()) != null) {
            this.setDatePromised(ts);
        }
        this.setC_BPartner_ID(project.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(project.getC_BPartner_Location_ID());
        this.setAD_User_ID(project.getAD_User_ID());
        this.setM_Warehouse_ID(project.getM_Warehouse_ID());
        this.setM_PriceList_ID(project.getM_PriceList_ID());
        this.setC_PaymentTerm_ID(project.getC_PaymentTerm_ID());
        this.setIsSOTrx(IsSOTrx);
        if (IsSOTrx) {
            if (DocSubTypeSO == null || DocSubTypeSO.length() == 0) {
                this.setC_DocTypeTarget_ID(DocSubTypeSO_OnCredit);
            } else {
                this.setC_DocTypeTarget_ID(DocSubTypeSO);
            }
        } else {
            this.setC_DocTypeTarget_ID();
        }
    }

    public MOrder(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    @Override
    public void setC_BPartner_ID(int C_BPartner_ID) {
        super.setC_BPartner_ID(C_BPartner_ID);
        super.setBill_BPartner_ID(C_BPartner_ID);
    }

    @Override
    public void setC_BPartner_Location_ID(int C_BPartner_Location_ID) {
        super.setC_BPartner_Location_ID(C_BPartner_Location_ID);
        super.setBill_Location_ID(C_BPartner_Location_ID);
    }

    @Override
    public void setAD_User_ID(int AD_User_ID) {
        super.setAD_User_ID(AD_User_ID);
        super.setBill_User_ID(AD_User_ID);
    }

    public void setShip_BPartner_ID(int C_BPartner_ID) {
        super.setC_BPartner_ID(C_BPartner_ID);
    }

    public void setShip_Location_ID(int C_BPartner_Location_ID) {
        super.setC_BPartner_Location_ID(C_BPartner_Location_ID);
    }

    public void setShip_User_ID(int AD_User_ID) {
        super.setAD_User_ID(AD_User_ID);
    }

    @Override
    public void setM_Warehouse_ID(int M_Warehouse_ID) {
        super.setM_Warehouse_ID(M_Warehouse_ID);
    }

    @Override
    public void setIsDropShip(boolean IsDropShip) {
        super.setIsDropShip(IsDropShip);
    }

    public void setC_DocTypeTarget_ID(String DocSubTypeSO_x) {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocSubTypeSO=? " + " AND IsActive='Y' " + "ORDER BY AD_Org_ID DESC, IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, sql, this.getAD_Client_ID(), DocSubTypeSO_x);
        if (C_DocType_ID <= 0) {
            this.log.severe("Not found for AD_Client_ID=" + this.getAD_Client_ID() + ", SubType=" + DocSubTypeSO_x);
        } else {
            this.log.fine("(SO) - " + DocSubTypeSO_x);
            this.setC_DocTypeTarget_ID(C_DocType_ID);
            this.setIsSOTrx(true);
        }
    }

    public void setC_DocTypeTarget_ID() {
        if (this.isSOTrx()) {
            this.setC_DocTypeTarget_ID(DocSubTypeSO_Standard);
            return;
        }
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocBaseType='POO' " + "ORDER BY AD_Org_ID DESC, IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, sql, this.getAD_Client_ID());
        if (C_DocType_ID <= 0) {
            this.log.severe("No POO found for AD_Client_ID=" + this.getAD_Client_ID());
        } else {
            this.log.fine("(PO) - " + C_DocType_ID);
            this.setC_DocTypeTarget_ID(C_DocType_ID);
        }
    }

    public void setBPartner(MBPartner bp) {
        MBPartnerLocation[] locs;
        String ss;
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = this.isSOTrx() ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID();
        if (ii != 0) {
            this.setC_PaymentTerm_ID(ii);
        }
        if ((ii = this.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID()) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if ((ss = bp.getDeliveryRule()) != null) {
            this.setDeliveryRule(ss);
        }
        if ((ss = bp.getDeliveryViaRule()) != null) {
            this.setDeliveryViaRule(ss);
        }
        if ((ss = bp.getInvoiceRule()) != null) {
            this.setInvoiceRule(ss);
        }
        if ((ss = bp.getPaymentRule()) != null) {
            this.setPaymentRule(ss);
        }
        if ((ii = bp.getSalesRep_ID()) != 0) {
            this.setSalesRep_ID(ii);
        }
        if ((locs = bp.getLocations(false)) != null) {
            for (int i2 = 0; i2 < locs.length; ++i2) {
                if (locs[i2].isShipTo()) {
                    super.setC_BPartner_Location_ID(locs[i2].getC_BPartner_Location_ID());
                }
                if (!locs[i2].isBillTo()) continue;
                this.setBill_Location_ID(locs[i2].getC_BPartner_Location_ID());
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                super.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
            if (this.getBill_Location_ID() == 0 && locs.length > 0) {
                this.setBill_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            throw new BPartnerNoShipToAddressException(bp);
        }
        if (this.getBill_Location_ID() == 0) {
            throw new BPartnerNoBillToAddressException(bp);
        }
        MUser[] contacts = bp.getContacts(false);
        if (contacts != null && contacts.length == 1) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    public int copyLinesFrom(MOrder otherOrder, boolean counter, boolean copyASI) {
        if (this.isProcessed() || this.isPosted() || otherOrder == null) {
            return 0;
        }
        MOrderLine[] fromLines = otherOrder.getLines(false, null);
        int count = 0;
        for (int i2 = 0; i2 < fromLines.length; ++i2) {
            Env.setContext(Env.getCtx(), 0, 1113, "Z_OrderRef", otherOrder.get_ID() + "");
            MOrderLine line = new MOrderLine(this);
            PO.copyValues(fromLines[i2], line, this.getAD_Client_ID(), this.getAD_Org_ID());
            line.setC_Order_ID(this.getC_Order_ID());
            line.setQtyDelivered(Env.ZERO);
            line.setQtyInvoiced(Env.ZERO);
            line.setQtyReserved(Env.ZERO);
            line.setDateDelivered(null);
            line.setDateInvoiced(null);
            String description = fromLines[i2].getDescription() == null ? "" : fromLines[i2].getDescription();
            line.setDescription(description);
            line.setOrder(this);
            line.set_ValueNoCheck("C_OrderLine_ID", I_ZERO);
            if (!copyASI) {
                line.setM_AttributeSetInstance_ID(0);
                line.setS_ResourceAssignment_ID(0);
            }
            if (counter) {
                line.setRef_OrderLine_ID(fromLines[i2].getC_OrderLine_ID());
            } else {
                line.setRef_OrderLine_ID(0);
            }
            line.setLink_OrderLine_ID(0);
            if (this.getC_BPartner_ID() != otherOrder.getC_BPartner_ID() && (line.getM_Product_ID() != 0 || line.getC_Charge_ID() != 0)) {
                line.setTax();
            } else if (this.getC_BPartner_ID() != otherOrder.getC_BPartner_ID() && line.getDescription() != null && !line.getDescription().isEmpty()) {
                line.setC_Tax_ID(fromLines[i2].getC_Tax_ID());
            }
            line.setProcessed(false);
            int exist = DB.getSQLValue(null, "SELECT COUNT(column_name) FROM information_schema.columns WHERE UPPER(table_name)= UPPER('c_orderline') AND UPPER(Column_Name) = UPPER('z_qtytoprepare')");
            if (exist != 0) {
                line.set_Value("Z_QtyToPrepare", (Object)Env.ZERO);
            }
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            if (counter) {
                fromLines[i2].setRef_OrderLine_ID(line.getC_OrderLine_ID());
                fromLines[i2].save(this.get_TrxName());
            }
            Env.setContext(Env.getCtx(), 0, 1113, "Z_OrderRef", null);
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MOrder[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",IsSOTrx=").append(this.isSOTrx()).append(",C_DocType_ID=").append(this.getC_DocType_ID()).append(", GrandTotal=").append(this.getGrandTotal()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get(this.getCtx(), 0, this.getC_Order_ID(), this.get_TrxName());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    @Override
    public void setM_PriceList_ID(int M_PriceList_ID) {
        MPriceList pl = MPriceList.get(this.getCtx(), M_PriceList_ID, null);
        if (pl.get_ID() == M_PriceList_ID) {
            super.setM_PriceList_ID(M_PriceList_ID);
            this.setC_Currency_ID(pl.getC_Currency_ID());
            this.setIsTaxIncluded(pl.isTaxIncluded());
        }
    }

    public MOrderLine[] getLines(String whereClause, String orderClause) {
        StringBuffer whereClauseFinal = new StringBuffer("C_Order_ID=? ");
        if (!Util.isEmpty(whereClause, true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "Line";
        }
        List<MOrderLine> list = new Query(this.getCtx(), "C_OrderLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(this.get_ID()).setOrderBy(orderClause).list();
        for (MOrderLine ol : list) {
            ol.setHeaderInfo(this);
        }
        return list.toArray(new MOrderLine[list.size()]);
    }

    public MOrderLine[] getLines(boolean requery, String orderBy) {
        if (this.m_lines != null && !requery) {
            MOrder.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? orderClause + orderBy : orderClause + "Line";
        this.m_lines = this.getLines(null, orderClause);
        return this.m_lines;
    }

    public MOrderLine[] getLines() {
        return this.getLines(false, null);
    }

    public void renumberLines(int step) {
        int number = step;
        MOrderLine[] lines = this.getLines(true, null);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MOrderLine line = lines[i2];
            line.setLine(number);
            line.save(this.get_TrxName());
            number += step;
        }
        this.m_lines = null;
    }

    public boolean isOrderLine(int C_OrderLine_ID) {
        if (this.m_lines == null) {
            this.getLines();
        }
        for (int i2 = 0; i2 < this.m_lines.length; ++i2) {
            if (this.m_lines[i2].getC_OrderLine_ID() != C_OrderLine_ID) continue;
            return true;
        }
        return false;
    }

    public MOrderTax[] getTaxes(boolean requery) {
        if (this.m_taxes != null && !requery) {
            return this.m_taxes;
        }
        List<MOrderTax> list = new Query(this.getCtx(), "C_OrderTax", "C_Order_ID=?", this.get_TrxName()).setParameters(this.get_ID()).list();
        this.m_taxes = list.toArray(new MOrderTax[list.size()]);
        return this.m_taxes;
    }

    public MInvoice[] getInvoices() {
        String whereClause = "EXISTS (SELECT 1 FROM C_InvoiceLine il, C_OrderLine ol WHERE il.C_Invoice_ID=C_Invoice.C_Invoice_ID AND il.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)";
        List<MInvoice> list = new Query(this.getCtx(), "C_Invoice", "EXISTS (SELECT 1 FROM C_InvoiceLine il, C_OrderLine ol WHERE il.C_Invoice_ID=C_Invoice.C_Invoice_ID AND il.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)", this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("C_Invoice_ID DESC").list();
        return list.toArray(new MInvoice[list.size()]);
    }

    public int getC_Invoice_ID() {
        String sql = "SELECT C_Invoice_ID FROM C_Invoice WHERE C_Order_ID=? AND DocStatus IN ('CO','CL') ORDER BY C_Invoice_ID DESC";
        int C_Invoice_ID = DB.getSQLValue(this.get_TrxName(), sql, this.get_ID());
        return C_Invoice_ID;
    }

    public MInOut[] getShipments() {
        String whereClause = "EXISTS (SELECT 1 FROM M_InOutLine iol, C_OrderLine ol WHERE iol.M_InOut_ID=M_InOut.M_InOut_ID AND iol.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)";
        List<MInOut> list = new Query(this.getCtx(), "M_InOut", "EXISTS (SELECT 1 FROM M_InOutLine iol, C_OrderLine ol WHERE iol.M_InOut_ID=M_InOut.M_InOut_ID AND iol.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)", this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("M_InOut_ID DESC").list();
        return list.toArray(new MInOut[list.size()]);
    }

    public String getCurrencyISO() {
        return MCurrency.getISO_Code(this.getCtx(), this.getC_Currency_ID());
    }

    public int getPrecision() {
        return MCurrency.getStdPrecision(this.getCtx(), this.getC_Currency_ID());
    }

    public String getDocStatusName() {
        return MRefList.getListName(this.getCtx(), 131, this.getDocStatus());
    }

    @Override
    public void setDocAction(String DocAction2) {
        this.setDocAction(DocAction2, false);
    }

    public void setDocAction(String DocAction2, boolean forceCreation) {
        super.setDocAction(DocAction2);
        this.m_forceCreation = forceCreation;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_Order_ID=" + this.getC_Order_ID();
        int noLine = DB.executeUpdateEx("UPDATE C_OrderLine " + set, this.get_TrxName());
        int noTax = DB.executeUpdateEx("UPDATE C_OrderTax " + set, this.get_TrxName());
        this.m_lines = null;
        this.m_taxes = null;
        this.log.fine("setProcessed - " + processed + " - Lines=" + noLine + ", Tax=" + noTax);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int ii;
        MWarehouse wh;
        int context_AD_Org_ID;
        if (this.getAD_Org_ID() == 0 && (context_AD_Org_ID = Env.getAD_Org_ID(this.getCtx())) != 0) {
            this.setAD_Org_ID(context_AD_Org_ID);
            this.log.warning("Changed Org to Context=" + context_AD_Org_ID);
        }
        if (this.getAD_Client_ID() == 0) {
            this.m_processMsg = "AD_Client_ID = 0";
            return false;
        }
        if (this.isSOTrx() && this.getDatePromised() != null && this.getDateOrdered().compareTo(this.getDatePromised()) > 0) {
            this.m_processMsg = "La date de commande ne peut \u00eatre inf\u00e9rieur \u00e0 la date de livraison.";
            throw new AdempiereException(this.m_processMsg);
        }
        if (newRecord && this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(0);
        }
        if (this.getM_Warehouse_ID() == 0) {
            int ii2 = Env.getContextAsInt(this.getCtx(), "#M_Warehouse_ID");
            if (ii2 != 0) {
                this.setM_Warehouse_ID(ii2);
            } else {
                throw new FillMandatoryException(new String[]{"M_Warehouse_ID"});
            }
        }
        if ((newRecord || this.is_ValueChanged("AD_Org_ID") || this.is_ValueChanged("M_Warehouse_ID")) && (wh = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID())).getAD_Org_ID() != this.getAD_Org_ID()) {
            this.log.saveWarning("WarehouseOrgConflict", "");
        }
        if (!newRecord && this.is_ValueChanged("M_Warehouse_ID")) {
            MOrderLine[] lines = this.getLines(false, null);
            for (int i2 = 0; i2 < lines.length; ++i2) {
                if (lines[i2].canChangeWarehouse()) continue;
                return false;
            }
        }
        if (this.getC_BPartner_ID() == 0) {
            this.setBPartner(MBPartner.getTemplate(this.getCtx(), this.getAD_Client_ID()));
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.setBPartner(new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null));
        }
        if (this.getBill_BPartner_ID() == 0) {
            this.setBill_BPartner_ID(this.getC_BPartner_ID());
            this.setBill_Location_ID(this.getC_BPartner_Location_ID());
        }
        if (this.getBill_Location_ID() == 0) {
            this.setBill_Location_ID(this.getC_BPartner_Location_ID());
        }
        if (this.getM_PriceList_ID() == 0 && (ii = DB.getSQLValueEx(null, "SELECT M_PriceList_ID FROM M_PriceList WHERE AD_Client_ID=? AND IsSOPriceList=? AND IsActive=?ORDER BY IsDefault DESC", this.getAD_Client_ID(), this.isSOTrx(), true)) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if (this.getC_Currency_ID() == 0) {
            String sql = "SELECT C_Currency_ID FROM M_PriceList WHERE M_PriceList_ID=?";
            int ii3 = DB.getSQLValue(null, sql, this.getM_PriceList_ID());
            if (ii3 != 0) {
                this.setC_Currency_ID(ii3);
            } else {
                this.setC_Currency_ID(Env.getContextAsInt(this.getCtx(), "#C_Currency_ID"));
            }
        }
        if (this.getSalesRep_ID() == 0 && (ii = Env.getContextAsInt(this.getCtx(), "#SalesRep_ID")) != 0) {
            this.setSalesRep_ID(ii);
        }
        if (this.getC_DocTypeTarget_ID() == 0) {
            this.setC_DocTypeTarget_ID(DocSubTypeSO_Standard);
        }
        if (this.getC_PaymentTerm_ID() == 0) {
            ii = Env.getContextAsInt(this.getCtx(), "#C_PaymentTerm_ID");
            if (ii != 0) {
                this.setC_PaymentTerm_ID(ii);
            } else {
                String sql = "SELECT C_PaymentTerm_ID FROM C_PaymentTerm WHERE AD_Client_ID=? AND IsDefault='Y'";
                ii = DB.getSQLValue(null, sql, this.getAD_Client_ID());
                if (ii != 0) {
                    this.setC_PaymentTerm_ID(ii);
                }
            }
        }
        String convertOnlyCustomer = MSysConfig.getValue("SOGEXIS_ORDERED_ONLY_CUSTOMER", "N", MClient.get(Env.getCtx()).get_ID());
        String docSubType = DB.getSQLValueString(null, "SELECT DocSubTypeSO FROM C_DocType WHERE C_DocType_ID = ?", this.getC_DocTypeTarget_ID());
        if (convertOnlyCustomer.equals("Y") && this.isSOTrx()) {
            if (docSubType.equals(DocSubTypeSO_Quotation) || docSubType.equals(DocSubTypeSO_Proposal)) {
                return true;
            }
            boolean isCustomer = DB.getSQLValueString(this.get_TrxName(), "SELECT isCustomer FROM C_BPartner WHERE C_BPartner_ID = " + this.getC_BPartner_ID(), new Object[0]).equals("Y");
            if (!isCustomer) {
                throw new AdempiereException("Le Tiers de la commande n'est pas client. Merci de vous rapprocher du service responsable de la gestion client pour r\u00e9gulariser le probl\u00e8me.");
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        int no;
        String sql;
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("Description") || this.is_ValueChanged("POReference")) {
            sql = "UPDATE C_Invoice i SET (Description,POReference)=(SELECT Description,POReference FROM C_Order o WHERE i.C_Order_ID=o.C_Order_ID) WHERE DocStatus NOT IN ('RE','CL') AND C_Order_ID=" + this.getC_Order_ID();
            no = DB.executeUpdateEx(sql, this.get_TrxName());
            this.log.fine("Description -> #" + no);
        }
        if (this.is_ValueChanged("PaymentRule") || this.is_ValueChanged("C_PaymentTerm_ID") || this.is_ValueChanged("C_Payment_ID") || this.is_ValueChanged("C_CashLine_ID")) {
            sql = "UPDATE C_Invoice i SET (PaymentRule,C_PaymentTerm_ID,C_Payment_ID,C_CashLine_ID)=(SELECT PaymentRule,C_PaymentTerm_ID,C_Payment_ID,C_CashLine_ID FROM C_Order o WHERE i.C_Order_ID=o.C_Order_ID)WHERE DocStatus NOT IN ('RE','CL') AND C_Order_ID=" + this.getC_Order_ID();
            no = DB.executeUpdate(sql, this.get_TrxName());
            this.log.fine("Payment -> #" + no);
        }
        if (this.is_ValueChanged("DateAcct")) {
            sql = "UPDATE C_Invoice i SET (DateAcct)=(SELECT DateAcct FROM C_Order o WHERE i.C_Order_ID=o.C_Order_ID)WHERE DocStatus NOT IN ('CO','RE','CL') AND Processed='N' AND C_Order_ID=" + this.getC_Order_ID();
            no = DB.executeUpdate(sql, this.get_TrxName());
            this.log.fine("DateAcct -> #" + no);
        }
        if (this.is_ValueChanged("AD_Org_ID") || this.is_ValueChanged("C_BPartner_ID") || this.is_ValueChanged("C_BPartner_Location_ID") || this.is_ValueChanged("DateOrdered") || this.is_ValueChanged("DatePromised") || this.is_ValueChanged("M_Warehouse_ID") || this.is_ValueChanged("M_Shipper_ID") || this.is_ValueChanged("C_Currency_ID")) {
            MOrderLine[] lines;
            for (MOrderLine line : lines = this.getLines()) {
                if (this.is_ValueChanged("AD_Org_ID")) {
                    line.setAD_Org_ID(this.getAD_Org_ID());
                }
                if (this.is_ValueChanged("C_BPartner_ID")) {
                    line.setC_BPartner_ID(this.getC_BPartner_ID());
                }
                if (this.is_ValueChanged("C_BPartner_Location_ID")) {
                    line.setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
                }
                if (this.is_ValueChanged("DateOrdered")) {
                    line.setDateOrdered(this.getDateOrdered());
                }
                if (this.is_ValueChanged("DatePromised")) {
                    line.setDatePromised(this.getDatePromised());
                }
                if (this.is_ValueChanged("M_Warehouse_ID")) {
                    line.setM_Warehouse_ID(this.getM_Warehouse_ID());
                }
                if (this.is_ValueChanged("M_Shipper_ID")) {
                    line.setM_Shipper_ID(this.getM_Shipper_ID());
                }
                if (this.is_ValueChanged("C_Currency_ID")) {
                    line.setC_Currency_ID(this.getC_Currency_ID());
                }
                line.saveEx();
            }
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            return false;
        }
        String testOrderCanDelete = MSysConfig.getValue("SOGEXIS_TEST_DELETE_INPROGRESS_PROPOSAL", "Y", MClient.get(Env.getCtx()).get_ID());
        if (testOrderCanDelete.equals("Y") && !this.getDocStatus().equals("DR") && this.getC_DocType().getDocSubTypeSO().equals(DocSubTypeSO_Proposal) && this.getDocStatus().equals("IP")) {
            throw new AdempiereException("Vous ne pouvez pas supprimer de '' " + this.getC_DocTypeTarget().getName() + " '' en statut en cours.");
        }
        for (MOrderLine line : this.getLines()) {
            line.deleteEx(true);
        }
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction(DocSubTypeSO_Prepay);
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocTypeTarget_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (this.getDeliveryRule() != null && this.getDeliveryRule().equals("O")) {
            for (int i2 = 0; i2 < lines.length; ++i2) {
                MOrderLine line = lines[i2];
                MProduct product = line.getProduct();
                if (product == null || !product.isExcludeAutoDelivery()) continue;
                this.m_processMsg = "@M_Product_ID@ " + product.getValue() + " @IsExcludeAutoDelivery@";
                return "IN";
            }
        }
        if (this.getC_DocType_ID() != this.getC_DocTypeTarget_ID()) {
            MDocType dtOld;
            if (this.getC_DocType_ID() != 0 && DocSubTypeSO_Standard.equals((dtOld = MDocType.get(this.getCtx(), this.getC_DocType_ID())).getDocSubTypeSO()) && !DocSubTypeSO_Standard.equals(dt.getDocSubTypeSO())) {
                for (int i3 = 0; i3 < lines.length; ++i3) {
                    if (lines[i3].getM_Warehouse_ID() == this.getM_Warehouse_ID()) continue;
                    this.log.warning("different Warehouse " + lines[i3]);
                    this.m_processMsg = "@CannotChangeDocType@";
                    return "IN";
                }
            }
            if ("DR".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || this.getC_DocType_ID() == 0) {
                this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
            } else if (dt.isOffer()) {
                this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
            } else {
                this.m_processMsg = "@CannotChangeDocType@";
                return "IN";
            }
        }
        String mandatoryType = "='Y'";
        String sql = "SELECT COUNT(*) FROM C_OrderLine ol INNER JOIN M_Product p ON (ol.M_Product_ID=p.M_Product_ID) INNER JOIN M_AttributeSet pas ON (p.M_AttributeSet_ID=pas.M_AttributeSet_ID) WHERE pas.MandatoryType" + mandatoryType + " AND (ol.M_AttributeSetInstance_ID is NULL OR ol.M_AttributeSetInstance_ID = 0)" + " AND ol.C_Order_ID=?";
        int no = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Order_ID());
        if (no != 0) {
            this.m_processMsg = "@LinesWithoutProductAttribute@ (" + no + ")";
            return "IN";
        }
        if (this.explodeBOM()) {
            lines = this.getLines(true, "M_Product_ID");
        }
        if (!this.reserveStock(dt, lines)) {
            this.m_processMsg = "Cannot reserve Stock";
            return "IN";
        }
        if (!this.calculateTaxTotal()) {
            this.m_processMsg = "Error calculating tax";
            return "IN";
        }
        if (!(!this.isSOTrx() || DocSubTypeSO_POS.equals(dt.getDocSubTypeSO()) && "B".equals(this.getPaymentRule()) && !MSysConfig.getBooleanValue("CHECK_CREDIT_ON_CASH_POS_ORDER", true, this.getAD_Client_ID(), this.getAD_Org_ID()) || DocSubTypeSO_Prepay.equals(dt.getDocSubTypeSO()) && !MSysConfig.getBooleanValue("CHECK_CREDIT_ON_PREPAY_ORDER", true, this.getAD_Client_ID(), this.getAD_Org_ID()))) {
            MBPartner bp = new MBPartner(this.getCtx(), this.getBill_BPartner_ID(), this.get_TrxName());
            String typeDocument = DB.getSQLValueString(null, "SELECT COALESCE(docsubTypeSo, '') FROM C_Doctype WHERE C_DocType_ID = " + this.getC_DocTypeTarget_ID(), new Object[0]);
            if (!typeDocument.equals(DocSubTypeSO_Quotation) && !typeDocument.equals(DocSubTypeSO_Proposal)) {
                if ("S".equals(bp.getSOCreditStatus())) {
                    this.m_processMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                    return "IN";
                }
                if ("H".equals(bp.getSOCreditStatus())) {
                    this.m_processMsg = "@BPartnerCreditHold@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                    return "IN";
                }
                BigDecimal grandTotal = MConversionRate.convertBase(this.getCtx(), this.getGrandTotal(), this.getC_Currency_ID(), this.getDateOrdered(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
                if ("H".equals(bp.getSOCreditStatus(grandTotal))) {
                    this.m_processMsg = "@BPartnerOverOCreditHold@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @GrandTotal@=" + grandTotal + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                    return "IN";
                }
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    private boolean explodeBOM() {
        boolean retValue = false;
        String where = "AND IsActive='Y' AND EXISTS (SELECT * FROM M_Product p WHERE C_OrderLine.M_Product_ID=p.M_Product_ID AND\tp.IsBOM='Y' AND p.IsVerified='Y' AND p.IsStocked='N')";
        String sql = "SELECT COUNT(*) FROM C_OrderLine WHERE C_Order_ID=? " + where;
        int count = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Order_ID());
        while (count != 0) {
            retValue = true;
            this.renumberLines(1000);
            MOrderLine[] lines = this.getLines(where, "Line");
            for (int i2 = 0; i2 < lines.length; ++i2) {
                MOrderLine line = lines[i2];
                MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
                this.log.fine(product.getName());
                int lineNo = line.getLine();
                MPPProductBOM bom = MPPProductBOM.get(product, this.getAD_Org_ID(), this.getDatePromised(), this.get_TrxName());
                if (bom != null) {
                    MPPProductBOMLine[] bomlines = bom.getLines(this.getDatePromised());
                    for (int j = 0; j < bomlines.length; ++j) {
                        MPPProductBOMLine bomline = bomlines[j];
                        MOrderLine newLine = new MOrderLine(this);
                        newLine.setLine(++lineNo);
                        newLine.setM_Product_ID(bomline.getM_Product_ID());
                        newLine.setC_UOM_ID(bomline.getC_UOM_ID());
                        newLine.setQty(line.getQtyOrdered().multiply(bomline.getQtyBOM()));
                        if (bomline.getDescription() != null) {
                            newLine.setDescription(bomline.getDescription());
                        }
                        newLine.setPrice();
                        newLine.save(this.get_TrxName());
                    }
                }
                line.setM_Product_ID(0);
                line.setM_AttributeSetInstance_ID(0);
                line.setPrice(Env.ZERO);
                line.setPriceLimit(Env.ZERO);
                line.setPriceList(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                line.setFreightAmt(Env.ZERO);
                String description = product.getName();
                if (product.getDescription() != null) {
                    description = description + " " + product.getDescription();
                }
                if (line.getDescription() != null) {
                    description = description + " " + line.getDescription();
                }
                line.setDescription(description);
                line.save(this.get_TrxName());
            }
            this.m_lines = null;
            count = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Invoice_ID());
            this.renumberLines(10);
        }
        return retValue;
    }

    private boolean reserveStock(MDocType dt, MOrderLine[] lines) {
        boolean binding;
        if (dt == null) {
            dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        }
        boolean bl = binding = !dt.isProposal();
        if ("VO".equals(this.getDocAction()) || DocSubTypeSO_Quotation.equals(dt.getDocSubTypeSO()) && "CL".equals(this.getDocAction())) {
            binding = false;
        }
        boolean isSOTrx = this.isSOTrx();
        this.log.fine("Binding=" + binding + " - IsSOTrx=" + isSOTrx);
        int header_M_Warehouse_ID = this.getM_Warehouse_ID();
        if (DocSubTypeSO_Standard.equals(dt.getDocSubTypeSO()) || "POO".equals(dt.getDocBaseType())) {
            header_M_Warehouse_ID = 0;
        }
        BigDecimal Volume = Env.ZERO;
        BigDecimal Weight = Env.ZERO;
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MProduct product;
            BigDecimal target;
            BigDecimal difference;
            MOrderLine line = lines[i2];
            if (header_M_Warehouse_ID != 0) {
                if (header_M_Warehouse_ID != line.getM_Warehouse_ID()) {
                    line.setM_Warehouse_ID(header_M_Warehouse_ID);
                }
                if (this.getAD_Org_ID() != line.getAD_Org_ID()) {
                    line.setAD_Org_ID(this.getAD_Org_ID());
                }
            }
            if ((difference = (target = binding ? line.getQtyOrdered() : Env.ZERO).subtract(line.getQtyReserved()).subtract(line.getQtyDelivered())).signum() == 0) {
                product = line.getProduct();
                if (product == null) continue;
                Volume = Volume.add(product.getVolume().multiply(line.getQtyOrdered()));
                Weight = Weight.add(product.getWeight().multiply(line.getQtyOrdered()));
                continue;
            }
            this.log.fine("Line=" + line.getLine() + " - Target=" + target + ",Difference=" + difference + " - Ordered=" + line.getQtyOrdered() + ",Reserved=" + line.getQtyReserved() + ",Delivered=" + line.getQtyDelivered());
            product = line.getProduct();
            if (product == null) continue;
            if (product.isStocked()) {
                BigDecimal ordered = isSOTrx ? Env.ZERO : difference;
                BigDecimal reserved = isSOTrx ? difference : Env.ZERO;
                int M_Locator_ID = 0;
                if (line.getM_AttributeSetInstance_ID() != 0) {
                    M_Locator_ID = MStorage.getM_Locator_ID(line.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), ordered, this.get_TrxName());
                }
                if (M_Locator_ID == 0) {
                    MWarehouse wh = MWarehouse.get(this.getCtx(), line.getM_Warehouse_ID());
                    M_Locator_ID = product.getM_Locator_ID();
                    if (M_Locator_ID != 0) {
                        MLocator locator = new MLocator(this.getCtx(), product.getM_Locator_ID(), this.get_TrxName());
                        if (locator.getM_Warehouse_ID() != wh.get_ID()) {
                            M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
                        }
                    } else {
                        M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
                    }
                }
                if (!MStorage.add(this.getCtx(), line.getM_Warehouse_ID(), M_Locator_ID, line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.getM_AttributeSetInstance_ID(), Env.ZERO, reserved, ordered, this.get_TrxName())) {
                    return false;
                }
            }
            line.setQtyReserved(line.getQtyReserved().add(difference));
            if (!line.save(this.get_TrxName())) {
                return false;
            }
            Volume = Volume.add(product.getVolume().multiply(line.getQtyOrdered()));
            Weight = Weight.add(product.getWeight().multiply(line.getQtyOrdered()));
        }
        this.setVolume(Volume);
        this.setWeight(Weight);
        return true;
    }

    public boolean calculateTaxTotal() {
        MOrderTax oTax;
        this.log.fine("");
        DB.executeUpdateEx("DELETE C_OrderTax WHERE C_Order_ID=" + this.getC_Order_ID(), this.get_TrxName());
        this.m_taxes = null;
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MOrderLine[] lines = this.getLines();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MOrderLine line = lines[i2];
            Integer taxID = new Integer(line.getC_Tax_ID());
            if (!taxList.contains(taxID)) {
                oTax = MOrderTax.get(line, this.getPrecision(), false, this.get_TrxName());
                oTax.setIsTaxIncluded(this.isTaxIncluded());
                if (!oTax.calculateTaxFromLines()) {
                    return false;
                }
                if (!oTax.save(this.get_TrxName())) {
                    return false;
                }
                taxList.add(taxID);
            }
            totalLines = totalLines.add(line.getLineNetAmt());
        }
        BigDecimal grandTotal = totalLines;
        MOrderTax[] taxes = this.getTaxes(true);
        for (int i3 = 0; i3 < taxes.length; ++i3) {
            oTax = taxes[i3];
            MTax tax = oTax.getTax();
            if (tax.isSummary()) {
                MTax[] cTaxes = tax.getChildTaxes(false);
                for (int j = 0; j < cTaxes.length; ++j) {
                    MTax cTax = cTaxes[j];
                    BigDecimal taxAmt = cTax.calculateTax(oTax.getTaxBaseAmt(), this.isTaxIncluded(), this.getPrecision());
                    MOrderTax newOTax = new MOrderTax(this.getCtx(), 0, this.get_TrxName());
                    newOTax.setClientOrg(this);
                    newOTax.setC_Order_ID(this.getC_Order_ID());
                    newOTax.setC_Tax_ID(cTax.getC_Tax_ID());
                    newOTax.setPrecision(this.getPrecision());
                    newOTax.setIsTaxIncluded(this.isTaxIncluded());
                    newOTax.setTaxBaseAmt(oTax.getTaxBaseAmt());
                    newOTax.setTaxAmt(taxAmt);
                    if (!newOTax.save(this.get_TrxName())) {
                        return false;
                    }
                    if (this.isTaxIncluded()) continue;
                    grandTotal = grandTotal.add(taxAmt);
                }
                if (!oTax.delete(true, this.get_TrxName())) {
                    return false;
                }
                if (oTax.save(this.get_TrxName())) continue;
                return false;
            }
            if (this.isTaxIncluded()) continue;
            grandTotal = grandTotal.add(oTax.getTaxAmt());
        }
        this.setTotalLines(totalLines);
        this.setGrandTotal(grandTotal);
        return true;
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String valid;
        MOrder counter;
        String status;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        String DocSubTypeSO = dt.getDocSubTypeSO();
        if (DocSubTypeSO_Prepay.equals(this.getDocAction())) {
            this.setProcessed(false);
            return "IP";
        }
        if (DocSubTypeSO_Proposal.equals(DocSubTypeSO) || DocSubTypeSO_Quotation.equals(DocSubTypeSO)) {
            if (DocSubTypeSO_Quotation.equals(DocSubTypeSO)) {
                this.reserveStock(dt, this.getLines(true, "M_Product_ID"));
            }
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
            if (this.m_processMsg != null) {
                return "IN";
            }
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 9);
            if (this.m_processMsg != null) {
                return "IN";
            }
            this.setDefiniteDocumentNo();
            this.setProcessed(true);
            return "CO";
        }
        if (!this.m_forceCreation && DocSubTypeSO_Prepay.equals(DocSubTypeSO) && this.getC_Payment_ID() == 0 && this.getC_CashLine_ID() == 0) {
            this.setProcessed(true);
            return DocSubTypeSO_Warehouse;
        }
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.getLines(true, null);
        this.log.info(this.toString());
        StringBuffer info = new StringBuffer();
        boolean realTimePOS = MSysConfig.getBooleanValue("REAL_TIME_POS", false, this.getAD_Client_ID());
        MInOut shipment = null;
        if (DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Warehouse.equals(DocSubTypeSO) || DocSubTypeSO_POS.equals(DocSubTypeSO) || DocSubTypeSO_Prepay.equals(DocSubTypeSO)) {
            if (!"F".equals(this.getDeliveryRule())) {
                this.setDeliveryRule("F");
            }
            if ((shipment = this.createShipment(dt, realTimePOS ? null : this.getDateOrdered())) == null) {
                return "IN";
            }
            info.append("@M_InOut_ID@: ").append(shipment.getDocumentNo());
            String msg = shipment.getProcessMsg();
            if (msg != null && msg.length() > 0) {
                info.append(" (").append(msg).append(")");
            }
        }
        if (DocSubTypeSO_POS.equals(DocSubTypeSO) || DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Prepay.equals(DocSubTypeSO)) {
            MInvoice invoice = this.createInvoice(dt, shipment, realTimePOS ? null : this.getDateOrdered());
            if (invoice == null) {
                return "IN";
            }
            info.append(" - @C_Invoice_ID@: ").append(invoice.getDocumentNo());
            String msg = invoice.getProcessMsg();
            if (msg != null && msg.length() > 0) {
                info.append(" (").append(msg).append(")");
            }
        }
        if ((counter = this.createCounterDoc()) != null) {
            info.append(" - @CounterDoc@: @Order@=").append(counter.getDocumentNo());
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate(this, 9)) != null) {
            if (info.length() > 0) {
                info.append(" - ");
            }
            info.append(valid);
            this.m_processMsg = info.toString();
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.m_processMsg = info.toString();
        String action_after_complete = MSysConfig.getValue("SOGEXIS_ACTION_AFTER_COMPLETE", "CL", MClient.get(Env.getCtx()).get_ID());
        this.setDocAction(action_after_complete);
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateOrdered(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    private MInOut createShipment(MDocType dt, Timestamp movementDate) {
        this.log.info("For " + dt);
        MInOut shipment = new MInOut(this, dt.getC_DocTypeShipment_ID(), movementDate);
        if (!shipment.save(this.get_TrxName())) {
            this.m_processMsg = "Could not create Shipment";
            return null;
        }
        MOrderLine[] oLines = this.getLines(true, null);
        for (int i2 = 0; i2 < oLines.length; ++i2) {
            MOrderLine oLine = oLines[i2];
            MInOutLine ioLine = new MInOutLine(shipment);
            BigDecimal MovementQty = oLine.getQtyOrdered().subtract(oLine.getQtyDelivered());
            int M_Locator_ID = MStorage.getM_Locator_ID(oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), MovementQty, this.get_TrxName());
            if (M_Locator_ID == 0) {
                MWarehouse wh = MWarehouse.get(this.getCtx(), oLine.getM_Warehouse_ID());
                M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            }
            ioLine.setOrderLine(oLine, M_Locator_ID, MovementQty);
            ioLine.setQty(MovementQty);
            if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                ioLine.setQtyEntered(MovementQty.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 6, 4));
            }
            if (ioLine.save(this.get_TrxName())) continue;
            this.m_processMsg = "Could not create Shipment Line";
            return null;
        }
        shipment.processIt("CO");
        shipment.saveEx(this.get_TrxName());
        if (!"CO".equals(shipment.getDocStatus())) {
            this.m_processMsg = "@M_InOut_ID@: " + shipment.getProcessMsg();
            return null;
        }
        return shipment;
    }

    private MInvoice createInvoice(MDocType dt, MInOut shipment, Timestamp invoiceDate) {
        this.log.info(dt.toString());
        MInvoice invoice = new MInvoice(this, dt.getC_DocTypeInvoice_ID(), invoiceDate);
        if (!invoice.save(this.get_TrxName())) {
            this.m_processMsg = "Could not create Invoice";
            return null;
        }
        if (shipment != null) {
            if (!"D".equals(this.getInvoiceRule())) {
                this.setInvoiceRule("D");
            }
            MInOutLine[] sLines = shipment.getLines(false);
            for (int i2 = 0; i2 < sLines.length; ++i2) {
                MInOutLine sLine = sLines[i2];
                MInvoiceLine iLine = new MInvoiceLine(invoice);
                iLine.setShipLine(sLine);
                if (sLine.sameOrderLineUOM()) {
                    iLine.setQtyEntered(sLine.getQtyEntered());
                } else {
                    iLine.setQtyEntered(sLine.getMovementQty());
                }
                iLine.setQtyInvoiced(sLine.getMovementQty());
                if (!iLine.save(this.get_TrxName())) {
                    this.m_processMsg = "Could not create Invoice Line from Shipment Line";
                    return null;
                }
                sLine.setIsInvoiced(true);
                if (sLine.save(this.get_TrxName())) continue;
                this.log.warning("Could not update Shipment line: " + sLine);
            }
        } else {
            if (!"I".equals(this.getInvoiceRule())) {
                this.setInvoiceRule("I");
            }
            MOrderLine[] oLines = this.getLines();
            for (int i3 = 0; i3 < oLines.length; ++i3) {
                MOrderLine oLine = oLines[i3];
                MInvoiceLine iLine = new MInvoiceLine(invoice);
                iLine.setOrderLine(oLine);
                iLine.setQtyInvoiced(oLine.getQtyOrdered().subtract(oLine.getQtyInvoiced()));
                if (oLine.getQtyOrdered().compareTo(oLine.getQtyEntered()) == 0) {
                    iLine.setQtyEntered(iLine.getQtyInvoiced());
                } else {
                    iLine.setQtyEntered(iLine.getQtyInvoiced().multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 12, 4));
                }
                if (iLine.save(this.get_TrxName())) continue;
                this.m_processMsg = "Could not create Invoice Line from Order Line";
                return null;
            }
        }
        invoice.processIt("CO");
        invoice.saveEx(this.get_TrxName());
        this.setC_CashLine_ID(invoice.getC_CashLine_ID());
        if (!"CO".equals(invoice.getDocStatus())) {
            this.m_processMsg = "@C_Invoice_ID@: " + invoice.getProcessMsg();
            return null;
        }
        return invoice;
    }

    private MOrder createCounterDoc() {
        if (this.getRef_Order_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get(this.getCtx(), this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID_Int();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, this.get_TrxName());
        MOrgInfo counterOrgInfo = MOrgInfo.get(this.getCtx(), counterAD_Org_ID, this.get_TrxName());
        this.log.info("Counter BP=" + counterBP.getName());
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType(this.getCtx(), this.getC_DocType_ID());
        if (counterDT != null) {
            this.log.fine(counterDT.toString());
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID(this.getCtx(), this.getC_DocType_ID());
            this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MOrder counter = MOrder.copyFrom(this, this.getDateOrdered(), C_DocTypeTarget_ID, !this.isSOTrx(), true, false, this.get_TrxName(), this.getDatePromised());
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setM_Warehouse_ID(counterOrgInfo.getM_Warehouse_ID());
        counter.setBPartner(counterBP);
        counter.setDatePromised(this.getDatePromised());
        counter.setSalesRep_ID(this.getSalesRep_ID());
        counter.save(this.get_TrxName());
        MOrderLine[] counterLines = counter.getLines(true, null);
        for (int i2 = 0; i2 < counterLines.length; ++i2) {
            MOrderLine counterLine = counterLines[i2];
            counterLine.setOrder(counter);
            counterLine.setPrice();
            counterLine.setTax();
            counterLine.save(this.get_TrxName());
        }
        this.log.fine(counter.toString());
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            counter.processIt(counterDT.getDocAction());
            counter.save(this.get_TrxName());
        }
        return counter;
    }

    @Override
    public boolean voidIt() {
        MOrderTax[] taxes;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MOrderLine line = lines[i2];
            BigDecimal old = line.getQtyOrdered();
            if (old.signum() != 0) {
                line.addDescription(Msg.getMsg(this.getCtx(), "Voided") + " (" + old + ")");
                line.setQty(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                line.save(this.get_TrxName());
            }
            if (this.isSOTrx()) continue;
            this.deleteMatchPOCostDetail(line);
        }
        for (MOrderTax tax : taxes = this.getTaxes(true)) {
            if (tax.calculateTaxFromLines() && tax.save()) continue;
            return false;
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        if (!this.reserveStock(null, lines)) {
            this.m_processMsg = "Cannot unreserve Stock (void)";
            return false;
        }
        MRequisitionLine.unlinkC_Order_ID(this.getCtx(), this.get_ID(), this.get_TrxName());
        if (!this.createReversals()) {
            return false;
        }
        MFactAcct.deleteEx(Table_ID, this.getC_Order_ID(), this.get_TrxName());
        this.setPosted(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    private boolean createReversals() {
        if (!this.isSOTrx()) {
            return true;
        }
        this.log.info("createReversals");
        StringBuffer info = new StringBuffer();
        info.append("@M_InOut_ID@:");
        MInOut[] shipments = this.getShipments();
        for (int i2 = 0; i2 < shipments.length; ++i2) {
            MInOut ship = shipments[i2];
            if ("CL".equals(ship.getDocStatus()) || "RE".equals(ship.getDocStatus()) || "VO".equals(ship.getDocStatus())) continue;
            ship.set_TrxName(this.get_TrxName());
            if (!"CO".equals(ship.getDocStatus())) {
                if (ship.voidIt()) {
                    ship.setDocStatus("VO");
                }
            } else if (ship.reverseCorrectIt()) {
                ship.setDocStatus("RE");
                info.append(" ").append(ship.getDocumentNo());
            } else {
                this.m_processMsg = "Could not reverse Shipment " + ship;
                return false;
            }
            ship.setDocAction("--");
            ship.save(this.get_TrxName());
        }
        info.append(" - @C_Invoice_ID@:");
        MInvoice[] invoices = this.getInvoices();
        for (int i3 = 0; i3 < invoices.length; ++i3) {
            MInvoice invoice = invoices[i3];
            if ("CL".equals(invoice.getDocStatus()) || "RE".equals(invoice.getDocStatus()) || "VO".equals(invoice.getDocStatus())) continue;
            invoice.set_TrxName(this.get_TrxName());
            if (!"CO".equals(invoice.getDocStatus())) {
                if (invoice.voidIt()) {
                    invoice.setDocStatus("VO");
                }
            } else if (invoice.reverseCorrectIt()) {
                invoice.setDocStatus("RE");
                info.append(" ").append(invoice.getDocumentNo());
            } else {
                this.m_processMsg = "Could not reverse Invoice " + invoice;
                return false;
            }
            invoice.setDocAction("--");
            invoice.save(this.get_TrxName());
        }
        this.m_processMsg = info.toString();
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.isSOTrx() || !this.getC_DocType().getDocSubTypeSO().equals(DocSubTypeSO_Proposal)) {
            MOrderLine[] lines = this.getLines(true, "M_Product_ID");
            for (int i2 = 0; i2 < lines.length; ++i2) {
                MOrderLine line = lines[i2];
                BigDecimal old = line.getQtyOrdered();
                if (old.compareTo(line.getQtyDelivered()) == 0) continue;
                line.setQtyLostSales(line.getQtyOrdered().subtract(line.getQtyDelivered()));
                line.setQtyOrdered(line.getQtyDelivered());
                line.addDescription("La quantit\u00e9 command\u00e9e \u00e9tait de (" + old + ")");
                line.save(this.get_TrxName());
            }
            if (!this.reserveStock(null, lines)) {
                this.m_processMsg = "Cannot unreserve Stock (close)";
                return false;
            }
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    public String reopenIt() {
        this.log.info(this.toString());
        if (!"CL".equals(this.getDocStatus())) {
            return "Not closed - can't reopen";
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MOrderLine line = lines[i2];
            if (Env.ZERO.compareTo(line.getQtyLostSales()) == 0) continue;
            line.setQtyOrdered(line.getQtyLostSales().add(line.getQtyDelivered()));
            line.setQtyLostSales(Env.ZERO);
            String desc = line.getDescription();
            if (desc == null) {
                desc = "";
            }
            Pattern pattern = Pattern.compile("( \\| )?Close \\(.*\\)");
            String[] parts = pattern.split(desc);
            desc = "";
            for (String s : parts) {
                desc = desc.concat(s);
            }
            line.setDescription(desc);
            if (line.save(this.get_TrxName())) continue;
            return "Couldn't save orderline";
        }
        if (!this.reserveStock(null, lines)) {
            this.m_processMsg = "Cannot unreserve Stock (close)";
            return "Failed to update reservations";
        }
        this.setDocStatus("CO");
        this.setDocAction("CL");
        if (!this.save(this.get_TrxName())) {
            return "Couldn't save reopened order";
        }
        return "";
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return this.voidIt();
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        String DocSubTypeSO = dt.getDocSubTypeSO();
        if (DocSubTypeSO_Prepay.equals(DocSubTypeSO)) {
            X_C_DocType newDT = null;
            MDocType[] dts = MDocType.getOfClient(this.getCtx());
            for (int i2 = 0; i2 < dts.length; ++i2) {
                MDocType type = dts[i2];
                if (!DocSubTypeSO_Prepay.equals(type.getDocSubTypeSO()) || !type.isDefault() && newDT != null) continue;
                newDT = type;
            }
            if (newDT == null) {
                return false;
            }
            this.setC_DocType_ID(newDT.getC_DocType_ID());
        }
        if (!this.isSOTrx()) {
            this.log.info("Existing documents not modified - " + dt);
        } else if (DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Warehouse.equals(DocSubTypeSO) || DocSubTypeSO_POS.equals(DocSubTypeSO)) {
            if (!this.createReversals()) {
                return false;
            }
        } else {
            this.log.info("Existing documents not modified - SubType=" + DocSubTypeSO);
        }
        MFactAcct.deleteEx(Table_ID, this.getC_Order_ID(), this.get_TrxName());
        this.setPosted(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "GrandTotal")).append("=").append(this.getGrandTotal());
        if (this.m_lines != null) {
            sb.append(" (#").append(this.m_lines.length).append(")");
        }
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }

    private String deleteMatchPOCostDetail(MOrderLine line) {
        MAcctSchema[] acctschemas = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID());
        for (int asn = 0; asn < acctschemas.length; ++asn) {
            MCostDetail cd;
            MMatchPO[] mPO;
            MAcctSchema as = acctschemas[asn];
            if (as.isSkipOrg(this.getAD_Org_ID()) || (mPO = MMatchPO.getOrderLine(this.getCtx(), line.getC_OrderLine_ID(), this.get_TrxName())).length != 0 || (cd = MCostDetail.get(this.getCtx(), "C_OrderLine_ID=?", line.getC_OrderLine_ID(), line.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.get_TrxName())) == null) continue;
            cd.setProcessed(false);
            cd.delete(true);
        }
        return "";
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public void updateIsDelivered() throws SQLException {
        int delta;
        if (this.isDelivered()) {
            return;
        }
        String query = "SELECT SUM(QtyOrdered-QtyDelivered) FROM C_OrderLine WHERE C_Order_ID=?";
        CPreparedStatement ps = DB.prepareStatement(query, this.get_TrxName());
        ps.setInt(1, this.get_ID());
        ResultSet rs = ps.executeQuery();
        if (rs.next() && (delta = rs.getInt(1)) == 0) {
            this.setIsDelivered(true);
        }
        rs.close();
        ps.close();
    }
}

