/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MIndex;
import org.compiere.model.MNewsChannel;
import org.compiere.model.X_CM_NewsItem;

public class MNewsItem
extends X_CM_NewsItem {
    private static final long serialVersionUID = -8217571535161436997L;

    public MNewsItem(Properties ctx, int CM_NewsItem_ID, String trxName) {
        super(ctx, CM_NewsItem_ID, trxName);
    }

    public MNewsItem(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MNewsChannel getNewsChannel() {
        int[] thisNewsChannel = MNewsChannel.getAllIDs("CM_NewsChannel", "CM_NewsChannel_ID=" + this.getCM_NewsChannel_ID(), this.get_TrxName());
        if (thisNewsChannel != null && thisNewsChannel.length == 1) {
            return new MNewsChannel(this.getCtx(), thisNewsChannel[0], this.get_TrxName());
        }
        return null;
    }

    public StringBuffer get_rss2ItemCode(StringBuffer xmlCode, MNewsChannel thisChannel) {
        if (this != null) {
            xmlCode.append("<item>");
            xmlCode.append("<CM_NewsItem_ID>" + this.get_ID() + "</CM_NewsItem_ID>");
            xmlCode.append("  <title><![CDATA[" + this.getTitle() + "]]></title>");
            xmlCode.append("  <description><![CDATA[" + this.getDescription() + "]]></description>");
            xmlCode.append("  <content><![CDATA[" + this.getContentHTML() + "]]></content>");
            xmlCode.append("  <link>" + thisChannel.getLink() + "?CM_NewsItem_ID=" + this.get_ID() + "</link>");
            xmlCode.append("  <author><![CDATA[" + this.getAuthor() + "]]></author>");
            xmlCode.append("  <pubDate>" + this.getPubDate() + "</pubDate>");
            xmlCode.append("</item>");
        }
        return xmlCode;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!newRecord) {
            MIndex.cleanUp(this.get_TrxName(), this.getAD_Client_ID(), this.get_Table_ID(), this.get_ID());
        }
        this.reIndex(newRecord);
        return success;
    }

    public void reIndex(boolean newRecord) {
        int CMWebProjectID = 0;
        if (this.getNewsChannel() != null) {
            CMWebProjectID = this.getNewsChannel().getCM_WebProject_ID();
        }
        String[] toBeIndexed = new String[]{this.getAuthor(), this.getDescription(), this.getTitle(), this.getContentHTML()};
        MIndex.reIndex(newRecord, toBeIndexed, this.getCtx(), this.getAD_Client_ID(), this.get_Table_ID(), this.get_ID(), CMWebProjectID, this.getUpdated());
    }
}

