/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostQueue;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.model.X_M_CostDetail;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MCostDetail
extends X_M_CostDetail {
    private static final long serialVersionUID = -7882724307127281675L;
    private static CLogger s_log = CLogger.getCLogger(MCostDetail.class);

    public static boolean createOrder(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_OrderLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND C_OrderLine_ID=" + C_OrderLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate(sql, trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "C_OrderLine_ID=?", C_OrderLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setC_OrderLine_ID(C_OrderLine_ID);
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get(as.getCtx(), as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createInvoice(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_InvoiceLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND C_InvoiceLine_ID=" + C_InvoiceLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate(sql, trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "C_InvoiceLine_ID=?", C_InvoiceLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setC_InvoiceLine_ID(C_InvoiceLine_ID);
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get(as.getCtx(), as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createShipment(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InOutLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, boolean IsSOTrx, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_InOutLine_ID=" + M_InOutLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate(sql, trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_InOutLine_ID=?", M_InOutLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_InOutLine_ID(M_InOutLine_ID);
            cd.setIsSOTrx(IsSOTrx);
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get(as.getCtx(), as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createInventory(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InventoryLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_InventoryLine_ID=" + M_InventoryLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate(sql, trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_InventoryLine_ID=?", M_InventoryLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_InventoryLine_ID(M_InventoryLine_ID);
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get(as.getCtx(), as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createMovement(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_MovementLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, boolean from, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_MovementLine_ID=" + M_MovementLine_ID + " AND IsSOTrx=" + (from ? "'Y'" : "'N'") + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate(sql, trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_MovementLine_ID=? AND IsSOTrx=" + (from ? "'Y'" : "'N'"), M_MovementLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_MovementLine_ID(M_MovementLine_ID);
            cd.setIsSOTrx(from);
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get(as.getCtx(), as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createProduction(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_ProductionLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_ProductionLine_ID=" + M_ProductionLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate(sql, trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_ProductionLine_ID=?", M_ProductionLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_ProductionLine_ID(M_ProductionLine_ID);
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get(as.getCtx(), as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + cd);
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MCostDetail get(Properties ctx, String whereClause, int ID, int M_AttributeSetInstance_ID, String trxName) {
        ResultSet rs;
        CPreparedStatement pstmt;
        MCostDetail retValue;
        block6: {
            int C_AcctSchema_ID;
            String sql = "SELECT * FROM M_CostDetail WHERE " + whereClause;
            MClientInfo clientInfo = MClientInfo.get(ctx);
            MAcctSchema primary = clientInfo.getMAcctSchema1();
            int n = C_AcctSchema_ID = primary != null ? primary.getC_AcctSchema_ID() : 0;
            if (C_AcctSchema_ID > 0) {
                sql = sql + " AND C_AcctSchema_ID=?";
            }
            retValue = null;
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, ID);
                pstmt.setInt(2, M_AttributeSetInstance_ID);
                if (C_AcctSchema_ID > 0) {
                    pstmt.setInt(3, C_AcctSchema_ID);
                }
                if (!(rs = pstmt.executeQuery()).next()) break block6;
                retValue = new MCostDetail(ctx, rs, trxName);
            }
            catch (Exception e) {
                try {
                    s_log.log(Level.SEVERE, sql + " - " + ID, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
        }
        DB.close(rs, pstmt);
        return retValue;
    }

    public static MCostDetail get(Properties ctx, String whereClause, int ID, int M_AttributeSetInstance_ID, int C_AcctSchema_ID, String trxName) {
        String localWhereClause = whereClause + " AND M_AttributeSetInstance_ID=?" + " AND C_AcctSchema_ID=?";
        MCostDetail retValue = (MCostDetail)new Query(ctx, "M_CostDetail", localWhereClause, trxName).setParameters(ID, M_AttributeSetInstance_ID, C_AcctSchema_ID).first();
        return retValue;
    }

    public static boolean processProduct(MProduct product, String trxName) {
        String whereClause = "M_Product_ID=? AND Processed=?";
        int counterOK = 0;
        int counterError = 0;
        List list = new Query(product.getCtx(), "M_CostDetail", "M_Product_ID=? AND Processed=?", trxName).setParameters(product.getM_Product_ID(), false).setOrderBy("C_AcctSchema_ID, M_CostElement_ID, AD_Org_ID, M_AttributeSetInstance_ID, Created").list();
        for (MCostDetail cd : list) {
            if (cd.process()) {
                ++counterOK;
                continue;
            }
            ++counterError;
        }
        s_log.config("OK=" + counterOK + ", Errors=" + counterError);
        return counterError == 0;
    }

    public MCostDetail(Properties ctx, int M_CostDetail_ID, String trxName) {
        super(ctx, M_CostDetail_ID, trxName);
        if (M_CostDetail_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setProcessed(false);
            this.setAmt(Env.ZERO);
            this.setQty(Env.ZERO);
            this.setIsSOTrx(false);
            this.setDeltaAmt(Env.ZERO);
            this.setDeltaQty(Env.ZERO);
        }
    }

    public MCostDetail(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCostDetail(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        this(as.getCtx(), 0, trxName);
        this.setClientOrg(as.getAD_Client_ID(), AD_Org_ID);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setM_CostElement_ID(M_CostElement_ID);
        this.setAmt(Amt);
        this.setQty(Qty);
        this.setDescription(Description);
    }

    @Override
    public void setAmt(BigDecimal Amt) {
        if (this.isProcessed()) {
            throw new IllegalStateException("Cannot change Amt - processed");
        }
        if (Amt == null) {
            super.setAmt(Env.ZERO);
        } else {
            super.setAmt(Amt);
        }
    }

    @Override
    public void setQty(BigDecimal Qty) {
        if (this.isProcessed()) {
            throw new IllegalStateException("Cannot change Qty - processed");
        }
        if (Qty == null) {
            super.setQty(Env.ZERO);
        } else {
            super.setQty(Qty);
        }
    }

    public boolean isOrder() {
        return this.getC_OrderLine_ID() != 0;
    }

    public boolean isInvoice() {
        return this.getC_InvoiceLine_ID() != 0;
    }

    public boolean isShipment() {
        return this.isSOTrx() && this.getM_InOutLine_ID() != 0;
    }

    public boolean isDelta() {
        return this.getDeltaAmt().signum() != 0 || this.getDeltaQty().signum() != 0;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        return !this.isProcessed();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MCostDetail[");
        sb.append(this.get_ID());
        if (this.getC_OrderLine_ID() != 0) {
            sb.append(",C_OrderLine_ID=").append(this.getC_OrderLine_ID());
        }
        if (this.getM_InOutLine_ID() != 0) {
            sb.append(",M_InOutLine_ID=").append(this.getM_InOutLine_ID());
        }
        if (this.getC_InvoiceLine_ID() != 0) {
            sb.append(",C_InvoiceLine_ID=").append(this.getC_InvoiceLine_ID());
        }
        if (this.getC_ProjectIssue_ID() != 0) {
            sb.append(",C_ProjectIssue_ID=").append(this.getC_ProjectIssue_ID());
        }
        if (this.getM_MovementLine_ID() != 0) {
            sb.append(",M_MovementLine_ID=").append(this.getM_MovementLine_ID());
        }
        if (this.getM_InventoryLine_ID() != 0) {
            sb.append(",M_InventoryLine_ID=").append(this.getM_InventoryLine_ID());
        }
        if (this.getM_ProductionLine_ID() != 0) {
            sb.append(",M_ProductionLine_ID=").append(this.getM_ProductionLine_ID());
        }
        sb.append(",Amt=").append(this.getAmt()).append(",Qty=").append(this.getQty());
        if (this.isDelta()) {
            sb.append(",DeltaAmt=").append(this.getDeltaAmt()).append(",DeltaQty=").append(this.getDeltaQty());
        }
        sb.append("]");
        return sb.toString();
    }

    public synchronized boolean process() {
        if (this.isProcessed()) {
            this.log.info("Already processed");
            return true;
        }
        boolean ok = false;
        MAcctSchema as = MAcctSchema.get(this.getCtx(), this.getC_AcctSchema_ID());
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        String CostingLevel = product.getCostingLevel(as);
        int Org_ID = this.getAD_Org_ID();
        int M_ASI_ID = this.getM_AttributeSetInstance_ID();
        if ("C".equals(CostingLevel)) {
            Org_ID = 0;
            M_ASI_ID = 0;
        } else if ("O".equals(CostingLevel)) {
            M_ASI_ID = 0;
        } else if ("B".equals(CostingLevel)) {
            Org_ID = 0;
        }
        if (this.getM_CostElement_ID() == 0) {
            MCostElement ce;
            MCostElement[] ces = MCostElement.getCostingMethods(this);
            for (int i2 = 0; i2 < ces.length && (ok = this.process(as, product, ce = ces[i2], Org_ID, M_ASI_ID)); ++i2) {
            }
        } else {
            MCostElement ce = MCostElement.get(this.getCtx(), this.getM_CostElement_ID());
            ok = this.process(as, product, ce, Org_ID, M_ASI_ID);
        }
        if (ok) {
            this.setDeltaAmt(null);
            this.setDeltaQty(null);
            this.setProcessed(true);
            ok = this.save();
        }
        this.log.info(ok + " - " + this.toString());
        return ok;
    }

    private boolean process(MAcctSchema as, MProduct product, MCostElement ce, int Org_ID, int M_ASI_ID) {
        MCost cost = MCost.get(product, M_ASI_ID, as, Org_ID, ce.getM_CostElement_ID(), this.get_TrxName());
        System.out.println(cost.getM_CostElement().getName());
        BigDecimal qty = Env.ZERO;
        BigDecimal amt = Env.ZERO;
        if (this.isDelta()) {
            qty = this.getDeltaQty();
            amt = this.getDeltaAmt();
        } else {
            qty = this.getQty();
            amt = this.getAmt();
        }
        int precision = as.getCostingPrecision();
        BigDecimal price = amt;
        if (qty.signum() != 0) {
            price = amt.divide(qty, precision, 4);
        }
        if (this.getC_OrderLine_ID() != 0) {
            boolean isReturnTrx;
            boolean bl = isReturnTrx = qty.signum() < 0;
            if (ce.isAveragePO()) {
                cost.setWeightedAverage(amt, qty);
                this.log.finer("PO - AveragePO - " + cost);
            } else if (ce.isLastPOPrice()) {
                if (!isReturnTrx) {
                    if (qty.signum() != 0) {
                        cost.setCurrentCostPrice(price);
                    } else {
                        BigDecimal cCosts = cost.getCurrentCostPrice().add(amt);
                        cost.setCurrentCostPrice(cCosts);
                    }
                }
                cost.add(amt, qty);
                this.log.finer("PO - LastPO - " + cost);
            } else if (ce.isUserDefined()) {
                this.log.finer("PO - UserDef - " + cost);
            } else if (!ce.isCostingMethod()) {
                this.log.finer("PO - " + ce + " - " + cost);
            }
        } else if (this.getC_InvoiceLine_ID() != 0) {
            boolean isReturnTrx;
            boolean bl = isReturnTrx = qty.signum() < 0;
            if (ce.isAverageInvoice()) {
                cost.setWeightedAverage(amt, qty);
                this.log.finer("Inv - AverageInv - " + cost);
            } else if (ce.isFifo() || ce.isLifo()) {
                MCostQueue cq = MCostQueue.get(product, this.getM_AttributeSetInstance_ID(), as, Org_ID, ce.getM_CostElement_ID(), this.get_TrxName());
                cq.setCosts(amt, qty, precision);
                cq.save();
                MCostQueue[] cQueue = MCostQueue.getQueue(product, M_ASI_ID, as, Org_ID, ce, this.get_TrxName());
                if (cQueue != null && cQueue.length > 0) {
                    cost.setCurrentCostPrice(cQueue[0].getCurrentCostPrice());
                }
                cost.add(amt, qty);
                this.log.finer("Inv - FiFo/LiFo - " + cost);
            } else if (ce.isLastInvoice()) {
                if (!isReturnTrx) {
                    if (qty.signum() != 0) {
                        cost.setCurrentCostPrice(price);
                    } else {
                        BigDecimal cCosts = cost.getCurrentCostPrice().add(amt);
                        cost.setCurrentCostPrice(cCosts);
                    }
                }
                cost.add(amt, qty);
                this.log.finer("Inv - LastInv - " + cost);
            } else if (ce.isStandardCosting()) {
                if (cost.is_new() && cost.getCurrentCostPrice().signum() == 0 && cost.getCurrentCostPriceLL().signum() == 0) {
                    cost.setCurrentCostPrice(price);
                    if (cost.getCurrentCostPrice().signum() == 0) {
                        cost.setCurrentCostPrice(MCost.getSeedCosts(product, M_ASI_ID, as, Org_ID, ce.getCostingMethod(), this.getC_OrderLine_ID()));
                        this.log.finest("Inv - Standard - CurrentCostPrice(seed)=" + cost.getCurrentCostPrice() + ", price=" + price);
                    }
                }
                cost.add(amt, qty);
                this.log.finer("Inv - Standard - " + cost);
            } else if (ce.isUserDefined()) {
                cost.add(amt, qty);
                this.log.finer("Inv - UserDef - " + cost);
            } else if (!ce.isCostingMethod()) {
                String costingMethod = product.getCostingMethod(as);
                if ("A".equals(costingMethod) || "I".equals(costingMethod)) {
                    String sql = "SELECT COALESCE(SUM(QtyOnHand),0) FROM M_Storage WHERE AD_Client_ID=" + cost.getAD_Client_ID() + " AND M_Product_ID=" + cost.getM_Product_ID();
                    String CostingLevel = product.getCostingLevel(as);
                    if ("O".equals(CostingLevel)) {
                        sql = sql + " AND AD_Org_ID=" + cost.getAD_Org_ID();
                    } else if ("B".equals(CostingLevel)) {
                        sql = sql + " AND M_AttributeSetInstance_ID=" + M_ASI_ID;
                    }
                    BigDecimal qtyOnhand = DB.getSQLValueBD(this.get_TrxName(), sql, new Object[0]);
                    if (qtyOnhand.signum() != 0) {
                        BigDecimal oldSum = cost.getCurrentCostPrice().multiply(cost.getCurrentQty());
                        BigDecimal sumAmt = oldSum.add(amt);
                        BigDecimal costs = sumAmt.divide(qtyOnhand, precision, 4);
                        cost.setCurrentCostPrice(costs);
                    }
                    cost.setCumulatedAmt(cost.getCumulatedAmt().add(amt));
                    cost.setCumulatedQty(cost.getCumulatedQty().add(qty));
                    cost.setCurrentQty(qtyOnhand);
                } else {
                    BigDecimal cCosts = cost.getCurrentCostPrice().add(amt);
                    cost.setCurrentCostPrice(cCosts);
                    cost.add(amt, qty);
                }
                this.log.finer("Inv - Landed Costs - " + cost);
            }
        } else if (this.getM_InOutLine_ID() != 0 || this.getM_MovementLine_ID() != 0 || this.getM_InventoryLine_ID() != 0 || this.getM_ProductionLine_ID() != 0 || this.getC_ProjectIssue_ID() != 0 || this.getPP_Cost_Collector_ID() != 0) {
            MCostElement[] lce;
            boolean addition;
            boolean bl = addition = qty.signum() > 0;
            if (ce.isAverageInvoice()) {
                if (addition) {
                    cost.setWeightedAverage(amt, qty);
                } else {
                    cost.setCurrentQty(cost.getCurrentQty().add(qty));
                }
                this.log.finer("QtyAdjust - AverageInv - " + cost);
            } else if (ce.isAveragePO()) {
                if (addition) {
                    cost.setWeightedAverage(amt, qty);
                } else {
                    cost.setCurrentQty(cost.getCurrentQty().add(qty));
                }
                this.log.finer("QtyAdjust - AveragePO - " + cost);
            } else if (ce.isFifo() || ce.isLifo()) {
                if (addition) {
                    MCostQueue cq = MCostQueue.get(product, this.getM_AttributeSetInstance_ID(), as, Org_ID, ce.getM_CostElement_ID(), this.get_TrxName());
                    cq.setCosts(amt, qty, precision);
                    cq.save();
                } else {
                    MCostQueue.adjustQty(product, M_ASI_ID, as, Org_ID, ce, qty.negate(), this.get_TrxName());
                }
                MCostQueue[] cQueue = MCostQueue.getQueue(product, M_ASI_ID, as, Org_ID, ce, this.get_TrxName());
                if (cQueue != null && cQueue.length > 0) {
                    cost.setCurrentCostPrice(cQueue[0].getCurrentCostPrice());
                }
                cost.setCurrentQty(cost.getCurrentQty().add(qty));
                this.log.finer("QtyAdjust - FiFo/Lifo - " + cost);
            } else if (ce.isLastInvoice()) {
                cost.setCurrentQty(cost.getCurrentQty().add(qty));
                this.log.finer("QtyAdjust - LastInv - " + cost);
            } else if (ce.isLastPOPrice()) {
                cost.setCurrentQty(cost.getCurrentQty().add(qty));
                this.log.finer("QtyAdjust - LastPO - " + cost);
            } else if (ce.isStandardCosting()) {
                if (addition) {
                    cost.add(amt, qty);
                    if (cost.getCurrentCostPrice().signum() == 0 && cost.getCurrentCostPriceLL().signum() == 0 && cost.is_new()) {
                        cost.setCurrentCostPrice(price);
                        this.log.finest("QtyAdjust - Standard - CurrentCostPrice=" + price);
                    }
                } else {
                    cost.setCurrentQty(cost.getCurrentQty().add(qty));
                }
                this.log.finer("QtyAdjust - Standard - " + cost);
            } else if (ce.isUserDefined()) {
                if (addition) {
                    cost.add(amt, qty);
                } else {
                    cost.setCurrentQty(cost.getCurrentQty().add(qty));
                }
                this.log.finer("QtyAdjust - UserDef - " + cost);
            } else if (!ce.isCostingMethod()) {
                this.log.finer("QtyAdjust - ?none? - " + cost);
            } else {
                this.log.warning("QtyAdjust - " + ce + " - " + cost);
            }
            String costingMethod = ce.getCostingMethod();
            if (("A".equals(costingMethod) || "I".equals(costingMethod)) && (lce = MCostElement.getNonCostingMethods(this)).length > 0) {
                String sql = "SELECT COALESCE(SUM(QtyOnHand),0) FROM M_Storage WHERE AD_Client_ID=" + cost.getAD_Client_ID() + " AND M_Product_ID=" + cost.getM_Product_ID();
                String CostingLevel = product.getCostingLevel(as);
                if ("O".equals(CostingLevel)) {
                    sql = sql + " AND AD_Org_ID=" + cost.getAD_Org_ID();
                } else if ("B".equals(CostingLevel)) {
                    sql = sql + " AND M_AttributeSetInstance_ID=" + M_ASI_ID;
                }
                BigDecimal qtyOnhand = DB.getSQLValueBD(this.get_TrxName(), sql, new Object[0]);
                for (int i2 = 0; i2 < lce.length; ++i2) {
                    MCost lCost = MCost.get(this.getCtx(), cost.getAD_Client_ID(), cost.getAD_Org_ID(), cost.getM_Product_ID(), cost.getM_CostType_ID(), cost.getC_AcctSchema_ID(), lce[i2].getM_CostElement_ID(), cost.getM_AttributeSetInstance_ID(), this.get_TrxName());
                    if (lCost == null) continue;
                    if (qtyOnhand.signum() != 0) {
                        BigDecimal oldSum = lCost.getCurrentCostPrice().multiply(lCost.getCurrentQty());
                        BigDecimal costs = oldSum.divide(qtyOnhand, precision, 4);
                        lCost.setCurrentCostPrice(costs);
                    }
                    lCost.setCurrentQty(qtyOnhand);
                    if (lCost.save()) continue;
                    this.log.warning("Update Landed Costs (Qty) fail: " + lce + " - " + lCost);
                    return false;
                }
            }
        } else {
            this.log.warning("Unknown Type: " + this.toString());
            return false;
        }
        this.setCurrentCostPrice(cost.getCurrentCostPrice());
        this.setCurrentQty(cost.getCurrentQty());
        this.setCumulatedAmt(cost.getCumulatedAmt());
        this.setCumulatedQty(cost.getCumulatedQty());
        return cost.save();
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            boolean ok = false;
            MAcctSchema as = new MAcctSchema(this.getCtx(), this.getC_AcctSchema_ID(), null);
            MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
            String CostingLevel = product.getCostingLevel(as);
            int Org_ID = this.getAD_Org_ID();
            int M_ASI_ID = this.getM_AttributeSetInstance_ID();
            if ("C".equals(CostingLevel)) {
                Org_ID = 0;
                M_ASI_ID = 0;
            } else if ("O".equals(CostingLevel)) {
                M_ASI_ID = 0;
            } else if ("B".equals(CostingLevel)) {
                Org_ID = 0;
            }
            if (this.getM_CostElement_ID() == 0) {
                MCostElement ce;
                MCostElement[] ces = MCostElement.getCostingMethods(this);
                for (int i2 = 0; i2 < ces.length && (ok = this.process(as, product, ce = ces[i2], Org_ID, M_ASI_ID)); ++i2) {
                }
            } else {
                MCostElement ce = MCostElement.get(this.getCtx(), this.getM_CostElement_ID());
                ok = this.process(as, product, ce, Org_ID, M_ASI_ID);
            }
            return ok;
        }
        return super.afterDelete(success);
    }
}

