/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCommissionLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Commission;

public class MCommission
extends X_C_Commission {
    private static final long serialVersionUID = 1786202619739310928L;

    public MCommission(Properties ctx, int C_Commission_ID, String trxName) {
        super(ctx, C_Commission_ID, trxName);
        if (C_Commission_ID == 0) {
            this.setDocBasisType("I");
            this.setFrequencyType("M");
            this.setListDetails(false);
        }
    }

    public MCommission(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCommissionLine[] getLines() {
        String whereClause = "IsActive='Y' AND C_Commission_ID=?";
        List<MCommissionLine> list = new Query(this.getCtx(), "C_CommissionLine", "IsActive='Y' AND C_Commission_ID=?", this.get_TrxName()).setParameters(this.getC_Commission_ID()).setOrderBy("Line").list();
        MCommissionLine[] retValue = new MCommissionLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Override
    public void setDateLastRun(Timestamp DateLastRun) {
        if (DateLastRun != null) {
            super.setDateLastRun(DateLastRun);
        }
    }

    public int copyLinesFrom(MCommission otherCom) {
        if (otherCom == null) {
            return 0;
        }
        MCommissionLine[] fromLines = otherCom.getLines();
        int count = 0;
        for (int i2 = 0; i2 < fromLines.length; ++i2) {
            MCommissionLine line = new MCommissionLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(fromLines[i2], line, this.getAD_Client_ID(), this.getAD_Org_ID());
            line.setC_Commission_ID(this.getC_Commission_ID());
            if (!line.save()) continue;
            ++count;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "copyLinesFrom - Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }
}

