/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAccount;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPGroup;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClientInfo;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.model.X_C_BPartner;
import org.compiere.model.X_I_BPartner;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MBPartner
extends X_C_BPartner {
    private static final long serialVersionUID = -3669895599574182217L;
    private static CLogger s_log = CLogger.getCLogger(MBPartner.class);
    private MUser[] m_contacts = null;
    private MBPartnerLocation[] m_locations = null;
    private MBPBankAccount[] m_accounts = null;
    private Integer m_primaryC_BPartner_Location_ID = null;
    private Integer m_primaryAD_User_ID = null;
    private boolean m_TotalOpenBalanceSet = false;
    private MBPGroup m_group = null;

    public static MBPartner getTemplate(Properties ctx, int AD_Client_ID) {
        MBPartner template = MBPartner.getBPartnerCashTrx(ctx, AD_Client_ID);
        if (template == null) {
            template = new MBPartner(ctx, 0, null);
        }
        if (template != null) {
            template.set_ValueNoCheck("C_BPartner_ID", new Integer(0));
            template.setValue("");
            template.setName("");
            template.setName2(null);
            template.setDUNS("");
            template.setFirstSale(null);
            template.setSO_CreditLimit(Env.ZERO);
            template.setSO_CreditUsed(Env.ZERO);
            template.setTotalOpenBalance(Env.ZERO);
            template.setActualLifeTimeValue(Env.ZERO);
            template.setPotentialLifeTimeValue(Env.ZERO);
            template.setAcqusitionCost(Env.ZERO);
            template.setShareOfCustomer(0);
            template.setSalesVolume(0);
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            template.set_ValueNoCheck("Created", ts);
            template.set_ValueNoCheck("Updated", ts);
        }
        return template;
    }

    public static MBPartner getBPartnerCashTrx(Properties ctx, int AD_Client_ID) {
        MBPartner retValue = (MBPartner)MClientInfo.get(ctx, AD_Client_ID).getC_BPartnerCashTrx();
        if (retValue == null) {
            s_log.log(Level.SEVERE, "Not found for AD_Client_ID=" + AD_Client_ID);
        }
        return retValue;
    }

    public static MBPartner get(Properties ctx, String Value) {
        if (Value == null || Value.length() == 0) {
            return null;
        }
        String whereClause = "Value=? AND AD_Client_ID=?";
        MBPartner retValue = (MBPartner)new Query(ctx, "C_BPartner", "Value=? AND AD_Client_ID=?", null).setParameters(Value, Env.getAD_Client_ID(ctx)).firstOnly();
        return retValue;
    }

    public static MBPartner get(Properties ctx, int C_BPartner_ID) {
        String whereClause = "C_BPartner_ID=? AND AD_Client_ID=?";
        MBPartner retValue = (MBPartner)new Query(ctx, "C_BPartner", "C_BPartner_ID=? AND AD_Client_ID=?", null).setParameters(C_BPartner_ID, Env.getAD_Client_ID(ctx)).firstOnly();
        return retValue;
    }

    public static BigDecimal getNotInvoicedAmt(int C_BPartner_ID) {
        BigDecimal retValue = null;
        String sql = "SELECT COALESCE(SUM(COALESCE(currencyBase((ol.QtyDelivered-ol.QtyInvoiced)*ol.PriceActual,o.C_Currency_ID,o.DateOrdered, o.AD_Client_ID,o.AD_Org_ID) ,0)),0) FROM C_OrderLine ol INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) WHERE o.IsSOTrx='Y' AND Bill_BPartner_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MBPartner(Properties ctx) {
        this(ctx, -1, null);
    }

    public MBPartner(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        super(ctx, C_BPartner_ID, trxName);
        if (C_BPartner_ID == -1) {
            this.initTemplate(Env.getContextAsInt(ctx, "AD_Client_ID"));
            C_BPartner_ID = 0;
        }
        if (C_BPartner_ID == 0) {
            this.setIsCustomer(true);
            this.setIsProspect(true);
            this.setSendEMail(false);
            this.setIsOneTime(false);
            this.setIsVendor(false);
            this.setIsSummary(false);
            this.setIsEmployee(false);
            this.setIsSalesRep(false);
            this.setIsTaxExempt(false);
            this.setIsPOTaxExempt(false);
            this.setIsDiscountPrinted(false);
            this.setSO_CreditLimit(Env.ZERO);
            this.setSO_CreditUsed(Env.ZERO);
            this.setTotalOpenBalance(Env.ZERO);
            this.setSOCreditStatus("X");
            this.setFirstSale(null);
            this.setActualLifeTimeValue(Env.ZERO);
            this.setPotentialLifeTimeValue(Env.ZERO);
            this.setAcqusitionCost(Env.ZERO);
            this.setShareOfCustomer(0);
            this.setSalesVolume(0);
        }
        this.log.fine(this.toString());
    }

    public MBPartner(X_I_BPartner impBP) {
        this(impBP.getCtx(), 0, impBP.get_TrxName());
        this.setClientOrg(impBP);
        this.setUpdatedBy(impBP.getUpdatedBy());
        String value = impBP.getValue();
        if (value == null || value.length() == 0) {
            value = impBP.getEMail();
        }
        if (value == null || value.length() == 0) {
            value = impBP.getContactName();
        }
        this.setValue(value);
        String name = impBP.getName();
        if (name == null || name.length() == 0) {
            name = impBP.getContactName();
        }
        if (name == null || name.length() == 0) {
            name = impBP.getEMail();
        }
        this.setName(name);
        this.setName2(impBP.getName2());
        this.setDescription(impBP.getDescription());
        this.setDUNS(impBP.getDUNS());
        this.setTaxID(impBP.getTaxID());
        this.setNAICS(impBP.getNAICS());
        this.setC_BP_Group_ID(impBP.getC_BP_Group_ID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initTemplate(int AD_Client_ID) {
        if (AD_Client_ID == 0) {
            throw new IllegalArgumentException("Client_ID=0");
        }
        boolean success = true;
        String sql = "SELECT * FROM C_BPartner WHERE C_BPartner_ID IN (SELECT C_BPartnerCashTrx_ID FROM AD_ClientInfo WHERE AD_Client_ID=?)";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                success = this.load(rs);
            } else {
                this.load(0, null);
                success = false;
                this.log.severe("None found");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        this.setStandardDefaults();
        this.set_ValueNoCheck("C_BPartner_ID", I_ZERO);
        this.setValue("");
        this.setName("");
        this.setName2(null);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MUser[] getContacts(boolean reload) {
        if (!reload && this.m_contacts != null && this.m_contacts.length != 0) {
            return this.m_contacts;
        }
        ArrayList<MUser> list = new ArrayList<MUser>();
        String sql = "SELECT * FROM AD_User WHERE C_BPartner_ID=? ORDER BY AD_User_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement("SELECT * FROM AD_User WHERE C_BPartner_ID=? ORDER BY AD_User_ID", this.get_TrxName());
            pstmt.setInt(1, this.getC_BPartner_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MUser(this.getCtx(), rs, this.get_TrxName()));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "SELECT * FROM AD_User WHERE C_BPartner_ID=? ORDER BY AD_User_ID", e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_contacts = new MUser[list.size()];
        list.toArray(this.m_contacts);
        return this.m_contacts;
    }

    public MUser getContact(int AD_User_ID) {
        MUser[] users = this.getContacts(false);
        if (users.length == 0) {
            return null;
        }
        for (int i2 = 0; AD_User_ID != 0 && i2 < users.length; ++i2) {
            if (users[i2].getAD_User_ID() != AD_User_ID) continue;
            return users[i2];
        }
        return users[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBPartnerLocation[] getLocations(boolean reload) {
        if (!reload && this.m_locations != null && this.m_locations.length != 0) {
            return this.m_locations;
        }
        ArrayList<MBPartnerLocation> list = new ArrayList<MBPartnerLocation>();
        String sql = "SELECT * FROM C_BPartner_Location WHERE C_BPartner_ID=? AND IsActive='Y' ORDER BY C_BPartner_Location_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement("SELECT * FROM C_BPartner_Location WHERE C_BPartner_ID=? AND IsActive='Y' ORDER BY C_BPartner_Location_ID", this.get_TrxName());
            pstmt.setInt(1, this.getC_BPartner_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MBPartnerLocation(this.getCtx(), rs, this.get_TrxName()));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "SELECT * FROM C_BPartner_Location WHERE C_BPartner_ID=? AND IsActive='Y' ORDER BY C_BPartner_Location_ID", e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_locations = new MBPartnerLocation[list.size()];
        list.toArray(this.m_locations);
        return this.m_locations;
    }

    public MBPartnerLocation getLocation(int C_BPartner_Location_ID) {
        MBPartnerLocation[] locations = this.getLocations(false);
        if (locations.length == 0) {
            return null;
        }
        MBPartnerLocation retValue = null;
        for (int i2 = 0; i2 < locations.length; ++i2) {
            if (locations[i2].getC_BPartner_Location_ID() == C_BPartner_Location_ID) {
                return locations[i2];
            }
            if (retValue != null || !locations[i2].isBillTo()) continue;
            retValue = locations[i2];
        }
        if (retValue == null) {
            return locations[0];
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBPBankAccount[] getBankAccounts(boolean requery) {
        if (this.m_accounts != null && this.m_accounts.length >= 0 && !requery) {
            return this.m_accounts;
        }
        ArrayList<MBPBankAccount> list = new ArrayList<MBPBankAccount>();
        String sql = "SELECT * FROM C_BP_BankAccount WHERE C_BPartner_ID=? AND IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_BPartner_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MBPBankAccount(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        this.m_accounts = new MBPBankAccount[list.size()];
        list.toArray(this.m_accounts);
        return this.m_accounts;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MBPartner[ID=").append(this.get_ID()).append(",Value=").append(this.getValue()).append(",Name=").append(this.getName()).append(",Open=").append(this.getTotalOpenBalance()).append("]");
        return sb.toString();
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void setAD_OrgBP_ID(int AD_OrgBP_ID) {
        if (AD_OrgBP_ID == 0) {
            super.setAD_OrgBP_ID(null);
        } else {
            super.setAD_OrgBP_ID(String.valueOf(AD_OrgBP_ID));
        }
    }

    public int getAD_OrgBP_ID_Int() {
        String org = super.getAD_OrgBP_ID();
        if (org == null) {
            return 0;
        }
        int AD_OrgBP_ID = 0;
        try {
            AD_OrgBP_ID = Integer.parseInt(org);
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, org, ex);
        }
        return AD_OrgBP_ID;
    }

    public int getPrimaryC_BPartner_Location_ID() {
        if (this.m_primaryC_BPartner_Location_ID == null) {
            MBPartnerLocation[] locs = this.getLocations(false);
            for (int i2 = 0; this.m_primaryC_BPartner_Location_ID == null && i2 < locs.length; ++i2) {
                if (!locs[i2].isBillTo()) continue;
                this.setPrimaryC_BPartner_Location_ID(locs[i2].getC_BPartner_Location_ID());
                break;
            }
            if (this.m_primaryC_BPartner_Location_ID == null && locs.length > 0) {
                this.setPrimaryC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.m_primaryC_BPartner_Location_ID == null) {
            return 0;
        }
        return this.m_primaryC_BPartner_Location_ID;
    }

    public MBPartnerLocation getPrimaryC_BPartner_Location() {
        if (this.m_primaryC_BPartner_Location_ID == null) {
            this.m_primaryC_BPartner_Location_ID = this.getPrimaryC_BPartner_Location_ID();
        }
        if (this.m_primaryC_BPartner_Location_ID == null) {
            return null;
        }
        return new MBPartnerLocation(this.getCtx(), this.m_primaryC_BPartner_Location_ID, null);
    }

    public int getPrimaryAD_User_ID() {
        if (this.m_primaryAD_User_ID == null) {
            MUser[] users = this.getContacts(false);
            if (this.m_primaryAD_User_ID == null && users.length > 0) {
                this.setPrimaryAD_User_ID(users[0].getAD_User_ID());
            }
        }
        if (this.m_primaryAD_User_ID == null) {
            return 0;
        }
        return this.m_primaryAD_User_ID;
    }

    public void setPrimaryC_BPartner_Location_ID(int C_BPartner_Location_ID) {
        this.m_primaryC_BPartner_Location_ID = new Integer(C_BPartner_Location_ID);
    }

    public void setPrimaryAD_User_ID(int AD_User_ID) {
        this.m_primaryAD_User_ID = new Integer(AD_User_ID);
    }

    public void setTotalOpenBalance() {
        BigDecimal SO_CreditUsed = null;
        BigDecimal TotalOpenBalance = null;
        String sql = "SELECT COALESCE((SELECT SUM(currencyBase(invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID),i.C_Currency_ID,i.DateInvoiced, i.AD_Client_ID,i.AD_Org_ID)) FROM C_Invoice_v i WHERE i.C_BPartner_ID=bp.C_BPartner_ID AND i.IsSOTrx='Y' AND i.IsPaid='N' AND i.DocStatus IN ('CO','CL')),0), COALESCE((SELECT SUM(currencyBase(invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID),i.C_Currency_ID,i.DateInvoiced, i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP) FROM C_Invoice_v i WHERE i.C_BPartner_ID=bp.C_BPartner_ID AND i.IsPaid='N' AND i.DocStatus IN ('CO','CL')),0) - COALESCE((SELECT SUM(currencyBase(Paymentavailable(p.C_Payment_ID),p.C_Currency_ID,p.DateTrx,p.AD_Client_ID,p.AD_Org_ID)) FROM C_Payment_v p WHERE p.C_BPartner_ID=bp.C_BPartner_ID AND p.IsAllocated='N' AND p.C_Charge_ID IS NULL AND p.DocStatus IN ('CO','CL')),0) FROM C_BPartner bp WHERE C_BPartner_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_BPartner_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                SO_CreditUsed = rs.getBigDecimal(1);
                TotalOpenBalance = rs.getBigDecimal(2);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_TotalOpenBalanceSet = true;
        if (SO_CreditUsed != null) {
            super.setSO_CreditUsed(SO_CreditUsed);
        }
        if (TotalOpenBalance != null) {
            super.setTotalOpenBalance(TotalOpenBalance);
        }
        this.setSOCreditStatus();
    }

    public void setActualLifeTimeValue() {
        BigDecimal ActualLifeTimeValue = null;
        String sql = "SELECT COALESCE ((SELECT SUM(currencyBase(i.GrandTotal,i.C_Currency_ID,i.DateInvoiced, i.AD_Client_ID,i.AD_Org_ID)) FROM C_Invoice_v i WHERE i.C_BPartner_ID=bp.C_BPartner_ID AND i.IsSOTrx='Y' AND i.DocStatus IN ('CO','CL')),0) FROM C_BPartner bp WHERE C_BPartner_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_BPartner_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                ActualLifeTimeValue = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (ActualLifeTimeValue != null) {
            super.setActualLifeTimeValue(ActualLifeTimeValue);
        }
    }

    public BigDecimal getTotalOpenBalance(boolean calculate) {
        if (this.getTotalOpenBalance().signum() == 0 && calculate) {
            this.setTotalOpenBalance();
        }
        return super.getTotalOpenBalance();
    }

    public void setSOCreditStatus() {
        BigDecimal creditLimit = this.getSO_CreditLimit();
        if ("X".equals(this.getSOCreditStatus()) || "S".equals(this.getSOCreditStatus()) || Env.ZERO.compareTo(creditLimit) == 0) {
            return;
        }
        if (creditLimit.compareTo(this.getTotalOpenBalance(!this.m_TotalOpenBalanceSet)) < 0) {
            this.setSOCreditStatus("H");
        } else {
            BigDecimal watchAmt = creditLimit.multiply(this.getCreditWatchRatio());
            if (watchAmt.compareTo(this.getTotalOpenBalance()) < 0) {
                this.setSOCreditStatus("W");
            } else {
                this.setSOCreditStatus("O");
            }
        }
    }

    public String getSOCreditStatus(BigDecimal additionalAmt) {
        if (additionalAmt == null || additionalAmt.signum() == 0) {
            return this.getSOCreditStatus();
        }
        BigDecimal creditLimit = this.getSO_CreditLimit();
        if ("X".equals(this.getSOCreditStatus()) || "S".equals(this.getSOCreditStatus()) || Env.ZERO.compareTo(creditLimit) == 0) {
            return this.getSOCreditStatus();
        }
        if ((creditLimit = creditLimit.subtract(additionalAmt)).compareTo(this.getTotalOpenBalance(!this.m_TotalOpenBalanceSet)) < 0) {
            return "H";
        }
        BigDecimal watchAmt = creditLimit.multiply(this.getCreditWatchRatio());
        if (watchAmt.compareTo(this.getTotalOpenBalance()) < 0) {
            return "W";
        }
        return "O";
    }

    public BigDecimal getCreditWatchRatio() {
        return this.getBPGroup().getCreditWatchRatio();
    }

    public boolean isCreditStopHold() {
        String status = this.getSOCreditStatus();
        return "S".equals(status) || "H".equals(status);
    }

    @Override
    public void setTotalOpenBalance(BigDecimal TotalOpenBalance) {
        this.m_TotalOpenBalanceSet = false;
        super.setTotalOpenBalance(TotalOpenBalance);
    }

    public MBPGroup getBPGroup() {
        if (this.m_group == null) {
            this.m_group = this.getC_BP_Group_ID() == 0 ? MBPGroup.getDefault(this.getCtx()) : MBPGroup.get(this.getCtx(), this.getC_BP_Group_ID());
        }
        return this.m_group;
    }

    public void setBPGroup(MBPGroup group) {
        this.m_group = group;
        if (this.m_group == null) {
            return;
        }
        this.setC_BP_Group_ID(this.m_group.getC_BP_Group_ID());
        if (this.m_group.getC_Dunning_ID() != 0) {
            this.setC_Dunning_ID(this.m_group.getC_Dunning_ID());
        }
        if (this.m_group.getM_PriceList_ID() != 0) {
            this.setM_PriceList_ID(this.m_group.getM_PriceList_ID());
        }
        if (this.m_group.getPO_PriceList_ID() != 0) {
            this.setPO_PriceList_ID(this.m_group.getPO_PriceList_ID());
        }
        if (this.m_group.getM_DiscountSchema_ID() != 0) {
            this.setM_DiscountSchema_ID(this.m_group.getM_DiscountSchema_ID());
        }
        if (this.m_group.getPO_DiscountSchema_ID() != 0) {
            this.setPO_DiscountSchema_ID(this.m_group.getPO_DiscountSchema_ID());
        }
    }

    @Override
    public int getM_PriceList_ID() {
        int ii = super.getM_PriceList_ID();
        if (ii == 0) {
            ii = this.getBPGroup().getM_PriceList_ID();
        }
        return ii;
    }

    @Override
    public int getPO_PriceList_ID() {
        int ii = super.getPO_PriceList_ID();
        if (ii == 0) {
            ii = this.getBPGroup().getPO_PriceList_ID();
        }
        return ii;
    }

    @Override
    public int getM_DiscountSchema_ID() {
        int ii = super.getM_DiscountSchema_ID();
        if (ii == 0) {
            ii = this.getBPGroup().getM_DiscountSchema_ID();
        }
        return ii;
    }

    @Override
    public int getPO_DiscountSchema_ID() {
        int ii = super.getPO_DiscountSchema_ID();
        if (ii == 0) {
            ii = this.getBPGroup().getPO_DiscountSchema_ID();
        }
        return ii;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("C_BP_Group_ID")) {
            MBPGroup grp = this.getBPGroup();
            if (grp == null) {
                this.log.saveWarning("Error", Msg.parseTranslation(this.getCtx(), "@NotFound@:  @C_BP_Group_ID@"));
                return false;
            }
            this.setBPGroup(grp);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            this.insert_Tree("BP");
            this.insert_Accounting("C_BP_Customer_Acct", "C_BP_Group_Acct", "p.C_BP_Group_ID=" + this.getC_BP_Group_ID());
            this.insert_Accounting("C_BP_Vendor_Acct", "C_BP_Group_Acct", "p.C_BP_Group_ID=" + this.getC_BP_Group_ID());
            this.insert_Accounting("C_BP_Employee_Acct", "C_AcctSchema_Default", null);
        }
        if (success && !newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription(this.getCtx(), "C_BPartner_ID=" + this.getC_BPartner_ID(), this.get_TrxName());
        }
        return success;
    }

    @Override
    protected boolean beforeDelete() {
        int nbrUseInPlanning = new Query(this.getCtx(), "Z_Event", " C_BPartner_ID = ? ", null).setOnlyActiveRecords(true).setClient_ID().setParameters(this.getC_BPartner_ID()).count();
        if (nbrUseInPlanning != 0) {
            throw new AdempiereException("Le Tiers est li\u00e9 \u00e0 un \u00e9v\u00e8nement du planning, vous ne pouvez supprimer le Tiers.");
        }
        return this.delete_Accounting("C_BP_Customer_Acct") && this.delete_Accounting("C_BP_Vendor_Acct") && this.delete_Accounting("C_BP_Employee_Acct");
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.delete_Tree("BP");
        }
        return success;
    }
}

