/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MAssetChange;
import org.compiere.model.MAssetDelivery;
import org.compiere.model.MAssetGroup;
import org.compiere.model.MAssetGroupAcct;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductDownload;
import org.compiere.model.MProject;
import org.compiere.model.MRefList;
import org.compiere.model.Query;
import org.compiere.model.X_A_Asset;
import org.compiere.model.X_A_Depreciation_Workfile;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MAsset
extends X_A_Asset {
    private static final long serialVersionUID = -7537696364072606170L;
    private static CLogger s_log = CLogger.getCLogger(MAsset.class);
    private MProduct m_product = null;

    public static MAsset getFromShipment(Properties ctx, int M_InOutLine_ID, String trxName) {
        String whereClause = "M_InOutLine_ID=?";
        MAsset retValue = (MAsset)new Query(ctx, "A_Asset", "M_InOutLine_ID=?", trxName).setParameters(M_InOutLine_ID).first();
        return retValue;
    }

    public MAsset(Properties ctx, int A_Asset_ID, String trxName) {
        super(ctx, A_Asset_ID, trxName);
        if (A_Asset_ID == 0) {
            this.setQty(Env.ONE);
        }
    }

    public MAsset(Properties ctx, int A_Asset_ID) {
        this(ctx, A_Asset_ID, null);
    }

    public MAsset(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAsset(MInOut shipment, MInOutLine shipLine, int deliveryCount) {
        this(shipment.getCtx(), 0, shipment.get_TrxName());
        this.setClientOrg(shipment);
        this.setValueNameDescription(shipment, shipLine, deliveryCount);
        this.setAssetServiceDate(shipment.getMovementDate());
        this.setIsOwned(false);
        this.setC_BPartner_ID(shipment.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(shipment.getC_BPartner_Location_ID());
        this.setAD_User_ID(shipment.getAD_User_ID());
        MProduct product = shipLine.getProduct();
        this.setM_Product_ID(product.getM_Product_ID());
        this.setA_Asset_Group_ID(product.getA_Asset_Group_ID());
        this.setGuaranteeDate(TimeUtil.addDays(shipment.getMovementDate(), product.getGuaranteeDays()));
        this.setVersionNo(product.getVersionNo());
        if (shipLine.getM_AttributeSetInstance_ID() != 0) {
            MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), shipLine.getM_AttributeSetInstance_ID(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
            this.setLot(asi.getLot());
            this.setSerNo(asi.getSerNo());
        }
        this.setHelp(shipLine.getDescription());
        if (deliveryCount != 0) {
            this.setQty(shipLine.getMovementQty());
        }
        this.setM_InOutLine_ID(shipLine.getM_InOutLine_ID());
        MAssetGroup ag = MAssetGroup.get(this.getCtx(), this.getA_Asset_Group_ID());
        if (!ag.isCreateAsActive()) {
            this.setIsActive(false);
        }
    }

    public void setValueNameDescription(MInOut shipment, MInOutLine line, int deliveryCount) {
        MProduct product = line.getProduct();
        MBPartner partner = shipment.getBPartner();
        this.setValueNameDescription(shipment, deliveryCount, product, partner);
    }

    public void setValueNameDescription(MInOut shipment, int deliveryCount, MProduct product, MBPartner partner) {
        String value;
        String documentNo = "_" + shipment.getDocumentNo();
        if (deliveryCount > 1) {
            documentNo = documentNo + "_" + deliveryCount;
        }
        if ((value = partner.getValue() + "_" + product.getValue()).length() > 40 - documentNo.length()) {
            value = value.substring(0, 40 - documentNo.length()) + documentNo;
        }
        this.setValue(value);
        String name = partner.getName() + " - " + product.getName();
        if (name.length() > 60) {
            name = name.substring(0, 60);
        }
        this.setName(name);
        String description = product.getDescription();
        this.setDescription(description);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    @Override
    public BigDecimal getQty() {
        BigDecimal qty = super.getQty();
        if (qty == null || qty.compareTo(Env.ZERO) == 0) {
            this.setQty(Env.ONE);
        }
        return super.getQty();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MAsset[").append(this.get_ID()).append("-").append(this.getValue()).append("]");
        return sb.toString();
    }

    public MAssetDelivery[] getDeliveries() {
        String whereClause = "A_Asset_ID=?";
        List<MAssetDelivery> list = new Query(this.getCtx(), "A_Asset_Delivery", "A_Asset_ID=?", this.get_TrxName()).setParameters(this.getA_Asset_ID()).setOrderBy("Created DESC").list();
        MAssetDelivery[] retValue = new MAssetDelivery[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int getDeliveryCount() {
        String sql = "SELECT COUNT(*) FROM A_Asset_Delivery WHERE A_Asset_ID=?";
        return DB.getSQLValue(this.get_TrxName(), sql, this.getA_Asset_ID());
    }

    public boolean isDownloadable() {
        if (!this.isActive()) {
            return false;
        }
        Timestamp guarantee = this.getGuaranteeDate();
        if (guarantee == null) {
            return false;
        }
        guarantee = TimeUtil.getDay(guarantee);
        Timestamp now = TimeUtil.getDay(System.currentTimeMillis());
        if (!now.after(guarantee)) {
            this.getProduct();
            return this.m_product != null && this.m_product.hasDownloads();
        }
        return false;
    }

    public String getProductVersionNo() {
        return this.getProduct().getVersionNo();
    }

    public int getProductR_MailText_ID() {
        return this.getProduct().getR_MailText_ID();
    }

    private MProduct getProduct() {
        if (this.m_product == null) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    public MProductDownload[] getProductDownloads() {
        if (this.m_product == null) {
            this.getProduct();
        }
        if (this.m_product != null) {
            return this.m_product.getProductDownloads(false);
        }
        return null;
    }

    public String[] getDownloadNames() {
        MProductDownload[] dls = this.getProductDownloads();
        if (dls != null && dls.length > 0) {
            String[] retValue = new String[dls.length];
            for (int i2 = 0; i2 < retValue.length; ++i2) {
                retValue[i2] = dls[i2].getName();
            }
            this.log.fine("#" + dls.length);
            return retValue;
        }
        return new String[0];
    }

    public String[] getDownloadURLs() {
        MProductDownload[] dls = this.getProductDownloads();
        if (dls != null && dls.length > 0) {
            String[] retValue = new String[dls.length];
            for (int i2 = 0; i2 < retValue.length; ++i2) {
                String url = dls[i2].getDownloadURL();
                int pos = Math.max(url.lastIndexOf(47), url.lastIndexOf(92));
                if (pos != -1) {
                    url = url.substring(pos + 1);
                }
                retValue[i2] = url;
            }
            return retValue;
        }
        return new String[0];
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.getQty();
        if (this.getA_Parent_Asset_ID() < 1) {
            this.setA_Parent_Asset_ID(this.getA_Asset_ID());
        }
        if (this.getC_Project_ID() <= 0) {
            MProject mProject = new MProject(this.getCtx(), 0, this.get_TrxName());
            mProject.setName(this.getName() + (StringUtils.isEmpty((String)this.getSerNo()) ? "" : "_" + this.getSerNo()));
            mProject.setC_BPartner_ID(this.getC_BPartner_ID());
            mProject.setAD_Org_ID(this.getAD_Org_ID());
            mProject.setAD_Client_ID(this.getAD_Client_ID());
            mProject.setC_Currency_ID(102);
            mProject.setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
            mProject.setAD_User_ID(this.getAD_User_ID());
            if (!mProject.save(this.get_TrxName())) {
                return false;
            }
            this.setC_Project_ID(mProject.getC_Project_ID());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        this.log.info("afterSave");
        int p_A_Asset_ID = 0;
        p_A_Asset_ID = this.getA_Asset_ID();
        String sql = "SELECT COUNT(*) FROM A_Depreciation_Workfile WHERE A_Asset_ID=?";
        CPreparedStatement pstmt = null;
        if (DB.getSQLValue(this.get_TrxName(), sql, p_A_Asset_ID) == 0) {
            sql = "SELECT * FROM A_Asset_Group_Acct WHERE A_Asset_Group_ID = ? AND IsActive='Y'";
            pstmt = null;
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            try {
                pstmt.setInt(1, this.getA_Asset_Group_ID());
                ResultSet rs = pstmt.executeQuery();
                int uselifemonths = 0;
                int uselifeyears = 0;
                boolean isdepreciate = false;
                MAssetChange change = new MAssetChange(this.getCtx(), 0, this.get_TrxName());
                X_A_Asset asset = new X_A_Asset(this.getCtx(), p_A_Asset_ID, this.get_TrxName());
                if (this.getA_Parent_Asset_ID() < 1) {
                    asset.setA_Parent_Asset_ID(this.getA_Asset_ID());
                    asset.save();
                }
                while (rs.next()) {
                    MAssetGroupAcct assetgrpacct = new MAssetGroupAcct(this.getCtx(), rs, this.get_TrxName());
                    MAssetAcct assetacct = new MAssetAcct(this.getCtx(), 0, this.get_TrxName());
                    isdepreciate = assetgrpacct.isProcessing();
                    if (this.isDepreciated() | isdepreciate) {
                        assetacct.setPostingType(assetgrpacct.getPostingType());
                        assetacct.setA_Split_Percent(assetgrpacct.getA_Split_Percent());
                        assetacct.setA_Depreciation_Conv_ID(assetgrpacct.getConventionType());
                        assetacct.setA_Salvage_Value(new BigDecimal(0.0));
                        assetacct.setA_Asset_ID(p_A_Asset_ID);
                        assetacct.setA_Depreciation_ID(assetgrpacct.getDepreciationType());
                        assetacct.setA_Asset_Spread_ID(assetgrpacct.getA_Asset_Spread_Type());
                        assetacct.setA_Period_Start(1);
                        if (this.getUseLifeMonths() == 0 & this.getUseLifeYears() == 0) {
                            assetacct.setA_Period_End(assetgrpacct.getUseLifeMonths());
                            asset.setUseLifeYears(assetgrpacct.getUseLifeYears());
                            asset.setUseLifeMonths(assetgrpacct.getUseLifeMonths());
                            asset.setIsDepreciated(true);
                            asset.setIsOwned(true);
                            asset.save();
                            uselifemonths = assetgrpacct.getUseLifeMonths();
                            uselifeyears = assetgrpacct.getUseLifeYears();
                        } else if (this.getUseLifeMonths() == 0) {
                            assetacct.setA_Period_End(this.getUseLifeYears() * 12);
                            asset.setUseLifeMonths(this.getUseLifeYears() * 12);
                            asset.setIsDepreciated(true);
                            asset.setIsOwned(true);
                            asset.save();
                            uselifemonths = this.getUseLifeYears() * 12;
                            uselifeyears = this.getUseLifeYears();
                        } else {
                            assetacct.setA_Period_End(this.getUseLifeMonths());
                            uselifemonths = this.getUseLifeMonths();
                            uselifeyears = this.getUseLifeYears();
                        }
                        assetacct.setA_Depreciation_Method_ID(assetgrpacct.getA_Depreciation_Calc_Type());
                        assetacct.setA_Asset_Acct(assetgrpacct.getA_Asset_Acct());
                        assetacct.setC_AcctSchema_ID(assetgrpacct.getC_AcctSchema_ID());
                        assetacct.setA_Accumdepreciation_Acct(assetgrpacct.getA_Accumdepreciation_Acct());
                        assetacct.setA_Depreciation_Acct(assetgrpacct.getA_Depreciation_Acct());
                        assetacct.setA_Disposal_Revenue(assetgrpacct.getA_Disposal_Revenue());
                        assetacct.setA_Disposal_Loss(assetgrpacct.getA_Disposal_Loss());
                        assetacct.setA_Reval_Accumdep_Offset_Cur(assetgrpacct.getA_Reval_Accumdep_Offset_Cur());
                        assetacct.setA_Reval_Accumdep_Offset_Prior(assetgrpacct.getA_Reval_Accumdep_Offset_Prior());
                        if (assetgrpacct.getA_Reval_Cal_Method() == null) {
                            assetacct.setA_Reval_Cal_Method("DFT");
                        } else {
                            assetacct.setA_Reval_Cal_Method(assetgrpacct.getA_Reval_Cal_Method());
                        }
                        assetacct.setA_Reval_Cost_Offset(assetgrpacct.getA_Reval_Cost_Offset());
                        assetacct.setA_Reval_Cost_Offset_Prior(assetgrpacct.getA_Reval_Cost_Offset_Prior());
                        assetacct.setA_Reval_Depexp_Offset(assetgrpacct.getA_Reval_Depexp_Offset());
                        assetacct.setA_Depreciation_Manual_Amount(assetgrpacct.getA_Depreciation_Manual_Amount());
                        assetacct.setA_Depreciation_Manual_Period(assetgrpacct.getA_Depreciation_Manual_Period());
                        assetacct.setA_Depreciation_Table_Header_ID(assetgrpacct.getA_Depreciation_Table_Header_ID());
                        assetacct.setA_Depreciation_Variable_Perc(assetgrpacct.getA_Depreciation_Variable_Perc());
                        assetacct.setProcessing(false);
                        assetacct.save();
                        change.setPostingType(assetacct.getPostingType());
                        change.setA_Split_Percent(assetacct.getA_Split_Percent());
                        change.setConventionType(assetacct.getA_Depreciation_Conv_ID());
                        change.setA_Asset_ID(p_A_Asset_ID);
                        change.setDepreciationType(assetacct.getA_Depreciation_ID());
                        change.setA_Asset_Spread_Type(assetacct.getA_Asset_Spread_ID());
                        change.setA_Period_Start(assetacct.getA_Period_Start());
                        change.setA_Period_End(assetacct.getA_Period_End());
                        change.setIsInPosession(this.isOwned());
                        change.setIsDisposed(this.isDisposed());
                        change.setIsDepreciated(this.isDepreciated());
                        change.setIsFullyDepreciated(this.isFullyDepreciated());
                        change.setA_Depreciation_Calc_Type(assetacct.getA_Depreciation_Method_ID());
                        change.setA_Asset_Acct(assetacct.getA_Asset_Acct());
                        change.setC_AcctSchema_ID(assetacct.getC_AcctSchema_ID());
                        change.setA_Accumdepreciation_Acct(assetacct.getA_Accumdepreciation_Acct());
                        change.setA_Depreciation_Acct(assetacct.getA_Depreciation_Acct());
                        change.setA_Disposal_Revenue(assetacct.getA_Disposal_Revenue());
                        change.setA_Disposal_Loss(assetacct.getA_Disposal_Loss());
                        change.setA_Reval_Accumdep_Offset_Cur(assetacct.getA_Reval_Accumdep_Offset_Cur());
                        change.setA_Reval_Accumdep_Offset_Prior(assetacct.getA_Reval_Accumdep_Offset_Prior());
                        if (assetacct.getA_Reval_Cal_Method() == null) {
                            change.setA_Reval_Cal_Method("DFT");
                        } else {
                            change.setA_Reval_Cal_Method(assetacct.getA_Reval_Cal_Method());
                        }
                        change.setA_Reval_Cost_Offset(assetacct.getA_Reval_Cost_Offset());
                        change.setA_Reval_Cost_Offset_Prior(assetacct.getA_Reval_Cost_Offset_Prior());
                        change.setA_Reval_Depexp_Offset(assetacct.getA_Reval_Depexp_Offset());
                        change.setA_Depreciation_Manual_Amount(assetacct.getA_Depreciation_Manual_Amount());
                        change.setA_Depreciation_Manual_Period(assetacct.getA_Depreciation_Manual_Period());
                        change.setA_Depreciation_Table_Header_ID(assetacct.getA_Depreciation_Table_Header_ID());
                        change.setA_Depreciation_Variable_Perc(assetacct.getA_Depreciation_Variable_Perc());
                    }
                    String sql2 = "SELECT COUNT(*) FROM A_Depreciation_Workfile WHERE A_Asset_ID=? AND PostingType = ?";
                    if (DB.getSQLValue(this.get_TrxName(), sql2, asset.getA_Asset_ID(), assetgrpacct.getPostingType()) != 0 || !(this.isDepreciated() | isdepreciate)) continue;
                    X_A_Depreciation_Workfile assetwk = new X_A_Depreciation_Workfile(this.getCtx(), 0, this.get_TrxName());
                    assetwk.setA_Asset_ID(p_A_Asset_ID);
                    assetwk.setA_Life_Period(uselifemonths);
                    assetwk.setA_Asset_Life_Years(uselifeyears);
                    assetwk.setIsDepreciated(this.isDepreciated());
                    assetwk.setPostingType(assetgrpacct.getPostingType());
                    assetwk.setA_Accumulated_Depr(new BigDecimal(0.0));
                    assetwk.setA_QTY_Current(new BigDecimal(0.0));
                    assetwk.setA_Asset_Cost(new BigDecimal(0.0));
                    assetwk.setA_Period_Posted(0);
                    assetwk.save();
                }
                change.setA_Asset_ID(p_A_Asset_ID);
                change.setA_Parent_Asset_ID(asset.getA_Parent_Asset_ID());
                change.setChangeType("CRT");
                change.setTextDetails(MRefList.getListDescription(this.getCtx(), "A_Update_Type", "CRT"));
                change.setIsInPosession(this.isOwned());
                change.setIsDisposed(this.isDisposed());
                change.setIsDepreciated(this.isDepreciated());
                change.setIsFullyDepreciated(this.isFullyDepreciated());
                change.setLot(this.getLot());
                change.setSerNo(this.getSerNo());
                change.setVersionNo(this.getVersionNo());
                change.setUseLifeMonths(this.getUseLifeMonths());
                change.setUseLifeYears(this.getUseLifeYears());
                change.setLifeUseUnits(this.getLifeUseUnits());
                change.setAssetDisposalDate(this.getAssetDisposalDate());
                change.setAssetServiceDate(this.getAssetServiceDate());
                change.setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
                change.setC_BPartner_ID(this.getC_BPartner_ID());
                change.setA_QTY_Current(this.getA_QTY_Current());
                change.setA_QTY_Original(this.getA_QTY_Original());
                change.setA_Asset_CreateDate(this.getA_Asset_CreateDate());
                change.setAD_User_ID(this.getAD_User_ID());
                change.setC_Location_ID(this.getC_Location_ID());
                change.save();
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.info("getAssets" + e);
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception e) {}
                pstmt = null;
            }
        } else {
            ResultSet rs;
            int uselifemonths = 0;
            int uselifeyears = 0;
            sql = "SELECT * FROM A_Asset_Acct WHERE A_Asset_ID = ? AND IsActive='Y'";
            pstmt = null;
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            try {
                pstmt.setInt(1, this.getA_Asset_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MAssetAcct assetacct = new MAssetAcct(this.getCtx(), rs, this.get_TrxName());
                    assetacct.setProcessing(false);
                    assetacct.setA_Asset_ID(p_A_Asset_ID);
                    assetacct.setA_Period_Start(1);
                    if (this.getUseLifeMonths() == 0) {
                        assetacct.setA_Period_End(this.getUseLifeYears() * 12);
                        this.setUseLifeMonths(this.getUseLifeYears() * 12);
                        uselifemonths = this.getUseLifeYears() * 12;
                        uselifeyears = this.getUseLifeYears();
                    } else {
                        assetacct.setA_Period_End(this.getUseLifeMonths());
                        uselifemonths = this.getUseLifeMonths();
                        uselifeyears = this.getUseLifeYears();
                    }
                    assetacct.save();
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.info("getAssets" + e);
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception e) {}
                pstmt = null;
            }
            sql = "SELECT * FROM A_Depreciation_Workfile WHERE A_Asset_ID=? AND IsActive='Y'";
            pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, p_A_Asset_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_A_Depreciation_Workfile assetwk = new X_A_Depreciation_Workfile(this.getCtx(), rs, this.get_TrxName());
                    assetwk.setA_Asset_ID(p_A_Asset_ID);
                    assetwk.setA_Life_Period(uselifemonths);
                    assetwk.setA_Asset_Life_Years(uselifeyears);
                    assetwk.setIsDepreciated(this.isDepreciated());
                    assetwk.save();
                    if (this.isProcessing()) {
                        MAssetChange change = new MAssetChange(this.getCtx(), 0, this.get_TrxName());
                        change.setA_Asset_ID(p_A_Asset_ID);
                        change.setChangeType("UPD");
                        change.setTextDetails(MRefList.getListDescription(this.getCtx(), "A_Update_Type", "UPD"));
                        change.setLot(this.getLot());
                        change.setSerNo(this.getSerNo());
                        change.setVersionNo(this.getVersionNo());
                        change.setA_Parent_Asset_ID(this.getA_Parent_Asset_ID());
                        change.setUseLifeMonths(this.getUseLifeMonths());
                        change.setUseLifeYears(this.getUseLifeYears());
                        change.setLifeUseUnits(this.getLifeUseUnits());
                        change.setAssetDisposalDate(this.getAssetDisposalDate());
                        change.setAssetServiceDate(this.getAssetServiceDate());
                        change.setIsInPosession(this.isOwned());
                        change.setA_Reval_Cal_Method("DFT");
                        change.setIsDisposed(this.isDisposed());
                        change.setIsDepreciated(this.isDepreciated());
                        change.setIsFullyDepreciated(this.isFullyDepreciated());
                        change.setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
                        change.setC_BPartner_ID(this.getC_BPartner_ID());
                        change.setPostingType("A");
                        change.setA_QTY_Current(this.getA_QTY_Current());
                        change.setA_QTY_Original(this.getA_QTY_Original());
                        change.setA_Asset_CreateDate(this.getA_Asset_CreateDate());
                        change.setAD_User_ID(this.getAD_User_ID());
                        change.setC_Location_ID(this.getC_Location_ID());
                        change.save();
                        continue;
                    }
                    X_A_Asset asset = new X_A_Asset(this.getCtx(), p_A_Asset_ID, this.get_TrxName());
                    asset.setProcessing(true);
                    asset.save();
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.info("getAssets" + e);
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception e) {}
                pstmt = null;
            }
        }
        return true;
    }
}

