/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.model.MClient;
import org.compiere.model.PrintInfo;
import org.compiere.model.X_AD_Archive;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MArchive
extends X_AD_Archive {
    private static final long serialVersionUID = -3476918478008050158L;
    private static CLogger s_log = CLogger.getCLogger(MArchive.class);
    private Integer m_inflated = null;
    private Integer m_deflated = null;
    private boolean isStoreArchiveOnFileSystem = false;
    private String m_archivePathRoot = "";
    private final String ARCHIVE_FOLDER_PLACEHOLDER = "%ARCHIVE_FOLDER%";

    public static MArchive[] get(Properties ctx, String whereClause) {
        ArrayList<MArchive> list = new ArrayList<MArchive>();
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM AD_Archive WHERE AD_Client_ID=?";
        if (whereClause != null && whereClause.length() > 0) {
            sql = sql + whereClause;
        }
        sql = sql + " ORDER BY Created";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, Env.getAD_Client_ID(ctx));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MArchive(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (list.size() == 0) {
            s_log.fine(sql);
        } else {
            s_log.finer(sql);
        }
        MArchive[] retValue = new MArchive[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MArchive(Properties ctx, int AD_Archive_ID, String trxName) {
        super(ctx, AD_Archive_ID, trxName);
        this.initArchiveStoreDetails(ctx, trxName);
    }

    public MArchive(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.initArchiveStoreDetails(ctx, trxName);
    }

    public MArchive(Properties ctx, PrintInfo info, String trxName) {
        this(ctx, 0, trxName);
        this.setName(info.getName());
        this.setIsReport(info.isReport());
        this.setAD_Process_ID(info.getAD_Process_ID());
        this.setAD_Table_ID(info.getAD_Table_ID());
        this.setRecord_ID(info.getRecord_ID());
        this.setC_BPartner_ID(info.getC_BPartner_ID());
        this.initArchiveStoreDetails(ctx, trxName);
    }

    private void initArchiveStoreDetails(Properties ctx, String trxName) {
        MClient client = new MClient(ctx, this.getAD_Client_ID(), trxName);
        this.isStoreArchiveOnFileSystem = client.isStoreArchiveOnFileSystem();
        if (this.isStoreArchiveOnFileSystem) {
            this.m_archivePathRoot = File.separatorChar == '\\' ? client.getWindowsArchivePath() : client.getUnixArchivePath();
            if ("".equals(this.m_archivePathRoot)) {
                this.log.severe("no archivePath defined");
            } else if (!this.m_archivePathRoot.endsWith(File.separator)) {
                this.log.warning("archive path doesn't end with " + File.separator);
                this.m_archivePathRoot = this.m_archivePathRoot + File.separator;
                this.log.fine(this.m_archivePathRoot);
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MArchive[");
        sb.append(this.get_ID()).append(",Name=").append(this.getName());
        if (this.m_inflated != null) {
            sb.append(",Inflated=" + this.m_inflated);
        }
        if (this.m_deflated != null) {
            sb.append(",Deflated=" + this.m_deflated);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public byte[] getBinaryData() {
        if (this.isStoreArchiveOnFileSystem) {
            return this.getBinaryDataFromFileSystem();
        }
        return this.getBinaryDataFromDB();
    }

    private byte[] getBinaryDataFromFileSystem() {
        if ("".equals(this.m_archivePathRoot)) {
            throw new IllegalArgumentException("no attachmentPath defined");
        }
        byte[] data = super.getBinaryData();
        this.m_deflated = null;
        this.m_inflated = null;
        if (data == null) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Node entryNode;
            NamedNodeMap attributes;
            Node fileNode;
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(data));
            NodeList entries = document.getElementsByTagName("entry");
            if (entries.getLength() != 1) {
                this.log.severe("no archive entry found");
            }
            if ((fileNode = (attributes = (entryNode = entries.item(0)).getAttributes()).getNamedItem("file")) == null) {
                this.log.severe("no filename for entry");
                return null;
            }
            String filePath = fileNode.getNodeValue();
            this.log.fine("filePath: " + filePath);
            if (filePath != null) {
                filePath = filePath.replaceFirst("%ARCHIVE_FOLDER%", this.m_archivePathRoot.replaceAll("\\\\", "\\\\\\\\"));
                String replaceSeparator = File.separator;
                if (!replaceSeparator.equals("/")) {
                    replaceSeparator = "\\\\";
                }
                filePath = filePath.replaceAll("/", replaceSeparator);
                filePath = filePath.replaceAll("\\\\", replaceSeparator);
            }
            this.log.fine("filePath: " + filePath);
            File file = new File(filePath);
            if (file.exists()) {
                byte[] dataEntry = new byte[(int)file.length()];
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    fileInputStream.read(dataEntry);
                    fileInputStream.close();
                }
                catch (FileNotFoundException e) {
                    this.log.severe("File Not Found.");
                    e.printStackTrace();
                }
                catch (IOException e1) {
                    this.log.severe("Error Reading The File.");
                    e1.printStackTrace();
                }
                return dataEntry;
            }
            this.log.severe("file not found: " + file.getAbsolutePath());
            return null;
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
            this.log.severe(x.getMessage());
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            this.log.severe(pce.getMessage());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.log.severe(ioe.getMessage());
        }
        return null;
    }

    private byte[] getBinaryDataFromDB() {
        byte[] deflatedData = super.getBinaryData();
        this.m_deflated = null;
        this.m_inflated = null;
        if (deflatedData == null) {
            return null;
        }
        this.log.fine("ZipSize=" + deflatedData.length);
        this.m_deflated = new Integer(deflatedData.length);
        if (deflatedData.length == 0) {
            return null;
        }
        byte[] inflatedData = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(deflatedData);
            ZipInputStream zip = new ZipInputStream(in);
            ZipEntry entry = zip.getNextEntry();
            if (entry != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[2048];
                int length = zip.read(buffer);
                while (length != -1) {
                    out.write(buffer, 0, length);
                    length = zip.read(buffer);
                }
                inflatedData = out.toByteArray();
                this.log.fine("Size=" + inflatedData.length + " - zip=" + entry.getCompressedSize() + "(" + entry.getSize() + ") " + entry.getCompressedSize() * 100L / entry.getSize() + "%");
                this.m_inflated = new Integer(inflatedData.length);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            inflatedData = null;
        }
        return inflatedData;
    }

    public InputStream getInputStream() {
        byte[] inflatedData = this.getBinaryData();
        if (inflatedData == null) {
            return null;
        }
        return new ByteArrayInputStream(inflatedData);
    }

    @Override
    public void setBinaryData(byte[] inflatedData) {
        if (this.isStoreArchiveOnFileSystem) {
            this.saveBinaryDataIntoFileSystem(inflatedData);
        } else {
            this.saveBinaryDataIntoDB(inflatedData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBinaryDataIntoFileSystem(byte[] inflatedData) {
        if ("".equals(this.m_archivePathRoot)) {
            throw new IllegalArgumentException("no attachmentPath defined");
        }
        if (inflatedData == null || inflatedData.length == 0) {
            throw new IllegalArgumentException("InflatedData is NULL");
        }
        if (this.get_ID() == 0) {
            super.setBinaryData(new byte[]{48});
            if (!this.save()) {
                throw new IllegalArgumentException("unable to save MArchive");
            }
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        FilterOutputStream out = null;
        try {
            File destFolder = new File(this.m_archivePathRoot + File.separator + this.getArchivePathSnippet());
            if (!destFolder.exists() && !destFolder.mkdirs()) {
                this.log.warning("unable to create folder: " + destFolder.getPath());
            }
            File destFile = new File(this.m_archivePathRoot + File.separator + this.getArchivePathSnippet() + this.get_ID() + ".pdf");
            out = new BufferedOutputStream(new FileOutputStream(destFile));
            out.write(inflatedData);
            ((BufferedOutputStream)out).flush();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement("archive");
            document.appendChild(root);
            document.setXmlStandalone(true);
            Element entry = document.createElement("entry");
            entry.setAttribute("file", "%ARCHIVE_FOLDER%" + this.getArchivePathSnippet() + this.get_ID() + ".pdf");
            root.appendChild(entry);
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bos);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            byte[] xmlData = bos.toByteArray();
            this.log.fine(bos.toString());
            super.setBinaryData(xmlData);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "saveLOBData", e);
            this.m_deflated = null;
            super.setBinaryData(null);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void saveBinaryDataIntoDB(byte[] inflatedData) {
        if (inflatedData == null || inflatedData.length == 0) {
            throw new IllegalArgumentException("InflatedData is NULL");
        }
        this.m_inflated = new Integer(inflatedData.length);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(out);
        zip.setMethod(8);
        zip.setLevel(9);
        zip.setComment("adempiere");
        byte[] deflatedData = null;
        try {
            ZipEntry entry = new ZipEntry("AdempiereArchive");
            entry.setTime(System.currentTimeMillis());
            entry.setMethod(8);
            zip.putNextEntry(entry);
            zip.write(inflatedData, 0, inflatedData.length);
            zip.closeEntry();
            this.log.fine(entry.getCompressedSize() + " (" + entry.getSize() + ") " + entry.getCompressedSize() * 100L / entry.getSize() + "%");
            zip.close();
            deflatedData = out.toByteArray();
            this.log.fine("Length=" + inflatedData.length);
            this.m_deflated = new Integer(deflatedData.length);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "saveLOBData", e);
            deflatedData = null;
            this.m_deflated = null;
        }
        super.setBinaryData(deflatedData);
    }

    public String getCreatedByName() {
        String name = "?";
        String sql = "SELECT Name FROM AD_User WHERE AD_User_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getCreatedBy());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                name = rs.getString(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return name;
    }

    private String getArchivePathSnippet() {
        String path = this.getAD_Client_ID() + File.separator + this.getAD_Org_ID() + File.separator;
        if (this.getAD_Process_ID() > 0) {
            path = path + this.getAD_Process_ID() + File.separator;
        }
        if (this.getAD_Table_ID() > 0) {
            path = path + this.getAD_Table_ID() + File.separator;
        }
        if (this.getRecord_ID() > 0) {
            path = path + this.getRecord_ID() + File.separator;
        }
        return path;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        byte[] data = super.getBinaryData();
        if (data == null || data.length == 0) {
            return false;
        }
        this.log.fine(this.toString());
        return true;
    }
}

