/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.script.ScriptEngine;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import org.compiere.model.Callout;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridTabVO;
import org.compiere.model.GridTable;
import org.compiere.model.GridWindow;
import org.compiere.model.MColumn;
import org.compiere.model.MImage;
import org.compiere.model.MLookup;
import org.compiere.model.MPrivateAccess;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MRule;
import org.compiere.model.MultiMap;
import org.compiere.model.StateChangeEvent;
import org.compiere.model.StateChangeListener;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class GridTab
implements DataStatusListener,
Evaluatee,
Serializable {
    private static final long serialVersionUID = -3825605601192688998L;
    public static final String DEFAULT_STATUS_MESSAGE = "NavigateOrUpdate";
    private GridTabVO m_vo;
    private GridWindow m_window;
    private GridTable m_mTable = null;
    private String m_keyColumnName = "";
    private String m_linkColumnName = "";
    private String m_parentColumnName = "";
    private String m_extendedWhere;
    private HashMap<Integer, Integer> m_Attachments = null;
    private HashMap<Integer, Integer> m_Chats = null;
    private ArrayList<Integer> m_Lock = null;
    private int m_currentRow = -1;
    private PropertyChangeSupport m_propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String PROPERTY = "CurrentRow";
    protected EventListenerList m_listenerList = new EventListenerList();
    private DataStatusEvent m_DataStatusEvent = null;
    private MQuery m_query = new MQuery();
    private String m_oldQuery = "0=9";
    private String m_linkValue = "999999";
    private String[] m_OrderBys = new String[3];
    private ArrayList<String> m_parents = new ArrayList(2);
    private MultiMap<String, GridField> m_depOnField = new MultiMap();
    private Loader m_loader = null;
    private volatile boolean m_loadComplete = false;
    private boolean m_included = false;
    private boolean m_includedAlreadyCalc = false;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private boolean m_parentNeedSave = false;
    private long m_lastDataStatusEventTime;
    private DataStatusEvent m_lastDataStatusEvent;
    public static final String CTX_KeyColumnName = "_TabInfo_KeyColumnName";
    public static final String CTX_LinkColumnName = "_TabInfo_LinkColumnName";
    public static final String CTX_TabLevel = "_TabInfo_TabLevel";
    public static final String CTX_AccessLevel = "_TabInfo_AccessLevel";
    public static final String CTX_AD_Tab_ID = "_TabInfo_AD_Tab_ID";
    public static final String CTX_Name = "_TabInfo_Name";
    public static final String CTX_AD_Table_ID = "_TabInfo_AD_Table_ID";
    public static final String CTX_FindSQL = "_TabInfo_FindSQL";
    public static final String CTX_SQL = "_TabInfo_SQL";
    private List<String> activeCallouts = new ArrayList<String>();
    private List<Callout> activeCalloutInstance = new ArrayList<Callout>();

    public GridTab(GridTabVO vo, GridWindow w) {
        this(vo, w, false);
    }

    public GridTab(GridTabVO vo, GridWindow w, boolean virtual) {
        this.m_window = w;
        this.m_vo = vo;
        this.m_mTable = new GridTable(this.m_vo.ctx, this.m_vo.AD_Table_ID, this.m_vo.TableName, this.m_vo.WindowNo, this.m_vo.TabNo, true, virtual);
        this.m_mTable.setReadOnly(this.m_vo.IsReadOnly || this.m_vo.IsView);
        this.m_mTable.setDeleteable(this.m_vo.IsDeleteable);
    }

    private void waitLoadCompete() {
        if (this.m_loadComplete) {
            return;
        }
        this.m_loader.setPriority(5);
        this.log.config("");
        while (this.m_loader.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "", e);
            }
        }
        this.log.config("fini");
    }

    public boolean isLoadComplete() {
        return this.m_loadComplete;
    }

    public boolean initTab(boolean async) {
        this.log.fine("#" + this.m_vo.TabNo + " - Async=" + async + " - Where=" + this.m_vo.WhereClause);
        if (this.isLoadComplete()) {
            return true;
        }
        if (this.m_loader != null && this.m_loader.isAlive()) {
            this.waitLoadCompete();
            if (this.isLoadComplete()) {
                return true;
            }
        }
        if (async) {
            this.m_loader = new Loader();
            this.m_loader.start();
            return false;
        }
        return this.loadTab();
    }

    protected boolean loadTab() {
        this.m_extendedWhere = this.m_vo.WhereClause;
        if (!this.loadFields()) {
            this.m_loadComplete = true;
            return false;
        }
        this.m_mTable.setOrderClause(this.getOrderByClause(this.m_vo.onlyCurrentRows));
        this.m_loadComplete = true;
        return true;
    }

    protected void dispose() {
        this.log.fine("#" + this.m_vo.TabNo);
        this.m_OrderBys = null;
        this.m_parents.clear();
        this.m_parents = null;
        this.m_mTable.close(true);
        this.m_mTable = null;
        this.m_depOnField.clear();
        this.m_depOnField = null;
        if (this.m_Attachments != null) {
            this.m_Attachments.clear();
        }
        this.m_Attachments = null;
        if (this.m_Chats != null) {
            this.m_Chats.clear();
        }
        this.m_Chats = null;
        if (this.m_vo.isInitFields()) {
            this.m_vo.getFields().clear();
        }
        this.m_vo = null;
        if (this.m_loader != null) {
            if (this.m_loader.isAlive()) {
                this.m_loader.interrupt();
            }
            this.m_loader = null;
        }
    }

    private boolean loadFields() {
        this.log.fine("#" + this.m_vo.TabNo);
        if (this.m_vo.getFields() == null) {
            return false;
        }
        for (int f = 0; f < this.m_vo.getFields().size(); ++f) {
            int sortNo;
            GridFieldVO voF = this.m_vo.getFields().get(f);
            if (voF == null) continue;
            GridField field = new GridField(voF);
            field.setGridTab(this);
            String columnName = field.getColumnName();
            if (field.isKey()) {
                this.setKeyColumnName(columnName);
            }
            if (field.isParentColumn()) {
                this.m_parents.add(columnName);
            }
            if ((sortNo = field.getSortNo()) != 0) {
                if (Math.abs(sortNo) == 1) {
                    this.m_OrderBys[0] = columnName;
                    if (sortNo < 0) {
                        this.m_OrderBys[0] = this.m_OrderBys[0] + " DESC";
                    }
                } else if (Math.abs(sortNo) == 2) {
                    this.m_OrderBys[1] = columnName;
                    if (sortNo < 0) {
                        this.m_OrderBys[1] = this.m_OrderBys[1] + " DESC";
                    }
                } else if (Math.abs(sortNo) == 3) {
                    this.m_OrderBys[2] = columnName;
                    if (sortNo < 0) {
                        this.m_OrderBys[2] = this.m_OrderBys[2] + " DESC";
                    }
                }
            }
            this.m_mTable.addField(field);
            ArrayList<String> list = field.getDependentOn();
            for (int i = 0; i < list.size(); ++i) {
                this.m_depOnField.put(list.get(i), field);
            }
            if (!columnName.equals("IsActive") && !columnName.equals("Processed") && !columnName.equals("Processing")) continue;
            this.m_depOnField.put(columnName, null);
        }
        if (!this.m_mTable.getTableName().equals("AD_PInstance_Log")) {
            if (this.m_mTable.getField("Created") == null) {
                GridField created = new GridField(GridFieldVO.createStdField(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.AD_Window_ID, this.m_vo.AD_Tab_ID, false, true, true));
                this.m_mTable.addField(created);
            }
            if (this.m_mTable.getField("CreatedBy") == null) {
                GridField createdBy = new GridField(GridFieldVO.createStdField(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.AD_Window_ID, this.m_vo.AD_Tab_ID, false, true, false));
                this.m_mTable.addField(createdBy);
            }
            if (this.m_mTable.getField("Updated") == null) {
                GridField updated = new GridField(GridFieldVO.createStdField(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.AD_Window_ID, this.m_vo.AD_Tab_ID, false, false, true));
                this.m_mTable.addField(updated);
            }
            if (this.m_mTable.getField("UpdatedBy") == null) {
                GridField updatedBy = new GridField(GridFieldVO.createStdField(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.AD_Window_ID, this.m_vo.AD_Tab_ID, false, false, false));
                this.m_mTable.addField(updatedBy);
            }
        }
        return true;
    }

    public ArrayList<String> getDependentOn() {
        ArrayList<String> list = new ArrayList<String>();
        Evaluator.parseDepends(list, this.m_vo.DisplayLogic);
        if (list.size() > 0 && CLogMgt.isLevelFiner()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                sb.append(list.get(i)).append(" ");
            }
            this.log.finer("(" + this.m_vo.Name + ") " + sb.toString());
        }
        return list;
    }

    public String getDisplayLogic() {
        return this.m_vo.DisplayLogic;
    }

    public GridTable getTableModel() {
        if (!this.m_loadComplete) {
            this.initTab(false);
        }
        return this.m_mTable;
    }

    public Icon getIcon() {
        if (this.m_vo.AD_Image_ID == 0) {
            return null;
        }
        MImage mImage = MImage.get(this.m_vo.ctx, this.m_vo.AD_Image_ID);
        return mImage.getIcon();
    }

    public boolean hasDependants(String columnName) {
        return this.m_depOnField.containsKey(columnName);
    }

    public ArrayList<GridField> getDependantFields(String columnName) {
        return this.m_depOnField.getValues(columnName);
    }

    public void setQuery(MQuery query) {
        this.m_query = query == null ? new MQuery() : query;
    }

    public MQuery getQuery() {
        return this.m_query;
    }

    public boolean isQueryActive() {
        if (this.m_query != null) {
            return this.m_query.isActive();
        }
        return false;
    }

    public boolean isQueryNewRecord() {
        if (this.m_query != null) {
            return this.m_query.isNewRecordQuery();
        }
        return false;
    }

    public void enableEvents() {
        this.m_mTable.addDataStatusListener(this);
    }

    public void query(boolean onlyCurrentRows) {
        this.query(onlyCurrentRows, 0, 0);
    }

    public void query(boolean onlyCurrentRows, int onlyCurrentDays, int maxRows) {
        String q;
        if (!this.m_loadComplete) {
            this.initTab(false);
        }
        Env.clearTabContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo);
        Env.clearTabContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo);
        this.log.fine("#" + this.m_vo.TabNo + " - Only Current Rows=" + onlyCurrentRows + ", Days=" + onlyCurrentDays + ", Detail=" + this.isDetail());
        boolean refresh = this.m_oldQuery.equals(this.m_query.getWhereClause()) && this.m_vo.onlyCurrentRows == onlyCurrentRows && this.m_vo.onlyCurrentDays == onlyCurrentDays;
        this.m_oldQuery = this.m_query.getWhereClause();
        this.m_vo.onlyCurrentRows = onlyCurrentRows;
        this.m_vo.onlyCurrentDays = onlyCurrentDays;
        StringBuffer where = new StringBuffer(this.m_vo.WhereClause);
        if (this.m_vo.onlyCurrentDays > 0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("Created >= ");
            where.append("SysDate-").append(this.m_vo.onlyCurrentDays);
        }
        if (this.isDetail()) {
            this.m_parentNeedSave = false;
            String lc = this.getLinkColumnName();
            if (lc.equals("")) {
                this.log.warning("No link column");
                where.append(" 2=3");
            } else {
                String value = null;
                if (this.m_parentColumnName.length() > 0) {
                    value = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.getParentTabNo(), this.m_parentColumnName, true);
                    if (value == null || value.length() == 0) {
                        value = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_parentColumnName, true);
                    }
                } else {
                    value = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.getParentTabNo(), lc, true);
                    if (value == null || value.length() == 0) {
                        value = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, lc, true);
                    }
                }
                if (refresh) {
                    refresh = this.m_linkValue.equals(value);
                }
                this.m_linkValue = value;
                if (value.length() == 0) {
                    this.m_parentNeedSave = true;
                    if (where.length() != 0) {
                        where.append(" AND ");
                    }
                    where.append(" 2=3");
                } else {
                    if (where.length() != 0) {
                        where.append(" AND ");
                    }
                    where.append(this.getTableName()).append(".").append(lc).append("=");
                    if (lc.endsWith("_ID")) {
                        where.append(DB.TO_NUMBER(new BigDecimal(value), 13));
                    } else {
                        where.append(DB.TO_STRING(value));
                    }
                }
            }
        }
        this.m_extendedWhere = where.toString();
        if (this.m_query.isActive() && (q = this.validateQuery(this.m_query)) != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append(" (").append(q).append(")");
        }
        this.log.fine("#" + this.m_vo.TabNo + " - " + where);
        if (this.m_mTable.isOpen()) {
            if (refresh) {
                this.m_mTable.dataRefreshAll();
            } else {
                this.m_mTable.dataRequery(where.toString(), this.m_vo.onlyCurrentRows && !this.isDetail(), onlyCurrentDays);
            }
        } else {
            this.m_mTable.setSelectWhereClause(where.toString(), this.m_vo.onlyCurrentRows && !this.isDetail(), onlyCurrentDays);
            this.m_mTable.open(maxRows);
        }
        this.setCurrentRow(0, true);
    }

    private String validateQuery(MQuery query) {
        if (query == null || query.getRestrictionCount() == 0) {
            return null;
        }
        if (query.getRestrictionCount() != 1) {
            this.log.fine("Ignored(More than 1 Restriction): " + query);
            return query.getWhereClause();
        }
        String colName = query.getColumnName(0);
        if (colName == null) {
            this.log.fine("Ignored(No Column): " + query);
            return query.getWhereClause();
        }
        if (colName.indexOf(40) != -1) {
            this.log.fine("Ignored(Function): " + colName);
            return query.getWhereClause();
        }
        String refColName = null;
        if (colName.equals("R_RequestRelated_ID")) {
            refColName = "R_Request_ID";
        } else if (colName.startsWith("C_DocType")) {
            refColName = "C_DocType_ID";
        }
        if (refColName != null) {
            query.setColumnName(0, refColName);
            if (this.getField(refColName) != null) {
                this.log.fine("Column " + colName + " replaced with synonym " + refColName);
                return query.getWhereClause();
            }
            refColName = null;
        }
        if (this.getField(colName) != null) {
            this.log.fine("Field Found: " + colName);
            return query.getWhereClause();
        }
        String sql = "SELECT cc.ColumnName FROM AD_Column c INNER JOIN AD_Ref_Table r ON (c.AD_Reference_Value_ID=r.AD_Reference_ID) INNER JOIN AD_Column cc ON (r.AD_Key=cc.AD_Column_ID) WHERE c.AD_Reference_ID IN (18,30) AND c.ColumnName=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, colName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                refColName = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "(ref) - Column=" + colName, e);
            return query.getWhereClause();
        }
        if (refColName != null) {
            query.setColumnName(0, refColName);
            if (this.getField(refColName) != null) {
                this.log.fine("Column " + colName + " replaced with " + refColName);
                return query.getWhereClause();
            }
            colName = refColName;
        }
        String tableName = null;
        String tabKeyColumn = this.getKeyColumnName();
        sql = "SELECT t.TableName FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE c.ColumnName=? AND IsKey='Y' AND EXISTS (SELECT * FROM AD_Column cc WHERE cc.AD_Table_ID=t.AD_Table_ID AND cc.ColumnName=?)";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, colName);
            pstmt.setString(2, tabKeyColumn);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                tableName = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "Column=" + colName + ", Key=" + tabKeyColumn, e);
            return null;
        }
        if (tabKeyColumn.equals("AD_Reference_ID")) {
            sql = "SELECT AD_Reference_ID FROM AD_Column WHERE ColumnName=?";
            int AD_Reference_ID = DB.getSQLValue(null, sql, colName);
            return "AD_Reference_ID=" + AD_Reference_ID;
        }
        if (tableName == null) {
            this.log.info("Not successfull - Column=" + colName + ", Key=" + tabKeyColumn + ", Query=" + query);
            return query.getWhereClause();
        }
        query.setTableName("xx");
        StringBuffer result = new StringBuffer(this.getTableName()).append(".").append(tabKeyColumn).append(" IN (SELECT xx.").append(tabKeyColumn).append(" FROM ").append(tableName).append(" xx WHERE ").append(query.getWhereClause(true)).append(")");
        this.log.fine(result.toString());
        return result.toString();
    }

    public void dataRefreshAll() {
        this.dataRefreshAll(true);
    }

    public void dataRefreshAll(boolean fireEvent) {
        this.log.fine("#" + this.m_vo.TabNo);
        int keyNo = this.m_mTable.getKeyID(this.m_currentRow);
        this.m_mTable.dataRefreshAll(fireEvent);
        if (keyNo != -1 && keyNo != this.m_mTable.getKeyID(this.m_currentRow)) {
            int size = this.getRowCount();
            for (int i = 0; i < size; ++i) {
                if (keyNo != this.m_mTable.getKeyID(i)) continue;
                this.m_currentRow = i;
                break;
            }
        }
        this.setCurrentRow(this.m_currentRow, fireEvent);
        if (fireEvent) {
            this.fireStateChangeEvent(new StateChangeEvent(this, 0));
        }
    }

    public void dataRefresh() {
        this.dataRefresh(true);
    }

    public void dataRefresh(boolean fireEvent) {
        this.dataRefresh(this.m_currentRow, fireEvent);
    }

    public void dataRefresh(int row) {
        this.dataRefresh(row, true);
    }

    public void dataRefresh(int row, boolean fireEvent) {
        this.log.fine("#" + this.m_vo.TabNo + " - row=" + row);
        this.m_mTable.dataRefresh(row, fireEvent);
        this.setCurrentRow(row, fireEvent);
        if (fireEvent) {
            this.fireStateChangeEvent(new StateChangeEvent(this, 1));
        }
    }

    public boolean dataSave(boolean manualCmd) {
        this.log.fine("#" + this.m_vo.TabNo + " - row=" + this.m_currentRow);
        try {
            boolean retValue;
            if (this.hasChangedCurrentTabAndParents() && (manualCmd || this.m_mTable.hasChanged(this.m_currentRow))) {
                return false;
            }
            boolean bl = retValue = this.m_mTable.dataSave(manualCmd) == 'O';
            if (manualCmd) {
                this.setCurrentRow(this.m_currentRow, false);
                if (this.m_lastDataStatusEvent != null && this.m_lastDataStatusEvent.getCurrentRow() == this.m_currentRow && (this.m_lastDataStatusEvent.Record_ID != null && this.m_lastDataStatusEvent.Record_ID instanceof Integer && (Integer)this.m_lastDataStatusEvent.Record_ID == 0 || this.m_lastDataStatusEvent.Record_ID == null)) {
                    this.updateDataStatusEventProperties(this.m_lastDataStatusEvent);
                }
            }
            this.fireStateChangeEvent(new StateChangeEvent(this, 4));
            if (retValue) {
                this.refreshParents();
            }
            return retValue;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "#" + this.m_vo.TabNo + " - row=" + this.m_currentRow, e);
            return false;
        }
    }

    public boolean hasChangedCurrentTabAndParents() {
        String msg = null;
        if (this.m_mTable.hasChanged(this.m_currentRow)) {
            msg = Msg.getMsg(Env.getCtx(), "CurrentRecordModified");
            this.log.saveError("CurrentRecordModified", msg, false);
            return true;
        }
        if (this.isDetail()) {
            int level = this.m_vo.TabLevel;
            for (int i = this.m_window.getTabIndex(this) - 1; i >= 0; --i) {
                GridTab parentTab = this.m_window.getTab(i);
                if (parentTab.m_vo.TabLevel != level - 1) continue;
                if (parentTab.m_mTable.hasChanged(parentTab.m_currentRow)) {
                    msg = Msg.getMsg(Env.getCtx(), "ParentRecordModified") + ": " + parentTab.getName();
                    this.log.saveError("ParentRecordModified", msg, false);
                    return true;
                }
                if (!parentTab.isDetail()) break;
                level = parentTab.m_vo.TabLevel;
            }
        }
        return false;
    }

    private void refreshParents() {
        if (this.isDetail()) {
            int level = this.m_vo.TabLevel;
            for (int i = this.m_window.getTabIndex(this) - 1; i >= 0; --i) {
                GridTab parentTab = this.m_window.getTab(i);
                if (parentTab.m_vo.TabLevel != level - 1) continue;
                parentTab.dataRefresh(false);
                if (!parentTab.isDetail()) break;
                level = parentTab.m_vo.TabLevel;
            }
            this.dataRefresh(false);
        }
    }

    public boolean needSave(boolean rowChange, boolean onlyRealChange) {
        if (rowChange) {
            return this.m_mTable.needSave(-2, onlyRealChange);
        }
        if (onlyRealChange) {
            return this.m_mTable.needSave();
        }
        return this.m_mTable.needSave(onlyRealChange);
    }

    public void dataIgnore() {
        this.log.fine("#" + this.m_vo.TabNo);
        this.m_mTable.dataIgnore();
        this.setCurrentRow(this.m_currentRow, false);
        this.fireStateChangeEvent(new StateChangeEvent(this, 5));
        this.log.fine("#" + this.m_vo.TabNo + "- fini");
    }

    public boolean dataNew(boolean copy) {
        int i;
        this.log.fine("#" + this.m_vo.TabNo);
        if (!this.isInsertRecord()) {
            this.log.warning("Inset Not allowed in TabNo=" + this.m_vo.TabNo);
            return false;
        }
        if (this.m_vo.TabLevel > 0 && this.m_vo.TabNo > 0) {
            boolean processed = "Y".equals(Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, "Processed"));
            if (processed) {
                this.log.warning("Not allowed in TabNo=" + this.m_vo.TabNo + " -> Processed=" + processed);
                return false;
            }
            this.log.finest("Processed=" + processed);
        }
        if (this.isDetail() && this.m_parentNeedSave) {
            return false;
        }
        int oldCurrentRow = this.m_currentRow++;
        boolean retValue = this.m_mTable.dataNew(oldCurrentRow, copy);
        this.m_currentRow = oldCurrentRow;
        if (!retValue) {
            return retValue;
        }
        this.setCurrentRow(this.m_currentRow + 1, true);
        for (i = 0; i < this.getFieldCount(); ++i) {
            this.processCallout(this.getField(i));
        }
        for (i = 0; i < this.getFieldCount(); ++i) {
            this.getField(i).refreshLookup();
            this.getField(i).validateValue();
        }
        this.m_mTable.setChanged(false);
        this.fireStateChangeEvent(new StateChangeEvent(this, 2));
        return retValue;
    }

    public boolean dataDelete() {
        this.log.fine("#" + this.m_vo.TabNo + " - row=" + this.m_currentRow);
        boolean retValue = this.m_mTable.dataDelete(this.m_currentRow);
        this.setCurrentRow(this.m_currentRow, true);
        this.fireStateChangeEvent(new StateChangeEvent(this, 3));
        return retValue;
    }

    public String getName() {
        return this.m_vo.Name;
    }

    public String getDescription() {
        return this.m_vo.Description;
    }

    public String getHelp() {
        return this.m_vo.Help;
    }

    public int getTabLevel() {
        return this.m_vo.TabLevel;
    }

    public String getCommitWarning() {
        return this.m_vo.CommitWarning;
    }

    protected GridTable getMTable() {
        return this.m_mTable;
    }

    public String getKeyColumnName() {
        return this.m_keyColumnName;
    }

    private void setKeyColumnName(String keyColumnName) {
        this.m_keyColumnName = keyColumnName;
        Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, CTX_KeyColumnName, this.m_keyColumnName);
    }

    public String getLinkColumnName() {
        return this.m_linkColumnName;
    }

    public void setLinkColumnName(String linkColumnName) {
        String sql = "SELECT ColumnName FROM AD_Column WHERE AD_Column_ID=?";
        if (this.m_vo.Parent_Column_ID > 0) {
            this.m_parentColumnName = DB.getSQLValueString(null, sql, this.m_vo.Parent_Column_ID);
        }
        if (this.m_parentColumnName == null) {
            this.m_parentColumnName = "";
        }
        if (linkColumnName != null) {
            this.m_linkColumnName = linkColumnName;
        } else {
            if (this.m_vo.AD_Column_ID == 0) {
                return;
            }
            String SQL = "SELECT ColumnName FROM AD_Column WHERE AD_Column_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
                pstmt.setInt(1, this.m_vo.AD_Column_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_linkColumnName = rs.getString(1);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "", e);
            }
            this.log.fine("AD_Column_ID=" + this.m_vo.AD_Column_ID + " - " + this.m_linkColumnName);
        }
        Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, CTX_LinkColumnName, this.m_linkColumnName);
    }

    public boolean isCurrent() {
        if (!this.m_mTable.isOpen()) {
            return false;
        }
        if (!this.m_oldQuery.equals(this.m_query.getWhereClause())) {
            return false;
        }
        if (!this.isDetail()) {
            return true;
        }
        String value = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.getLinkColumnName());
        return this.m_linkValue.equals(value);
    }

    public boolean isOpen() {
        if (this.m_mTable != null) {
            return this.m_mTable.isOpen();
        }
        return false;
    }

    public boolean isIncluded() {
        if (!this.m_includedAlreadyCalc) {
            this.m_included = false;
            if (this.getParentTab() != null) {
                for (GridTab tab : this.getParentTab().getIncludedTabs()) {
                    if (!tab.equals(this)) continue;
                    this.m_included = true;
                    break;
                }
            }
            this.m_includedAlreadyCalc = true;
        }
        return this.m_included;
    }

    public void setIncluded(boolean isIncluded) {
        this.m_included = isIncluded;
    }

    public boolean isOnlyCurrentRows() {
        return this.m_vo.onlyCurrentRows;
    }

    public ArrayList<String> getParentColumnNames() {
        return this.m_parents;
    }

    public boolean isDetail() {
        if (this.m_vo.TabLevel == 0) {
            return false;
        }
        return this.m_parents.size() > 0 || this.m_vo.AD_Column_ID != 0;
    }

    public boolean isPrinted() {
        return this.m_vo.AD_Process_ID != 0;
    }

    public int getWindowNo() {
        return this.m_vo.WindowNo;
    }

    public int getTabNo() {
        return this.m_vo.TabNo;
    }

    public int getAD_Process_ID() {
        return this.m_vo.AD_Process_ID;
    }

    public boolean isHighVolume() {
        return this.m_vo.IsHighVolume;
    }

    public boolean isReadOnly() {
        if (this.m_vo.IsReadOnly) {
            return true;
        }
        if (this.m_parentNeedSave) {
            return true;
        }
        if (this.m_vo.ReadOnlyLogic == null || this.m_vo.ReadOnlyLogic.equals("")) {
            return this.m_vo.IsReadOnly;
        }
        boolean retValue = Evaluator.evaluateLogic(this, this.m_vo.ReadOnlyLogic);
        this.log.finest(this.m_vo.Name + " (" + this.m_vo.ReadOnlyLogic + ") => " + retValue);
        return retValue;
    }

    public boolean isAlwaysUpdateField() {
        for (int i = 0; i < this.m_mTable.getColumnCount(); ++i) {
            GridField field = this.m_mTable.getField(i);
            if (!field.isAlwaysUpdateable()) continue;
            return true;
        }
        return false;
    }

    public boolean isInsertRecord() {
        if (this.isReadOnly()) {
            return false;
        }
        return this.m_vo.IsInsertRecord;
    }

    public boolean isDisplayed() {
        String dl = this.m_vo.DisplayLogic;
        if (dl == null || dl.equals("")) {
            return true;
        }
        String parsed = Env.parseContext(this.m_vo.ctx, 0, dl, false, false).trim();
        if (parsed.length() == 0) {
            return true;
        }
        boolean retValue = Evaluator.evaluateLogic(this, dl);
        this.log.config(this.m_vo.Name + " (" + dl + ") => " + retValue);
        return retValue;
    }

    @Override
    public String get_ValueAsString(String variableName) {
        return Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, variableName, false, true);
    }

    public boolean isSingleRow() {
        return this.m_vo.IsSingleRow;
    }

    public void setSingleRow(boolean isSingleRow) {
        this.m_vo.IsSingleRow = isSingleRow;
    }

    public boolean isTreeTab() {
        return this.m_vo.HasTree;
    }

    public int getAD_Tab_ID() {
        return this.m_vo.AD_Tab_ID;
    }

    public int getAD_Table_ID() {
        return this.m_vo.AD_Table_ID;
    }

    public int getAD_Window_ID() {
        return this.m_vo.AD_Window_ID;
    }

    public int getIncluded_Tab_ID() {
        return this.m_vo.Included_Tab_ID;
    }

    public String getTableName() {
        return this.m_vo.TableName;
    }

    public String getWhereClause() {
        return this.m_vo.WhereClause;
    }

    public boolean isSortTab() {
        return this.m_vo.IsSortTab;
    }

    public int getAD_ColumnSortOrder_ID() {
        return this.m_vo.AD_ColumnSortOrder_ID;
    }

    public int getAD_ColumnSortYesNo_ID() {
        return this.m_vo.AD_ColumnSortYesNo_ID;
    }

    public String getWhereExtended() {
        return this.m_extendedWhere;
    }

    private String getOrderByClause(boolean onlyCurrentRows) {
        if (this.m_vo.OrderByClause.length() > 0) {
            String orderBy = Env.parseContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.OrderByClause, false, false);
            return orderBy;
        }
        this.m_vo.OrderByClause = "";
        for (int i = 0; i < 3; ++i) {
            String order = this.m_OrderBys[i];
            if (order == null || order.length() <= 0) continue;
            if (this.m_vo.OrderByClause.length() > 0) {
                this.m_vo.OrderByClause = this.m_vo.OrderByClause + ",";
            }
            this.m_vo.OrderByClause = this.m_vo.OrderByClause + order;
        }
        if (this.m_vo.OrderByClause.length() > 0) {
            return this.m_vo.OrderByClause;
        }
        this.m_vo.OrderByClause = "Created";
        if (onlyCurrentRows && !this.isDetail()) {
            this.m_vo.OrderByClause = this.m_vo.OrderByClause + " DESC";
        }
        return this.m_vo.OrderByClause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrxInfo() {
        block30: {
            ResultSet rs;
            CPreparedStatement pstmt;
            boolean filled;
            Object[] arguments;
            MessageFormat mf;
            block27: {
                block28: {
                    ResultSet rs2;
                    CPreparedStatement pstmt2;
                    boolean filled2;
                    Object[] arguments2;
                    MessageFormat mf2;
                    block26: {
                        int Record_ID;
                        if (this.m_vo.TableName.startsWith("C_InvoiceBatch")) {
                            int Record_ID2 = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, "C_InvoiceBatch_ID");
                            this.log.fine(this.m_vo.TableName + " - " + Record_ID2);
                            MessageFormat mf3 = null;
                            try {
                                mf3 = new MessageFormat(Msg.getMsg(Env.getAD_Language(this.m_vo.ctx), "InvoiceBatchSummary"), Env.getLanguage(this.m_vo.ctx).getLocale());
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, "InvoiceBatchSummary=" + Msg.getMsg(Env.getAD_Language(this.m_vo.ctx), "InvoiceBatchSummary"), e);
                            }
                            if (mf3 == null) {
                                return " ";
                            }
                            Object[] arguments3 = new Object[3];
                            boolean filled3 = false;
                            String sql = "SELECT COUNT(*), NVL(SUM(LineNetAmt),0), NVL(SUM(LineTotalAmt),0) FROM C_InvoiceBatchLine WHERE C_InvoiceBatch_ID=? AND IsActive='Y'";
                            try {
                                CPreparedStatement pstmt3 = DB.prepareStatement(sql, null);
                                pstmt3.setInt(1, Record_ID2);
                                ResultSet rs3 = pstmt3.executeQuery();
                                if (rs3.next()) {
                                    Integer lines = new Integer(rs3.getInt(1));
                                    arguments3[0] = lines;
                                    Double net = new Double(rs3.getDouble(2));
                                    arguments3[1] = net;
                                    Double total = new Double(rs3.getDouble(3));
                                    arguments3[2] = total;
                                    filled3 = true;
                                }
                                rs3.close();
                                pstmt3.close();
                            }
                            catch (SQLException e) {
                                this.log.log(Level.SEVERE, this.m_vo.TableName + "\nSQL=" + sql, e);
                            }
                            if (filled3) {
                                return mf3.format(arguments3);
                            }
                            return " ";
                        }
                        if (!this.m_vo.TableName.startsWith("C_Order") && !this.m_vo.TableName.startsWith("C_Invoice")) break block28;
                        boolean isOrder = this.m_vo.TableName.startsWith("C_Order");
                        StringBuffer sql = new StringBuffer("SELECT COUNT(*) AS Lines,c.ISO_Code,o.TotalLines,o.GrandTotal,currencyBase(o.GrandTotal,o.C_Currency_ID,o.DateAcct, o.AD_Client_ID,o.AD_Org_ID) AS ConvAmt ");
                        if (isOrder) {
                            Record_ID = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, "C_Order_ID");
                            sql.append("FROM C_Order o INNER JOIN C_Currency c ON (o.C_Currency_ID=c.C_Currency_ID) INNER JOIN C_OrderLine l ON (o.C_Order_ID=l.C_Order_ID) WHERE o.C_Order_ID=? ");
                        } else {
                            Record_ID = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, "C_Invoice_ID");
                            sql.append("FROM C_Invoice o INNER JOIN C_Currency c ON (o.C_Currency_ID=c.C_Currency_ID) INNER JOIN C_InvoiceLine l ON (o.C_Invoice_ID=l.C_Invoice_ID) WHERE o.C_Invoice_ID=? ");
                        }
                        sql.append("GROUP BY o.C_Currency_ID, c.ISO_Code, o.TotalLines, o.GrandTotal, o.DateAcct, o.AD_Client_ID, o.AD_Org_ID");
                        this.log.fine(this.m_vo.TableName + " - " + Record_ID);
                        mf2 = null;
                        try {
                            mf2 = new MessageFormat(Msg.getMsg(Env.getAD_Language(this.m_vo.ctx), "OrderSummary"), Env.getLanguage(this.m_vo.ctx).getLocale());
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, "OrderSummary=" + Msg.getMsg(Env.getAD_Language(this.m_vo.ctx), "OrderSummary"), e);
                        }
                        if (mf2 == null) {
                            return " ";
                        }
                        arguments2 = new Object[5];
                        filled2 = false;
                        pstmt2 = null;
                        rs2 = null;
                        try {
                            pstmt2 = DB.prepareStatement(sql.toString(), null);
                            pstmt2.setInt(1, Record_ID);
                            rs2 = pstmt2.executeQuery();
                            if (!rs2.next()) break block26;
                            Integer lines = new Integer(rs2.getInt(1));
                            arguments2[0] = lines;
                            Double lineTotal = new Double(rs2.getDouble(3));
                            arguments2[1] = lineTotal;
                            Double grandTotal = new Double(rs2.getDouble(4));
                            arguments2[2] = grandTotal;
                            String currency = rs2.getString(2);
                            arguments2[3] = currency;
                            Double grandEuro = new Double(rs2.getDouble(5));
                            arguments2[4] = grandEuro;
                            filled2 = true;
                        }
                        catch (SQLException e) {
                            try {
                                this.log.log(Level.SEVERE, this.m_vo.TableName + "\nSQL=" + sql, e);
                            }
                            catch (Throwable throwable) {
                                DB.close(rs2, pstmt2);
                                rs2 = null;
                                pstmt2 = null;
                                throw throwable;
                            }
                            DB.close(rs2, pstmt2);
                            rs2 = null;
                            pstmt2 = null;
                        }
                    }
                    DB.close(rs2, pstmt2);
                    rs2 = null;
                    pstmt2 = null;
                    if (filled2) {
                        return mf2.format(arguments2);
                    }
                    return " ";
                }
                if (!this.m_vo.TableName.startsWith("S_TimeExpense") || this.m_vo.TabNo != 0) break block30;
                int Record_ID = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, "S_TimeExpense_ID");
                this.log.fine(this.m_vo.TableName + " - " + Record_ID);
                mf = null;
                try {
                    mf = new MessageFormat(Msg.getMsg(Env.getAD_Language(this.m_vo.ctx), "ExpenseSummary"), Env.getLanguage(this.m_vo.ctx).getLocale());
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "ExpenseSummary=" + Msg.getMsg(Env.getAD_Language(this.m_vo.ctx), "ExpenseSummary"), e);
                }
                if (mf == null) {
                    return " ";
                }
                arguments = new Object[3];
                filled = false;
                String SQL = "SELECT COUNT(*) AS Lines, SUM(ConvertedAmt*Qty) FROM S_TimeExpenseLine WHERE S_TimeExpense_ID=?";
                pstmt = null;
                rs = null;
                try {
                    pstmt = DB.prepareStatement(SQL, null);
                    pstmt.setInt(1, Record_ID);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) break block27;
                    Integer lines = new Integer(rs.getInt(1));
                    arguments[0] = lines;
                    Double total = new Double(rs.getDouble(2));
                    arguments[1] = total;
                    arguments[2] = " ";
                    filled = true;
                }
                catch (SQLException e) {
                    try {
                        this.log.log(Level.SEVERE, this.m_vo.TableName + "\nSQL=" + SQL, e);
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (filled) {
                return mf.format(arguments);
            }
            return " ";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDependentInfo() {
        if (this.m_vo.TableName.equals("C_Order")) {
            ResultSet rs;
            CPreparedStatement pstmt;
            block15: {
                int C_DocTyp_ID = 0;
                Integer target = (Integer)this.getValue("C_DocTypeTarget_ID");
                if (target != null) {
                    C_DocTyp_ID = target;
                }
                if (C_DocTyp_ID == 0) {
                    return;
                }
                String sql = "SELECT DocSubTypeSO FROM C_DocType WHERE C_DocType_ID=?";
                pstmt = null;
                rs = null;
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, C_DocTyp_ID);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) break block15;
                    Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, "OrderType", rs.getString(1));
                }
                catch (SQLException e) {
                    try {
                        this.log.log(Level.SEVERE, sql, e);
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.m_vo.TableName.equals("C_BPartner_Location")) {
            Integer location_int = (Integer)this.getValue("C_Location_ID");
            String phone_frm = null;
            if (location_int != null) {
                phone_frm = DB.getSQLValueString(null, "SELECT ExpressionPhone FROM C_Country c, C_Location l WHERE c.C_Country_ID = l.C_Country_ID AND l.C_location_ID = ?", location_int);
            }
            GridField fPhone = this.getField("Phone");
            MColumn colPhone = null;
            if (fPhone != null) {
                colPhone = MColumn.get(Env.getCtx(), fPhone.getAD_Column_ID());
            }
            GridField fPhone2 = this.getField("Phone2");
            MColumn colPhone2 = null;
            if (fPhone2 != null) {
                colPhone2 = MColumn.get(Env.getCtx(), fPhone2.getAD_Column_ID());
            }
            GridField fFax = this.getField("Fax");
            MColumn colFax = null;
            if (fFax != null) {
                colFax = MColumn.get(Env.getCtx(), fFax.getAD_Column_ID());
            }
            if (colPhone != null && (colPhone.getVFormat() == null || colPhone.getVFormat().length() == 0)) {
                fPhone.setVFormat(phone_frm);
            }
            if (colPhone2 != null && (colPhone2.getVFormat() == null || colPhone2.getVFormat().length() == 0)) {
                fPhone2.setVFormat(phone_frm);
            }
            if (colFax != null && (colFax.getVFormat() == null || colFax.getVFormat().length() == 0)) {
                fFax.setVFormat(phone_frm);
            }
        }
    }

    public void loadAttachments() {
        this.log.fine("#" + this.m_vo.TabNo);
        if (!this.canHaveAttachment()) {
            return;
        }
        String SQL = "SELECT AD_Attachment_ID, Record_ID FROM AD_Attachment WHERE AD_Table_ID=?";
        try {
            if (this.m_Attachments == null) {
                this.m_Attachments = new HashMap();
            } else {
                this.m_Attachments.clear();
            }
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, this.m_vo.AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Integer key = new Integer(rs.getInt(2));
                Integer value = new Integer(rs.getInt(1));
                this.m_Attachments.put(key, value);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "loadAttachments", e);
        }
        this.log.config("#" + this.m_Attachments.size());
    }

    public boolean canHaveAttachment() {
        return this.getKeyColumnName().endsWith("_ID");
    }

    public boolean hasAttachment() {
        if (this.m_Attachments == null) {
            this.loadAttachments();
        }
        if (this.m_Attachments == null || this.m_Attachments.isEmpty()) {
            return false;
        }
        Integer key = new Integer(this.m_mTable.getKeyID(this.m_currentRow));
        return this.m_Attachments.containsKey(key);
    }

    public int getAD_AttachmentID() {
        if (this.m_Attachments == null) {
            this.loadAttachments();
        }
        if (this.m_Attachments.isEmpty()) {
            return 0;
        }
        Integer key = new Integer(this.m_mTable.getKeyID(this.m_currentRow));
        Integer value = this.m_Attachments.get(key);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public void loadChats() {
        this.log.fine("#" + this.m_vo.TabNo);
        if (!this.canHaveAttachment()) {
            return;
        }
        String sql = "SELECT CM_Chat_ID, Record_ID FROM CM_Chat WHERE AD_Table_ID=?";
        try {
            if (this.m_Chats == null) {
                this.m_Chats = new HashMap();
            } else {
                this.m_Chats.clear();
            }
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_vo.AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Integer key = new Integer(rs.getInt(2));
                Integer value = new Integer(rs.getInt(1));
                this.m_Chats.put(key, value);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        this.log.config("#" + this.m_Chats.size());
    }

    public boolean hasChat() {
        if (this.m_Chats == null) {
            this.loadChats();
        }
        if (this.m_Chats == null || this.m_Chats.isEmpty()) {
            return false;
        }
        Integer key = new Integer(this.m_mTable.getKeyID(this.m_currentRow));
        return this.m_Chats.containsKey(key);
    }

    public int getCM_ChatID() {
        if (this.m_Chats == null) {
            this.loadChats();
        }
        if (this.m_Chats.isEmpty()) {
            return 0;
        }
        Integer key = new Integer(this.m_mTable.getKeyID(this.m_currentRow));
        Integer value = this.m_Chats.get(key);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public void loadLocks() {
        int AD_User_ID = Env.getContextAsInt(Env.getCtx(), "#AD_User_ID");
        this.log.fine("#" + this.m_vo.TabNo + " - AD_User_ID=" + AD_User_ID);
        if (!this.canHaveAttachment()) {
            return;
        }
        String sql = "SELECT Record_ID FROM AD_Private_Access WHERE AD_User_ID=? AND AD_Table_ID=? AND IsActive='Y' ORDER BY Record_ID";
        try {
            if (this.m_Lock == null) {
                this.m_Lock = new ArrayList();
            } else {
                this.m_Lock.clear();
            }
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_User_ID);
            pstmt.setInt(2, this.m_vo.AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Integer key = new Integer(rs.getInt(1));
                this.m_Lock.add(key);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        this.log.fine("#" + this.m_Lock.size());
    }

    public boolean isLocked() {
        if (!MRole.getDefault(this.m_vo.ctx, false).isPersonalLock()) {
            return false;
        }
        if (this.m_Lock == null) {
            this.loadLocks();
        }
        if (this.m_Lock == null || this.m_Lock.isEmpty()) {
            return false;
        }
        Integer key = new Integer(this.m_mTable.getKeyID(this.m_currentRow));
        return this.m_Lock.contains(key);
    }

    public void lock(Properties ctx, int Record_ID, boolean lock) {
        int AD_User_ID = Env.getContextAsInt(ctx, "#AD_User_ID");
        this.log.fine("Lock=" + lock + ", AD_User_ID=" + AD_User_ID + ", AD_Table_ID=" + this.m_vo.AD_Table_ID + ", Record_ID=" + Record_ID);
        MPrivateAccess access = MPrivateAccess.get(ctx, AD_User_ID, this.m_vo.AD_Table_ID, Record_ID);
        if (access == null) {
            access = new MPrivateAccess(ctx, AD_User_ID, this.m_vo.AD_Table_ID, Record_ID);
        }
        access.setIsActive(lock);
        access.save();
        this.loadLocks();
    }

    @Override
    public void dataStatusChanged(DataStatusEvent e) {
        this.log.fine("#" + this.m_vo.TabNo + " - " + e.toString());
        int oldCurrentRow = e.getCurrentRow();
        this.m_DataStatusEvent = e;
        String msg = this.m_DataStatusEvent.getAD_Message();
        if (msg != null && msg.equals("Sorted")) {
            this.setCurrentRow(0, true);
        }
        this.m_DataStatusEvent = e;
        this.m_DataStatusEvent.setCurrentRow(this.m_currentRow);
        if (oldCurrentRow == this.m_currentRow) {
            GridField field = this.m_mTable.getField(e.getChangedColumn());
            if (field != null) {
                Object value = this.m_mTable.getValueAt(this.m_currentRow, e.getChangedColumn());
                field.setValue(value, this.m_mTable.isInserting());
            }
        } else {
            this.fireDataStatusChanged(this.m_DataStatusEvent);
        }
        this.m_lastDataStatusEventTime = System.currentTimeMillis();
        this.m_lastDataStatusEvent = this.m_DataStatusEvent;
        this.m_DataStatusEvent = null;
    }

    private void fireDataStatusChanged(DataStatusEvent e) {
        DataStatusListener[] listeners = (DataStatusListener[])this.m_listenerList.getListeners(DataStatusListener.class);
        if (listeners.length == 0) {
            return;
        }
        this.log.fine(e.toString());
        if (e.getCurrentRow() >= 0) {
            this.updateDataStatusEventProperties(e);
        }
        e.setInserting(this.m_mTable.isInserting());
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].dataStatusChanged(e);
        }
    }

    private void updateDataStatusEventProperties(DataStatusEvent e) {
        e.Created = (Timestamp)this.getValue("Created");
        e.CreatedBy = (Integer)this.getValue("CreatedBy");
        e.Updated = (Timestamp)this.getValue("Updated");
        e.UpdatedBy = (Integer)this.getValue("UpdatedBy");
        e.Record_ID = this.getValue(this.m_keyColumnName);
        StringBuffer info = new StringBuffer(this.getTableName());
        if (this.m_keyColumnName != null && this.m_keyColumnName.length() > 0) {
            info.append(" - ").append(this.m_keyColumnName).append("=").append(e.Record_ID);
        } else {
            for (int i = 0; i < this.m_parents.size(); ++i) {
                String keyCol = this.m_parents.get(i);
                info.append(" - ").append(keyCol).append("=").append(this.getValue(keyCol));
            }
        }
        e.Info = info.toString();
    }

    public void fireDataStatusEEvent(String AD_Message, String info, boolean isError) {
        this.m_mTable.fireDataStatusEEvent(AD_Message, info, isError);
    }

    public void fireDataStatusEEvent(ValueNamePair errorLog) {
        if (errorLog != null) {
            this.m_mTable.fireDataStatusEEvent(errorLog);
        }
    }

    public int getCurrentRow() {
        if (this.m_currentRow != this.verifyRow(this.m_currentRow)) {
            this.setCurrentRow(this.m_mTable.getRowCount() - 1, true);
        }
        return this.m_currentRow;
    }

    public int getRecord_ID() {
        return this.m_mTable.getKeyID(this.m_currentRow);
    }

    public int getKeyID(int row) {
        return this.m_mTable.getKeyID(row);
    }

    public int navigate(int targetRow) {
        if (targetRow == this.m_currentRow) {
            return this.m_currentRow;
        }
        this.log.info("Row=" + targetRow);
        int newRow = this.verifyRow(targetRow);
        if (!this.m_mTable.dataSave(newRow, false)) {
            return this.m_currentRow;
        }
        if (this.m_mTable.isInserting()) {
            if (newRow > this.m_currentRow) {
                --newRow;
            }
            this.dataIgnore();
        }
        return this.setCurrentRow(newRow, true);
    }

    public int navigateRelative(int rowChange) {
        return this.navigate(this.m_currentRow + rowChange);
    }

    public int navigateCurrent() {
        this.log.info("Row=" + this.m_currentRow);
        return this.setCurrentRow(this.m_currentRow, true);
    }

    private int verifyRow(int targetRow) {
        int newRow = targetRow;
        if (!this.m_mTable.isOpen()) {
            this.log.severe("Table not open");
            return -1;
        }
        int rows = this.getRowCount();
        if (rows == 0) {
            this.log.fine("No Rows");
            return -1;
        }
        if (newRow >= rows) {
            newRow = rows - 1;
            this.log.fine("Set to max Row: " + newRow);
        } else if (newRow < 0) {
            newRow = 0;
            this.log.fine("Set to first Row");
        }
        return newRow;
    }

    private int setCurrentRow(int newCurrentRow, boolean fireEvents) {
        int oldCurrentRow = this.m_currentRow;
        this.m_currentRow = this.verifyRow(newCurrentRow);
        this.log.fine("Row=" + this.m_currentRow + " - fire=" + fireEvents);
        int size = this.m_mTable.getColumnCount();
        for (int i = 0; i < size; ++i) {
            GridField mField = this.m_mTable.getField(i);
            if (this.m_currentRow >= 0) {
                Object value = this.m_mTable.getValueAt(this.m_currentRow, i);
                mField.setValue(value, this.m_mTable.isInserting());
                if (!this.m_mTable.isInserting()) continue;
                mField.validateValue();
                continue;
            }
            if (mField.isKey()) {
                mField.setValueAndUpdateContext();
                continue;
            }
            mField.setValue();
        }
        this.loadDependentInfo();
        if (!fireEvents) {
            return this.m_currentRow;
        }
        this.m_propertyChangeSupport.firePropertyChange(PROPERTY, oldCurrentRow, this.m_currentRow);
        long since = System.currentTimeMillis() - this.m_lastDataStatusEventTime;
        if (since <= 500L && this.m_lastDataStatusEvent != null) {
            this.m_DataStatusEvent = this.m_lastDataStatusEvent;
        }
        if (this.m_DataStatusEvent == null) {
            this.m_DataStatusEvent = new DataStatusEvent(this, this.getRowCount(), this.m_mTable.isInserting(), Env.isAutoCommit(Env.getCtx(), this.m_vo.WindowNo), this.m_mTable.isInserting());
            this.m_DataStatusEvent.AD_Table_ID = this.m_vo.AD_Table_ID;
        }
        this.m_DataStatusEvent.setCurrentRow(this.m_currentRow);
        String status = this.m_DataStatusEvent.getAD_Message();
        if (status == null || status.length() == 0) {
            this.m_DataStatusEvent.setInfo(DEFAULT_STATUS_MESSAGE, null, false, false);
        }
        this.fireDataStatusChanged(this.m_DataStatusEvent);
        this.m_DataStatusEvent = null;
        return this.m_currentRow;
    }

    public void setCurrentRow(int row) {
        this.setCurrentRow(row, false);
    }

    public int getRowCount() {
        int count = this.m_mTable.getRowCount();
        if (count == 0 && this.m_mTable.isLoading()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            count = this.m_mTable.getRowCount();
        }
        return count;
    }

    public int getFieldCount() {
        return this.m_mTable.getColumnCount();
    }

    public GridField getField(int index) {
        return index >= 0 ? this.m_mTable.getField(index) : null;
    }

    public GridField getField(String columnName) {
        return this.m_mTable.getField(columnName);
    }

    public GridField[] getFields() {
        return this.m_mTable.getFields();
    }

    public String setValue(String columnName, Object value) {
        if (columnName == null) {
            return "NoColumn";
        }
        return this.setValue(this.m_mTable.getField(columnName), value);
    }

    public String setValue(GridField field, Object value) {
        if (field == null) {
            return "NoField";
        }
        this.log.fine(field.getColumnName() + "=" + value + " - Row=" + this.m_currentRow);
        if (DisplayType.isID(field.getDisplayType()) && value instanceof Integer && (Integer)value < 0) {
            value = null;
        }
        int col = this.m_mTable.findColumn(field.getColumnName());
        this.m_mTable.setValueAt(value, this.m_currentRow, col, false);
        return "";
    }

    public boolean isProcessed() {
        return this.getValueAsBoolean("Processed");
    }

    public boolean isActive() {
        return this.getValueAsBoolean("IsActive");
    }

    public String processFieldChange(GridField changedField) {
        this.processDependencies(changedField);
        return this.processCallout(changedField);
    }

    private void processDependencies(GridField changedField) {
        String columnName = changedField.getColumnName();
        if (!this.hasDependants(columnName)) {
            return;
        }
        ArrayList<GridField> list = this.getDependantFields(columnName);
        for (int i = 0; i < list.size(); ++i) {
            MLookup mLookup;
            GridField dependentField = list.get(i);
            if (dependentField == null || !(dependentField.getLookup() instanceof MLookup) || (mLookup = (MLookup)dependentField.getLookup()).getValidation().indexOf("@" + columnName + "@") == -1) continue;
            this.log.fine(columnName + " changed - " + dependentField.getColumnName() + " set to null");
            this.setValue(dependentField, null);
        }
    }

    public String[] getActiveCallouts() {
        String[] list = new String[this.activeCallouts.size()];
        return this.activeCallouts.toArray(list);
    }

    public Callout[] getActiveCalloutInstance() {
        Callout[] list = new Callout[this.activeCalloutInstance.size()];
        return this.activeCalloutInstance.toArray(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processCallout(GridField field) {
        String callout = field.getCallout();
        if (callout.length() == 0) {
            return "";
        }
        if (this.isProcessed() && !field.isAlwaysUpdateable()) {
            return "";
        }
        Object value = field.getValue();
        Object oldValue = field.getOldValue();
        this.log.fine(field.getColumnName() + "=" + value + " (" + callout + ") - old=" + oldValue);
        StringTokenizer st = new StringTokenizer(callout, ";,", false);
        while (st.hasMoreTokens()) {
            String cmd = st.nextToken().trim();
            if (this.activeCallouts.contains(cmd)) continue;
            String retValue = "";
            if (cmd.toLowerCase().startsWith("@script:")) {
                MRule rule = MRule.get(this.m_vo.ctx, cmd.substring("@script:".length()));
                if (rule == null) {
                    retValue = "Callout " + cmd + " not found";
                    this.log.log(Level.SEVERE, retValue);
                    return retValue;
                }
                if (!rule.getEventType().equals("C") || !rule.getRuleType().equals("S")) {
                    retValue = "Callout " + cmd + " must be of type JSR 223 and event Callout";
                    this.log.log(Level.SEVERE, retValue);
                    return retValue;
                }
                ScriptEngine engine = rule.getScriptEngine();
                MRule.setContext(engine, this.m_vo.ctx, this.m_vo.WindowNo);
                engine.put("A_WindowNo", this.m_vo.WindowNo);
                engine.put("A_Tab", this);
                engine.put("A_Field", field);
                engine.put("A_Value", value);
                engine.put("A_OldValue", oldValue);
                engine.put("A_Ctx", this.m_vo.ctx);
                try {
                    this.activeCallouts.add(cmd);
                    retValue = engine.eval(rule.getScript()).toString();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "", e);
                    String string = retValue = "Callout Invalid: " + e.toString();
                    return string;
                }
                finally {
                    this.activeCallouts.remove(cmd);
                }
            }
            Callout call = null;
            String method = null;
            int methodStart = cmd.lastIndexOf(46);
            try {
                if (methodStart != -1) {
                    Class<?> cClass = null;
                    cClass = Class.forName(cmd.substring(0, methodStart));
                    call = (Callout)cClass.newInstance();
                    method = cmd.substring(methodStart + 1);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "class", e);
                return "Callout Invalid: " + cmd + " (" + e.toString() + ")";
            }
            if (call == null || method == null || method.length() == 0) {
                return "Callout Invalid: " + method;
            }
            try {
                this.activeCallouts.add(cmd);
                this.activeCalloutInstance.add(call);
                retValue = call.start(this.m_vo.ctx, method, this.m_vo.WindowNo, this, field, value, oldValue);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "start", e);
                String string = retValue = "Callout Invalid: " + e.toString();
                return string;
            }
            finally {
                this.activeCallouts.remove(cmd);
                this.activeCalloutInstance.remove(call);
            }
            if (Util.isEmpty(retValue)) continue;
            this.log.severe(retValue);
            return retValue;
        }
        return "";
    }

    public Object getValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        GridField field = this.m_mTable.getField(columnName);
        return this.getValue(field);
    }

    public boolean getValueAsBoolean(String columnName) {
        int index = this.m_mTable.findColumn(columnName);
        if (index != -1) {
            Object oo = this.m_mTable.getValueAt(this.m_currentRow, index);
            if (oo instanceof String) {
                return "Y".equals(oo);
            }
            if (oo instanceof Boolean) {
                return (Boolean)oo;
            }
        }
        return "Y".equals(Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, columnName));
    }

    public Object getValue(GridField field) {
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public Object getValue(int row, String columnName) {
        int col = this.m_mTable.findColumn(columnName);
        if (col == -1) {
            return null;
        }
        return this.m_mTable.getValueAt(row, col);
    }

    public String toString() {
        String retValue = "MTab #";
        retValue = this.m_vo != null ? retValue + this.m_vo.TabNo + " " + this.m_vo.Name + " (" + this.m_vo.AD_Tab_ID + ")" : retValue + "???";
        return retValue;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_propertyChangeSupport.removePropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_propertyChangeSupport.addPropertyChangeListener(l);
    }

    public synchronized void removeDataStatusListener(DataStatusListener l) {
        this.m_listenerList.remove(DataStatusListener.class, l);
    }

    public synchronized void addDataStatusListener(DataStatusListener l) {
        this.m_listenerList.add(DataStatusListener.class, l);
    }

    public synchronized void addStateChangeListener(StateChangeListener l) {
        this.m_listenerList.add(StateChangeListener.class, l);
    }

    public synchronized void removeStateChangeListener(StateChangeListener l) {
        this.m_listenerList.remove(StateChangeListener.class, l);
    }

    public void setFieldVFormat(String identifier, String strNewFormat) {
        this.m_mTable.setFieldVFormat(identifier, strNewFormat);
    }

    public void switchRows(int from, int to, int sortColumn, boolean ascending) {
        this.log.fine(from + " - " + to + " - " + sortColumn + " - " + ascending);
        if (from == to) {
            this.log.finest("nothing to do - from == to");
            return;
        }
        if (!this.m_mTable.isRowEditable(from) || !this.m_mTable.isRowEditable(to)) {
            this.log.finest("row not editable - return");
            return;
        }
        if ((to = this.verifyRow(to)) == -1) {
            this.log.finest("Row range check - return");
            return;
        }
        this.m_mTable.dataSave(to, false);
        int lineCol = this.m_mTable.findColumn("Line");
        if (lineCol == -1) {
            lineCol = this.m_mTable.findColumn("SeqNo");
        }
        if (lineCol == -1) {
            return;
        }
        Integer lineNoCurrentRow = null;
        Integer lineNoNextRow = null;
        if (this.m_mTable.getValueAt(from, lineCol) instanceof Integer) {
            lineNoCurrentRow = (Integer)this.m_mTable.getValueAt(from, lineCol);
            lineNoNextRow = (Integer)this.m_mTable.getValueAt(to, lineCol);
        } else if (this.m_mTable.getValueAt(from, lineCol) instanceof BigDecimal) {
            lineNoCurrentRow = new Integer(((BigDecimal)this.m_mTable.getValueAt(from, lineCol)).intValue());
            lineNoNextRow = new Integer(((BigDecimal)this.m_mTable.getValueAt(to, lineCol)).intValue());
        } else {
            this.log.fine("unknown value format - return");
            return;
        }
        if (lineNoCurrentRow >= 9900 || lineNoNextRow >= 9900) {
            this.log.fine("don't sort - might be special lines");
            return;
        }
        this.m_mTable.setValueAt(lineNoCurrentRow, to, lineCol);
        this.setCurrentRow(to, false);
        this.m_mTable.dataSave(true);
        this.m_mTable.setValueAt(lineNoNextRow, from, lineCol);
        this.setCurrentRow(from, false);
        this.m_mTable.dataSave(true);
        if (sortColumn != -1) {
            this.m_mTable.sort(sortColumn, ascending);
        } else {
            this.m_mTable.sort(lineCol, true);
        }
        this.navigate(to);
    }

    private void fireStateChangeEvent(StateChangeEvent e) {
        StateChangeListener[] listeners = (StateChangeListener[])this.m_listenerList.getListeners(StateChangeListener.class);
        if (listeners.length == 0) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].stateChange(e);
        }
    }

    public List<GridTab> getIncludedTabs() {
        ArrayList<GridTab> list = new ArrayList<GridTab>(1);
        block0: for (GridField field : this.getFields()) {
            if (field.getIncluded_Tab_ID() <= 0) continue;
            for (int i = 0; i < this.m_window.getTabCount(); ++i) {
                GridTab detailTab = this.m_window.getTab(i);
                if (detailTab.getAD_Tab_ID() != field.getIncluded_Tab_ID()) continue;
                list.add(detailTab);
                continue block0;
            }
        }
        return list;
    }

    private int getParentTabNo() {
        int tabNo = this.m_vo.TabNo;
        int currentLevel = this.m_vo.TabLevel;
        int parentLevel = currentLevel - 1;
        if (parentLevel < 0) {
            return tabNo;
        }
        while (parentLevel != currentLevel) {
            currentLevel = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, --tabNo, CTX_TabLevel);
        }
        return tabNo;
    }

    public GridTab getParentTab() {
        int parentTabNo = this.getParentTabNo();
        if (parentTabNo < 0 || parentTabNo == this.m_vo.TabNo) {
            return null;
        }
        return this.m_window.getTab(parentTabNo);
    }

    class Loader
    extends Thread {
        Loader() {
        }

        @Override
        public void run() {
            GridTab.this.loadTab();
        }
    }
}

