/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MClient;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MSysConfig;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutProductPrice
extends CalloutEngine {
    public String prixRevient(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer M_PriceList_Version_ID = (Integer)mTab.getValue("M_PriceList_Version_ID");
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        BigDecimal PriceStd = (BigDecimal)mTab.getValue("PriceStd");
        BigDecimal FraiApproche = (BigDecimal)mTab.getValue("Z_Fraisapproche");
        BigDecimal ZMarge = (BigDecimal)mTab.getValue("Z_Marge");
        if (M_PriceList_Version_ID == null || M_PriceList_Version_ID == 0) {
            return "";
        }
        String typeProduct = new MProduct(ctx, M_Product_ID, null).getProductType();
        if (!typeProduct.equals("I")) {
            return "";
        }
        MPriceListVersion mPriceListVersion = new MPriceListVersion(ctx, M_PriceList_Version_ID, null);
        String update = MSysConfig.getValue("SOGEXIS_UPDATE_MARGE", "N", MClient.get(Env.getCtx()).get_ID());
        if (!mPriceListVersion.getM_PriceList().isSOPriceList()) {
            if (PriceStd == null) {
                return "";
            }
            if (FraiApproche == null) {
                return "";
            }
            if (mField.getColumnName().equals("PriceStd") || mField.getColumnName().equals("Z_Fraisapproche")) {
                mTab.setValue("PriceLimit", (Object)PriceStd.multiply(FraiApproche).setScale(2, 1));
            } else if (mField.getColumnName().equals("PriceLimit")) {
                mTab.setValue("Z_Fraisapproche", (Object)((BigDecimal)mTab.getValue("PriceLimit")).divide(PriceStd, 2, 4));
            }
            BigDecimal PriceLimit = (BigDecimal)mTab.getValue("PriceLimit");
        } else {
            BigDecimal PriceLimit = (BigDecimal)mTab.getValue("PriceLimit");
            if (PriceLimit == null || PriceLimit.compareTo(Env.ZERO) == 0) {
                return "";
            }
            if (mField.getColumnName().equals("PriceStd")) {
                if (PriceStd == null) {
                    return "";
                }
                mTab.setValue("Z_Marge", (Object)PriceStd.multiply(Env.ONEHUNDRED).divide(PriceLimit, 4).subtract(Env.ONEHUNDRED));
            } else if (mField.getColumnName().equals("Z_Marge")) {
                if (ZMarge == null) {
                    return "";
                }
                BigDecimal tmp = ZMarge.divide(Env.ONEHUNDRED);
                mTab.setValue("PriceStd", (Object)PriceLimit.multiply(tmp).add(PriceLimit).setScale(2, 1));
            } else if (mField.getColumnName().equals("PriceLimit")) {
                if (ZMarge == null && PriceStd == null) {
                    return "";
                }
                if (ZMarge == null && PriceStd != null) {
                    mTab.setValue("Z_Marge", (Object)PriceStd.multiply(Env.ONEHUNDRED).divide(PriceLimit, 4).subtract(Env.ONEHUNDRED));
                } else if (PriceStd == null && ZMarge != null) {
                    BigDecimal tmp = ZMarge.divide(Env.ONEHUNDRED);
                    mTab.setValue("PriceStd", (Object)PriceLimit.multiply(tmp).add(PriceLimit).setScale(2, 1));
                } else if (PriceStd != null && ZMarge != null) {
                    if (update.equals("N")) {
                        BigDecimal tmp = ZMarge.divide(Env.ONEHUNDRED);
                        mTab.setValue("PriceStd", (Object)PriceLimit.multiply(tmp).add(PriceLimit).setScale(2, 1));
                    } else if (update.equals("Y")) {
                        mTab.setValue("Z_Marge", (Object)PriceStd.multiply(Env.ONEHUNDRED).divide(PriceLimit, 4).subtract(Env.ONEHUNDRED));
                    }
                }
            }
        }
        return "";
    }

    public String priceLimit(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        mTab.setValue("PriceLimit", (Object)new BigDecimal(DB.getSQLValueStringEx(null, "SELECT Z_PUMP FROM M_Product WHERE M_Product_ID = ? ", mTab.getValue("M_Product_ID"))));
        return "";
    }

    public String zMarge(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        String soList = DB.getSQLValueString(null, "SELECT issopricelist FROM M_PriceList WHERE M_PriceList_ID = (SELECT M_PriceList_ID FROM M_PriceList_Version WHERE M_PriceList_Version_ID = ?)", mTab.getValue("M_PriceList_Version_ID"));
        if (soList == null || soList.equals("N")) {
            return "";
        }
        BigDecimal priceStd = (BigDecimal)mTab.getValue("PriceStd");
        BigDecimal priceLimit = (BigDecimal)mTab.getValue("PriceLimit");
        BigDecimal zMarge = Env.ZERO;
        String typeMargin = MSysConfig.getValue("SOGEXIS_TYPE_MARGE", "MT", MClient.get(Env.getCtx()).get_ID());
        if (typeMargin.equals("MT")) {
            if (priceLimit.compareTo(Env.ZERO) == 0) {
                mTab.setValue("Z_Marge", (Object)zMarge);
                return "";
            }
            zMarge = priceStd.multiply(Env.ONEHUNDRED);
            zMarge = zMarge.divide(priceLimit, 2, 4);
            zMarge = zMarge.subtract(Env.ONEHUNDRED);
        } else if (typeMargin.equals("MB")) {
            if (priceStd.compareTo(Env.ZERO) == 0) {
                mTab.setValue("Z_Marge", (Object)zMarge);
                return "";
            }
            zMarge = priceStd.subtract(priceLimit);
            zMarge = zMarge.divide(priceStd, 2, 4);
            zMarge = zMarge.multiply(Env.ONEHUNDRED);
        }
        mTab.setValue("Z_Marge", (Object)zMarge.setScale(2, 4));
        return "";
    }

    public String priceStd(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        String soList = DB.getSQLValueString(null, "SELECT issopricelist FROM M_PriceList WHERE M_PriceList_ID = (SELECT M_PriceList_ID FROM M_PriceList_Version WHERE M_PriceList_Version_ID = ?)", mTab.getValue("M_PriceList_Version_ID"));
        if (soList == null || soList.equals("N")) {
            return "";
        }
        BigDecimal zMarge = (BigDecimal)mTab.getValue("Z_Marge");
        BigDecimal priceLimit = (BigDecimal)mTab.getValue("PriceLimit");
        BigDecimal priceStd = Env.ZERO;
        priceStd = zMarge.divide(Env.ONEHUNDRED, 2, 4);
        priceStd = priceStd.multiply(priceLimit);
        priceStd = priceStd.add(priceLimit);
        mTab.setValue("PriceStd", (Object)priceStd.setScale(2, 4));
        return "";
    }

    public String copyPrice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        if (((BigDecimal)mTab.getValue("PriceLimit")).compareTo(Env.ZERO) == 0) {
            mTab.setValue("PriceLimit", mTab.getValue("PriceList"));
        }
        if (((BigDecimal)mTab.getValue("PriceStd")).compareTo(Env.ZERO) == 0) {
            mTab.setValue("PriceStd", mTab.getValue("PriceList"));
            this.prixRevient(ctx, WindowNo, mTab, mField, value);
        }
        return "";
    }
}

