/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.compiere.apps.AEnv;
import org.compiere.apps.FieldRecordInfo;
import org.compiere.grid.ed.Calculator;
import org.compiere.grid.ed.MDocNumber;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VManagedEditor;
import org.compiere.grid.ed.ValuePreference;
import org.compiere.model.GridField;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public final class VNumber
extends JComponent
implements VEditor,
ActionListener,
KeyListener,
FocusListener,
VManagedEditor {
    private static final long serialVersionUID = -1473227631807352033L;
    public static final int SIZE = 12;
    public static final boolean AUTO_POPUP = false;
    JPopupMenu popupMenu = new JPopupMenu();
    private String m_columnName;
    protected int m_displayType;
    private DecimalFormat m_format;
    private String m_title;
    private boolean m_setting;
    private String m_oldText;
    private String m_initialText;
    private boolean m_rangeSet = false;
    private Double m_minValue;
    private Double m_maxValue;
    private boolean m_modified = false;
    private CTextField m_text = new CTextField(12);
    private CButton m_button = new CButton();
    private GridField m_mField = null;
    private static CLogger log = CLogger.getCLogger(VNumber.class);

    public VNumber() {
        this("Number", false, false, true, 22, "Number");
    }

    public VNumber(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int displayType, String title) {
        super.setName(columnName);
        this.m_columnName = columnName;
        this.m_title = title;
        this.setDisplayType(displayType);
        LookAndFeel.installBorder(this, "TextField.border");
        this.setLayout(new BorderLayout());
        this.m_text.setBorder(null);
        this.m_text.setHorizontalAlignment(11);
        this.m_text.addKeyListener(this);
        this.m_text.addFocusListener(this);
        this.setMandatory(mandatory);
        this.add((Component)this.m_text, "Center");
        this.m_button.setIcon(Env.getImageIcon("Calculator10.gif"));
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.setFocusable(false);
        this.m_button.addActionListener(this);
        this.add((Component)this.m_button, "East");
        this.setColumns(12, 0);
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
        this.m_text.addMouseListener(new VNumber_mouseAdapter(this));
    }

    @Override
    public void dispose() {
        this.m_text = null;
        this.m_button = null;
        this.m_mField = null;
    }

    protected void setDocument(Document doc) {
        this.m_text.setDocument(doc);
    }

    public void selectAll() {
        this.m_text.selectAll();
    }

    public void setColumns(int columns, int height) {
        this.m_text.setPreferredSize(null);
        this.m_text.setMinimumSize(null);
        this.m_text.setColumns(columns);
        if (height > 0) {
            Dimension size = this.m_text.getPreferredSize();
            if (height > size.height) {
                size.height = height;
            }
            if (CComboBox.FIELD_HIGHT - 4 > size.height) {
                size.height = VLookup.FIELD_HIGHT - 4;
            }
            this.m_text.setPreferredSize(size);
            this.m_text.setMinimumSize(size);
        } else {
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < 12; ++i) {
                s.append("0");
            }
            CTextField f = new CTextField(s.toString());
            this.m_text.setPreferredSize(f.getPreferredSize());
            this.m_text.setMinimumSize(f.getMinimumSize());
        }
        this.setPreferredSize(this.m_text.getPreferredSize());
        this.setMinimumSize(this.m_text.getMinimumSize());
        int h = this.m_text.getPreferredSize().height;
        this.m_button.setPreferredSize(new Dimension(h, h));
    }

    public boolean setRange(Double minValue, Double maxValue) {
        this.m_rangeSet = true;
        this.m_minValue = minValue;
        this.m_maxValue = maxValue;
        return this.m_rangeSet;
    }

    public boolean setRange(String minValue, String maxValue) {
        if (minValue == null || maxValue == null) {
            return false;
        }
        try {
            this.m_minValue = Double.valueOf(minValue);
            this.m_maxValue = Double.valueOf(maxValue);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        this.m_rangeSet = true;
        return this.m_rangeSet;
    }

    public void setDisplayType(int displayType) {
        this.m_displayType = displayType;
        if (!DisplayType.isNumeric(displayType)) {
            this.m_displayType = 22;
        }
        this.m_format = DisplayType.getNumberFormat(displayType);
        this.m_text.setDocument(new MDocNumber(displayType, this.m_format, this.m_text, this.m_title));
    }

    @Override
    public void setReadWrite(boolean value) {
        if (this.m_text.isReadWrite() != value) {
            this.m_text.setReadWrite(value);
        }
        if (this.m_button.isReadWrite() != value) {
            this.m_button.setReadWrite(value);
        }
        if (this.m_button.isVisible() != value) {
            this.m_button.setVisible(value);
        }
        this.setFocusable(value);
    }

    @Override
    public boolean isReadWrite() {
        return this.m_text.isReadWrite();
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_text.setMandatory(mandatory);
    }

    @Override
    public boolean isMandatory() {
        return this.m_text.isMandatory();
    }

    @Override
    public void setBackground(Color color) {
        this.m_text.setBackground(color);
    }

    @Override
    public void setBackground(boolean error) {
        this.m_text.setBackground(error);
    }

    @Override
    public void setForeground(Color fg) {
        this.m_text.setForeground(fg);
    }

    @Override
    public void setValue(Object value) {
        log.finest("Value=" + value);
        this.m_oldText = value == null ? "" : this.m_format.format(value);
        if (this.m_setting) {
            return;
        }
        this.m_text.setText(this.m_oldText);
        this.m_initialText = this.m_oldText;
        this.m_modified = false;
    }

    @Override
    public void requestFocus() {
        this.m_text.requestFocus();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public Object getValue() {
        if (this.m_text == null || this.m_text.getText() == null || this.m_text.getText().length() == 0) {
            return null;
        }
        String value = this.m_text.getText();
        if (value == null || value.length() == 0) {
            if (!this.m_modified) {
                return null;
            }
            if (this.m_displayType == 11) {
                return new Integer(0);
            }
            return Env.ZERO;
        }
        if (value.equals(".") || value.equals(",") || value.equals("-")) {
            value = "0";
        }
        if (value.equals("..")) {
            value = "0";
            this.m_text.setText(".");
        }
        try {
            Number number = this.m_format.parse(value);
            value = number.toString();
            BigDecimal bd = new BigDecimal(value);
            if (this.m_displayType == 11) {
                return new Integer(bd.intValue());
            }
            if (bd.signum() == 0) {
                return bd;
            }
            return bd.setScale(this.m_format.getMaximumFractionDigits(), 4);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Value=" + value, e);
            this.m_text.setText(this.m_format.format(0L));
            if (this.m_displayType == 11) {
                return new Integer(0);
            }
            return Env.ZERO;
        }
    }

    @Override
    public String getDisplay() {
        return this.m_text.getText();
    }

    public String getTitle() {
        return this.m_title;
    }

    public Object plus() {
        Object value = this.getValue();
        if (value == null) {
            value = this.m_displayType == 11 ? new Integer(0) : Env.ZERO;
        }
        value = value instanceof BigDecimal ? ((BigDecimal)value).add(Env.ONE) : new Integer((Integer)value + 1);
        this.setValue(value);
        return value;
    }

    public Object minus(int minimum) {
        Object value = this.getValue();
        if (value == null) {
            value = this.m_displayType == 11 ? new Integer(minimum) : new BigDecimal(minimum);
            this.setValue(value);
            return value;
        }
        if (value instanceof BigDecimal) {
            BigDecimal min;
            BigDecimal bd = ((BigDecimal)value).subtract(Env.ONE);
            value = bd.compareTo(min = new BigDecimal(minimum)) < 0 ? min : bd;
        } else {
            int i = (Integer)value;
            if (--i < minimum) {
                i = minimum;
            }
            value = new Integer(i);
        }
        this.setValue(value);
        return value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.config(e.getActionCommand());
        if ("ValuePreference".equals(e.getActionCommand())) {
            if (MRole.getDefault().isShowPreference()) {
                ValuePreference.start(this.m_mField, this.getValue());
            }
            return;
        }
        if (e.getActionCommand().equals("ChangeLog")) {
            FieldRecordInfo.start(this.m_mField);
            return;
        }
        if (e.getSource() == this.m_button) {
            this.m_button.setEnabled(false);
            String str = VNumber.startCalculator(this, this.m_text.getText(), this.m_format, this.m_displayType, this.m_title, ' ');
            this.m_text.setText(str);
            this.m_button.setEnabled(true);
            try {
                this.fireVetoableChange(this.m_columnName, this.m_oldText, this.getValue());
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.m_text.requestFocus();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        log.finest("Key=" + e.getKeyCode() + " - " + e.getKeyChar() + " -> " + this.m_text.getText());
        if (e.getKeyCode() == 27) {
            this.m_text.setText(this.m_initialText);
        }
        this.m_modified = true;
        this.m_setting = true;
        try {
            if (e.getKeyCode() == 10) {
                this.fireVetoableChange(this.m_columnName, this.m_oldText, this.getValue());
                this.fireActionPerformed();
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.m_setting = false;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.m_text != null) {
            this.m_text.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.commitChanges();
    }

    @Override
    public void commitChanges() {
        Object oo = this.getValue();
        if (this.m_rangeSet) {
            String error = null;
            if (oo instanceof Integer) {
                Integer ii = (Integer)oo;
                if ((double)ii.intValue() < this.m_minValue) {
                    error = oo + " < " + this.m_minValue;
                    oo = new Integer(this.m_minValue.intValue());
                } else if ((double)ii.intValue() > this.m_maxValue) {
                    error = oo + " > " + this.m_maxValue;
                    oo = new Integer(this.m_maxValue.intValue());
                }
            } else if (oo instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)oo;
                if (bd.doubleValue() < this.m_minValue) {
                    error = oo + " < " + this.m_minValue;
                    oo = new BigDecimal(this.m_minValue);
                } else if (bd.doubleValue() > this.m_maxValue) {
                    error = oo + " > " + this.m_maxValue;
                    oo = new BigDecimal(this.m_maxValue);
                }
            }
            if (error != null) {
                log.warning(error);
            }
        }
        try {
            this.fireVetoableChange(this.m_columnName, this.m_initialText, oo);
            this.fireActionPerformed();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public static String startCalculator(Container jc, String value, DecimalFormat format, int displayType, String title) {
        return VNumber.startCalculator(jc, value, format, displayType, title, ' ');
    }

    public static String startCalculator(Container jc, String value, DecimalFormat format, int displayType, String title, char operator) {
        log.config("Value=" + value);
        BigDecimal startValue = new BigDecimal(0.0);
        try {
            if (value != null && value.length() > 0) {
                Number number = format.parse(value);
                startValue = new BigDecimal(number.toString());
            }
        }
        catch (ParseException pe) {
            log.info("InvalidEntry - " + pe.getMessage());
        }
        JFrame frame = Env.getFrame(jc);
        Calculator calc = new Calculator(frame, title, displayType, format, startValue);
        if ("*+-/%".indexOf(operator) > -1) {
            calc.handleInput(operator);
        }
        AEnv.showCenterWindow(frame, calc);
        BigDecimal result = calc.getNumber();
        log.config("Result=" + result);
        calc = null;
        if (result != null) {
            return format.format(result);
        }
        return value;
    }

    @Override
    public void setField(GridField mField) {
        this.m_mField = mField;
        if (this.m_mField != null && MRole.getDefault().isShowPreference()) {
            ValuePreference.addMenu(this, this.popupMenu);
        }
        if (this.m_mField != null) {
            FieldRecordInfo.addMenu(this, this.popupMenu);
        }
    }

    @Override
    public GridField getField() {
        return this.m_mField;
    }

    @Override
    public void setFocusable(boolean value) {
        this.m_text.setFocusable(value);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    protected void fireActionPerformed() {
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        ActionEvent ae = new ActionEvent(this, 1001, "VNumber", EventQueue.getMostRecentEventTime(), modifiers);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(ae);
        }
    }

    @Override
    public boolean isDirty() {
        return this.m_modified;
    }

    @Override
    public void rollbackChanges() {
        this.m_text.setText(this.m_oldText);
        this.m_initialText = this.m_oldText;
        this.m_modified = false;
    }

    final class VNumber_mouseAdapter
    extends MouseAdapter {
        private VNumber m_adaptee;

        VNumber_mouseAdapter(VNumber adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.m_adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

