/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.compiere.model.GridField;
import org.compiere.swing.CButton;
import org.compiere.swing.CTable;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public final class VHeaderRenderer
implements TableCellRenderer {
    private Integer prefWidth;
    private CButton m_button;
    private int m_alignment;
    private JLabel m_label;

    public VHeaderRenderer() {
        this.m_button = new CButton();
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.putClientProperty("Plastic.is3D", Boolean.FALSE);
    }

    public VHeaderRenderer(GridField mField) {
        this.m_alignment = DisplayType.isNumeric(mField.getDisplayType()) ? 4 : (mField.getDisplayType() == 20 ? 0 : 2);
        this.m_label = new JLabel();
        if (mField.getPreferredWidthInListView() != 0) {
            this.prefWidth = mField.getPreferredWidthInListView();
        }
    }

    public VHeaderRenderer(int displayType) {
        this.m_alignment = DisplayType.isNumeric(displayType) ? 4 : (displayType == 20 ? 0 : 2);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        CTable cTable;
        ImageIcon icon = null;
        if (table2 instanceof CTable && (cTable = (CTable)table2).getSortColumn() == table2.convertColumnIndexToModel(column)) {
            ImageIcon imageIcon = icon = cTable.isSortAscending() ? Env.getImageIcon2("uparrow") : Env.getImageIcon2("downarrow");
        }
        if (this.m_label == null && this.m_button == null) {
            Component headerComponent;
            TableCellRenderer headerRenderer = table2.getTableHeader().getDefaultRenderer();
            Component component = headerComponent = headerRenderer == null ? null : headerRenderer.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
            if (value == null) {
                headerComponent.setPreferredSize(new Dimension(0, 0));
            }
            if (headerComponent instanceof JLabel) {
                ((JLabel)headerComponent).setIcon(icon);
                ((JLabel)headerComponent).setHorizontalTextPosition(10);
            }
            return headerComponent;
        }
        if (this.m_button == null) {
            this.m_label.setHorizontalAlignment(this.m_alignment);
            if (value == null) {
                this.m_label.setPreferredSize(new Dimension(0, 0));
            } else {
                this.m_label.setText(value.toString());
                if (this.prefWidth != null && this.prefWidth > 0) {
                    this.m_label.setPreferredSize(new Dimension(this.prefWidth, this.m_label.getHeight()));
                    this.m_label.setToolTipText(value.toString());
                }
            }
            this.m_label.setIcon(icon);
            this.m_label.setHorizontalTextPosition(10);
            return this.m_label;
        }
        if (value == null) {
            this.m_button.setPreferredSize(new Dimension(0, 0));
            return this.m_button;
        }
        this.m_button.setText(value.toString());
        this.m_button.setIcon(icon);
        this.m_button.setHorizontalTextPosition(10);
        return this.m_button;
    }
}

