/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.compiere.grid.ed.ADempiereAutoCompleteDecorator;
import org.compiere.grid.ed.VAccount;
import org.compiere.grid.ed.VAssignment;
import org.compiere.grid.ed.VBinary;
import org.compiere.grid.ed.VButton;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VColor;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VFile;
import org.compiere.grid.ed.VImage;
import org.compiere.grid.ed.VLocation;
import org.compiere.grid.ed.VLocator;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VMemo;
import org.compiere.grid.ed.VNumber;
import org.compiere.grid.ed.VPAttribute;
import org.compiere.grid.ed.VPassword;
import org.compiere.grid.ed.VString;
import org.compiere.grid.ed.VText;
import org.compiere.grid.ed.VTextLong;
import org.compiere.grid.ed.VURL;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MAccountLookup;
import org.compiere.model.MLocationLookup;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MPAttributeLookup;
import org.compiere.swing.CLabel;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;

public class VEditorFactory {
    private static CLogger log = CLogger.getCLogger(VEditorFactory.class);

    public static VEditor getEditor(GridField mField, boolean tableEditor) {
        return VEditorFactory.getEditor(null, mField, tableEditor);
    }

    public static VEditor getEditor(GridTab mTab, GridField mField, boolean tableEditor) {
        if (mField == null) {
            return null;
        }
        JComponent editor = null;
        int displayType = mField.getDisplayType();
        String columnName = mField.getColumnName();
        boolean mandatory = mField.isMandatory(false);
        boolean readOnly = mField.isReadOnly();
        boolean updateable = mField.isUpdateable();
        int WindowNo = mField.getWindowNo();
        if (mField.isHeading()) {
            return null;
        }
        if (displayType == 10 || displayType == 42 || tableEditor && (displayType == 14 || displayType == 36)) {
            if (mField.isEncryptedField()) {
                VPassword vs = new VPassword(columnName, mandatory, readOnly, updateable, mField.getDisplayLength(), mField.getFieldLength(), mField.getVFormat());
                vs.setName(columnName);
                vs.setField(mField);
                editor = vs;
            } else {
                VString vs = new VString(columnName, mandatory, readOnly, updateable, mField.getDisplayLength(), mField.getFieldLength(), mField.getVFormat(), mField.getObscureType());
                vs.setName(columnName);
                vs.setField(mField);
                if (mField.isAutocomplete()) {
                    ADempiereAutoCompleteDecorator.decorate((JTextComponent)vs, mField.getEntries(), false);
                }
                editor = vs;
            }
        } else if (displayType == 40) {
            VURL vs = new VURL(columnName, mandatory, readOnly, updateable, mField.getDisplayLength(), mField.getFieldLength());
            vs.setName(columnName);
            vs.setField(mField);
            editor = vs;
        } else if (displayType == 38 || displayType == 39) {
            VFile file = new VFile(columnName, mandatory, readOnly, updateable, mField.getFieldLength(), displayType == 39);
            file.setName(columnName);
            file.setField(mField);
            editor = file;
        } else if (DisplayType.isLookup(displayType) || displayType == 13) {
            VLookup vl = new VLookup(columnName, mandatory, readOnly, updateable, mField.getLookup());
            vl.setName(columnName);
            vl.setField(mField);
            editor = vl;
        } else if (DisplayType.isNumeric(displayType)) {
            VNumber vn = new VNumber(columnName, mandatory, readOnly, updateable, displayType, mField.getHeader());
            vn.setRange(mField.getValueMin(), mField.getValueMax());
            vn.setName(columnName);
            vn.setField(mField);
            editor = vn;
        } else if (displayType == 20) {
            VCheckBox vc = new VCheckBox(columnName, mandatory, readOnly, updateable, mField.getHeader(), mField.getDescription(), tableEditor);
            vc.setName(columnName);
            vc.setField(mField);
            editor = vc;
        } else if (displayType == 14) {
            VText vt = new VText(columnName, mandatory, readOnly, updateable, mField.getDisplayLength(), mField.getFieldLength());
            vt.setName(columnName);
            vt.setField(mField);
            editor = vt;
        } else if (displayType == 34) {
            VMemo vt = new VMemo(columnName, mandatory, readOnly, updateable, mField.getDisplayLength(), mField.getFieldLength());
            vt.setName(columnName);
            vt.setField(mField);
            editor = vt;
        } else if (DisplayType.isDate(displayType)) {
            if (displayType == 16) {
                readOnly = true;
            }
            VDate vd = new VDate(columnName, mandatory, readOnly, updateable, displayType, mField.getHeader());
            vd.setName(columnName);
            vd.setField(mField);
            editor = vd;
        } else if (displayType == 21) {
            VLocation loc = new VLocation(mTab, columnName, mandatory, readOnly, updateable, (MLocationLookup)mField.getLookup());
            loc.setName(columnName);
            loc.setField(mField);
            editor = loc;
        } else if (displayType == 31) {
            VLocator loc = new VLocator(columnName, mandatory, readOnly, updateable, (MLocatorLookup)mField.getLookup(), WindowNo);
            loc.setName(columnName);
            loc.setField(mField);
            editor = loc;
        } else if (displayType == 25) {
            VAccount acct = new VAccount(columnName, mandatory, readOnly, updateable, new MAccountLookup(mField.getVO().ctx, mField.getWindowNo()), mField.getHeader());
            acct.setName(columnName);
            acct.setField(mField);
            editor = acct;
        } else if (displayType == 28) {
            VButton button = new VButton(columnName, mandatory, readOnly, updateable, mField.getHeader(), mField.getDescription(), mField.getHelp(), mField.getAD_Process_ID());
            button.setName(columnName);
            button.setField(mField);
            editor = button;
        } else if (displayType == 33) {
            VAssignment assign = new VAssignment(mandatory, readOnly, updateable);
            assign.setName(columnName);
            assign.setField(mField);
            editor = assign;
        } else if (displayType == 27) {
            VColor color = new VColor(mTab, mandatory, readOnly);
            color.setName(columnName);
            color.setField(mField);
            editor = color;
        } else if (displayType == 32) {
            VImage image = new VImage(columnName, WindowNo);
            image.setName(columnName);
            image.setField(mField);
            editor = image;
        } else if (displayType == 35) {
            VPAttribute attrib = new VPAttribute(mTab, mandatory, readOnly, updateable, WindowNo, (MPAttributeLookup)mField.getLookup());
            attrib.setName(columnName);
            attrib.setField(mField);
            editor = attrib;
        } else if (displayType == 36) {
            VTextLong vt = new VTextLong(columnName, mandatory, readOnly, updateable, mField.getDisplayLength(), mField.getFieldLength());
            vt.setName(columnName);
            vt.setField(mField);
            editor = vt;
        } else if (displayType == 23) {
            VBinary bin = new VBinary(columnName, WindowNo);
            bin.setName(columnName);
            bin.setField(mField);
            editor = bin;
        } else {
            log.log(Level.WARNING, columnName + " - Unknown Type: " + displayType);
        }
        return editor;
    }

    public static CLabel getLabel(GridField mField) {
        if (mField == null) {
            return null;
        }
        int displayType = mField.getDisplayType();
        if (mField.isFieldOnly() || displayType == 20 || displayType == 28) {
            return null;
        }
        CLabel label = new CLabel(mField.getHeader(), mField.getDescription());
        label.setName(mField.getColumnName());
        return label;
    }
}

