/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form.cbl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.compiere.apps.ADialog;
import org.compiere.apps.ADialogDialog;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.ReportCtl;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextPane;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class ZPrintContrat
extends CPanel
implements FormPanel,
ActionListener,
ChangeListener,
TableModelListener,
ASyncProcess {
    private static final long serialVersionUID = 1L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(ZPrintContrat.class);
    private static final String A_PRINT = "Print";
    private boolean m_selectionActive = true;
    private CTabbedPane tabbedPane = new CTabbedPane();
    private CPanel selPanel = new CPanel();
    private CPanel selNorthPanel = new CPanel();
    private BorderLayout selPanelLayout = new BorderLayout();
    private CLabel lDocType = new CLabel();
    private CLabel lDocStatus = new CLabel();
    private CLabel lDateFacturation = new CLabel();
    private CLabel lDateFacturationAvance = new CLabel();
    private CLabel lDateOnProcess = new CLabel();
    private VLookup fDocType;
    private VLookup fDocStatus;
    private ALayout northPanelLayout = new ALayout();
    private ConfirmPanel confirmPanelSel = new ConfirmPanel(true);
    private ConfirmPanel confirmPanelGen = new ConfirmPanel(true);
    private StatusBar statusBar = new StatusBar();
    private CPanel genPanel = new CPanel();
    private BorderLayout genLayout = new BorderLayout();
    private CTextPane info = new CTextPane();
    private JScrollPane scrollPane = new JScrollPane();
    private MiniTable miniTable = new MiniTable();
    private VDate fDateFacturation = new VDate("Date", true, false, true, 15, "Date Facturation");
    private VDate fDateFacturationAvance = new VDate("Date", false, false, true, 15, "Date Facturation Forfait Avance");
    private VCheckBox fDateOnProcess = new VCheckBox();

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        try {
            this.fillPicks();
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.tabbedPane, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
            frame.setPreferredSize(new Dimension(500, 600));
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "init", ex);
        }
    }

    void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.selPanel.setLayout(this.selPanelLayout);
        this.lDocType.setLabelFor(this.fDocType);
        this.lDocType.setText(Msg.translate(Env.getCtx(), "C_DocType_ID"));
        this.lDocStatus.setLabelFor(this.fDocStatus);
        this.lDocStatus.setText(Msg.translate(Env.getCtx(), "DocumentStatus"));
        this.lDateFacturation.setLabelFor(this.fDateFacturation);
        this.lDateFacturation.setText(Msg.translate(Env.getCtx(), "DateInvoiced"));
        this.lDateFacturationAvance.setLabelFor(this.fDateFacturationAvance);
        this.lDateFacturationAvance.setText(Msg.translate(Env.getCtx(), "ZDateFacturationAvance"));
        this.lDateOnProcess.setLabelFor(this.fDateFacturationAvance);
        this.lDateOnProcess.setText(Msg.translate(Env.getCtx(), "DateOnProcess"));
        this.selNorthPanel.setLayout(this.northPanelLayout);
        this.tabbedPane.add((Component)this.selPanel, Msg.getMsg(Env.getCtx(), "Select"));
        this.selPanel.add((Component)this.selNorthPanel, "North");
        this.selNorthPanel.add((Component)this.lDocType, new ALayoutConstraint(0, 0));
        this.selNorthPanel.add((Component)this.fDocType, null);
        this.selNorthPanel.add((Component)this.lDateFacturation, new ALayoutConstraint(1, 0));
        this.selNorthPanel.add((Component)this.fDateFacturation, null);
        this.selNorthPanel.add((Component)this.lDateFacturationAvance, new ALayoutConstraint(2, 0));
        this.selNorthPanel.add((Component)this.fDateFacturationAvance, null);
        this.selNorthPanel.add((Component)this.lDocStatus, new ALayoutConstraint(3, 0));
        this.selNorthPanel.add((Component)this.fDocStatus, null);
        this.selNorthPanel.add((Component)this.lDateOnProcess, new ALayoutConstraint(4, 0));
        this.selNorthPanel.add((Component)this.fDateOnProcess, null);
        this.selPanel.setName("selPanel");
        this.selPanel.add((Component)this.confirmPanelSel, "South");
        this.selPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.miniTable, null);
        CButton printButton = ConfirmPanel.createPrintButton(A_PRINT);
        printButton.addActionListener(this);
        this.confirmPanelSel.addButton(printButton);
        this.confirmPanelSel.addActionListener(this);
        this.tabbedPane.add((Component)this.genPanel, Msg.getMsg(Env.getCtx(), "Generate"));
        this.genPanel.setLayout(this.genLayout);
        this.genPanel.add((Component)this.info, "Center");
        this.genPanel.setEnabled(false);
        this.info.setEditable(false);
        this.genPanel.add((Component)this.confirmPanelGen, "South");
        this.confirmPanelGen.getOKButton().setVisible(false);
        this.confirmPanelGen.addActionListener(this);
    }

    private void fillPicks() throws Exception {
        MLookup docL = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, 19, Env.getLanguage(Env.getCtx()), "C_DocType_ID", 170, false, "C_DocType.C_DocType_ID = 1000131");
        this.fDocType = new VLookup("C_DocType_ID", true, false, true, docL);
        MLookup statusL = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, 17, Env.getLanguage(Env.getCtx()), "DocumentStatus", 1000064, false, "");
        this.fDocStatus = new VLookup("DocStatus", true, false, true, statusL);
        this.fDateFacturation.setValue(Env.getContextAsDate(Env.getCtx(), "#Date"));
        this.fDateFacturationAvance.setValue(Env.getContextAsDate(Env.getCtx(), "#Date"));
    }

    private void dynInit() {
        this.miniTable.addColumn("C_Invoice_ID");
        this.miniTable.addColumn("DocumentNo");
        this.miniTable.addColumn("DateInvoiced");
        this.miniTable.addColumn("GrandTotal");
        this.miniTable.setMultiSelection(true);
        this.miniTable.setRowSelectionAllowed(true);
        this.miniTable.setColumnClass(0, IDColumn.class, false, " ");
        this.miniTable.setColumnClass(1, String.class, true, Msg.translate(Env.getCtx(), "DocumentNo"));
        this.miniTable.setColumnClass(2, Timestamp.class, true, Msg.translate(Env.getCtx(), "DateInvoiced"));
        this.miniTable.setColumnClass(3, BigDecimal.class, true, Msg.translate(Env.getCtx(), "GrandTotal"));
        this.miniTable.autoSize();
        this.miniTable.getModel().addTableModelListener(this);
        this.statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "Lancer le processus de gnration de facture"));
        this.statusBar.setStatusDB(" ");
        this.tabbedPane.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] executeQuery(ProcessInfo pi) {
        log.info("");
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        StringBuffer sql = new StringBuffer("SELECT C_Invoice_ID, DocumentNo, DateInvoiced, GrandTotal ");
        sql.append("FROM C_Invoice ").append("WHERE AD_Client_ID=?");
        sql.append(" order by c_bpartner_id");
        int[] ids = pi.getIDs();
        int row = 0;
        this.miniTable.setRowCount(row);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, AD_Client_ID);
            rs = pstmt.executeQuery();
            int[] idsTris = new int[ids.length];
            int j = 0;
            while (rs.next()) {
                boolean exist = false;
                for (int i = 0; i < ids.length; ++i) {
                    if (rs.getInt(1) != ids[i]) continue;
                    idsTris[j] = ids[i];
                    ++j;
                    exist = true;
                    break;
                }
                if (!exist) continue;
                this.miniTable.setRowCount(row + 1);
                this.miniTable.setValueAt(new IDColumn(rs.getInt(1)), row, 0);
                this.miniTable.setValueAt(rs.getString(2), row, 1);
                this.miniTable.setValueAt(rs.getTimestamp(3), row, 2);
                this.miniTable.setValueAt(rs.getBigDecimal(4), row, 3);
                ++row;
            }
            if (idsTris.length > 0) {
                ids = idsTris;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, sql.toString(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        DB.close(rs, pstmt);
        this.miniTable.autoSize();
        this.statusBar.setStatusDB(String.valueOf(this.miniTable.getRowCount()));
        return ids;
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info("Cmd=" + e.getActionCommand());
        if (e.getActionCommand().equals("Ok")) {
            int rep = JOptionPane.showConfirmDialog(this, "ATTENTION, voulez-vous vraiment excuter ce traitement?  Aprs validation les factures seront gnres de faon irrversible.", "Confirmation", 1);
            if (rep == 0) {
                this.generateInvoices();
            }
            return;
        }
        if (e.getActionCommand().equals(A_PRINT)) {
            ArrayList<Integer> list = this.getSelection();
            for (int i = 0; i < list.size(); ++i) {
                int c_Invoice_ID = list.get(i);
                ReportCtl.startDocumentPrint(2, c_Invoice_ID, true);
            }
            int rows = this.miniTable.getRowCount();
            for (int i = 0; i < rows; ++i) {
                IDColumn id = (IDColumn)this.miniTable.getValueAt(i, 0);
                id.setSelected(false);
            }
            this.statusBar.setStatusDB("0");
            return;
        }
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.tabbedPane.getSelectedIndex();
        this.m_selectionActive = index == 0;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int rowsSelected = 0;
        int rows = this.miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)this.miniTable.getValueAt(i, 0);
            if (id == null || !id.isSelected()) continue;
            ++rowsSelected;
        }
        this.statusBar.setStatusDB(" " + rowsSelected + " ");
    }

    private ArrayList<Integer> getSelection() {
        log.info("");
        this.miniTable.editingStopped(new ChangeEvent(this));
        ArrayList<Integer> results = new ArrayList<Integer>();
        int rows = this.miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)this.miniTable.getValueAt(i, 0);
            if (id == null || !id.isSelected()) continue;
            results.add(id.getRecord_ID());
        }
        return results;
    }

    private void generateInvoices() {
        String trxName = Trx.createTrxName("IVG");
        Trx trx = Trx.get(trxName, true);
        int AD_Process_ID = DB.getSQLValue(null, "SELECT AD_Process_ID FROM AD_Process WHERE ClassName = ?", "org.compiere.process.cbl.ZZInvoiceGenerate");
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0);
        if (!instance.save()) {
            this.info.setText(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
            return;
        }
        ProcessInfo pi = new ProcessInfo("", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara para = new MPInstancePara(instance, 10);
        para.setParameter("C_DocType_ID", String.valueOf(this.fDocType.getValue()));
        if (!para.save()) {
            String msg = "No C_DocType_ID Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        para = new MPInstancePara(instance, 20);
        para.setParameterName("DateInvoiced");
        para.setP_Date(this.fDateFacturation.getTimestamp());
        if (!para.save()) {
            String msg = "No DateInvoiced Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        para = new MPInstancePara(instance, 30);
        para.setParameterName("ZDateFacturationAvance");
        para.setP_Date(this.fDateFacturationAvance.getTimestamp());
        if (!para.save()) {
            String msg = "No Date Facturation Avance Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        para = new MPInstancePara(instance, 40);
        para.setParameter("DocumentStatus", String.valueOf(this.fDocStatus.getValue()));
        if (!para.save()) {
            String msg = "No Document Status Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        para = new MPInstancePara(instance, 50);
        if (this.fDateOnProcess.getValue().equals(false)) {
            para.setParameter("DateOnProcess", "N");
        } else {
            para.setParameter("DateOnProcess", "Y");
        }
        if (!para.save()) {
            String msg = "No DateOnProcess Status Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        para = new MPInstancePara(instance, 60);
        para.setParameter("FormAcess", "Y");
        if (!para.save()) {
            String msg = "No FormAcess Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        ProcessCtl worker = new ProcessCtl(this, Env.getWindowNo(this), pi, trx);
        worker.start();
    }

    private void generateInvoice_complete(ProcessInfo pi) {
        this.tabbedPane.setSelectedIndex(1);
        ProcessInfoUtil.setLogFromDB(pi);
        StringBuffer iText = new StringBuffer();
        iText.append("<b>").append(pi.getSummary()).append("</b>").append(pi.getLogInfo(true));
        this.info.setText(iText.toString());
        int[] ids = pi.getIDs();
        if (ids == null || ids.length == 0) {
            return;
        }
        ids = this.executeQuery(pi);
        if (ADialog.ask(this.m_WindowNo, this, "PrintInvoices")) {
            ADialogDialog d;
            this.setCursor(Cursor.getPredefinedCursor(3));
            int retValue = ADialogDialog.A_CANCEL;
            do {
                for (int i = 0; i < ids.length; ++i) {
                    int C_Invoice_ID = ids[i];
                    ReportCtl.startDocumentPrint(2, C_Invoice_ID, true);
                }
            } while ((retValue = (d = new ADialogDialog((Frame)this.m_frame, Env.getHeader(Env.getCtx(), this.m_WindowNo), Msg.getMsg(Env.getCtx(), "PrintoutOK?"), 3)).getReturnCode()) == ADialogDialog.A_CANCEL);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void lockUI(ProcessInfo pi) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabled(false);
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
        this.generateInvoice_complete(pi);
    }

    @Override
    public boolean isUILocked() {
        return this.isEnabled();
    }

    @Override
    public void executeASync(ProcessInfo pi) {
    }
}

