/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.form.Merge;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VMerge
extends Merge
implements FormPanel,
ActionListener {
    private CPanel panel = new CPanel();
    private FormFrame m_frame;
    private CLabel[] m_label = null;
    private VLookup[] m_from = null;
    private VLookup[] m_to = null;
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel CenterPanel = new CPanel();
    private GridLayout centerLayout = new GridLayout();
    private CLabel mergeFromLabel = new CLabel();
    private CLabel mergeToLabel = new CLabel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        log.info("VMerge.init - WinNo=" + this.m_WindowNo);
        try {
            this.preInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.panel, "Center");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
    }

    public void preInit() {
        int count = 4;
        this.m_columnName = new String[count];
        this.m_label = new CLabel[count];
        this.m_from = new VLookup[count];
        this.m_to = new VLookup[count];
        this.preInit(0, 2163, 19, AD_ORG_ID);
        this.preInit(1, 2762, 30, C_BPARTNER_ID);
        this.preInit(2, 971, 30, AD_USER_ID);
        this.preInit(3, 2221, 30, M_PRODUCT_ID);
    }

    private void preInit(int index, int AD_Column_ID, int displayType, String ColumnName) {
        this.m_columnName[index] = ColumnName;
        String what = Msg.translate(Env.getCtx(), ColumnName);
        this.m_label[index] = new CLabel(what);
        this.m_from[index] = new VLookup(ColumnName, false, false, true, MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, displayType));
        this.m_to[index] = new VLookup(ColumnName, false, false, true, MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, displayType));
    }

    void jbInit() throws Exception {
        this.panel.setLayout(this.mainLayout);
        this.mainLayout.setHgap(5);
        this.mainLayout.setVgap(5);
        this.panel.add((Component)this.confirmPanel, "South");
        this.confirmPanel.addActionListener(this);
        this.centerLayout.setHgap(5);
        this.centerLayout.setVgap(5);
        this.centerLayout.setColumns(3);
        this.centerLayout.setRows(this.m_label.length + 1);
        this.CenterPanel.setLayout(this.centerLayout);
        this.panel.add((Component)this.CenterPanel, "Center");
        this.CenterPanel.add((Component)new CLabel(), null);
        this.CenterPanel.add((Component)this.mergeFromLabel, null);
        this.CenterPanel.add((Component)this.mergeToLabel, null);
        Font heading = this.mergeFromLabel.getFont();
        heading = new Font(heading.getName(), 1, heading.getSize());
        this.mergeFromLabel.setFont(heading);
        this.mergeFromLabel.setRequestFocusEnabled(false);
        this.mergeFromLabel.setText(Msg.getMsg(Env.getCtx(), "MergeFrom"));
        this.mergeToLabel.setFont(heading);
        this.mergeToLabel.setText(Msg.getMsg(Env.getCtx(), "MergeTo"));
        for (int i = 0; i < this.m_label.length; ++i) {
            this.CenterPanel.add((Component)this.m_label[i], null);
            this.CenterPanel.add((Component)this.m_from[i], null);
            this.CenterPanel.add((Component)this.m_to[i], null);
        }
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
            return;
        }
        String columnName = null;
        String from_Info = null;
        String to_Info = null;
        int from_ID = 0;
        int to_ID = 0;
        for (int i = 0; i < this.m_columnName.length && from_ID == 0 && to_ID == 0; ++i) {
            Object value = this.m_from[i].getValue();
            if (value == null || !(value instanceof Integer)) continue;
            from_ID = (Integer)value;
            value = this.m_to[i].getValue();
            if (value != null && value instanceof Integer) {
                to_ID = (Integer)value;
            } else {
                from_ID = 0;
            }
            if (from_ID == 0) continue;
            columnName = this.m_columnName[i];
            from_Info = this.m_from[i].getDisplay();
            to_Info = this.m_to[i].getDisplay();
        }
        if (from_ID == 0 || from_ID == to_ID) {
            return;
        }
        String msg = Msg.getMsg(Env.getCtx(), "MergeFrom") + " = " + from_Info + "\n" + Msg.getMsg(Env.getCtx(), "MergeTo") + " = " + to_Info;
        if (!ADialog.ask(this.m_WindowNo, this.panel, "MergeQuestion", msg)) {
            return;
        }
        this.updateDeleteTable(columnName);
        this.panel.setCursor(Cursor.getPredefinedCursor(3));
        this.confirmPanel.getOKButton().setEnabled(false);
        boolean success = this.merge(columnName, from_ID, to_ID);
        this.postMerge(columnName, to_ID);
        this.confirmPanel.getOKButton().setEnabled(true);
        this.panel.setCursor(Cursor.getDefaultCursor());
        if (!success) {
            ADialog.error(this.m_WindowNo, this.panel, "MergeError", this.m_errorLog.toString());
            return;
        }
        ADialog.info(this.m_WindowNo, this.panel, "MergeSuccess", msg + " #" + this.m_totalCount);
        this.dispose();
    }
}

