/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.logging.Level;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.apps.ADialog;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.form.InOutGen;
import org.compiere.apps.form.VGenPanel;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MOrder;
import org.compiere.model.MRMA;
import org.compiere.swing.CLabel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VInOutGen
extends InOutGen
implements FormPanel,
ActionListener,
VetoableChangeListener {
    private VGenPanel panel;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VInOutGen.class);
    private CLabel lWarehouse = new CLabel();
    private VLookup fWarehouse;
    private CLabel lBPartner = new CLabel();
    private VLookup fBPartner;
    private CLabel lDocType = new CLabel();
    private VComboBox cmbDocType = new VComboBox();
    private CLabel lDocAction = new CLabel();
    private VLookup docAction;

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        this.panel = new VGenPanel(this, WindowNo, frame);
        try {
            super.dynInit();
            this.dynInit();
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "init", ex);
        }
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    void jbInit() throws Exception {
        this.lWarehouse.setLabelFor(this.fWarehouse);
        this.lBPartner.setLabelFor(this.fBPartner);
        this.lBPartner.setText(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.lDocAction.setLabelFor(this.docAction);
        this.lDocAction.setText(Msg.translate(Env.getCtx(), "DocAction"));
        this.lDocType.setLabelFor(this.cmbDocType);
        this.panel.getParameterPanel().add((Component)this.lWarehouse, null);
        this.panel.getParameterPanel().add((Component)this.fWarehouse, null);
        this.panel.getParameterPanel().add((Component)this.lBPartner, null);
        this.panel.getParameterPanel().add((Component)this.fBPartner, null);
        this.panel.getParameterPanel().add((Component)this.lDocType, null);
        this.panel.getParameterPanel().add((Component)this.cmbDocType, null);
        this.panel.getParameterPanel().add((Component)this.lDocAction, null);
        this.panel.getParameterPanel().add((Component)this.docAction, null);
    }

    @Override
    public void dynInit() throws Exception {
        MLookup orgL = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, 2223, 19);
        this.fWarehouse = new VLookup("M_Warehouse_ID", true, false, true, orgL);
        this.lWarehouse.setText(Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        this.fWarehouse.addVetoableChangeListener(this);
        this.setM_Warehouse_ID(this.fWarehouse.getValue());
        MLookup docActionL = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 4324, 17, Env.getLanguage(Env.getCtx()), "DocAction", 135, false, "AD_Ref_List.Value IN ('CO','PR')");
        this.docAction = new VLookup("DocAction", true, false, true, docActionL);
        this.docAction.addVetoableChangeListener(this);
        MLookup bpL = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, 2762, 30);
        this.fBPartner = new VLookup("C_BPartner_ID", false, false, true, bpL);
        this.lBPartner.setText(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.fBPartner.addVetoableChangeListener(this);
        this.lDocType.setText(Msg.translate(Env.getCtx(), "C_DocType_ID"));
        this.cmbDocType.addItem(new KeyNamePair(MOrder.Table_ID, Msg.translate(Env.getCtx(), "Order")));
        this.cmbDocType.addItem(new KeyNamePair(MRMA.Table_ID, Msg.translate(Env.getCtx(), "VendorRMA")));
        this.cmbDocType.addActionListener(this);
        this.panel.getStatusBar().setStatusLine(Msg.getMsg(Env.getCtx(), "InOutGenerateSel"));
    }

    @Override
    public void executeQuery() {
        KeyNamePair docTypeKNPair = (KeyNamePair)this.cmbDocType.getSelectedItem();
        this.executeQuery(docTypeKNPair, this.panel.getMiniTable());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.cmbDocType.equals(e.getSource())) {
            this.executeQuery();
            return;
        }
        try {
            this.validate();
        }
        catch (Exception ex) {
            ADialog.error(this.m_WindowNo, this.panel, "Error", ex.getLocalizedMessage());
        }
    }

    @Override
    public void validate() {
        this.panel.saveSelection();
        if (this.getM_Warehouse_ID() <= 0) {
            throw new FillMandatoryException(new String[]{"M_Warehouse_ID"});
        }
        ArrayList<Integer> selection = this.getSelection();
        if (selection != null && selection.size() > 0 && this.isSelectionActive()) {
            this.panel.generate();
        } else {
            this.panel.dispose();
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        log.info(e.getPropertyName() + "=" + e.getNewValue());
        if (e.getPropertyName().equals("M_Warehouse_ID")) {
            this.setM_Warehouse_ID(e.getNewValue());
        }
        if (e.getPropertyName().equals("C_BPartner_ID")) {
            this.m_C_BPartner_ID = e.getNewValue();
            this.fBPartner.setValue(this.m_C_BPartner_ID);
        }
        this.executeQuery();
    }

    @Override
    public String generate() {
        KeyNamePair docTypeKNPair = (KeyNamePair)this.cmbDocType.getSelectedItem();
        String docActionSelected = (String)this.docAction.getValue();
        return this.generate(this.panel.getStatusBar(), docTypeKNPair, docActionSelected);
    }
}

