/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Payroll;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRProcess;

public class Doc_HRProcess
extends Doc {
    public MHRProcess process = null;
    public static final String DOCTYPE_Payroll = "HRP";

    public Doc_HRProcess(MAcctSchema[] mAcctSchemaArray, ResultSet resultSet, String string) {
        super(mAcctSchemaArray, MHRProcess.class, resultSet, DOCTYPE_Payroll, string);
    }

    @Override
    protected String loadDocumentDetails() {
        this.process = (MHRProcess)this.getPO();
        this.setDateDoc(this.getDateAcct());
        this.p_lines = this.loadLines(this.process);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MHRProcess mHRProcess) {
        ArrayList<DocLine_Payroll> arrayList = new ArrayList<DocLine_Payroll>();
        MHRMovement[] mHRMovementArray = mHRProcess.getLines(true);
        for (int i = 0; i < mHRMovementArray.length; ++i) {
            MHRMovement mHRMovement = mHRMovementArray[i];
            DocLine_Payroll docLine_Payroll = new DocLine_Payroll(mHRMovement, this);
            this.log.fine(docLine_Payroll.toString());
            arrayList.add(docLine_Payroll);
        }
        DocLine[] docLineArray = new DocLine[arrayList.size()];
        arrayList.toArray(docLineArray);
        return docLineArray;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal bigDecimal = Env.ZERO;
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Fact> createFacts(MAcctSchema mAcctSchema) {
        Serializable serializable;
        Fact fact = new Fact(this, mAcctSchema, "A");
        ResultSet resultSet = null;
        CPreparedStatement cPreparedStatement = null;
        try {
            Object object;
            Serializable serializable2;
            int n;
            serializable = Env.ZERO;
            BigDecimal bigDecimal = Env.ZERO;
            cPreparedStatement = DB.prepareStatement("SELECT m.HR_Concept_id, MAX(c.Name) As Name, SUM(m.Amount) As Amount, MAX(c.AccountSign) As AccountSign,  MAX(CA.IsBalancing) As IsBalancing, e.AD_Org_ID As AD_Org_ID, m.C_Activity_ID, bp.C_BPartner_ID FROM HR_Movement m INNER JOIN HR_Concept_Acct ca ON (ca.HR_Concept_ID=m.HR_Concept_ID AND ca.IsActive = 'Y') INNER JOIN HR_Concept      c  ON (c.HR_Concept_ID=m.HR_Concept_ID AND c.IsActive = 'Y') INNER JOIN C_BPartner      bp ON (bp.C_BPartner_ID = m.C_BPartner_ID) INNER JOIN HR_Employee\t e  ON (bp.C_BPartner_ID=e.C_BPartner_ID) INNER JOIN HR_Department   d  ON (d.HR_Department_ID=e.HR_Department_ID) WHERE m.HR_Process_ID=? AND (m.Qty <> 0 OR m.Amount <> 0) AND c.AccountSign != 'N' GROUP BY m.HR_Concept_ID,e.AD_Org_ID,m.C_Activity_ID , bp.C_BPartner_ID ORDER BY e.AD_Org_ID,m.C_Activity_ID,bp.C_BPartner_ID", this.getTrxName());
            cPreparedStatement.setInt(1, this.process.getHR_Process_ID());
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                FactLine factLine;
                MAccount mAccount;
                n = resultSet.getInt("HR_Concept_ID");
                serializable2 = resultSet.getBigDecimal("Amount");
                serializable2 = serializable2.setScale(mAcctSchema.getStdPrecision(), 4);
                object = resultSet.getString("AccountSign");
                boolean bl = "Y".equals(resultSet.getString("IsBalancing"));
                int n2 = resultSet.getInt("AD_Org_ID");
                int n3 = resultSet.getInt("C_Activity_ID");
                int n4 = resultSet.getInt("C_BPartner_ID");
                if (object == null || ((String)object).length() <= 0 || !"D".equals(object) && !"C".equals(object)) continue;
                if (bl) {
                    mAccount = MAccount.get(this.getCtx(), this.getAccountBalancing(mAcctSchema.getC_AcctSchema_ID(), n, "D"));
                    factLine = fact.createLine(null, mAccount, mAcctSchema.getC_Currency_ID(), (BigDecimal)serializable2, null);
                    factLine.setAD_OrgTrx_ID(n2);
                    factLine.setC_Activity_ID(n3);
                    factLine.setC_BPartner_ID(n4);
                    factLine.saveEx();
                    MAccount mAccount2 = MAccount.get(this.getCtx(), this.getAccountBalancing(mAcctSchema.getC_AcctSchema_ID(), n, "C"));
                    FactLine factLine2 = fact.createLine(null, mAccount2, mAcctSchema.getC_Currency_ID(), null, (BigDecimal)serializable2);
                    factLine2.setAD_OrgTrx_ID(n2);
                    factLine2.setC_Activity_ID(n3);
                    factLine2.setC_BPartner_ID(n4);
                    factLine2.saveEx();
                    continue;
                }
                if ("D".equals(object)) {
                    mAccount = MAccount.get(this.getCtx(), this.getAccountBalancing(mAcctSchema.getC_AcctSchema_ID(), n, "D"));
                    factLine = fact.createLine(null, mAccount, mAcctSchema.getC_Currency_ID(), (BigDecimal)serializable2, null);
                    factLine.setAD_OrgTrx_ID(n2);
                    factLine.setC_Activity_ID(n3);
                    factLine.setC_BPartner_ID(n4);
                    factLine.saveEx();
                    serializable = ((BigDecimal)serializable).add((BigDecimal)serializable2);
                    continue;
                }
                if (!"C".equals(object)) continue;
                mAccount = MAccount.get(this.getCtx(), this.getAccountBalancing(mAcctSchema.getC_AcctSchema_ID(), n, "C"));
                factLine = fact.createLine(null, mAccount, mAcctSchema.getC_Currency_ID(), null, (BigDecimal)serializable2);
                factLine.setAD_OrgTrx_ID(n2);
                factLine.setC_Activity_ID(n3);
                factLine.setC_BPartner_ID(n4);
                factLine.saveEx();
                bigDecimal = bigDecimal.add((BigDecimal)serializable2);
            }
            if ((((BigDecimal)serializable).signum() != 0 || bigDecimal.signum() != 0) && (n = this.process.getHR_Payroll().getC_Charge_ID()) > 0) {
                serializable2 = MCharge.getAccount(n, mAcctSchema, ((BigDecimal)serializable).subtract(bigDecimal));
                object = null;
                object = ((BigDecimal)serializable).abs().compareTo(bigDecimal.abs()) > 0 ? fact.createLine(null, (MAccount)serializable2, mAcctSchema.getC_Currency_ID(), null, ((BigDecimal)serializable).subtract(bigDecimal)) : fact.createLine(null, (MAccount)serializable2, mAcctSchema.getC_Currency_ID(), bigDecimal.abs().subtract(((BigDecimal)serializable).abs()), null);
                ((PO)object).setAD_Org_ID(this.getAD_Org_ID());
                ((PO)object).saveEx();
            }
        }
        catch (Exception exception) {
            ArrayList<Fact> arrayList;
            try {
                this.log.log(Level.SEVERE, "SELECT m.HR_Concept_id, MAX(c.Name) As Name, SUM(m.Amount) As Amount, MAX(c.AccountSign) As AccountSign,  MAX(CA.IsBalancing) As IsBalancing, e.AD_Org_ID As AD_Org_ID, m.C_Activity_ID, bp.C_BPartner_ID FROM HR_Movement m INNER JOIN HR_Concept_Acct ca ON (ca.HR_Concept_ID=m.HR_Concept_ID AND ca.IsActive = 'Y') INNER JOIN HR_Concept      c  ON (c.HR_Concept_ID=m.HR_Concept_ID AND c.IsActive = 'Y') INNER JOIN C_BPartner      bp ON (bp.C_BPartner_ID = m.C_BPartner_ID) INNER JOIN HR_Employee\t e  ON (bp.C_BPartner_ID=e.C_BPartner_ID) INNER JOIN HR_Department   d  ON (d.HR_Department_ID=e.HR_Department_ID) WHERE m.HR_Process_ID=? AND (m.Qty <> 0 OR m.Amount <> 0) AND c.AccountSign != 'N' GROUP BY m.HR_Concept_ID,e.AD_Org_ID,m.C_Activity_ID , bp.C_BPartner_ID ORDER BY e.AD_Org_ID,m.C_Activity_ID,bp.C_BPartner_ID", exception);
                this.p_Error = exception.getLocalizedMessage();
                arrayList = null;
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                cPreparedStatement = null;
                resultSet = null;
                throw throwable;
            }
            DB.close(resultSet, cPreparedStatement);
            cPreparedStatement = null;
            resultSet = null;
            return arrayList;
        }
        DB.close(resultSet, cPreparedStatement);
        cPreparedStatement = null;
        resultSet = null;
        serializable = new ArrayList();
        ((ArrayList)serializable).add(fact);
        return serializable;
    }

    private int getAccountBalancing(int n, int n2, String string) {
        String string2;
        if ("D".equals(string)) {
            string2 = "HR_Expense_Acct";
        } else if ("C".equals(string)) {
            string2 = "HR_Revenue_Acct";
        } else {
            throw new IllegalArgumentException("Invalid value for AccountSign=" + string);
        }
        String string3 = "SELECT " + string2 + " FROM HR_Concept_Acct" + " WHERE HR_Concept_ID=? AND C_AcctSchema_ID=?";
        int n3 = DB.getSQLValueEx(this.getTrxName(), string3, n2, n);
        return n3;
    }
}

