/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import org.compiere.model.MColumn;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSearchDefinition;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public abstract class AbstractDocumentSearch {
    static CLogger log = CLogger.getCLogger(AbstractDocumentSearch.class);
    protected boolean windowOpened = false;

    public boolean openDocumentsByDocumentNo(String searchString) {
        this.windowOpened = false;
        log.fine("Search started with String: " + searchString);
        if (searchString != null && !"".equals(searchString)) {
            int i;
            String[] codes = searchString.trim().replaceAll("  ", " ").split(" ");
            ArrayList<String> codeList = new ArrayList<String>();
            boolean codeSearch = true;
            searchString = "";
            for (i = 0; i < codes.length; ++i) {
                try {
                    String s = codes[i];
                    if (MSearchDefinition.isValidTransactionCode(s) && codeSearch) {
                        codeList.add(s);
                        continue;
                    }
                    codeSearch = false;
                    searchString = searchString + s;
                    if (i == codes.length - 1) continue;
                    searchString = searchString + " ";
                    continue;
                }
                catch (SQLException e) {
                    log.severe(e.toString());
                    e.printStackTrace();
                }
            }
            if (codeList.size() > 0) {
                for (i = 0; i < codeList.size(); ++i) {
                    log.fine("Search with Transaction: '" + (String)codeList.get(i) + "' for: '" + searchString + "'");
                    this.getID((String)codeList.get(i), searchString);
                }
            } else {
                log.fine("Search without Transaction: " + searchString);
                this.getID(null, searchString);
            }
        } else {
            log.fine("Search String is invalid");
        }
        return this.windowOpened;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getID(String transactionCode, String searchString) {
        ResultSet rsSO = null;
        ResultSet rsPO = null;
        CPreparedStatement pstmtSO = null;
        PreparedStatement pstmtPO = null;
        String sqlSO = null;
        String sqlPO = null;
        Properties ctx = Env.getCtx();
        MRole role = MRole.get(ctx, Env.getAD_Role_ID(ctx), Env.getAD_User_ID(ctx), true);
        try {
            for (MSearchDefinition msd : MSearchDefinition.getForCode(transactionCode)) {
                MTable table;
                block24: {
                    block22: {
                        block23: {
                            table = new MTable(Env.getCtx(), msd.getAD_Table_ID(), null);
                            if (!msd.getSearchType().equals("T")) break block22;
                            MColumn column = new MColumn(Env.getCtx(), msd.getAD_Column_ID(), null);
                            sqlSO = "SELECT " + table.getTableName() + "_ID FROM " + table.getTableName() + " ";
                            sqlSO = msd.getDataType().equals("I") ? sqlSO + "WHERE " + column.getColumnName() + "=?" : sqlSO + "WHERE UPPER(" + column.getColumnName() + ") LIKE UPPER(?)";
                            if (msd.getPO_Window_ID() != 0) {
                                sqlPO = sqlSO + " AND IsSOTrx='N'";
                                sqlSO = sqlSO + " AND IsSOTrx='Y'";
                            }
                            pstmtSO = DB.prepareStatement(sqlSO, null);
                            pstmtPO = DB.prepareStatement(sqlPO, null);
                            if (!msd.getDataType().equals("I")) break block23;
                            pstmtSO.setInt(1, Integer.valueOf(searchString.replaceAll("\\D", "")));
                            if (msd.getPO_Window_ID() != 0) {
                                pstmtPO.setInt(1, Integer.valueOf(searchString.replaceAll("\\D", "")));
                            }
                            break block24;
                        }
                        if (!msd.getDataType().equals("S")) break block24;
                        pstmtSO.setString(1, searchString);
                        if (msd.getPO_Window_ID() == 0) break block24;
                        pstmtPO.setString(1, searchString);
                        break block24;
                    }
                    if (msd.getSearchType().equals("Q")) {
                        sqlSO = msd.getQuery();
                        pstmtSO = DB.prepareStatement(sqlSO, null);
                        int count = 1;
                        for (char c : sqlSO.toCharArray()) {
                            if (c != '?') continue;
                            ++count;
                        }
                        for (int i = 1; i < count; ++i) {
                            if (msd.getDataType().equals("I")) {
                                pstmtSO.setInt(i, Integer.valueOf(searchString.replaceAll("\\D", "")));
                                continue;
                            }
                            if (!msd.getDataType().equals("S")) continue;
                            pstmtSO.setString(i, searchString);
                        }
                    }
                }
                if (pstmtSO != null) {
                    log.fine("SQL Sales: " + sqlSO);
                    rsSO = pstmtSO.executeQuery();
                    Vector<Integer> idSO = new Vector<Integer>();
                    while (rsSO.next()) {
                        idSO.add(new Integer(rsSO.getInt(1)));
                    }
                    if (role.getWindowAccess(msd.getAD_Window_ID()) != null) {
                        log.fine("Open Window: " + msd.getAD_Window_ID() + " / Table: " + table.getTableName() + " / Number of Results: " + idSO.size());
                        if (idSO.size() == 0 && (searchString == null || searchString.trim().length() == 0)) {
                            idSO.add(new Integer(0));
                        }
                        this.openWindow(idSO, table.getTableName(), msd.getAD_Window_ID());
                    } else {
                        log.warning("Role is not allowed to view this window");
                    }
                }
                if (pstmtPO != null) {
                    log.fine("SQL Purchase: " + sqlPO);
                    rsPO = pstmtPO.executeQuery();
                    Vector<Integer> idPO = new Vector<Integer>();
                    while (rsPO.next()) {
                        idPO.add(new Integer(rsPO.getInt(1)));
                    }
                    if (role.getWindowAccess(msd.getPO_Window_ID()) != null) {
                        log.fine("Open Window: " + msd.getPO_Window_ID() + " / Table: " + table.getTableName() + " / Number of Results: " + idPO.size());
                        this.openWindow(idPO, table.getTableName(), msd.getPO_Window_ID());
                    } else {
                        log.warning("Role is not allowed to view this window");
                    }
                }
                DB.close(rsSO, pstmtSO);
                DB.close(rsPO, pstmtPO);
                pstmtSO = null;
                pstmtPO = null;
                rsSO = null;
                rsPO = null;
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
            e.printStackTrace();
        }
        finally {
            DB.close(rsSO, pstmtSO);
            DB.close(rsPO, pstmtPO);
            rsSO = null;
            rsPO = null;
            pstmtSO = null;
            pstmtPO = null;
        }
    }

    private void openWindow(Vector<Integer> ids, String tableName, int windowId) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        String whereString = " " + tableName + "_ID";
        if (ids.size() == 1) {
            whereString = ids.get(0) == 0 ? null : whereString + "=" + ids.get(0);
        } else {
            whereString = whereString + " IN (";
            for (int i = 0; i < ids.size(); ++i) {
                whereString = whereString + ids.get(i);
                whereString = i < ids.size() - 1 ? whereString + "," : whereString + ") ";
            }
        }
        log.fine(whereString);
        MQuery query = new MQuery(tableName);
        query.addRestriction(whereString);
        boolean ok = this.openWindow(windowId, query);
        if (!ok) {
            log.severe("Unable to open window: " + whereString);
        }
        if (!this.windowOpened && ok) {
            this.windowOpened = true;
        }
    }

    protected abstract boolean openWindow(int var1, MQuery var2);
}

