/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class InvoiceGenerateRMA
extends SvrProcess {
    private boolean p_Selection = false;
    private String p_docAction = "CO";
    private int m_created = 0;
    private Timestamp m_dateinvoiced = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("Selection")) {
                this.p_Selection = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("DocAction")) {
                this.p_docAction = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.m_dateinvoiced = Env.getContextAsDate(this.getCtx(), "#Date");
        if (this.m_dateinvoiced == null) {
            this.m_dateinvoiced = new Timestamp(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        if (!this.p_Selection) {
            throw new IllegalStateException("Shipments can only be generated from selection");
        }
        String sql = "SELECT rma.M_RMA_ID FROM M_RMA rma, T_Selection WHERE rma.DocStatus='CO' AND rma.IsSOTrx='Y' AND rma.AD_Client_ID=? AND rma.M_RMA_ID = T_Selection.T_Selection_ID AND T_Selection.AD_PInstance_ID=? ";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, Env.getAD_Client_ID(this.getCtx()));
            pstmt.setInt(2, this.getAD_PInstance_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.generateInvoice(rs.getInt(1));
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "Could not close prepared statement");
            }
        }
        return "@Created@ = " + this.m_created;
    }

    private int getInvoiceDocTypeId(int M_RMA_ID) {
        String docTypeSQl = "SELECT dt.C_DocTypeInvoice_ID FROM C_DocType dt INNER JOIN M_RMA rma ON dt.C_DocType_ID=rma.C_DocType_ID WHERE rma.M_RMA_ID=?";
        int docTypeId = DB.getSQLValue(null, docTypeSQl, M_RMA_ID);
        return docTypeId;
    }

    private MInvoice createInvoice(MRMA rma) {
        int docTypeId = this.getInvoiceDocTypeId(rma.get_ID());
        if (docTypeId == -1) {
            throw new IllegalStateException("Could not get invoice document type for Vendor RMA");
        }
        MInvoice invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        invoice.setRMA(rma);
        invoice.setC_DocTypeTarget_ID(docTypeId);
        if (!invoice.save()) {
            throw new IllegalStateException("Could not create invoice");
        }
        return invoice;
    }

    private MInvoiceLine[] createInvoiceLines(MRMA rma, MInvoice invoice) {
        MRMALine[] rmaLines;
        ArrayList<MInvoiceLine> invLineList = new ArrayList<MInvoiceLine>();
        for (MRMALine rmaLine : rmaLines = rma.getLines(true)) {
            if (rmaLine.getM_InOutLine_ID() == 0) {
                throw new IllegalStateException("No customer return line - RMA = " + rma.getDocumentNo() + ", Line = " + rmaLine.getLine());
            }
            MInvoiceLine invLine = new MInvoiceLine(invoice);
            invLine.setRMALine(rmaLine);
            if (!invLine.save()) {
                throw new IllegalStateException("Could not create invoice line");
            }
            invLineList.add(invLine);
        }
        MInvoiceLine[] invLines = new MInvoiceLine[invLineList.size()];
        invLineList.toArray(invLines);
        return invLines;
    }

    private void generateInvoice(int M_RMA_ID) {
        MInvoice invoice;
        MRMA rma = new MRMA(this.getCtx(), M_RMA_ID, this.get_TrxName());
        MInvoiceLine[] invoiceLines = this.createInvoiceLines(rma, invoice = this.createInvoice(rma));
        if (invoiceLines.length == 0) {
            this.log.log(Level.WARNING, "No invoice lines created: M_RMA_ID=" + M_RMA_ID + ", M_Invoice_ID=" + invoice.get_ID());
        }
        StringBuffer processMsg = new StringBuffer(invoice.getDocumentNo());
        if (!invoice.processIt(this.p_docAction)) {
            processMsg.append(" (NOT Processed)");
            this.log.warning("Invoice Processing failed: " + invoice + " - " + invoice.getProcessMsg());
        }
        if (!invoice.save()) {
            throw new IllegalStateException("Could not update invoice");
        }
        this.addLog(invoice.getC_Invoice_ID(), invoice.getDateInvoiced(), null, processMsg.toString());
        ++this.m_created;
    }
}

