/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import org.adempiere.process.rpl.exp.ExportHelper;
import org.compiere.model.MClient;
import org.compiere.model.MOrg;
import org.compiere.model.MReplicationStrategy;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_AD_ReplicationDocument;
import org.compiere.model.X_AD_ReplicationTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ExportModelValidator
implements ModelValidator {
    public static final String CTX_IsReplicationEnabled = "#IsReplicationEnabled";
    private static CLogger log = CLogger.getCLogger(ExportModelValidator.class);
    private int m_AD_Client_ID = -1;
    private int m_AD_Org_ID = -1;
    private int m_AD_Role_ID = -1;
    private int m_AD_User_ID = -1;
    private int m_AD_ReplicationStrategy_ID = -1;
    ModelValidationEngine m_engine = null;
    ExportHelper expHelper = null;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        this.m_engine = engine;
        if (client == null) {
            log.warning("Export Model Validator cannot be used as a global validator, it needs to be defined in a per-client (tenant) basis");
            return;
        }
        this.m_AD_Client_ID = client.getAD_Client_ID();
        log.info(client.toString());
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        X_AD_ReplicationTable replicationTable;
        log.info("po.get_TableName() = " + po.get_TableName());
        if (this.expHelper != null && (type == 5 || type == 4 || type == 3) && (replicationTable = MReplicationStrategy.getReplicationTable(po.getCtx(), this.m_AD_ReplicationStrategy_ID, po.get_Table_ID())) != null) {
            this.expHelper.exportRecord(po, 0, replicationTable.getReplicationType(), type);
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int type) {
        log.info("Replicate the Document = " + po.get_TableName() + " with Type = " + type);
        String result = null;
        if (this.expHelper != null) {
            try {
                if (type == 9 || type == 11 || type == 13 || type == 10 || type == 12) {
                    X_AD_ReplicationDocument replicationDocument = null;
                    int C_DocType_ID = po.get_ValueAsInt("C_DocType_ID");
                    replicationDocument = C_DocType_ID > 0 ? MReplicationStrategy.getReplicationDocument(po.getCtx(), this.m_AD_ReplicationStrategy_ID, po.get_Table_ID(), C_DocType_ID) : MReplicationStrategy.getReplicationDocument(po.getCtx(), this.m_AD_ReplicationStrategy_ID, po.get_Table_ID());
                    if (replicationDocument != null) {
                        this.expHelper.exportRecord(po, 1, replicationDocument.getReplicationType(), type);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = e.toString();
            }
        }
        return result;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        Env.setContext(Env.getCtx(), CTX_IsReplicationEnabled, true);
        this.m_AD_Org_ID = AD_Org_ID;
        this.m_AD_Role_ID = AD_Role_ID;
        this.m_AD_User_ID = AD_User_ID;
        log.info("AD_Org_ID  =" + this.m_AD_Org_ID);
        log.info("AD_Role_ID =" + this.m_AD_Role_ID);
        log.info("AD_User_ID =" + this.m_AD_User_ID);
        this.loadReplicationStrategy();
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public void loadReplicationStrategy() {
        String tableName;
        MClient client = MClient.get(Env.getCtx(), this.m_AD_Client_ID);
        MReplicationStrategy rplStrategy = null;
        this.m_AD_ReplicationStrategy_ID = MOrg.get(client.getCtx(), this.m_AD_Org_ID).getAD_ReplicationStrategy_ID();
        if (this.m_AD_ReplicationStrategy_ID <= 0) {
            this.m_AD_ReplicationStrategy_ID = client.getAD_ReplicationStrategy_ID();
            log.info("client.getAD_ReplicationStrategy_ID() = " + this.m_AD_ReplicationStrategy_ID);
        }
        if (this.m_AD_ReplicationStrategy_ID > 0) {
            rplStrategy = new MReplicationStrategy(client.getCtx(), this.m_AD_ReplicationStrategy_ID, null);
            if (!rplStrategy.isActive()) {
                return;
            }
            this.expHelper = new ExportHelper(client, rplStrategy);
        }
        if (rplStrategy != null) {
            for (X_AD_ReplicationTable rplTable : rplStrategy.getReplicationTables()) {
                if (!"M".equals(rplTable.getReplicationType()) && !"B".equals(rplTable.getReplicationType()) && !"R".equals(rplTable.getReplicationType())) continue;
                tableName = MTable.getTableName(client.getCtx(), rplTable.getAD_Table_ID());
                this.m_engine.addModelChange(tableName, this);
            }
        }
        if (rplStrategy != null) {
            for (X_AD_ReplicationDocument rplDocument : rplStrategy.getReplicationDocuments()) {
                if (!"M".equals(rplDocument.getReplicationType()) && !"R".equals(rplDocument.getReplicationType())) continue;
                tableName = MTable.getTableName(client.getCtx(), rplDocument.getAD_Table_ID());
                this.m_engine.addDocValidate(tableName, this);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(ExportModelValidator.class.getName());
        return sb.toString();
    }
}

